<?php
/**
* @package Solar
*/
 
if ( has_post_thumbnail()) {
	$large_imgSrc = wp_get_attachment_image_src( get_post_thumbnail_id(), 'single_post_thumb');
	$imgUrl = $large_imgSrc[0];
}else{
	$imgUrl = get_template_directory_uri().'/images/img_404.png';
} 
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('single-post'); ?>>
	<div class="post-thumb" style="background-image:url(<?php echo $imgUrl; ?>);">        
        <figure class="post-thumb-wrap"></figure>
    </div><!-- post-thumb -->
    <div class="post-summary">
        <header class="entry-header">
            <div class="entry-contains">
                <h3 class="post-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h3>
                <div class="entry-summary">                	                    
					<?php echo content(40);
                    wp_link_pages(array(
                        'before' => '<div class="page-links">' . __('Pages : ', 'Tattoo'),
                        'after' => '</div>',
                    )); ?>
                </div><!-- .entry-summary -->
                <div class="search-more">
                	<a href="<?php the_permalink(); ?>"><?php echo of_get_option('blogpostreadmoretext'); ?></a>
                </div><!-- search more -->
            </div><div class="clear"></div>
        </header><!-- .entry-header -->
    </div><div class="clear"></div>
</article><!-- article -->