<?php
/**
* @package Tattoo
*/

$num_comments = get_comments_number(); // get_comments_number returns only a numeric value

if ( comments_open() ) {
	if ( $num_comments == 0 ) {
		$comments = __('No Comments','Tattoo');
	} elseif ( $num_comments > 1 ) {
		$comments = $num_comments . __(' Comments','Tattoo');
	} else {
		$comments = __('1 Comment','Tattoo');
	}
	$write_comments = '<a href="' . get_comments_link() .'">'. $comments.'</a>';
} else {
	$write_comments =  __('Comments are off for this post.','Tattoo');
}
			
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('single-post'); ?>>
    <div class="post-summary">

        <div class="single-post-thumb">
            <?php the_post_thumbnail('full' ); ?>
        </div><!-- single-post-thumb -->

        <header class="entry-header">
            <div class="entry-contains">
                <ul class="post-meta">
                    <span class="post-auth"><?php echo get_the_author_posts_link(); ?></span>
                    <span class="post-cate"><?php echo getPostCategories(); ?></span>
                    <span class="post-comnt"><?php echo $write_comments; ?></span>
                </ul>
            </div><div class="clear"></div>
        </header><!-- .entry-header -->

        <div class="entry-summary">                	                    
			<?php the_content();
            wp_link_pages(array(
				'before' => '<div class="page-links">' . __('Pages : ', 'Tattoo'),
				'after' => '</div>',
			)); ?>
        </div><!-- .entry-summary -->
        <div class="post-bottom">
        	<div class="post-tags">
				<?php echo the_tags('', '', '<br />'); ?>
            </div>
            <div class="social_share">
				<?php echo Tattoo_social_sharing_buttons(); ?>
            </div><div class="clear"></div>
        </div><!-- post bottom -->
    </div><!-- post-summary -->
    <?php if (get_the_author_meta('description')) : // Checking if the user has added any author descript or not. If it is added only, then lets move ahead ?>
        <div class="author-box">
            <div class="author-img"><?php echo get_avatar(get_the_author_meta('user_email'), '70'); // Display the author gravatar image with the size of 100 ?></div>
            <div class="author-bio-box">
                <h4 class="author-name"><?php echo get_the_author_posts_link(); // Displays the author name of the posts ?></h4>
                <p class="author-description"><?php esc_textarea(the_author_meta('description')); // Displays the author description added in Biographical Info ?></p>
                <div class="author-meta">            
                <?php $twitter = get_the_author_meta('twitter', $author_id); $facebook = get_the_author_meta('facebook', $author_id); $googlep = get_the_author_meta('google_plus', $author_id); ?>
                <?php 
                    if(!empty($twitter)) {
                        echo '<a title="Follow me on Twitter" href="'.$twitter.'"><i class="fab fa-twitter"></i></a>';
                    }
                    if(!empty($facebook)) {
                        echo '<a title="Follow me on Facebook" href="'.$facebook.'"><i class="fab fa-facebook-f"></i></a>';
                    }
                    if(!empty($googlep)) {
                        echo '<a title="Follow me on Google Plus" href="'.$googlep.'"><i class="fab fa-google-plus-g"></i></a>';
                    }
                ?>
                </div><!-- author meta -->
            </div><div class="clear"></div>
        </div><!-- author box -->
    <?php endif; ?>
	<?php Tattoo_content_nav( 'nav-below' ); ?>
    <?php if ( is_user_logged_in() ) { ?>
    <footer class="entry-meta">
        <?php edit_post_link( __( 'Edit', 'Tattoo' ), '<span class="edit-link">', '</span>' ); ?>        
    </footer><!-- .entry-meta -->
    <?php } else {
    
    }?>
</article><!-- article -->