<?php
/**
 * @package Tattoo
 */

if ( has_post_thumbnail()) {
	$large_imgSrc = wp_get_attachment_image_src( get_post_thumbnail_id(), 'latest_post_thumb');
	$imgUrl = $large_imgSrc[0];
}else{
	$imgUrl = get_template_directory_uri().'/images/img_404.png';
}

$num_comments = get_comments_number(); // get_comments_number returns only a numeric value

if ( comments_open() ) {
	if ( $num_comments == 0 ) {
		$comments = __('No Comments','Tattoo');
	} elseif ( $num_comments > 1 ) {
		$comments = $num_comments . __(' Comments','Tattoo');
	} else {
		$comments = __('1 Comment','Tattoo');
	}
	$write_comments = '<a href="' . get_comments_link() .'">'. $comments.'</a>';
} else {
	$write_comments =  __('Comments are off for this post.','Tattoo');
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="blog-post-inner">
        <?php if( !is_search() ) : ?>
            <div class="news-thumb">
                <a class="entry-news-thumb" href="<?php the_permalink(); ?>"><img src="<?php echo $imgUrl; ?>"></a>
                <div class="post-date-meta">
                    <div class="post-date"><div class="post-date-inner"><span class="day"><?php echo get_the_date('d'); ?></span> <span class="month"><?php echo get_the_date('M'); ?></span></div></div>	
                </div>              
            </div><!-- news-thumb --> 
        <?php endif; ?> 

        <div class="post-data">
            
            <?php if ( is_search() ) : // Only display Excerpts for Search ?>
                <div class="entry-summary">            	
                    <p><?php the_excerpt( ); ?></p>
                    <?php
                        wp_link_pages( array(
                            'before' => '<div class="page-links">' . __( 'Pages:', 'Tattoo' ),
                            'after'  => '</div>',
                        ) );
                    ?>
                </div><!-- .entry-summary -->
            <?php else : ?>
                <div class="entry-content">
                    <header class="entry-header">
                        <div class="entry-contains">                
                            <?php if( !is_search() ): ?>
                                <ul class="post-meta">
                                    <span class="post-auth"><?php echo get_the_author_posts_link(); ?></span>
                                    <span class="post-cate"><?php echo getPostCategories(); ?></span>   
                                    <span class="post-comnt"><?php echo $write_comments; ?></span>
                                </ul>
                            <?php endif; ?>
                        </div>
                    </header> 
                        
                    <h3 class="post-title<?php if( is_search() ):?> search-title<?php endif; ?>"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h3>
                    <p><?php echo content( of_get_option('blogpagepostexcerptlength') ); ?></p>
                    <a href="<?php the_permalink(); ?>" class="ln-read-more"><?php echo of_get_option('blogpostreadmoretext'); ?></a>
                </div><!-- .entry-content -->
            <?php endif; ?>
        </div><!-- post data -->
    </div><!-- blog-post-inner -->
</article><!-- article -->