<?php
/**
 * Tattoo functions and definitions
 *
 * @package Tattoo Pro
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */

function content($limit) {
$content = explode(' ', get_the_excerpt(), $limit);
if (count($content)>=$limit) {
array_pop($content);
$content = implode(" ",$content).'...';
} else {
$content = implode(" ",$content);
}	
$content = preg_replace('/\[.+\]/','', $content);
$content = apply_filters('the_content', $content);
$content = str_replace(']]>', ']]&gt;', $content);
return $content;
}
//Excerpt limit function
function custom_excerpt_length( $length ) {
	return 100;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

if ( ! function_exists( 'Tattoo_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function Tattoo_setup() {

	if ( ! isset( $content_width ) )
		$content_width = 640; /* pixels */

	load_theme_textdomain( 'Tattoo', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	
	if ( class_exists( 'WooCommerce' ) ) {
		add_theme_support( 'woocommerce' );
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
		add_theme_support( 'wc-product-gallery-slider' );
	}
	
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'title-tag' );

	add_image_size('testi-thumb',500,500,true);
	add_image_size('team-post-thumb',630,770,true);
	add_image_size('gal-thumb',1000,800,true);
	add_image_size('latest-news-thumb',800,650,true);
	add_image_size('portf-post-thumb',1000,800,true);
	
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'Tattoo' ),
	) );
	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff'
	) );
	add_editor_style( 'editor-style.css' );
}
endif; // Tattoo_setup
add_action( 'after_setup_theme', 'Tattoo_setup' );

function Tattoo_widgets_init() {

	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'Tattoo' ),
		'description'   => __( 'Appears on blog page sidebar', 'Tattoo' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s"><div class="widget_content">',
		'after_widget'  => '</div></aside>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar Main', 'Tattoo' ),
		'description'   => __( 'Appears on page sidebar', 'Tattoo' ),
		'id'            => 'sidebar-main',
		'before_widget' => '<aside id="%1$s" class="widget %2$s"><div class="widget_content">',
		'after_widget'  => '</div></aside>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );	
	
	register_sidebar( array(
		'name'          => __( 'Footer 1', 'Tattoo' ),
		'description'   => __( 'Appears on footer', 'Tattoo' ),
		'id'            => 'footer-1',
		'before_widget' => '<div id="%1$s" class="%2$s"><div class="widget-space">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h5 class="footer-widget-title">',
		'after_title'   => '</h5>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer 2', 'Tattoo' ),
		'description'   => __( 'Appears on footer', 'Tattoo' ),
		'id'            => 'footer-2',
		'before_widget' => '<div id="%1$s" class="%2$s"><div class="widget-space">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h5 class="footer-widget-title">',
		'after_title'   => '</h5>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer 3', 'Tattoo' ),
		'description'   => __( 'Appears on footer', 'Tattoo' ),
		'id'            => 'footer-3',
		'before_widget' => '<div id="%1$s" class="%2$s"><div class="widget-space">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h5 class="footer-widget-title">',
		'after_title'   => '</h5>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer 4', 'Tattoo' ),
		'description'   => __( 'Appears on footer', 'Tattoo' ),
		'id'            => 'footer-4',
		'before_widget' => '<div id="%1$s" class="%2$s"><div class="widget-space">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h5 class="footer-widget-title">',
		'after_title'   => '</h5>',
	) );
	
	if ( class_exists( 'WooCommerce' ) ) {
		register_sidebar( array(
			'name'          => __( 'Shop Widget', 'Tattoo' ),
			'description'   => __( 'Appears on shop page', 'Tattoo' ),
			'id'            => 'shop',
			'before_widget' => '<aside id="%1$s" class="widget %2$s"><div class="widget_content">',
			'after_widget'  => '</div></aside>',
			'before_title'  => '<h3 class="widget-title"><span>',
			'after_title'   => '</span></h3>',
		) );
	}
	
	register_widget( 'Alexatheme_Footer_Get_In_Touch' );
	register_widget( 'Alexatheme_Widget_latest_posts' );
	register_widget( 'Alexatheme_About_Us' );
	register_widget( 'Alexatheme_Widget_Sidebar_Banner' );
	register_widget( 'Alexatheme_Widget_Newsletter' );
	register_widget( 'Alexatheme_Working_Hours' );
	register_widget( 'Alexatheme_Widget_Brochure' );
	
}
add_action( 'widgets_init', 'Tattoo_widgets_init' );

define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri() . '/inc/' );
require_once get_template_directory() . '/inc/options-framework.php';

function Tattoo_scripts() {
	
	wp_enqueue_style( 'Tattoo-google-fonts', get_template_directory_uri().'/css/gfonts.css', true );

	wp_enqueue_style( 'Tattoo-basic-style', get_stylesheet_uri() );
	wp_enqueue_style( 'Tattoo-editor-style', get_template_directory_uri().'/editor-style.css' );
	wp_enqueue_style( 'Tattoo-base-style', get_template_directory_uri().'/css/default.css' );

	//Nivo Slider                              
	wp_enqueue_style( 'Tattoo-nivo-style', get_template_directory_uri().'/css/nivo-slider.css' );
	wp_enqueue_script( 'Tattoo-nivo-slider', get_template_directory_uri() . '/js/jquery.nivo.slider.js', array('jquery') );

	//Custom JS		
	wp_enqueue_script( 'Tattoo-customscripts', get_template_directory_uri() . '/js/custom.js', array('jquery') );
	
	//Font Awesome
	wp_enqueue_script('Tattoo-fontawesome', 'https://kit.fontawesome.com/a05eda20c4.js' );
	
	//Owl Caraousal
	wp_enqueue_script( 'Tattoo-owljs', get_template_directory_uri().'/js/owl.carousel.min.js', array('jquery') );
	wp_enqueue_style( 'Tattoo-owlcss-style', get_template_directory_uri().'/css/owl/owl.carousel.min.css' );
	wp_enqueue_style( 'Tattoo-owltheme-style', get_template_directory_uri().'/css/owl/owl.theme.default.min.css' );	
	
	//Responsive Style
	wp_enqueue_style( 'Tattoo-responsive-style', get_template_directory_uri().'/css/responsive.css' );	
	
	// counter script
	wp_enqueue_script( 'Tattoo-counter-scripts', get_template_directory_uri().'/js/jquery.waypoints.min.js', array('jquery') );
	wp_enqueue_script( 'Tattoo-counting-scripts', get_template_directory_uri().'/js/jquery.counterup.min.js', array('jquery') );
	
	// mixitup script
	wp_enqueue_style( 'Tattoo-mixitup-style', get_template_directory_uri().'/mixitup/style-mixitup.css' );
	wp_enqueue_script( 'Tattoo-jquery_mixitup', get_template_directory_uri() . '/mixitup/jquery.mixitup.min.js', array('jquery') );
	
	// fancybox script
	wp_enqueue_script( 'Tattoo-fancybox-scripts', get_template_directory_uri().'/js/jquery.fancybox.min.js', array('jquery') );
	wp_enqueue_style( 'Tattoo-fancybox-style', get_template_directory_uri().'/css/jquery.fancybox.min.css' );	
	
	// LightSlider script
	wp_enqueue_script( 'Tattoo-lightslider-scripts', get_template_directory_uri().'/js/lightslider.js', array('jquery') );
	wp_enqueue_style( 'Tattoo-lightslider-style', get_template_directory_uri().'/css/lightslider.css' );
	
	//Animation
	wp_enqueue_style( 'Tattoo-animate-style', get_template_directory_uri().'/css/animate.css' );
	wp_enqueue_script( 'Tattoo-animate-script', get_template_directory_uri() . '/js/wow.min.js', array('jquery') );
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'Tattoo_scripts' );

/**
 * Style for Widgets in admin panel
 */
function Tattoo_widgets_load_scripts() {
	wp_enqueue_style( 'Tattoo-widgets-style', get_template_directory_uri() . '/inc/widgets/admin/css/widgets-style.css', '1.0.0', false );
	wp_enqueue_script( 'Tattoo-chosen-init', get_template_directory_uri() . '/inc/widgets/admin/js/chosen-init.js', array( 'jquery' ), '1.0.0', true );
	wp_enqueue_script( 'Tattoo-chosen', get_template_directory_uri() . '/inc/widgets/admin/js/chosen.jquery.min.js', array('jquery', 'jquery-ui-sortable'), '1.6.2', true );
}
add_action( 'admin_enqueue_scripts', 'Tattoo_widgets_load_scripts' );

function media_css_hook(){
	
	?>
    	
<script>			
jQuery(window).load(function() {
	jQuery('#slider').nivoSlider({
		effect:'<?php echo of_get_option('slideefect',true); ?>',
		animSpeed: <?php echo of_get_option('slideanim',true); ?>,
		pauseTime: <?php echo of_get_option('slidepause',true); ?>,
		directionNav: <?php echo of_get_option('slidenav',true); ?>,
		controlNav: <?php echo of_get_option('slidepage',true); ?>,
		pauseOnHover: <?php echo of_get_option('slidepausehover',true); ?>,
		manualAdvance: <?php echo of_get_option('onoffauto',true); ?>,
		controlNavThumbs: false
	});
});

jQuery(document).ready(function() {
	jQuery('.link').on('click', function(event){
		var $this = jQuery(this);
		if($this.hasClass('clicked')){
			$this.removeAttr('style').removeClass('clicked');
		} else{
			$this.css('background','#7fc242').addClass('clicked');
		}
	});
});

</script>
<?php  
}
add_action('wp_head','media_css_hook'); 

function Tattoo_custom_head_codes() { 
	if ( function_exists('of_get_option') ){
		
		$typebody = of_get_option('bodyfontface');
		$typeh1 = of_get_option('h1fontface');
		$typeh2 = of_get_option('h2fontface');
		$typeh3 = of_get_option('h3fontface');
		$typeh4 = of_get_option('h4fontface');
		$typeh5 = of_get_option('h5fontface');
		$typeh6 = of_get_option('h6fontface');
		$typelogo = of_get_option('logofontface');
		$typetag = of_get_option('tagfontface');
		$typenav = of_get_option('navfontface');
		$typeslidesubtitle	= of_get_option('slidesubtitlefontface');
		$typeslidetitle	= of_get_option('slidetitlefontface');
		$typeslidedesc	= of_get_option('slidedescfontface');
		$typesectitle = of_get_option('sectitlefontface');
		$typesecsubtitle = of_get_option('secsubtitlefontface');
		$typetestname = of_get_option('testnamefontface');
		$typetestcmp = of_get_option('testcmpfontface');
		$typeteamtitle = of_get_option('teamtitlefontface');
		$typelpttl = of_get_option('lpttlfontface');
		$typefoottitle = of_get_option('foottitlefontface');
		$typepagetitle = of_get_option('pagetitlefontface');
		$typebpttl = of_get_option('bpttlfontface');
		$typewidgettitle = of_get_option('widgettitlefontface');
		$typeprodtitle = of_get_option('prodtitlefontface');
		$typesingleprodtitle = of_get_option('singleprodtitlefontface');
		
		wp_enqueue_style( 'Tattoo-gfonts', '//fonts.googleapis.com/css?family='.rawurlencode($typebody['face'].'|'.$typeh1['face'].'|'.$typeh2['face'].'|'.$typeh3['face'].'|'.$typeh4['face'].'|'.$typeh5['face'].'|'.$typeh6['face'].'|'.$typelogo['face'].'|'.$typetag['face'].'|'.$typenav['face'].'|'.$typeslidesubtitle['face'].'|'.$typeslidetitle['face'].'|'.$typeslidedesc['face'].'|'.$typesectitle['face'].'|'.$typesecsubtitle['face'].'|'.$typetestname['face'].'|'.$typetestcmp['face'].'|'.$typeteamtitle['face'].'|'.$typelpttl['face'].'|'.$typefoottitle['face'].'|'.$typepagetitle['face'].'|'.$typebpttl['face'].'|'.$typewidgettitle['face'].'|'.$typeprodtitle['face'].'|'.$typesingleprodtitle['face'] ));
		
		if ( of_get_option('style2', true) != '' ) {
			echo "<style>". esc_html( of_get_option('style2', true) ) ."</style>";
		}
		echo "<style>";
		
		//Fonts - BODY
		if( of_get_option('bodyfontface',true) != ''){
			echo "body{
					font-family:".$typebody['face'].";
					font-size:".$typebody['size'].";
					color:".$typebody['color'].";
					font-weight:".$typebody['weight'].";
					font-style:".$typebody['style'].";
				}";
		}
		//Fonts - H1
		if ( of_get_option('h1fontface', true) != '') {
			echo "h1{
					font-family:".$typeh1['face'].";
					font-size:".$typeh1['size'].";
					color:".$typeh1['color'].";
					font-style:".$typeh1['style'].";
					font-weight:".$typeh1['weight'].";
				}";
		}
		//Fonts - H2
		if ( of_get_option('h2fontface', true) != '') {
			echo "h2{
					font-family:".$typeh2['face'].";
					font-size:".$typeh2['size'].";
					color:".$typeh2['color'].";
					font-style:".$typeh2['style'].";
					font-weight:".$typeh2['weight'].";
				}";
		}
		//Fonts - H3
		if ( of_get_option('h3fontface', true) != '') {
			echo "h3{
					font-family:".$typeh3['face'].";
					font-size:".$typeh3['size'].";
					color:".$typeh3['color'].";
					font-style:".$typeh3['style'].";
					font-weight:".$typeh3['weight'].";
				}";
		}
		//Fonts - H4
		if ( of_get_option('h4fontface', true) != '') {
			echo "h4{
					font-family:".$typeh4['face'].";
					font-size:".$typeh4['size'].";
					color:".$typeh4['color'].";
					font-style:".$typeh4['style'].";
					font-weight:".$typeh4['weight'].";
				}";
		}
		//Fonts - H5
		if ( of_get_option('h5fontface', true) != '') {
			echo "h5{
					font-family:".$typeh5['face'].";
					font-size:".$typeh5['size'].";
					color:".$typeh5['color'].";
					font-style:".$typeh5['style'].";
					font-weight:".$typeh5['weight'].";
				}";
		}
		//Fonts - H6
		if ( of_get_option('h6fontface', true) != '') {
			echo "h6{
					font-family:".$typeh6['face'].";
					font-size:".$typeh6['size'].";
					color:".$typeh6['color'].";
					font-style:".$typeh6['style'].";
					font-weight:".$typeh6['weight'].";
				}";
		}
		//Fonts - Logo
		if( of_get_option('logofontface',true) != ''){
			echo ".logo h1{
					font-family:".$typelogo['face'].";
					font-size:".$typelogo['size'].";
					font-style:".$typelogo['style'].";
					font-weight:".$typelogo['weight'].";
					color:".$typelogo['color'].";
				}";
		}
		//Fonts - Logo Tagline
		if ( of_get_option('tagfontface', true) != '') {
			echo ".tagline, .logo p{
					font-family:".$typetag['face'].";
					font-size:".$typetag['size'].";
					color:".$typetag['color'].";
					font-style:".$typetag['style'].";
					font-weight:".$typetag['weight'].";
				}";
		}
		//Fonts - Navigation
		if ( of_get_option('navfontface', true) != '') {
			echo ".sitenav ul{
					font-family:".$typenav['face'].";
					font-size:".$typenav['size'].";
					font-style:".$typenav['style'].";
					font-weight:".$typenav['weight'].";
				}";
			echo ".sitenav ul li a, .sitenav ul li.current_page_item ul li a{
					color:".$typenav['color'].";
				}";
		}
		//Fonts - Slider Sub Title
		if ( of_get_option('slidesubtitlefontface', true) != '') {
			echo ".nivo-caption h4{
					font-family:".$typeslidesubtitle['face'].";
					font-size:".$typeslidesubtitle['size'].";
					color:".$typeslidesubtitle['color'].";
					font-style:".$typeslidesubtitle['style'].";
					font-weight:".$typeslidesubtitle['weight'].";
				}";
		}
		//Fonts - Slider Main Title
		if ( of_get_option('slidetitlefontface', true) != '') {
			echo ".nivo-caption h2{
					font-family:".$typeslidetitle['face'].";
					font-size:".$typeslidetitle['size'].";
					color:".$typeslidetitle['color'].";
					font-style:".$typeslidetitle['style'].";
					font-weight:".$typeslidetitle['weight'].";
				}";
		}
		//Fonts - Slider Description
		if ( of_get_option('slidedescfontface', true) != '') {
			echo ".nivo-caption p{
					font-family:".$typeslidedesc['face'].";
					font-size:".$typeslidedesc['size'].";
					color:".$typeslidedesc['color'].";
					font-style:".$typeslidedesc['style'].";
					font-weight:".$typeslidedesc['weight'].";
				}";
		}
		//Fonts - Section Main Title
		if ( of_get_option('sectitlefontface', true) != '') {
			echo "h2.section_title{
					font-family:".$typesectitle['face'].";
					font-size:".$typesectitle['size'].";
					color:".$typesectitle['color'].";
					font-style:".$typesectitle['style'].";
					font-weight:".$typesectitle['weight'].";
				}";
		}
		//Fonts - Section Sub Title
		if ( of_get_option('secsubtitlefontface', true) != '') {
			echo ".section_head h4.section-sub-title, .faq-right h6{
					font-family:".$typesecsubtitle['face'].";
					font-size:".$typesecsubtitle['size'].";
					color:".$typesecsubtitle['color'].";
					font-style:".$typesecsubtitle['style'].";
					font-weight:".$typesecsubtitle['weight'].";
				}";
		}
		//Fonts - Testimonials Title
		if ( of_get_option('testnamefontface', true) != '') {
			echo ".testi-content h4 {
					font-family:".$typetestname['face'].";
					font-size:".$typetestname['size'].";
					font-style:".$typetestname['style'].";
					font-weight:".$typetestname['weight'].";
				}";
			echo ".testi-content h4 a {
					color:".$typetestname['color'].";
				}";
		}
		//Fonts - Testimonials Company name
		if ( of_get_option('testcmpfontface', true) != '') {
			echo ".testi-position {
					font-family:".$typetestcmp['face'].";
					font-size:".$typetestcmp['size'].";
					font-style:".$typetestcmp['style'].";
					font-weight:".$typetestcmp['weight'].";
					color:".$typetestcmp['color'].";
				}";
		}
		//Fonts - Team Member Title
		if ( of_get_option('teamtitlefontface', true) != '') {
			echo ".team-content h4{
					font-family:".$typeteamtitle['face'].";
					font-size:".$typeteamtitle['size'].";
					font-style:".$typeteamtitle['style'].";
					font-weight:".$typeteamtitle['weight'].";
				}";
			echo ".team-content h4 a{
					color:".$typeteamtitle['color'].";
				}";	
		}
		//Fonts - Latest News Title
		if ( of_get_option('lpttlfontface', true) != '') {
			echo ".news-content h3{
					font-family:".$typelpttl['face'].";
					font-size:".$typelpttl['size'].";
					font-style:".$typelpttl['style'].";
					font-weight:".$typelpttl['weight'].";
				}";
			echo ".news-content h3 a{
					color:".$typelpttl['color'].";
				}";
		}
		//Fonts - Footer Widget Title
		if ( of_get_option('foottitlefontface', true) != '') {
			echo ".foo-cols h5.footer-widget-title{
					font-family:".$typefoottitle['face'].";
					font-size:".$typefoottitle['size'].";
					color:".$typefoottitle['color'].";
					font-style:".$typefoottitle['style'].";
					font-weight:".$typefoottitle['weight'].";
				}";
		}
		//Fonts - InnerPage Title
		if ( of_get_option('pagetitlefontface', true) != '') {
			echo "h1.innerpage-title{
					font-family:".$typepagetitle['face'].";
					font-size:".$typepagetitle['size'].";
					color:".$typepagetitle['color'].";
					font-style:".$typepagetitle['style'].";
					font-weight:".$typepagetitle['weight'].";
				}";
		}
		//Fonts - Blog Page Post Title
		if ( of_get_option('bpttlfontface', true) != '') {
			echo "h3.post-title{
					font-family:".$typebpttl['face'].";
					font-size:".$typebpttl['size'].";
					font-style:".$typebpttl['style'].";
					font-weight:".$typebpttl['weight'].";
				}";
			echo "h3.post-title a{
					color:".$typebpttl['color'].";
				}";
		}
		//Fonts - Widget Title
		if ( of_get_option('widgettitlefontface', true) != '') {
			echo "h3.widget-title{
					font-family:".$typewidgettitle['face'].";
					font-size:".$typewidgettitle['size'].";
					color:".$typewidgettitle['color'].";
					font-style:".$typewidgettitle['style'].";
					font-weight:".$typewidgettitle['weight'].";
				}";
		}
		//Fonts - Product Grid Title
		if ( of_get_option('prodtitlefontface', true) != '') {
			echo ".woocommerce ul.products li.product h2.woocommerce-loop-product__title{
					font-family:".$typeprodtitle['face'].";
					font-size:".$typeprodtitle['size']." !important;
					color:".$typeprodtitle['color'].";
					font-style:".$typeprodtitle['style'].";
					font-weight:".$typeprodtitle['weight'].";
				}";
		}
		//Fonts - Single Product Title
		if ( of_get_option('singleprodtitlefontface', true) != '') {
			echo ".woocommerce h1.product_title{
					font-family:".$typesingleprodtitle['face'].";
					font-size:".$typesingleprodtitle['size'].";
					color:".$typesingleprodtitle['color'].";
					font-style:".$typesingleprodtitle['style'].";
					font-weight:".$typesingleprodtitle['weight'].";
				}";
		}
		
		// Body Background Color
		if ( of_get_option('bodybgcolor', true) != '' || of_get_option('bodyclr', true) != '' ) {
			echo "body { background-color:".of_get_option('bodybgcolor',true)."; color:".of_get_option('bodyclr',true)."}";
		}		

		// Header Overlay Color
		$headopac = of_get_option('headbgcolor',true); 
		list($r,$g,$b) = sscanf($headopac,'#%02x%02x%02x');
		if ( of_get_option('headbgcolor', true) != '' ) {
			echo ".navigation, .sitenav ul li:hover > ul, .sticky-header, .team-content, .pricing-col:before, #footer-wrapper:before, .innerbanner:before, h1.innerpage-title span, .overlay-two { background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('headbgopac',true).");}";
		}

		// Navigation CSS									
		if( of_get_option('navhovercolor',true) != '' ){
			echo ".sitenav ul li.current_page_item a, .sitenav ul li a:hover, .sitenav ul li.current_page_item ul li a:hover { color:".of_get_option('navhovercolor',true).";}";
			echo ".sitenav ul li ul { border-color:".of_get_option('navhovercolor',true).";}";
		}
		
		// Slider Nivo Control CSS
		if( of_get_option('sldpagebg',true) != ''){
			echo ".nivo-controlNav a { border-color:".of_get_option('sldpagebg',true)."}";
		}
		if( of_get_option('sldpagehvbg',true) != ''){
			echo ".nivo-controlNav a.active{ border-color:".of_get_option('sldpagehvbg',true)."; background-color:".of_get_option('sldpagehvbg',true)."}";
			echo "a.nivo-nextNav, a.nivo-prevNav { background-color:".of_get_option('sldpagehvbg',true)."}";
		}
		if( of_get_option('sliderloader',true) != ''){
			echo ".slider-main{ background-image:url(".of_get_option('sliderloader',true)."); }";
		}else{
			echo ".slider-main{ background:none; }";
		}
		// Slider Overlay Color
		$sldropac = of_get_option('sldbgcolor',true); 
		list($r,$g,$b) = sscanf($sldropac,'#%02x%02x%02x');
		if ( of_get_option('sldbgcolor', true) != '' ) {
			echo "#slider:before{ background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('sldbgopac',true).");}";
		}			
		
		// Link Anchor Tag CSS			
		if ( of_get_option('linkcolor', true) != '' ) {
			echo 'a, .slide_toggle a, .postby a, .nav-previous h5, .nav-next h5, .process-box:hover .process-icon i, h1.innerpage-title.without-banner, h1.innerpage-title.without-banner span, .newsletter button, .skillbar-title span, .skill-bar-percent, .contact-opening-hrs .single-contact-opening-hrs strong, blockquote.align-left, blockquote.align-right, .contact-content .wpcf7-form label, .overlay-text ul li a:hover, .portfolio-share ul.social-share-post li a:hover, .owl-carousel .owl-nav button:hover::before, .pagination ul li .current, .pagination ul li a:hover {color:'. esc_html( of_get_option('linkcolor', true) ) .';}';
			
			echo '.process-box:hover .process-icon. .contact-opening-hrs .single-contact-opening-hrs h4::before, .overlay-text ul li a:hover, .owl-carousel .owl-nav button:hover, .contact-content .form-group input[type=text], .contact-content .form-group input[type=email], .contact-content .form-group input[type=tel], .contact-content .form-group textarea { border-color:'. esc_html( of_get_option('linkcolor', true) ) .';}';

			echo '.section_head:after, .faq-right:after, #process_main:after, #customorder_main:after, .post-date, .foo-cols h5.footer-widget-title:before, .download-brochure a:before, .skill-bg, .prev-page a, .next-page a, .abt-content:after, .gal-category, .ptfmeta-left ul li span:before, .ptfmeta-right ul li span:before, .related-port h3:before, .pagination ul li span, .pagination ul li a, h3.widget-title:before, #back-top a:before { background-color:'. esc_html( of_get_option('linkcolor', true) ) .';}';
		}

		if ( of_get_option('linkhovercolor', true) != '' ) {
			echo 'a:hover, .toggle a:hover, .slide_toggle a:hover, .postby a:hover, .nav-previous:hover h5, .nav-next:hover h5, .ser-btm a:hover, .team-content span, .video-left .pop-video .pop-icon a, .price-icon, .process-icon i, .post-meta span a i, .blog-post-single .post-meta span a:before, .blog-post-single .post-meta span a:hover, .contact-opening-hrs .single-contact-opening-hrs h4, .foo-cols ul.menu li a:hover, .widget-space h3, ul.entry-meta li a:hover, .single-team-info span, .single-testi-info span, .opening-hrs h6, .opening-hrs .opening-hrs-list li:last-child, .widget-getintouch-info li::before, p.comment-awaiting-moderation, section.videosec h6, .abt-content h3 span, .overlay-text ul li a, .ptfmeta-left ul li span, .ptfmeta-right ul li span, .owl-carousel .owl-nav button.owl-prev:before, .owl-carousel .owl-nav button.owl-next:before, #nav-below.post-navigation .nav-previous .meta-nav-icon i, #nav-below.post-navigation .nav-next .meta-nav-icon i {color:'. esc_html( of_get_option('linkhovercolor', true) ) .';}';
			
			echo '.section_head:before, .faq-right:before, .count-thumb:before, .count-thumb:after, .video-tag, .quote-left, .pricing-col .price-shape:before, .pricing-col .price-shape:after, #process_main:before, .news-box, #customorder_main:before, .blog-post-repeat, .foo-cols h5.footer-widget-title:after, .accordion-box h2.active:before, .download-brochure a, .newsletter button, .pop-icon a, .member-single-social a, .single-blog-post .post_tags ul li a, .author-box, .navigation .page-numbers.current, .navigation .page-numbers:hover, .prev-page a:hover, .next-page a:hover, #sidebar .member-info ul li:before, h1.innerpage-title span:before, h1.innerpage-title span:after, .abt-content:before, .portfolio-overlay, .ptfmeta-left ul li span:after, .ptfmeta-right ul li span:after, .related-port h3:after, .pagination ul li .current, .pagination ul li a:hover, .c-icon, h3.widget-title:after, #back-top a:after { background-color:'. esc_html( of_get_option('linkhovercolor', true) ) .';}';

			echo '.testimonials-item, .testi-thumb img, .process-icon, .single-team-thumb img, .single-testi-thumb img, .accordion-box h2.active:before, blockquote.align-left, blockquote.align-right, .overlay-text ul li a, .owl-carousel .owl-nav button, .c-info-inner:after, .c-icon:after { border-color:'. esc_html( of_get_option('linkhovercolor', true) ) .';}';

			echo 'c-info { border-color:'. esc_html( of_get_option('linkhovercolor', true) ) .'; border-right-color:transparent; border-left-color:transparent;}';

			echo '.owl-carousel .owl-nav button { border-color:'. esc_html( of_get_option('linkhovercolor', true) ) .' !important;}';
		}

		// Second Default Fonts & Background Colors
		if( of_get_option('defaultclr',true) != '' ){
			echo ".ser-btm a, .post-date, .post-meta span a:hover, .post-meta span a:before, .gal-category a, .portfolio-overlay span.port-category a, .pagination ul li span, .pagination ul li a, .member-single-social a:hover { color:".of_get_option('defaultclr',true)."; }";
			echo ".team-inner:hover .team-content, .video-left .pop-video .pop-icon a, .pricing-col .price-shape3:after, .pricing-col .price-shape3:before, .pricing-col .price-shape2:after, .pricing-col .price-shape2:before { background-color:".of_get_option('defaultclr',true)."; }";
		}

		// Social Icons Color 
		if( of_get_option('socialfontcolor',true) != '' ){
			echo ".social-icons a{ color:".of_get_option('socialfontcolor',true)."; }";
		}
		if( of_get_option('socialfonthvcolor',true) != '' ){
			echo ".social-icons a:hover{ color:".of_get_option('socialfonthvcolor',true)."; }";
		}
		if( of_get_option('teamsocialfontcolor',true) != '' || of_get_option('teamsocialbgcolor',true) != '' ){
			echo ".team-content .member-social-icon li a { color:".of_get_option('teamsocialfontcolor',true)."; background-color:".of_get_option('teamsocialbgcolor',true)."; }";
		}
		if( of_get_option('teamsocialhvfontcolor',true) != '' || of_get_option('teamsocialhvbgcolor',true) != '' ){
			echo ".team-content .member-social-icon li a:hover { color:".of_get_option('teamsocialhvfontcolor',true)."; background-color:".of_get_option('teamsocialhvbgcolor',true)."; }";
		}

		// Font Colors
		if ( of_get_option('ovrlaysecclr', true) != '' ) {	
			echo ".sec-overlay h2.section_title, .sec-overlay p{ color:".of_get_option('ovrlaysecclr', true)."; }";
		}
		
		// Services Overlay opacity and color			
		$seroverlay = of_get_option('seroverlaycolor',true);
		list($r,$g,$b) = sscanf($seroverlay,'#%02x%02x%02x');
		if ( of_get_option('seroverlaycolor', true) != '' ) {
			echo ".ser-heading, .ser-trend {background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('seroverlaycoloropacity',true).");}";
		}
		
		// Footer Colors		
		if ( of_get_option('footdesccolor', true) != '' ) {
			echo "#footer-wrapper{ color:".of_get_option('footdesccolor', true)."; }";
		}
		if ( of_get_option('footerbgimg', true) != '' ) {
			echo "#footer-wrapper{ background-image:url(".of_get_option('footerbgimg', true).");}";
		}

		$footopac = of_get_option('footbgcolor',true); 
		list($r,$g,$b) = sscanf($footopac,'#%02x%02x%02x');
		if ( of_get_option('footbgcolor', true) != '' ) {
			echo "#footer-wrapper:before{ background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('footbgopac',true).");}";
		}

		$copyopac = of_get_option('copyoverlaycolor',true); 
		list($r,$g,$b) = sscanf($copyopac,'#%02x%02x%02x');
		if ( of_get_option('copyoverlaycolor', true) != '' ) {
			echo ".copyright-text, .copyright-text:before, .designby-text, .designby-text:before { background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('copyoverlaycoloropacity',true).");}";
		}

		if( of_get_option('copycolor', true) != ''){
			echo ".copyright-wrapper{ color:".of_get_option('copycolor',true)."; }";
		}
		if ( of_get_option('copylinks', true) != '' ) {
			echo ".copyright-wrapper a{ color: ".of_get_option('copylinks', true)."; }";
		}
		if ( of_get_option('copylinkshov', true) != '' ) {
			echo ".copyright-wrapper a:hover{ color: ".of_get_option('copylinkshov', true)."; }";
		}
		
		// Button CSS
		if( of_get_option('btnbgcolor',true) != ''){
			echo "a.main-button, .woocommerce div.product .woocommerce-tabs ul.tabs li a.selected:after, .woocommerce #respond input#submit, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce a.button, .woocommerce button.button, .woocommerce button.button.alt, .woocommerce input.button, .woocommerce a.added_to_cart, .woocommerce a.button.alt, .woocommerce input.button.alt, .woocommerce nav.woocommerce-pagination ul li span.current, .quantity-wrap input.plus:hover, .quantity-wrap input.minus:hover, .woocommerce-MyAccount-navigation ul li a, .owl-theme .owl-dots .owl-dot.active span, .owl-theme .owl-dots .owl-dot:hover span, #sidebar .search-form input.search-submit, #sidebar .woocommerce-product-search button, #sidebar #wp-calendar tbody td a, #sidebar #wp-calendar tfoot td a, #sidebar .widget_tag_cloud a, #sidebar .member-info ul li::before, .widget-newsletter .wpcf7-submit, #commentform input#submit, input.search-submit, .post-password-form input[type=submit], #commentform input#submit, input.search-submit, .post-password-form input[type=submit], .wpcf7 form input[type='submit'] { background-color:".of_get_option('btnbgcolor',true).";}";
		}
		
		if( of_get_option('btnbgcolor',true) != ''){
			echo "ul.list-1 li:before, ul.list-2 li:before, ul.list-3 li:before, ul.list-4 li:before, ul.list-5 li:before, ul.list-6 li:before, ul.list-7 li:before, ul.list-8 li:before, ul.list-9 li:before, ul.list-10 li:before, .widget-about-conte h2.wid-abt-hd, .product_meta > span:before, .woocommerce .star-rating span:before { color:".of_get_option('btnbgcolor',true)."; }";			

			echo ".contact-content .form-group input[type='text']:focus, .contact-content .form-group input[type='email']:focus, .contact-content .form-group input[type='tel']:focus, .contact-content .form-group textarea:focus, .feat-icon, input[type='text']:focus, input[type='email']:focus, input[type='url']:focus, input[type='password']:focus, input[type='search']:focus, input[type='number']:focus, input[type='tel']:focus, select:focus, input[type='range']:focus, input[type='date']:focus, input[type='month']:focus, input[type='week']:focus, input[type='time']:focus, input[type='datetime']:focus, input[type='datetime-local']:focus, input[type='color']:focus, textarea:focus{ border-color:".of_get_option('btnbgcolor',true)." !important; }";
		}
				
		if( of_get_option('btntxtcolor', true) != ''){
			echo "a.main-button, .p-cate a, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce button.button.alt, .woocommerce input.button, .woocommerce a.added_to_cart, .woocommerce a.button.alt, .woocommerce input.button.alt, .woocommerce ul.products li.product .onsale, .woocommerce ul.products li.product .sale-perc, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current, #sidebar .widget_tag_cloud a, #commentform input#submit, input.search-submit, .post-password-form input[type=submit], .wpcf7 form input[type='submit'] { color:". of_get_option('btntxtcolor', true) ."; }";
		}
		
		if( of_get_option('btnbghvcolor',true) != '' ){
			echo "a.main-button:hover, .woocommerce ul.products li.product .woocommerce-loop-product__title, .owl-theme .owl-dots .owl-dot span, .p-cate a:hover, #sidebar .widget_tag_cloud a:hover, #sidebar #wp-calendar caption, #commentform input#submit:hover, input.search-submit:hover, .post-password-form input[type=submit]:hover, #sidebar #wp-calendar tbody td a:hover, #sidebar #wp-calendar tfoot td a:hover, #sidebar .search-form input.search-submit:hover, .wpcf7 form input[type='submit']:hover, .woocommerce ul.products li.product .sale-perc, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce button.button.alt:hover, .woocommerce input.button:hover, .woocommerce a.added_to_cart:hover, .woocommerce a.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce .widget_price_filter .price_slider_wrapper .ui-widget-content, .woocommerce .widget_price_filter .ui-slider .ui-slider-range, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce .woo-entry-new-badge, .woocommerce .soldout, .woocommerce-MyAccount-navigation ul li a:hover { background-color:".of_get_option('btnbghvcolor',true)."; }";
		}
		
		if( of_get_option('btnbghvcolor',true) != ''){
			echo ".widget-about-conte .sub-wid-abt-hd{ color:".of_get_option('btnbghvcolor',true)."; }";
		}

		if( of_get_option('btntxthvcolor', true) != '' ){
			echo "a.main-button:hover, .p-cate a:hover, #sidebar .widget_tag_cloud a:hover, #commentform input#submit:hover, input.search-submit:hover, .post-password-form input[type=submit]:hover, .wpcf7 form input[type='submit']:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce button.button.alt:hover, .woocommerce input.button:hover, .woocommerce a.added_to_cart:hover, .woocommerce a.button.alt:hover, .woocommerce input.button.alt:hover, .woocommerce .widget_price_filter .price_slider_wrapper .ui-widget-content, .woocommerce .woo-entry-new-badge, .woocommerce .soldout, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover{ color:". esc_html( of_get_option('btntxthvcolor', true) ) .";}";
		}
		
		//First Button
		if( of_get_option('btnstyle1',true) != '' || of_get_option('',true) != 'btnstyle1hv' ){
			echo "a.buttonstyle1{ color:".of_get_option('btnstyle1',true)."; border-color:".of_get_option('btnstyle1',true).";}";
			echo "a.buttonstyle1:hover { color:".of_get_option('btnstyle1hv',true)."; border-color:".of_get_option('btnstyle1hv',true).";}";
		}		
		
		//Slider Button
		if( of_get_option('sldrbtncolor',true) != '' || of_get_option('sldrbtnhvcolor',true) != ''){
			echo "a.sliderbtn{ border-color:".of_get_option('sldrbtncolor',true)."; color:".of_get_option('sldrbtncolor',true)."; }";
			echo "a.sliderbtn:hover{ border-color:".of_get_option('sldrbtnhvcolor',true)."; color:".of_get_option('sldrbtnhvcolor',true)."; }";
		}
		
		//News & Blog Read More Button
		if( of_get_option('readmorebtncolor',true) != '' || of_get_option('readmorebtnhvcolor',true) != ''){
			echo "a.ln-read-more { border-color:".of_get_option('readmorebtncolor',true)."; color:".of_get_option('readmorebtncolor',true)."; }";
			echo "a.ln-read-more:hover { border-color:".of_get_option('readmorebtnhvcolor',true)."; color:".of_get_option('readmorebtnhvcolor',true)."; }";
		}
		
		// Overlay opacity and color			
		$leryoverlay = of_get_option('overlaycolor',true);
		list($r,$g,$b) = sscanf($leryoverlay,'#%02x%02x%02x');
		if ( of_get_option('overlaycolor', true) != '' ) {
			echo ".sec-overlay:before{background-color:rgba(".$r.",".$g.",".$b.",".of_get_option('overlaycoloropacity',true).");}";
		}

		// Sidebar Widget CSS
		if( of_get_option('sidebarfontcolor',true) != '' ){
			echo "#sidebar ul li, #sidebar ul li a{color:".of_get_option('sidebarfontcolor',true)."; }";
		}
		if( of_get_option('sidebarfonthvcolor',true) != '' ){
			echo "#sidebar ul li a:hover{color:".of_get_option('sidebarfonthvcolor',true)."; }";
		}

		// Tab colors 
		if ( of_get_option('tabactbdrclr', true) != '' ) {
			echo ".tabs-wrapper ul.tabs li a:before { background-color:".of_get_option('tabactbdrclr', true).";}";
		}
		if ( of_get_option('tabttlactvclr', true) != '' ) {
			echo ".tabs-wrapper ul.tabs li a.selected, .tabs-wrapper ul.tabs li a{ color:".of_get_option('tabttlactvclr', true).";}";
		}
		if ( of_get_option('tabcontentfontcolor', true) != '' ) {
			echo ".tabs-wrapper .tab-content{ color:".of_get_option('tabcontentfontcolor', true)."; }";
		}
		
		// Accourdian colors
		if ( of_get_option('accttlclr', true) != '' || of_get_option('acctitlebrdclr', true) != '' || of_get_option('acciconclr', true) != '' ) {
			echo ".accordion-box h2 { color:".of_get_option('accttlclr', true)."; border-color:".of_get_option('acctitlebrdclr', true)."; }";
			echo ".accordion-box h2:after { color:".of_get_option('accttlclr', true).";}";
			echo ".accordion-box h2:before { background-color:".of_get_option('accttlclr', true)."; color:".of_get_option('acciconclr', true)."; }";
		}
		if ( of_get_option('accttlactvclr', true) != '' || of_get_option('accbdractvclr', true) != '') {
			echo ".accordion-box h2.active { color:".of_get_option('accttlactvclr', true)."; border-color:".of_get_option('accbdractvclr', true)."; }";
			echo ".accordion-box h2.active:after { color:".of_get_option('accttlactvclr', true).";}";
			echo ".accordion-box h2.active:before { background-color:".of_get_option('accttlactvclr', true).";}";
		}
		if ( of_get_option('accdescclr', true) != '' ) {
			echo ".acc-content, .acc-content p { color:".of_get_option('accdescclr', true)."; }";
		}
		
		// Skill bar colors
		if ( of_get_option('skillbarbgcolor', true) != '' ) {
			echo ".skill-bg { background-color:".of_get_option('skillbarbgcolor', true)."; }";
		}		
		
		// Back to top
		if( of_get_option('backtpicnclr',true ) !='' || of_get_option('backtpicnhvclr',true ) !='' ){
			echo "#back-top a { color:".of_get_option('backtpicnclr',true)."; }";
			echo "#back-top a:hover { color:".of_get_option('backtpicnhvclr',true)."; }";
		}
		
		// Toggle Menu CSS
		if ( of_get_option('mobilemenubg', true) != '' || of_get_option('mainheadbgclr', true) != '' ) {
			echo "@media screen and (max-width: 990px){
					.header-responsive{ background-color:".of_get_option('mainheadbgclr',true)."; }
					.sitenav ul, span.submenu-button, .submenu-button.submenu-opened:before{ background-color:".of_get_option('mobilemenubg',true)."; }
					.sitenav ul ul{ background-color:transparent; }
				}";
		}
		if( of_get_option('imgeffect',true) != 'off'){
			echo '.woocommerce ul.products li.product .product-item-inner:hover img.attachment-woocommerce_thumbnail{ opacity:0; }';
		}

		echo "</style>";
	}
}
add_action('wp_head', 'Tattoo_custom_head_codes');


function Tattoo_pagination() {
	global $wp_query;
	$big = 12345678;
	$page_format = paginate_links( array(
	    'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
	    'format' => '?paged=%#%',
	    'current' => max( 1, get_query_var('paged') ),
	    'total' => $wp_query->max_num_pages,
	    'type'  => 'array'
	) );
	if( is_array($page_format) ) {
		$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
		echo '<div class="pagination"><div><ul>';
		echo '<li><span>'. $paged . ' of ' . $wp_query->max_num_pages .'</span></li>';
		foreach ( $page_format as $page ) {
			echo "<li>$page</li>";
		}
		echo '</ul></div></div>';
	}
}
/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Load Social Share file.
 */
require get_template_directory() . '/inc/social-share.php';

/**
 * Load custom functions file.
 */
require get_template_directory() . '/inc/custom-functions.php';

/**
 * Load CPT Post Files
 */
require get_template_directory() . '/inc/main-shortcode/photo-gallery.php';
require get_template_directory() . '/inc/main-shortcode/team-members.php';
require get_template_directory() . '/inc/main-shortcode/testimonials.php';
require get_template_directory() . '/inc/main-shortcode/latest-news.php';
require get_template_directory() . '/inc/main-shortcode/portfolio.php';
/**
 * Load Widgets File.
 */
require get_template_directory() . '/inc/widgets/widget-getintouch.php';
require get_template_directory() . '/inc/widgets/widget-aboutus.php';
require get_template_directory() . '/inc/widgets/widget-lastest-posts.php';
require get_template_directory() . '/inc/widgets/widget-side-banner.php';
require get_template_directory() . '/inc/widgets/widget-newsletter.php';
require get_template_directory() . '/inc/widgets/widget-working-hrs.php';
require get_template_directory() . '/inc/widgets/widget-brochure.php';

function Tattoo_custom_blogpost_pagination( $wp_query ){
	$big = 999999999; // need an unlikely integer
	if ( get_query_var('paged') ) { $pageVar = 'paged'; }
	elseif ( get_query_var('page') ) { $pageVar = 'page'; }
	else { $pageVar = 'paged'; }
	$pagin = paginate_links( array(
		'base' 			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
		'format' 		=> '?'.$pageVar.'=%#%',
		'current' 		=> max( 1, get_query_var($pageVar) ),
		'total' 		=> $wp_query->max_num_pages,
		'prev_text'		=> '&laquo; Prev',
		'next_text' 	=> 'Next &raquo;',
		'type'  => 'array'
	) ); 
	if( is_array($pagin) ) {
		$paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
		echo '<div class="pagination"><div><ul>';
		echo '<li><span>'. $paged . ' of ' . $wp_query->max_num_pages .'</span></li>';
		foreach ( $pagin as $page ) {
			echo "<li>$page</li>";
		}
		echo '</ul></div></div>';
	} 
}
// get slug by id
function Tattoo_get_slug_by_id($id) {
	$post_data = get_post($id, ARRAY_A);
	$slug = $post_data['post_name'];
	return $slug; 
}

// Enable shortcodes in text widgets
add_filter('widget_text','do_shortcode');

// Add span to category cournt
function Tattoo_cat_count_span($links) {
  $links = str_replace('</a> (', '</a> <span>(', $links);
  $links = str_replace(')', ')</span>', $links);
  return $links;
}
add_filter('wp_list_categories', 'Tattoo_cat_count_span');

// Add span to archive count
function Tattoo_archive_count($links) {
    $links = str_replace('</a>&nbsp;(', '</a> <span>(', $links);
    $links = str_replace(')', ')</span>', $links);
    return $links;
}
add_filter('get_archives_link', 'Tattoo_archive_count');

/*****************************************************************************************************
//* Remove Woocommers shop page title
******************************************************************************************************/
function Tattoo_hide_woo_page_title() {
	return false;
}
add_filter( 'woocommerce_show_page_title' , 'Tattoo_hide_woo_page_title' );

/*****************************************************************************************************
//* Add New Product badge on woocommerce archive pages
******************************************************************************************************/
function Tattoo_show_new_badge() {
	$postdate      = get_the_time( 'Y-m-d' ); // Post date
	$postdatestamp = strtotime( $postdate );  // Timestamped post date
	$newness       = 2;                      // Newness in days
	if ( ( time() - ( 60 * 60 * 24 * $newness ) ) < $postdatestamp ) {
		echo '<div class="woo-entry-new-badge">' . esc_html__( 'New', 'Tattoo' ) . '</div>';
	}
}
add_action( 'woocommerce_before_shop_loop_item_title','Tattoo_show_new_badge', 20 );

/*****************************************************************************************************
//* Add Discounted percentage in woocommerce product grid
******************************************************************************************************/
function Tattoo_show_sale_percentage() {
	global $product;
	if( ! $product->is_type( 'grouped' ) ) {
		if ( $product->is_on_sale() ) {
			if ( ! $product->is_type( 'variable' ) ) {
				$max_percentage = ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100;
			} else {
				$max_percentage = 0;		 
				foreach ( $product->get_children() as $child_id ) {
					$variation = wc_get_product( $child_id );
					$price = $variation->get_regular_price();
					$sale = $variation->get_sale_price();
					if ( $price != 0 && ! empty( $sale ) ) $percentage = ( $price - $sale ) / $price * 100;
					if ( $percentage > $max_percentage ) {
						$max_percentage = $percentage;
					}
				}		 
			}

			echo "<div class='sale-perc'>-" . round($max_percentage) . "%</div>";
		}
	}
}
add_action( 'woocommerce_before_shop_loop_item_title', 'Tattoo_show_sale_percentage', 25 );

/*****************************************************************************************************
//* Add sold out badge on archive pages
******************************************************************************************************/
add_action( 'woocommerce_before_shop_loop_item_title', function() {
    global $product;
    if ( !$product->is_in_stock() ) {
        echo '<div class="soldout">Sold out</div>';
    }
},11);

/*****************************************************************************************************
//* Add Image on Hover in archive pages
******************************************************************************************************/
if( of_get_option('imgeffect',true) != 'off'){
	function Tattoo_add_extra_product_thumbs() {
			global $product;
			$attachment_ids = $product->get_gallery_attachment_ids();
			foreach( array_slice( $attachment_ids, 0,1 ) as $attachment_id ) {
				$thumbnail_url = wp_get_attachment_image_src( $attachment_id, 'full' );
				echo '<img class="onhover" src="' . $thumbnail_url[0] . '">';
			}
	}
	add_action('woocommerce_before_shop_loop_item_title','Tattoo_add_extra_product_thumbs', 10);
}

/*****************************************************************************************************
//* Change number or products per row to 3
******************************************************************************************************/
if (!function_exists('loop_columns')) {
	function loop_columns() {
		return 3; // 3 products per row
	}
}
add_filter('loop_shop_columns', 'loop_columns', 999);

/*****************************************************************************************************
//* Add number of related products on single product page
******************************************************************************************************/
function Tattoo_related_products_args( $args ) {
	$args['posts_per_page'] = 3; // 3 related products
	$args['columns'] = 3; // arranged in 3 columns
	return $args;
}
add_filter( 'woocommerce_output_related_products_args', 'Tattoo_related_products_args' );

/*****************************************************************************************************
//* Add pagination after 9 products
******************************************************************************************************/
function new_loop_shop_per_page( $cols ) {
  // $cols contains the current number of products per page based on the value stored on Options -> Reading
  // Return the number of products you wanna show per page.
  $cols = 9;
  return $cols;
}
add_filter( 'loop_shop_per_page', 'new_loop_shop_per_page', 9 );

/*****************************************************************************************************
//* Modify Product Image Width
******************************************************************************************************/
function Tattoo_woo_prod_thumb() {
	$theme_support = get_theme_support( 'woocommerce' );
	$theme_support = is_array( $theme_support ) ? $theme_support[0] : array();

	$theme_support['thumbnail_image_width'] = 600;

	remove_theme_support( 'woocommerce' );
	add_theme_support( 'woocommerce', $theme_support );
}

add_action( 'after_setup_theme', 'Tattoo_woo_prod_thumb', 10 );

add_filter( 'woocommerce_get_image_size_gallery_thumbnail', function( $size ) {
	return array(
	'width' => 300,
	'height' => 300,
	'crop' => 0,
	);
} );

/*****************************************************************************************************
//* Add class to stock notification
******************************************************************************************************/
function Tattoo_woo_filter_get_stock_html( $html, $product ) {
    $availability = $product->get_availability();

    if ( ! empty( $availability['availability'] ) ) {
        $class = esc_attr( $availability['class'] );
        $avail_text = wp_kses_post( $availability['availability'] );
        $stock_qty = $product->get_stock_quantity();
		
		if( $stock_qty >= 11 ){
			$class .= ' avail-in-stock';
            $avail_text = sprintf( __( '%s In Stock', 'Tattoo' ), ''.$stock_qty.'');
		}
        elseif( ( $stock_qty > 0 && $stock_qty <= 10 ) ){
            $class .= ' few-in-stock';
            $avail_text = sprintf( __( 'Only %s left in stock', 'Tattoo' ), ''.$stock_qty.'');
		}elseif( $stock_qty = 0 ){
			$class .= ' out-of-stock';
            $avail_text = sprintf( __( 'Out of stock', 'Tattoo' ), '');
		}
        ob_start();

        // Make your changes below
        ?>
        <p class="stock <?php echo $class; ?>"><?php echo $avail_text; ?></p>
        <?php

        $html = ob_get_clean();
    }
    return $html;
}
add_filter( 'woocommerce_get_stock_html', 'Tattoo_woo_filter_get_stock_html', 10, 2 );

/*****************************************************************************************************
//* On / Off Gutenberg
******************************************************************************************************/
if( of_get_option('gutenonoff', true) == 'disable' ){
	add_filter('use_block_editor_for_post', '__return_false');
	add_filter('use_widgets_block_editor', '__return_false');
}
/*****************************************************************************************************
//* Stop WP adding extra <p> </p> to your pages' content
******************************************************************************************************/
if( of_get_option('gutenonoff', true) != 'disable' ){
	remove_filter( 'the_content', 'wpautop' );	
}



/*****************************************************************************************************
//* Remove Product permalink from shop loop
******************************************************************************************************/
remove_action('woocommerce_before_shop_loop_item','woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_after_shop_loop_item','woocommerce_template_loop_product_link_close', 5);

/*****************************************************************************************************
//* Wrap Woocommerce Shop Page Elements
******************************************************************************************************/
function Tattoo_wrap_start_all_elements(){
	echo '<div class="product-item-inner">';
}
add_action('woocommerce_before_shop_loop_item','Tattoo_wrap_start_all_elements', 1);

function Tattoo_wrap_end_all_elements(){
	echo '</div>';
}
add_action('woocommerce_after_shop_loop_item_title','Tattoo_wrap_end_all_elements', 30);


/*****************************************************************************************************
//* Wrap Product Thumbnail Image
******************************************************************************************************/
function Tattoo_start_wrap_prod_thumb() {
	echo '<div class="product-item-thumbnail"><div class="product-item-thumbnail-holder"><a href="' . esc_url( get_the_permalink() ) . '" class="woocommerce-LoopProduct-link woocommerce-loop-product__link">';
}
add_action('woocommerce_before_shop_loop_item_title','Tattoo_start_wrap_prod_thumb', 9);

function Tattoo_end_wrap_prod_thumb() {
	echo '</a></div></div>';
}
add_action('woocommerce_before_shop_loop_item_title','Tattoo_end_wrap_prod_thumb', 25);

/*****************************************************************************************************
/* Wrap Product Title And Price
******************************************************************************************************/
function Tattoo_start_wrap_prod_title() {
	echo '<div class="product-item-title">';
}
add_action('woocommerce_shop_loop_item_title','Tattoo_start_wrap_prod_title', 9);

function Tattoo_end_wrap_prod_title() {
	echo '</div>';
}
add_action('woocommerce_after_shop_loop_item_title','Tattoo_end_wrap_prod_title', 12);

/*****************************************************************************************************
/* Rearrenge Product Rating in shop page
******************************************************************************************************/
remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 );
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_rating', 25 );

/*****************************************************************************************************
/* Display Plus Minus Button for quantity in single product page
******************************************************************************************************/
function Tattoo_display_quantity_plus() {
   echo '<div class="quantity-wrap"><input class="minus" type="button" value="-">';
}
add_action( 'woocommerce_before_add_to_cart_quantity', 'Tattoo_display_quantity_plus',10 );

function Tattoo_display_quantity_minus() {
   echo '<input class="plus" type="button" value="+"></div>';
}
add_action( 'woocommerce_after_add_to_cart_quantity', 'Tattoo_display_quantity_minus',10 );
  
// -------------
// 2. Trigger jQuery script  
function Tattoo_add_cart_quantity_plus_minus() {
	// Check for woocommerce
	if ( class_exists( 'WooCommerce' ) ) {
		// Only run this on the single product page
		if ( ! is_product() ) return; ?>
			<script type="text/javascript">
				jQuery(document).ready(function($){   

					$('form.cart').on( 'click', 'input.plus, input.minus', function() {

						// Get current quantity values
						var qty = $( this ).closest( 'form.cart' ).find( '.qty' );
						var val   = parseFloat(qty.val());
						var max = parseFloat(qty.attr( 'max' ));
						var min = parseFloat(qty.attr( 'min' ));
						var step = parseFloat(qty.attr( 'step' ));

						// Change the value if plus or minus
						if ( $( this ).is( '.plus' ) ) {
							if ( max && ( max <= val ) ) {
								qty.val( max );
							} else {
								qty.val( val + step );
							}
						} else {
							if ( min && ( min >= val ) ) {
								qty.val( min );
							} else if ( val > 1 ) {
								qty.val( val - step );
							}
						}
					
					});

				});
			</script>
		<?php
	}
}
add_action( 'wp_footer', 'Tattoo_add_cart_quantity_plus_minus' );

// Destination Categories
if( ! class_exists( 'Showcase_Taxonomy_Images' ) ) {
	class Showcase_Taxonomy_Images {    public function __construct() {
	   //
	  }    /**
	   * Initialize the class and start calling our hooks and filters
	   */
	   public function init() {
	   // Image actions
	   add_action( 'dest_category_add_form_fields', array( $this, 'add_category_image' ), 10, 2 );
	   add_action( 'created_dest_category', array( $this, 'save_category_image' ), 10, 2 );
	   add_action( 'dest_category_edit_form_fields', array( $this, 'update_category_image' ), 10, 2 );
	   add_action( 'edited_dest_category', array( $this, 'updated_category_image' ), 10, 2 );
	   add_action( 'admin_enqueue_scripts', array( $this, 'load_media' ) );
	   add_action( 'admin_footer', array( $this, 'add_script' ) );
	 }   public function load_media() {
	   if( ! isset( $_GET['taxonomy'] ) || $_GET['taxonomy'] != 'dest_category' ) {
		 return;
	   }
	   wp_enqueue_media();
	 }   /**
	  * Add a form field in the new category page
	  * @since 1.0.0
	  */   public function add_category_image( $taxonomy ) { ?>
	   <div class="form-field term-group">
		 <label for="showcase-taxonomy-image-id"><?php _e( 'Image', 'showcase' ); ?></label>
		 <input type="hidden" id="showcase-taxonomy-image-id" name="showcase-taxonomy-image-id" class="custom_media_url" value="">
		 <div id="category-image-wrapper"></div>
		 <p>
		   <input type="button" class="button button-secondary showcase_tax_media_button" id="showcase_tax_media_button" name="showcase_tax_media_button" value="<?php _e( 'Add Image', 'showcase' ); ?>" />
		   <input type="button" class="button button-secondary showcase_tax_media_remove" id="showcase_tax_media_remove" name="showcase_tax_media_remove" value="<?php _e( 'Remove Image', 'showcase' ); ?>" />
		 </p>
	   </div>
	 <?php }   /**
	  * Save the form field
	  * @since 1.0.0
	  */
	 public function save_category_image( $term_id, $tt_id ) {
	   if( isset( $_POST['showcase-taxonomy-image-id'] ) && '' !== $_POST['showcase-taxonomy-image-id'] ){
		 add_term_meta( $term_id, 'showcase-taxonomy-image-id', absint( $_POST['showcase-taxonomy-image-id'] ), true );
	   }
	  }    /**
	   * Edit the form field
	   * @since 1.0.0
	   */
	  public function update_category_image( $term, $taxonomy ) { ?>
		<tr class="form-field term-group-wrap">
		  <th scope="row">
			<label for="showcase-taxonomy-image-id"><?php _e( 'Image', 'showcase' ); ?></label>
		  </th>
		  <td>
			<?php $image_id = get_term_meta( $term->term_id, 'showcase-taxonomy-image-id', true ); ?>
			<input type="hidden" id="showcase-taxonomy-image-id" name="showcase-taxonomy-image-id" value="<?php echo esc_attr( $image_id ); ?>">
			<div id="category-image-wrapper">
			  <?php if( $image_id ) { ?>
				<?php echo wp_get_attachment_image( $image_id, 'thumbnail' ); ?>
			  <?php } ?>
			</div>
			<p>
			  <input type="button" class="button button-secondary showcase_tax_media_button" id="showcase_tax_media_button" name="showcase_tax_media_button" value="<?php _e( 'Add Image', 'showcase' ); ?>" />
			  <input type="button" class="button button-secondary showcase_tax_media_remove" id="showcase_tax_media_remove" name="showcase_tax_media_remove" value="<?php _e( 'Remove Image', 'showcase' ); ?>" />
			</p>
		  </td>
		</tr>
	 <?php }   /**
	  * Update the form field value
	  * @since 1.0.0
	  */
	 public function updated_category_image( $term_id, $tt_id ) {
	   if( isset( $_POST['showcase-taxonomy-image-id'] ) && '' !== $_POST['showcase-taxonomy-image-id'] ){
		 update_term_meta( $term_id, 'showcase-taxonomy-image-id', absint( $_POST['showcase-taxonomy-image-id'] ) );
	   } else {
		 update_term_meta( $term_id, 'showcase-taxonomy-image-id', '' );
	   }
	 }   /**
	  * Enqueue styles and scripts
	  * @since 1.0.0
	  */
	 public function add_script() {
	   if( ! isset( $_GET['taxonomy'] ) || $_GET['taxonomy'] != 'dest_category' ) {
		 return;
	   } ?>
	   <script> jQuery(document).ready( function($) {
		 _wpMediaViewsL10n.insertIntoPost = '<?php _e( "Insert", "showcase" ); ?>';
		 function ct_media_upload(button_class) {
		   var _custom_media = true, _orig_send_attachment = wp.media.editor.send.attachment;
		   $('body').on('click', button_class, function(e) {
			 var button_id = '#'+$(this).attr('id');
			 var send_attachment_bkp = wp.media.editor.send.attachment;
			 var button = $(button_id);
			 _custom_media = true;
			 wp.media.editor.send.attachment = function(props, attachment){
			   if( _custom_media ) {
				 $('#showcase-taxonomy-image-id').val(attachment.id);
				 $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
				 $( '#category-image-wrapper .custom_media_image' ).attr( 'src',attachment.url ).css( 'display','block' );
			   } else {
				 return _orig_send_attachment.apply( button_id, [props, attachment] );
			   }
			 }
			 wp.media.editor.open(button); return false;
		   });
		 }
		 ct_media_upload('.showcase_tax_media_button.button');
		 $('body').on('click','.showcase_tax_media_remove',function(){
		   $('#showcase-taxonomy-image-id').val('');
		   $('#category-image-wrapper').html('<img class="custom_media_image" src="" style="margin:0;padding:0;max-height:100px;float:none;" />');
		 });
		 // Thanks: http://stackoverflow.com/questions/15281995/wordpress-create-category-ajax-response
		 $(document).ajaxComplete(function(event, xhr, settings) {
		   var queryStringArr = settings.data.split('&');
		   if( $.inArray('action=add-tag', queryStringArr) !== -1 ){
			 var xml = xhr.responseXML;
			 $response = $(xml).find('term_id').text();
			 if($response!=""){
			   // Clear the thumb image
			   $('#category-image-wrapper').html('');
			 }
			}
		  });
		});
	  </script>
	 <?php }
	}
  $Showcase_Taxonomy_Images = new Showcase_Taxonomy_Images();
  $Showcase_Taxonomy_Images->init(); }