<?php
/**
 * @package Tattoo Pro
 * Setup the WordPress core custom functions feature.
 *
*/

add_action('Tattoo_optionsframework_custom_scripts', 'Tattoo_optionsframework_custom_scripts');
function Tattoo_optionsframework_custom_scripts() { ?>
	<script type="text/javascript">
    jQuery(document).ready(function() {
    
        jQuery('#example_showhidden').click(function() {
            jQuery('#section-example_text_hidden').fadeToggle(400);
        });
        
        if (jQuery('#example_showhidden:checked').val() !== undefined) {
            jQuery('#section-example_text_hidden').show();
        }
        
    });
    </script><?php
}

// get_the_content format text
function get_the_content_format( $str ){
	$raw_content = apply_filters( 'the_content', $str );
	$content = str_replace( ']]>', ']]&gt;', $raw_content );
	return $content;
}
// the_content format text
function the_content_format( $str ){
	echo get_the_content_format( $str );
}

function is_google_font( $font ){
	$notGoogleFont = array( 'Arial', 'Comic Sans MS', 'FreeSans', 'Georgia', 'Lucida Sans Unicode', 'Palatino Linotype', 'Symbol', 'Tahoma', 'Trebuchet MS', 'Verdana' );
	if( in_array($font, $notGoogleFont) ){
		return false;
	}else{
		return true;
	}
}

// subhead section function
function sub_head_section( $more ) {
	$pgs = 0;
	do {
		$pgs++;
	} while ($more > $pgs);
	return $pgs;
}

//[clear]
function clear_func() {
	$clr = '<div class="clear"></div>';
	return $clr;
}
add_shortcode( 'clear', 'clear_func' );


//[column_content]Your content here...[/column_content]
function column_content_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'type' => '',	
		'subcls' => '',
	), $atts ) );
	$colPos = strpos($type, '_last');
	if($colPos === false){
		$cnt = '<div class="'.$type.' '.$subcls.'">'.get_the_content_format( do_shortcode($content) ).'</div>';
	}else{
		$type = substr($type,0,$colPos);
		$cnt = '<div class="'.$type.' '.$subcls.' last_column">'.get_the_content_format( do_shortcode($content) ).'</div>';
	}
	return $cnt;
}
add_shortcode( 'column_content', 'column_content_func' );


//[hr]
function hrule_func() {
	$hrule = '<div class="hr"></div>';
	return $hrule;
}
add_shortcode( 'hr', 'hrule_func' );


//[hr_top]
function back_to_top_func() {
	$back_top = '<div id="back-top">
		<a title="Top of Page" href="#top"><span><i class="fal fa-'.of_get_option('backtpicn',true).'" aria-hidden="true"></i></span></a>
	</div>';
	return $back_top;
}
add_shortcode( 'back-to-top', 'back_to_top_func' );


// [searchform]
function searchform_shortcode_func( $atts ){
	return get_search_form( false );
}
add_shortcode( 'searchform', 'searchform_shortcode_func' );

// accordion
function accordion_func( $atts, $content = null ) {
	$acc = '<div class="customtab">'.get_the_content_format( do_shortcode($content) ).'<div class="clear"></div></div>';
	return $acc;
}
add_shortcode( 'accordion', 'accordion_func' );
function accordion_content_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'title' => 'Accordion Title',
	), $atts ) );
	$content = wpautop(trim($content));
	$acn = '<div class="accordion-box"><h2>'.$title.'</h2>
			<div class="acc-content">'.$content.'</div><div class="clear"></div></div>';
	return $acn;
}
add_shortcode( 'accordion_content', 'accordion_content_func' );


// remove excerpt more
function new_excerpt_more( $more ) {
	return '... ';
}
add_filter('excerpt_more', 'new_excerpt_more');

// get post categories function
function getPostCategories(){
	$categories = get_the_category();
	$catOut = '';
	$separator = ' ';
	$catOutput = '';
	if($categories){
		foreach($categories as $category) {
			$catOutput .= '<a href="'.get_category_link( $category->term_id ).'" title="' . esc_attr( sprintf( __( "View all posts in %s", 'Tattoo' ), $category->name ) ) . '">'.$category->cat_name.'</a>'.$separator;
		}
		$catOut = ''.trim($catOutput, $separator);
	}
	return $catOut;
}


// replace last occurance of a string.
function str_lreplace($search, $replace, $subject){
	$pos = strrpos($subject, $search);
	if($pos !== false){
		$subject = substr_replace($subject, $replace, $pos, strlen($search));
	}
	return $subject;
}

//Gradient button
function gradient_button_func( $atts ) {
	extract( shortcode_atts( array(
		'size' => 'small',
		'bg_color' => '#636b74',
		'color' => '#fff',
		'text' => 'More',
		'title' => 'Click',
		'url' => '',
		'position' => 'center',
	), $atts ) );
	$btn  = "<div class=\"clear\"></div>";
	$btn .= "<a href=\"{$url}\" ";
	$btn .= ($title != "") ? " title=\"{$title}\" " : "";
	$btn .= "class=\"grad-btn-{$size} btn-align-{$position}\" style=\"background-color:{$bg_color}; color:{$color}\">";
	$btn .= "{$text}</a>";
	$btn  .= "<div class=\"clear\"></div>";

	return $btn;
}
add_shortcode( 'gradient_button', 'gradient_button_func' );

//Simple Button
function simple_button_func( $atts ) {
	extract( shortcode_atts( array(
		'size' => 'small',
		'bg_color' => '#636b74',
		'color' => '#fff',
		'text' => 'More',
		'title' => 'Click',
		'url' => '',
		'position' => 'left',
	), $atts ) );
	$btn  = "<div class=\"clear\"></div>";
	$btn .= "<a href=\"{$url}\" ";
	$btn .= ($title != "") ? " title=\"{$title}\" " : "";
	$btn .= "class=\"simple-btn-{$size} btn-align-{$position}\" style=\"background-color:{$bg_color}; color:{$color}\">";
	$btn .= "{$text}</a>";
	$btn  .= "<div class=\"clear\"></div>";

	return $btn;
}
add_shortcode( 'simple_button', 'simple_button_func' );

//Round Button
function round_button_func( $atts ) {
	extract( shortcode_atts( array(
		'style' => 'dark',
		'text' => 'More',
		'title' => 'Click',
		'url' => '',
		'position' => 'left',
	), $atts ) );
	$btn  = "<div class=\"clear\"></div>";
	$btn .= "<a href=\"{$url}\" ";
	$btn .= ($title != "") ? " title=\"{$title}\" " : "";
	$btn .= "class=\"round-btn-{$style} round-btn btn-align-{$position}\">";
	$btn .= "<span>{$text}</span></a>";
	$btn  .= "<div class=\"clear\"></div>";

	return $btn;
}
add_shortcode( 'round_button', 'round_button_func' );

//MEssage Info 
function msg_box_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'type' => 'info',
		'bg_color' => '#f6f6f6',
		'color' => '#333',
		'start_color' => "#fff",
		'end_color' => "#eee",
		'border' => "#ccc",
		'align' => '',
		'width' => '100%',
	), $atts ) );
	$msg = '';

	if($type == 'success'){
		$msg  = '<div class="msg-success"><div class="msg-box-icon">';
		$msg .= ($content == '') ? "This is a sample of the 'success' style message box shortcode. To use this style use the following shortcode" : $content;
		$msg .= '</div></div>';
	}elseif($type == 'error'){
		$msg  = '<div class="msg-error"><div class="msg-box-icon">';
		$msg .= ($content == '') ? "This is a sample of the 'error' style message box shortcode. To use this style use the following shortcode." : $content;
		$msg .= '</div></div>';
	}elseif($type == 'warning'){
		$msg  = '<div class="msg-warning"><div class="msg-box-icon">';
		$msg .= ($content == '') ? "This is a sample of the 'warning' style message box shortcode. To use this style use the following shortcode." : $content;
		$msg .= '</div></div>';
	}elseif($type == 'info'){
		$msg  = '<div class="msg-info"><div class="msg-box-icon">';
		$msg .= ($content == '') ? "This is a sample of the 'info' style message box shortcode. To use this style use the following shortcode." : $content;
		$msg .= '</div></div>';
	}elseif($type == 'about'){
		$msg  = '<div class="msg-about"><div class="msg-box-icon">';
		$msg .= ($content == '') ? "This is a sample of the 'about' style message box shortcode. To use this style use the following shortcode." : $content;
		$msg .= '</div></div>';
	}elseif($type == 'custom'){
		$msg  = "<div style=\"width:{$width};\" class=\"msg-align-{$align}\"><div class=\"msg-custom\" style=\"background-color:{$end_color}; background:   -moz-linear-gradient(center top , {$start_color}, {$end_color}); background: -webkit-gradient(linear, 0% 0%, 0% 100%, from({$start_color}), to({$end_color})); background: -webkit-linear-gradient(top, {$start_color}, {$end_color}); background: -ms-linear-gradient(top, {$start_color}, {$end_color}); background: -o-linear-gradient(top, {$start_color}, {$end_color}); border:1px {$border} solid; color:{$color};\">"; 
		$msg .= ($content == '') ? "This is a sample of the 'simple' style message box shortcode." : $content;
		$msg .= '</div></div><div class="clear"></div>';
	}elseif($type == 'simple'){
		$msg  = "<div class=\"msg-simple\" style=\"background-color:{$bg_color}; color:{$color};\">";
		$msg .= ($content == '') ? "This is a sample of the 'simple' style message box shortcode." : $content;
		$msg .= '</div>';
	}
	return $msg;
}
add_shortcode( 'message', 'msg_box_func' );

// List Style
function unorderedlist_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'style' => 'list-1',
	), $atts ) );
	$content = wpautop(trim($content));
	$ulist = '<ul class="'.$style.'">'.$content.'</ul>';
	return $ulist;
}
add_shortcode( 'unordered_list', 'unorderedlist_func' );

//Dropcap
function dropcap_func( $atts, $content = null ) {
	$dcap = '<span class="dropcap">'.$content.'</span>';
	return $dcap;
}
add_shortcode( 'dropcap', 'dropcap_func' );

//Blockquote
function blkquote_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'align' => '',
	), $atts ) );
	$quote = ($content == '' ) ? "<blockquote class=\"align-{$align}\">This is a pullquote. Lorem ipsum dolor sit amet, consectetur adipiscing elit sed pharetra aliquet metus.</blockquote>" : "<blockquote class=\"align-{$align}\">$content</blockquote>";

	return $quote;
}
add_shortcode( 'blockquote', 'blkquote_func' );

//Youtube video 
function Tattoo_youtube_vid($atts,$content = null){
	extract( shortcode_atts( array(
		'vid_identifier' => '',
	),$atts));
	return'<div class="youtube-vid"><iframe height="240" width="320" src="//www.youtube.com/embed/'.$vid_identifier.'?rel=0&showinfo=0&controls=1;" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe></div>';
}
add_shortcode('youtube','Tattoo_youtube_vid');

//Vimeo Video
function Tattoo_vimoe_vid($atts,$content = null){
	extract( shortcode_atts( array(
		'vid_identifier' => '',
	),$atts));
	return'<div class="vimeo-vid"><iframe src="//player.vimeo.com/video/'.$vid_identifier.'?title=0&byline=0&portrait=0&autoplay=0&rel=0;" height="240" width="320" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe></div>';
}
add_shortcode('vimeo','Tattoo_vimoe_vid');

// Social Icon Shortcodes
function Tattoo_social_area($atts,$content = null){
  return '<div class="social-icons">'.do_shortcode($content).'</div>';
 }
add_shortcode('social_area','Tattoo_social_area');

function Tattoo_social($atts){
 extract(shortcode_atts(array(
  'icon' => '',
  'link' => ''
 ),$atts));
  return '<a href="'.$link.'" target="_blank" title="'.$icon.'"><i class="fab fa-'.$icon.'"></i></a>';
 }
add_shortcode('social','Tattoo_social');

// Tab Function
function tabs_func( $atts, $content = null ) {
	$tabs = '<div class="tabs-wrapper"><ul class="tabs">'.do_shortcode($content).'</ul></div>';
	return $tabs;
}
add_shortcode( 'tabs', 'tabs_func' );

function tab_func( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'title' => 'Tab Title',
	), $atts ) );
	$rand = rand(100,999);
	$tab = '<li><a rel="tab'.$rand.'" href="javascript:void(0)">'.$title.'</a><div id="tab'.$rand.'" class="tab-content">'.get_the_content_format($content).'</div></li>';
	return $tab;
}
add_shortcode( 'tab', 'tab_func' );

// Button Shortcode
function readmorebtn_fun($atts){
	extract(shortcode_atts(array(
	'name'	=> '',
	'align'	=> '',
	'link'	=> '#'	
	), $atts));
	return '<div class="custombtn" style="text-align:'.$align.'">	
	   <a class="main-button" href="'.$link.'"><span>'.$name.'</span></a>	   	   
	</div>';
	}
add_shortcode('button','readmorebtn_fun');

// add shortcode for skills
function Tattoo_skills($Tattoo_skill_var){
	extract( shortcode_atts(array(
		'title' 	=> 'title',
		'percent'	=> 'percent',
		'bgcolor_active' => '',
	), $Tattoo_skill_var));
	
	return '<div class="skillbar clearfix " data-percent="'.$percent.'%">
			<div class="skillbar-title"><span>'.$title.'</span></div>
			<div class="skill-bg"><div class="skillbar-bar" style="background-color:'.$bgcolor_active.';"></div></div>
			<div class="skill-bar-percent">'.$percent.'%</div>
			</div>';
}

add_shortcode('skill','Tattoo_skills');

//Spacer Shortcode
function Tattoo_spacer($atts){
	extract(shortcode_atts(array(
		'space' => '',
	), $atts));
	return '<div style="height:'.$space.'px"></div>';
	}
add_shortcode('spacer', 'Tattoo_spacer');

/*Clients Logo function*/
function Tattoo_client_logos($atts, $content = null){
  return '<div class="partners owl-carousel owl-theme">'.do_shortcode($content).'</div>';
  }
add_shortcode('client_lists','Tattoo_client_logos');

function Tattoo_client($atts){
  extract(shortcode_atts(array(
  'image'  => '',
  'link'  => '#'  
  ), $atts));
  return '<div class="item"><div class="partner-logo"><a href="'.$link.'" target="_blank"><img src="'.$image.'" /></a></div></div>';
  }
add_shortcode('client','Tattoo_client');

//Section title
function Tattoo_sec_ttl($atts){
	extract( shortcode_atts( array(		
		'title' => '',
		'section_text' => '',
	), $atts));
	
	return'<div class="section_head"><h2 class="section_title"><span>'.$title.'</span></h2><p>'.$section_text.'</p></div>';	
}
add_shortcode('section_title','Tattoo_sec_ttl');

//Custom Heading
function Tattoo_cust_heading($atts){
	extract( shortcode_atts( array(
		'sml_ttl' =>'',
		'sml_title_color' => '',
		'title' => '',
		'title_color' => '',		
		'font_size'	 =>	'',
		'font_family'	=> '',
		'align' => '',
	), $atts));
	
	return'<div class="custom-heading" style="text-align:'.$align.';">
				<h4 style="color:'.$sml_title_color.';">'.$sml_ttl.'</h4>			
				<h2 style="color:'.$title_color.';font-size:'.$font_size.'; font-family:'.$font_family.';">'.$title.'</h2>
			</div>';	
}
add_shortcode('custom_heading','Tattoo_cust_heading');

// Section Code
function Tattoo_section_code_func( $atts, $content = null ){
	extract( shortcode_atts( array(
		'animation_type'	=>	'',
		'background_image'	=>	'',
		'background_color'	=>	'',
		'container_class'	=>	'',
		'section_sub_title'		=>	'',
		'section_title'		=>	'',
		'section_text'	=>	'',
		'section_class'		=>	'',
	), $atts));
	
	$sec_bg_img = '';
	$sec_title = '';
	$sec_bg_clr = '';

	if ( $section_title != ''  ) :
		$sec_title = '<div class="section_head">
						<h4 class="section-sub-title">'.$section_sub_title.'</h4>
						<div class="heading-line"></div><!-- heading-line -->
						<h2 class="section_title"><span>'.$section_title.'</span></h2>
						<p>'.$section_text.'</p>
					</div><!-- section head -->';
	endif;
	
	if ( $background_image != '' ):
		$sec_bg_img	= 'background-image:url('.$background_image.');';
	endif;
	
	if ( $background_color != '' ):
		$sec_bg_clr	= 'background-color:'.$background_color.';';
	endif;
	
	return '<section class="section-content '.$section_class.'" style="'.$sec_bg_img.' '.$sec_bg_clr.'">
				<div class="'.$container_class.'">
					<div class="wow '.$animation_type.'" data-wow-duration="3s">
						'.$sec_title.'
						'.get_the_content_format( $content ).'
					</div><!-- animation class -->
				</div><!-- container class -->								
			</section><!-- section -->';
}
add_shortcode('section','Tattoo_section_code_func');

//Image Carousel PORTFOLIO GALLERY
function Tattoo_image_carousel_wrap( $atts, $content = null ){
	$img_caro_wrap = '<div class="image-carousel"><ul id="portfolio-gallery" class="gallery list-unstyled cS-hidden">'.get_the_content_format( do_shortcode($content) ).'</ul></div>';
	return $img_caro_wrap;
}
add_shortcode('image_carousel','Tattoo_image_carousel_wrap');

function Tattoo_carousel_image( $atts ){
	extract( shortcode_atts( array(
		'path' => '',
	), $atts ) );
	
	return '<li data-thumb="'.$path.'"><a href="'.$path.'" data-fancybox="images"><img src="'.$path.'" /></a></li>';

}
add_shortcode('image','Tattoo_carousel_image');

/* ===================================== Theme Shortcode =======================================*/

function Tattoo_features_func( $atts, $content = null){
	extract( shortcode_atts( array(
		'image_path' => '',
		'title' => '',
		'button_text' => '',
		'button_link' => ''
		
	),$atts));

	return '<div class="feature-box">
				<div class="feature-thumb"><img src="'.$image_path.'"/></div>
				<div class="feature-inner">
					<h5><a href="'.$button_link.'">'.$title.'</a></h5>
					<p>'.$content.'</p>
					<a class="sliderbtn" href="'.$button_link.'">'.$button_text.'</a>
				</div><!-- feature-inner -->
			</div><!-- feature-box -->';
}
add_shortcode('features','Tattoo_features_func');

// add shortcode for Counter
function Tattoo_counter_wrap( $atts, $content = null ){
	$counter = '<div class="counter-main">'.do_shortcode($content).'</div>';
	return $counter;
}
add_shortcode('counter_wrap','Tattoo_counter_wrap');
function Tattoo_counter($atts, $content = null){
	extract(shortcode_atts(array(
		'image_path' => '',
		'plus'	=> '',
		'title'	=> '',
		'count'	=> '',
		'number_color' => '',
		'title_color' => '',
	), $atts));	

	return '<div class="counter-column">
				<div class="count-box">
					<div class="countnumber">
						'.(($plus == 'yes') ? '<span class="plus">&#43;</span>' : '').'<h2 class="counter" data-speed="5000" style="color:'.$number_color.'">'.$count.' </h2>
					</div><!-- countnumber -->
					<div class="count-thumb">
						<img src="'.$image_path.'"/>
					</div><!-- count-thumb -->
					<div class="counter-ttl">
						<h6 style="color:'.$title_color.'">'.$title.'</h6>
					</div><!-- counter-ttl -->
				</div><!-- count-box -->
			</div><!-- counter-column -->';
}
add_shortcode('counter','Tattoo_counter');

// Add shortcode for Services Third section
function Tattoo_services_func( $atts, $content = null ){
	extract( shortcode_atts( array(
		'image_path' => '',
		'title' => '',
		'price' => '',
		'link' => ''
	),$atts));

	return '<div class="services-box">
				<div class="ser-thumb">
					<img src="'.$image_path.'"/>
				</div><!-- ser-thumb -->
				<div class="ser-heading">
					<h4>'.$title.'</h4>
				</div><!-- ser-heading -->
				<div class="ser-trend">
					<div class="ser-desc">
						<h3 class="ser-title">'.$title.'</h3>
						<p class="ser-text">'.$content.'</p>
					</div><!-- ser-desc -->
					<div class="ser-btm">
						<span class="ser-price">'.$price.'</span>
						<a href="'.$link.'"><i class="fas fa-chevron-right" aria-hidden="true"></i></a>
					</div><!-- ser-btm -->
				</div><!-- ser-trend -->
			</div><!-- services-box -->';
}
add_shortcode('services','Tattoo_services_func');

// add shortcode for About
function Tattoo_video_wrap( $atts, $content = null ){
	$about = '<div class="video-main">'.do_shortcode($content).'</div>';
	return $about;
}
add_shortcode('video_wrap','Tattoo_video_wrap');

function Tattoo_video_left_func( $atts, $content = null){
	extract( shortcode_atts( array(
		'image_path' => '',
		'title' => '',
		'tagline' => ''
		
	),$atts));

	return '<div class="video-left">
				<img src="'.$image_path.'"/>
				'.do_shortcode($content).'
				<div class="video-tag">
					<h3>'.$title.'</h3>
					<span>'.$tagline.'</span>
				</div><!-- video-tag -->
			</div><!-- video-left -->';
}
add_shortcode('video_left','Tattoo_video_left_func');

function Tattoo_faq_right_func( $atts, $content = null){
	extract( shortcode_atts( array(
		'title' => '',
		'sub_title' => ''
		
	),$atts));

	return '<div class="faq-right">
				<h6>'.$sub_title.'</h5>	
				<h3>'.$title.'</h3>
				<p>'.do_shortcode($content).'</p>	
			</div><!-- faq-right -->';
}
add_shortcode('faq_right','Tattoo_faq_right_func');

// Pricing List
function Tattoo_pricing_plan_func( $atts ){
	extract(shortcode_atts( array(
		'image_path' => '',
		'icon'	=> '',
		'icon_style' => 'regular',
		'title' => '',
		'price' => '',
		'price_sign' => '',
		'row1'	=>	'',
		'row2'	=>	'',
		'row3'	=>	'',
		'row4'	=>	'',
		'row5'	=>	'',
		'row6'	=>	'',
		'row7'	=>	'',
		'row8'	=>	'',
		'row9'	=>	'',
		'row10'	=>	'',
		'btn_label'	=>	'',
		'link'	=>	''
	),$atts));

	if($icon_style == 'regular'){
		$shw_icon_style ='r';
	} elseif($icon_style == 'light'){
		$shw_icon_style ='l';
	} elseif($icon_style == 'solid'){
		$shw_icon_style ='s';
	} elseif($icon_style == 'brand'){
		$shw_icon_style ='b';
	}
	
	return'<div class="pricing-col" style="background-image:url('.$image_path.')">
				<div class="price-shape"></div>
				<div class="price-shape2"></div>
				<div class="price-shape3"></div>
				<div class="price-icon">
					<span><i class="fa'.$shw_icon_style.' fa-'.$icon.'" aria-hidden="true"></i></span>
				</div>
				<div class="package-name">
					<h5>'.$title.'</h5>
				</div>
				<div class="package-price">
					<sup>'.$price_sign.' </sup>'.$price.'
				</div>
				<div class="package-row">
					'.(($row1 != '') ? '<p>'.$row1.'</p>' : '').'
					'.(($row2 != '') ? '<p>'.$row2.'</p>' : '').'
					'.(($row3 != '') ? '<p>'.$row3.'</p>' : '').'
					'.(($row4 != '') ? '<p>'.$row4.'</p>' : '').'
					'.(($row5 != '') ? '<p>'.$row5.'</p>' : '').'
					'.(($row6 != '') ? '<p>'.$row6.'</p>' : '').'
					'.(($row7 != '') ? '<p>'.$row7.'</p>' : '').'
					'.(($row8 != '') ? '<p>'.$row8.'</p>' : '').'
					'.(($row9 != '') ? '<p>'.$row9.'</p>' : '').'
					'.(($row10 != '') ? '<p>'.$row10.'</p>' : '').'
				</div>
				<div class="package-btn">
					<a href="'.$link.'" class="buttonstyle1">'.$btn_label.'</a>
				</div>
		   </div>';
}
add_shortcode('pricing-plan','Tattoo_pricing_plan_func');

// Process Section Shortcode
function Tattoo_process_wrap_func( $atts, $content = null ){
	extract( shortcode_atts(array(
		'title' => '',
	),$atts));
	
	return '<div id="process_main">
				<h2>'.$title.'</h2>
				'.get_the_content_format( do_shortcode($content) ).'								
			</div><!-- process_main -->';
}
add_shortcode('process_wrap','Tattoo_process_wrap_func');

function Tattoo_process_func( $atts, $content = null){
	extract( shortcode_atts( array(
		'title' => '',
		'icon'	=> '',
		'icon_style' => 'regular'
	),$atts));

	if($icon_style == 'regular'){
		$shw_icon_style ='r';
	} elseif($icon_style == 'light'){
		$shw_icon_style ='l';
	} elseif($icon_style == 'solid'){
		$shw_icon_style ='s';
	} elseif($icon_style == 'brand'){
		$shw_icon_style ='b';
	}

	return '<div class="process-box">
				<div class="process-icon"><span><i class="fa'.$shw_icon_style.' fa-'.$icon.'" aria-hidden="true"></i></span></div>
				<div class="process-title"><h6>'.$title.'</h6></div>
			</div><!-- process-box -->';
}
add_shortcode('process','Tattoo_process_func');

// Contact Form In Custom Order Section Shortcode
function Tattoo_contactus_func( $atts, $content = null ){
	extract( shortcode_atts(array(
		'title' => '',
		'small_content' => ''
	),$atts));
	
	return '<div id="customorder_main">
				<h2>'.$title.'</h2>
				<p>'.$small_content.'</p>
				'.get_the_content_format( do_shortcode($content) ).'								
			</div><!-- customorder_main -->';
}
add_shortcode('custom_order','Tattoo_contactus_func');

// Custom Order Form Details Shortcode
function Tattoo_custom_order_form_func( $atts, $content = null ){
	extract( shortcode_atts(array(
		'form_name' => '',
		'form_id' => ''
	),$atts));
	
	return '[contact-form-7 id="'.$form_id.'" title="'.$form_name.'"]';
}
add_shortcode('custom_order_form','Tattoo_custom_order_form_func');

/* ===================================== Theme Extra Shortcode =======================================*/
// Add shortcut for icon box
function Tattoo_icon_box_func( $atts, $content = null ){
	extract( shortcode_atts ( array(
		'icon'	=> '',
		'icon_style' => 'regular',
		'title' => '',
		'link' => '',
	),$atts ));

	if($icon_style == 'regular'){
		$shw_icon_style ='r';
	} elseif($icon_style == 'light'){
		$shw_icon_style ='l';
	} elseif($icon_style == 'solid'){
		$shw_icon_style ='s';
	} elseif($icon_style == 'brand'){
		$shw_icon_style ='b';
	}

	if( !empty($icon)){
		$shwicon = '<div class="icon-box-thumb"><span><i class="fa'.$shw_icon_style.' fa-'.$icon.'" aria-hidden="true"></i></span></div><!-- icon box thumb-->';
	} if( !empty($title)){
		$shwttl = '<h4><a href="'.$link.'">'.$title.'</a></h4>';
	}

	return '<div class="icon-box"><div class="inner-icon-box"><div class="icon-outer">'.$shwicon.'</div><div class="icon-box-content">'.$shwttl.'<p>'.$content.'</p><a class="ReadMore" href="#">Read More</a></div></div></div>';
}
add_shortcode('icon_box','Tattoo_icon_box_func');

//popup video
function Tattoo_popup_func( $atts ){
	extract( shortcode_atts(array(
		'video_link' => '',
	),$atts));
	
	return '<div class="pop-video"><div class="inner-pop-video"><div class="pop-icon"><a data-fancybox data-width="1060" data-height="600" href="'.$video_link.'"><i class="fal fa-play-circle"></i></a></div></div></div>';
}
add_shortcode('popup_video','Tattoo_popup_func');

define('FLY_THEME_DOC','live-demo.online/documentation/tattoo-doc/');