<?php
/**
 * @package Tattoo
 * Setup the WordPress core custom header feature.
 *
 * @uses Tattoo_header_style()
 * @uses Tattoo_admin_header_style()
 * @uses Tattoo_admin_header_image()

 */
function Tattoo_custom_header_setup() {
add_theme_support( 'custom-header', apply_filters( 'Tattoo_custom_header_args', array(
		//'default-image'          => get_template_directory_uri().'/images/inner-banner.jpg',
		'default-text-color'     => 'fff',
		'width'                  => 1420,
		'height'                 => 300,
		'wp-head-callback'       => 'Tattoo_header_style',
		'admin-head-callback'    => 'Tattoo_admin_header_style',
		'admin-preview-callback' => 'Tattoo_admin_header_image',
	) ) );
}
add_action( 'after_setup_theme', 'Tattoo_custom_header_setup' );

if ( ! function_exists( 'Tattoo_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see Tattoo_custom_header_setup().
 */
function Tattoo_header_style() {
	$header_text_color = get_header_textcolor();
	?>
	<style type="text/css">
	<?php
		//Check if user has defined any header image.
		if ( get_header_image() ) :
	?>
		.innerbanner123{
			background: url(<?php echo get_header_image(); ?>) no-repeat #111;
			background-position: center top;
		}
	<?php endif; ?>	
	</style>
	<?php
}
endif; // Tattoo_header_style

if ( ! function_exists( 'Tattoo_admin_header_style' ) ) :
/**
 * Styles the header image displayed on the Appearance > Header admin panel.
 *
 * @see Tattoo_custom_header_setup().
 */
function Tattoo_admin_header_style() {?>
	<style type="text/css">
	.appearance_page_custom-header #headimg { border: none; }
	</style><?php
}
endif; // Tattoo_admin_header_style


add_action( 'admin_head', 'admin_header_css' );
function admin_header_css(){ ?>
	<style>pre{white-space: pre-wrap;}</style><?php
}


if ( ! function_exists( 'Tattoo_admin_header_image' ) ) :
/**
 * Custom header image markup displayed on the Appearance > Header admin panel.
 *
 * @see Tattoo_custom_header_setup().
 */
function Tattoo_admin_header_image() {
	$style = sprintf( ' style="color:#%s;"', get_header_textcolor() );
?>
	<div id="headimg">
		<?php if ( get_header_image() ) : ?>
		<img src="<?php header_image(); ?>" alt="">
		<?php endif; ?>
	</div>
<?php     
}
endif; // Tattoo_admin_header_image 


define('star_URL','https://www.alexathemes.net');
define('star_THEME_URL','https://alexathemes.net/themes/');