<?php
//custom post type for Our photogallery
function my_custom_post_photogallery() {
	$labels = array(
		'name'               => __( 'Photo Gallery','Tattoo' ),
		'singular_name'      => __( 'Photo Gallery','Tattoo' ),
		'add_new'            => __( 'Add New','Tattoo' ),
		'add_new_item'       => __( 'Add New Image ','Tattoo' ),
		'edit_item'          => __( 'Edit Image','Tattoo' ),
		'new_item'           => __( 'New Image','Tattoo' ),
		'all_items'          => __( 'All Images','Tattoo' ),
		'view_item'          => __( 'View Image','Tattoo' ),
		'search_items'       => __( 'Search Images','Tattoo' ),
		'not_found'          => __( 'No images found','Tattoo' ),
		'not_found_in_trash' => __( 'No images found in the Trash','Tattoo' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Photo Gallery'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Manage Photo Gallery',
		'public'        => true,
		'menu_position' => null,
		'menu_icon'   => 'dashicons-format-gallery',
		'supports'      => array( 'title', 'thumbnail' ),
		'has_archive'   => false,
	);
	register_post_type( 'photogallery', $args );
}
add_action( 'init', 'my_custom_post_photogallery' );
/******************************************************************************************/
//Register Category to Photogallery CPT
function taxonomies_photo_gallery() {
  $labels = array(
    'name'              => __( 'Gallery Categories', 'Tattoo' ),
    'singular_name'     => __( 'Gallery Category', 'Tattoo' ),
    'search_items'      => __( 'Search Gallery Categories', 'Tattoo' ),
    'all_items'         => __( 'All Gallery Categories', 'Tattoo' ),
    'parent_item'       => __( 'Parent Gallery Category', 'Tattoo' ),
    'parent_item_colon' => __( 'Parent Gallery Category:', 'Tattoo' ),
    'edit_item'         => __( 'Edit Gallery Category', 'Tattoo' ), 
    'update_item'       => __( 'Update Gallery Category', 'Tattoo' ),
    'add_new_item'      => __( 'Add New Gallery Category', 'Tattoo' ),
    'new_item_name'     => __( 'New Gallery Category', 'Tattoo' ),
    'menu_name'         => __( 'Gallery Categories', 'Tattoo' ),
  );
  $args = array(
    'labels' => $labels,
    'hierarchical' => true,
	'show_admin_column'	=>	true,
  );
  register_taxonomy( 'photogallery_category', 'photogallery', $args );
}
add_action( 'init', 'taxonomies_photo_gallery', 0 );
/******************************************************************************************/
//Register Meta Boxes to photogallery
function photo_gallery_admin_func(){
	add_meta_box(
		"video_file_url-meta",
		"Video File URL",
		"display_photo_gallery_func",
		"photogallery", "normal", "low"); 
}
add_action("admin_init", "photo_gallery_admin_func");
//Display Photogallery Meta Boxes
function display_photo_gallery_func() {
	global $post;  
	$custom     = get_post_custom($post->ID);  
	$video_file_url  = isset ( $custom["video_file_url"][0] ) ? $custom["video_file_url"][0] : '';  ?> 
	<style>
	.amount_input { margin:0; padding:6px; width:80%; }
	</style>
	<table width="100%"> 
		<tr><td width="110">Video File URL : </td><td colspan="2"><input class="amount_input" type="text" name="video_file_url"  value="<?php echo $video_file_url; ?>"  /></td></tr> 
		<tr><td></td><td><strong>YouTube video url:</strong></td><td>http://www.youtube.com/watch?v=qqXi8WmQ_WM</td></tr> 
		<tr><td></td><td width="120"><strong>Vimeo video url:</strong></td><td>http://vimeo.com/8245346</td></tr> 
	</table>
	<?php
}
//Save Meta boxes
function photo_gallery_save_details(){
	global $post; 
	if ( isset($_POST["video_file_url"]) ) {
		update_post_meta($post->ID, "video_file_url", $_POST["video_file_url"]);
	} 
}
add_action('save_post', 'photo_gallery_save_details');
/**************************************************************************************************/
//Gallery Function
function photo_gallery_shortcode_func( $atts ){
	extract( shortcode_atts( array(
		'show'	=>	'',
		'type' => '',
		'category'	=>	'',
		'column'	=>	'',
	),$atts));
	
	$gallerypos ='<div class="gallery-wrap">';
	
	$gal_query = new WP_Query( array(			
		'post_type' => 'photogallery', 
		'posts_per_page' => $show,
		'photogallery_category' => $category,
		'orderby' => 'title',
    	'order'   => 'ASC',
	) );
	
	if( $gal_query->have_posts() ) : $counter = 0;
		
		if( $type == 'filter' ){
			$gallerypos .= '<div class="portoolbar"><ul id="portfoliofilter clearfix"><li class="filter" data-filter="all">All</li>';
			$categories = get_categories( array('taxonomy' => 'photogallery_category') );
			foreach ($categories as $category) {
				$gallerypos .= '<li class="filter" data-filter=".'.$category->slug.'">'.$category->name.'</li>';
			}
			$gallerypos .= '</ul></div>';
		}

		if( $type == 'slider' ) : $gallerypos .='<div class="owl-carousel gal-rotator owl-theme">';  endif;

		if( $type == 'filter' ) : $gallerypos .='<div id="mixitupgal">';  endif;

		while( $gal_query->have_posts() ) : $gal_query->the_post();
			$counter++; 
			
			$videoUrl = get_post_meta( get_the_ID(), 'video_file_url', true);
			$imgSrc = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full');
			$imgSrcThumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'gal-thumb');
		
			if ( $imgSrc[0]!='' ) {
				$imgUrl = $imgSrc[0];
			}else{
				$imgUrl = get_template_directory_uri().'/images/img_404.png';
			}
			
			if ( $imgSrcThumb[0]!='' ) {
				$imgThumbUrl = $imgSrcThumb[0];
			}else{
				$imgThumbUrl = get_template_directory_uri().'/images/img_404.png';
			}

			if( $type == 'filter' ){
				$terms = wp_get_post_terms( get_the_ID(), 'photogallery_category', array("fields" => "all"));		
				$categories = get_the_category();
				$slugAr = array();
				foreach( $terms as $tv ){
					$slugAr[] = $tv->slug;
				}
			}
			
			if( $counter%2 == 0 ) $nomargn2 = ' lastcols'; else $nomargn2 = '';
			if( $counter%3 == 0 ) $nomargn3 = ' lastcols'; else $nomargn3 = '';
			if( $counter%4 == 0 ) $nomargn4 = ' lastcols'; else $nomargn4 = '';
			
			if( $column == 2 ){
				$shwgridcol = 'grid-col-two '.$nomargn2.'';
				$countcol = '1';
			}
			elseif( $column == 3 ){
				$shwgridcol = 'grid-col-three '.$nomargn3.'';
				$countcol = '2';
			}
			elseif( $column == 4 ){
				$shwgridcol = 'grid-col-four '.$nomargn4.'';
				$countcol = '3';
			}
				
			if( $type == 'grid' ) :
				$gallerypos .='<div class="gallery '.$shwgridcol.'">
									<div class="gallery-image">
										<img src="'.$imgThumbUrl.'" alt="'.get_the_title().'"/>
										<div class="gal-category">
											'.get_the_term_list(get_the_ID(), 'photogallery_category', '', '').'
										</div><!-- gal-category -->
										<div class="gal-icon">
											<a class="pop-gallery" data-fancybox="group'.$countcol.'" data-thumb="'.$imgThumbUrl.'" href="'.( ($videoUrl) ? $videoUrl : $imgSrc[0] ).'" data-caption="'.get_the_title().'"><i class="fal fa-plus"></i></a>
										</div>
									</div>
							   </div>';				
			elseif( $type == 'slider' ) :
				$gallerypos .='<div class="item"><div class="gallery">
									<div class="gallery-image">
										<img src="'.$imgThumbUrl.'" alt="'.get_the_title().'"/>
										<div class="gal-category">
											'.get_the_term_list(get_the_ID(), 'photogallery_category', '', '').'
										</div><!-- gal-category -->
										<div class="gal-icon">
											<a class="pop-gallery" data-fancybox="group'.$countcol.'" data-thumb="'.$imgThumbUrl.'" href="'.( ($videoUrl) ? $videoUrl : $imgSrc[0] ).'" data-caption="'.get_the_title().'"><i class="fal fa-plus"></i></a>
										</div>
									</div>
							   </div></div>';
			elseif( $type == 'filter' ) :
				$gallerypos .='<div class="mix '.implode(' ', $slugAr).'"><div class="gallery">
									<div class="gallery-image">
										<img src="'.$imgThumbUrl.'" alt="'.get_the_title().'"/>
										<div class="gal-category">
											'.get_the_term_list(get_the_ID(), 'photogallery_category', '', '').'
										</div><!-- gal-category -->
										<div class="gal-icon">
											<a class="pop-gallery" data-fancybox="group4" data-thumb="'.$imgThumbUrl.'" href="'.( ($videoUrl) ? $videoUrl : $imgSrc[0] ).'" data-caption="'.get_the_title().'"><i class="fal fa-plus"></i></a>
										</div>
									</div>
							   </div></div>';
			endif;
			
		endwhile; wp_reset_postdata(); 
		if( $type == 'filter' ) : $gallerypos .='</div>'; endif;
		if( $type == 'slider' ) : $gallerypos .='</div>'; endif;
		$gallerypos .='<div class="clear"></div>';
	else :
		$gallerypos .='<div class="text-center error_msg" style="display:table; margin:0 auto;">'.__('Sorry, No photos in Gallery.','Tattoo').'</div>';
	endif;
	$gallerypos .='</div>';
		
	return $gallerypos;
	
}
add_shortcode('photo-gallery','photo_gallery_shortcode_func');