<?php
//custom post type for Portfolio
function my_custom_post_portfolio() {
	$labels = array(
		'name'               => __( 'Portfolios','Tattoo' ),
		'singular_name'      => __( 'Portfolio','Tattoo' ),
		'add_new'            => __( 'Add New','Tattoo' ),
		'add_new_item'       => __( 'Add New Portfolio ','Tattoo' ),
		'edit_item'          => __( 'Edit Portfolio','Tattoo' ),
		'new_item'           => __( 'New Portfolio','Tattoo' ),
		'all_items'          => __( 'All Portfolios','Tattoo' ),
		'view_item'          => __( 'View Portfolio','Tattoo' ),
		'search_items'       => __( 'Search Portfolios','Tattoo' ),
		'not_found'          => __( 'No Portfolios found','Tattoo' ),
		'not_found_in_trash' => __( 'No Portfolios found in the Trash','Tattoo' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Portfolios'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Manage Portfolios',
		'public'        => true,
		'menu_position' => null,
		'menu_icon'   => 'dashicons-index-card',
		'supports'      => array( 'title', 'thumbnail', 'editor' ),
		'has_archive'   => false,
	);
	register_post_type( 'portfolio', $args );
}
add_action( 'init', 'my_custom_post_portfolio' );
/******************************************************************************************/
//Register Category to Portfolio CPT
function taxonomies_portfolios() {
  $labels = array(
    'name'              => __( 'Portfolio Categories', 'Tattoo' ),
    'singular_name'     => __( 'Category', 'Tattoo' ),
    'search_items'      => __( 'Search Categories', 'Tattoo' ),
    'all_items'         => __( 'All Categories', 'Tattoo' ),
    'parent_item'       => __( 'Parent Category', 'Tattoo' ),
    'parent_item_colon' => __( 'Parent Category:', 'Tattoo' ),
    'edit_item'         => __( 'Edit Category', 'Tattoo' ), 
    'update_item'       => __( 'Update Category', 'Tattoo' ),
    'add_new_item'      => __( 'Add New Category', 'Tattoo' ),
    'new_item_name'     => __( 'New Category', 'Tattoo' ),
    'menu_name'         => __( 'Categories', 'Tattoo' ),
  );
  $args = array(
    'labels' => $labels,
    'hierarchical' => true,
	'show_admin_column'	=>	true,
  );
  register_taxonomy( 'port_category', 'portfolio', $args );
}
add_action( 'init', 'taxonomies_portfolios', 0 );
/******************************************************************************************/
// Metabox for Portfolio CPT
function Tattoo_portf_meta_box(){
	add_meta_box(
		'portf_info_meta',
		'Other Information',
		'display_portf_info_meta',
		'portfolio','normal','high'
	);
}
add_action('admin_init','Tattoo_portf_meta_box');

function display_portf_info_meta( $portfolio ){
	$clientlbl = esc_html( get_post_meta( $portfolio->ID, '_clientlbl', true ) );
	$client = esc_html( get_post_meta( $portfolio->ID, '_client', true ) );
	$locatelbl = esc_html( get_post_meta( $portfolio->ID, '_locatelbl', true ) );
	$location = esc_html( get_post_meta( $portfolio->ID, '_location', true ) );
	$pdatelbl = esc_html( get_post_meta( $portfolio->ID, '_pdatelbl', true ) );
	$pdate = esc_html( get_post_meta( $portfolio->ID, '_pdate', true ) );
	$designlbl = esc_html( get_post_meta( $portfolio->ID, '_designlbl', true ) );
	$designer = esc_html( get_post_meta( $portfolio->ID, '_designer', true ) );
?>

<table width="100%">
	<tr>
        <td width="20%"><strong><?php _e('Field Name','Tattoo');?></strong></td>
        <td width="40%"><strong><?php _e('Label','Tattoo');?></strong></td>
        <td width="40%"><strong><?php _e('Value','Tattoo');?></strong></td>
    </tr>
    <tr>
        <td width="20%">Client</td>
        <td width="40%"><input type="text" name="clientlbl" value="<?php echo $clientlbl; ?>" style="width:100%;" /></td>
        <td width="40%"><input type="text" name="client" value="<?php echo $client; ?>" style="width:100%;" /></td>
	</tr>
	<tr>
        <td width="20%">Location</td>
        <td width="40%"><input type="text" name="locatelbl" value="<?php echo $locatelbl; ?>" style="width:100%;" /></td>
        <td width="40%"><input type="text" name="location" value="<?php echo $location; ?>" style="width:100%;" /></td>
	</tr>
	<tr>
        <td width="20%">Completed Date</td>
        <td width="40%"><input type="text" name="pdatelbl" value="<?php echo $pdatelbl; ?>" style="width:100%;" /></td>
        <td width="40%"><input type="text" name="pdate" value="<?php echo $pdate; ?>" style="width:100%;" /></td>
	</tr>
	<tr>
        <td width="20%">Designer</td>
        <td width="40%"><input type="text" name="designlbl" value="<?php echo $designlbl; ?>" style="width:100%;" /></td>
        <td width="40%"><input type="text" name="designer" value="<?php echo $designer; ?>" style="width:100%;" /></td>
	</tr>
</table>

<?php }
function save_portf_info_meta( $portfolio_id, $portfolio ){
	if ( $portfolio->post_type == 'portfolio' ) {
		if ( isset($_POST['clientlbl']) ) {
            update_post_meta( $portfolio_id, '_clientlbl', $_POST['clientlbl'] );
        }
		if ( isset($_POST['client']) ) {
            update_post_meta( $portfolio_id, '_client', $_POST['client'] );
		}
		if ( isset($_POST['locatelbl']) ) {
            update_post_meta( $portfolio_id, '_locatelbl', $_POST['locatelbl'] );
        }
		if ( isset($_POST['location']) ) {
            update_post_meta( $portfolio_id, '_location', $_POST['location'] );
		}
		if ( isset($_POST['pdatelbl']) ) {
            update_post_meta( $portfolio_id, '_pdatelbl', $_POST['pdatelbl'] );
        }
		if ( isset($_POST['pdate']) ) {
            update_post_meta( $portfolio_id, '_pdate', $_POST['pdate'] );
		}
		if ( isset($_POST['designlbl']) ) {
            update_post_meta( $portfolio_id, '_designlbl', $_POST['designlbl'] );
        }
		if ( isset($_POST['designer']) ) {
            update_post_meta( $portfolio_id, '_designer', $_POST['designer'] );
		}		         
	}
}
add_action('save_post','save_portf_info_meta',10,2);
/******************************************************************************************/
/* Portfolio Shortcode */
function Tattoo_portfolio_shortcode_func( $atts ){
	extract( shortcode_atts( array(
		'show' => '-1',
		'type' => '',
		'filter' => 'true',
		'column' => '3'
	),$atts));
	
	$port = '';
	
	$port_query = new WP_Query( array(
		'post_type' => 'portfolio', 
		'posts_per_page' => $show,
		'orderby' => 'title',
    	'order'   => 'ASC',
	));
	
	if( $port_query->have_posts() ) :
		
		if( $type == 'grid' ){
			if( $filter == 'true' ){
				$port .= '<div class="portoolbar"><ul id="portfoliofilter clearfix"><li class="filter" data-filter="all">All</li>';
				$categories = get_categories( array('taxonomy' => 'port_category') );
				foreach ($categories as $category) {
					$port .= '<li class="filter" data-filter=".'.$category->slug.'">'.$category->name.'</li>';
				}
				$port .= '</ul></div>';
			}
		}

		if( $type == 'grid' ){
			$port .= '<div class="portfolio-main"><div id="mixitup">';
		} else {
			$port .= '<div class="portfolio-main"><div class="owl-carousel portf-rotator owl-theme">';
		}

		while( $port_query->have_posts() ) : $port_query->the_post();
			$terms = wp_get_post_terms( get_the_ID(), 'port_category', array("fields" => "all"));		
			$categories = get_the_category();
			$slugAr = array();
			foreach( $terms as $tv ){
				$slugAr[] = $tv->slug;
			}
			
			$imgSrc = wp_get_attachment_image_src( get_post_thumbnail_id(), 'portf-post-thumb');
			if ( $imgSrc[0]!='' ) {
				$imgUrl = $imgSrc[0];
			}else{
				$imgUrl = get_template_directory_uri().'/images/img_404.png';
			}
			
			if( $column == 2 ){
				$shwgridcol = 'grid-col-two';
				$countcol = '1';
			}
			elseif( $column == 3 ){
				$shwgridcol = 'grid-col-three';
				$countcol = '2';
			}
			elseif( $column == 4 ){
				$shwgridcol = 'grid-col-four';
				$countcol = '3';
			}

			if( $type == 'grid'){	
				$port .= '<div class="mix '.$shwgridcol.' '.implode(' ', $slugAr).'">
							<div class="portfolio-inner">
								<div class="portfolio-image">
									<img src="'.$imgUrl.'" alt="'.get_the_title().'">
									<div class="portfolio-overlay">
										<h5>'.get_the_title().'</h5>
										<span class="port-category">'.get_the_term_list(get_the_ID(), 'port_category', '', '').'</span>
									</div><!-- portfolio-content -->
									<div class="overlay-two">
										<div class="overlay-inner">
											<div class="overlay-text">
												<ul>
													<li><a href="'.get_the_permalink().'"><i class="fas fa-link"></i></a></li>
													<li><a class="pop-gallery" data-fancybox="group'.$countcol.'" data-thumb="'.$imgThumbUrl.'" href="'.( ($videoUrl) ? $videoUrl : $imgSrc[0] ).'" data-caption="'.get_the_title().'"><i class="fas fa-search-plus"></i></a></li>
												</ul>
												<h5><a href="'.get_the_permalink().'">'.get_the_title().'</a></h5>
											</div><!-- content-overlay -->
										</div><!-- overlay-inner -->
									</div><!-- overlay-two -->
								</div><!-- portfolio-image -->
							</div><!-- portfolio-inner -->
						</div><!-- mix -->';
			} elseif( $type == 'slider') {
				$port .= '<div class="items">
							<div class="portfolio-inner">
								<div class="portfolio-image">
									<img src="'.$imgUrl.'" alt="'.get_the_title().'">
									<div class="portfolio-overlay">
										<h5>'.get_the_title().'</h5>
										<span class="port-category">'.get_the_term_list(get_the_ID(), 'port_category', '', '').'</span>
									</div><!-- portfolio-content -->
									<div class="overlay-two">
										<div class="overlay-inner">
											<div class="overlay-text">
												<ul>
													<li><a href="'.get_the_permalink().'"><i class="fas fa-link"></i></a></li>
													<li><a class="pop-gallery" data-fancybox="group'.$countcol.'" data-thumb="'.$imgThumbUrl.'" href="'.( ($videoUrl) ? $videoUrl : $imgSrc[0] ).'" data-caption="'.get_the_title().'"><i class="fas fa-search-plus"></i></a></li>
												</ul>
												<h5><a href="'.get_the_permalink().'">'.get_the_title().'</a></h5>
											</div><!-- content-overlay -->
										</div><!-- overlay-inner -->
									</div><!-- overlay-two -->
								</div><!-- portfolio-image -->
							</div><!-- portfolio-inner -->
						</div><!-- item -->';
			}

		endwhile; wp_reset_postdata();

		$port .= '</div><!-- #mixitup --></div><!-- .portfolio main -->';

	else : 
		$port .='<div class="text-center error_msg" style="display:table; margin:0 auto;">'.__('Sorry, There are no Portfolio found','Tattoo').'</div>';
	endif;
	
	return $port;
}
add_shortcode('portfolio','Tattoo_portfolio_shortcode_func');