<?php
//custom post type for Our Team
function my_custom_post_team() {
	$labels = array(
		'name'               => __( 'Our Team', 'Tattoo' ),
		'singular_name'      => __( 'Our Team', 'Tattoo' ),
		'add_new'            => __( 'Add New', 'Tattoo' ),
		'add_new_item'       => __( 'Add New Menmber', 'Tattoo' ),
		'edit_item'          => __( 'Edit Menmber', 'Tattoo' ),
		'new_item'           => __( 'New Menmber', 'Tattoo' ),
		'all_items'          => __( 'All Menmbers', 'Tattoo' ),
		'view_item'          => __( 'View Menmbers', 'Tattoo' ),
		'search_items'       => __( 'Search Menmbers', 'Tattoo' ),
		'not_found'          => __( 'No Menmbers found', 'Tattoo' ),
		'not_found_in_trash' => __( 'No Menmbers found in the Trash', 'Tattoo' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Our Team'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Manage team posts',
		'public'        => true,
		'menu_position' => null,
		'menu_icon'		=> 'dashicons-groups',
		'supports'      => array( 'title', 'editor', 'thumbnail' ),
		'rewrite' => array('slug' => 'our-team'),
		'has_archive'   => false,
	);
	register_post_type( 'team', $args );
}
add_action( 'init', 'my_custom_post_team' );

// add meta box to team
add_action( 'admin_init', 'my_team_admin_function' );
function my_team_admin_function() {
    add_meta_box( 'team_meta_box',
        'Team Member Details',
        'display_team_meta_box',
        'team', 'normal', 'default'
    );
}

function display_team_meta_box( $team ) {
	$address = esc_html( get_post_meta( $team->ID, 'address', true ));
	$phone = esc_html( get_post_meta( $team->ID, 'phone', true ));
	$mobile = esc_html( get_post_meta( $team->ID, 'mobile', true ));
	$email = esc_html( get_post_meta( $team->ID, 'email', true ));
	$designation = esc_html( get_post_meta( $team->ID, 'designation', true ) );	
	$facebook = get_post_meta( $team->ID, 'facebook', true );
	$facebooklink = esc_url( get_post_meta( $team->ID, 'facebooklink', true ) );
    $twitter = get_post_meta( $team->ID, 'twitter', true );
	$twitterlink = esc_url( get_post_meta( $team->ID, 'twitterlink', true ) );
    $linkedin = get_post_meta( $team->ID, 'linkedin', true );
	$linkedinlink = esc_url( get_post_meta( $team->ID, 'linkedinlink', true ) );
	$pint = get_post_meta( $team->ID, 'google', true );
	$googlelink = esc_url( get_post_meta( $team->ID, 'googlelink', true ) );
    $dribbble = get_post_meta( $team->ID, 'dribbble', true );
	$dribbblelink = get_post_meta( $team->ID, 'dribbblelink', true );
?>
	<table width="100%">
    	<tr>
            <td width="20%">Designation </td>
            <td width="20%"><input type="text" name="designation" value="<?php echo $designation; ?>" style="width:100%;" /></td>
        </tr>
        <tr>
            <td width="20%">Email </td>
            <td width="20%"><input type="text" name="email" value="<?php echo $email; ?>" style="width:100%;" /></td>
        </tr>
        <tr>
            <td width="20%">Phone </td>
            <td width="20%"><input type="text" name="phone" value="<?php echo $phone; ?>" style="width:100%;" /></td>
        </tr>
        <tr>
            <td width="20%">Mobile </td>
            <td width="20%"><input type="text" name="mobile" value="<?php echo $mobile; ?>" style="width:100%;" /></td>
        </tr>
    	<tr>
            <td width="20%">Address </td>
            <td width="20%"><input type="text" name="address" value="<?php echo $address; ?>" style="width:100%;" /></td>
        </tr>            	        
        <tr>
            <td width="20%">Social link 1</td>
            <td width="20%"><input type="text" name="facebook" value="<?php echo $facebook; ?>" style="width:100%;"/></td>
            <td width="30%"><input style="width:100%;" type="text" name="facebooklink" value="<?php echo $facebooklink; ?>" /></td>
        </tr>
        <tr>
            <td width="20%">Social Link 2</td>
            <td width="20%"><input type="text" name="twitter" value="<?php echo $twitter; ?>" style="width:100%;"/></td>
            <td width="30%"><input style="width:100%;" type="text" name="twitterlink" value="<?php echo $twitterlink; ?>" /></td>
        </tr>
        <tr>
            <td width="20%">Social Link 3</td>
            <td width="20%"><input type="text" name="linkedin" value="<?php echo $linkedin; ?>" style="width:100%;"/></td>
            <td width="30%"><input style="width:100%;" type="text" name="linkedinlink" value="<?php echo $linkedinlink; ?>" /></td>
        </tr>
        <tr>
            <td width="20%">Social Link 4</td>
            <td width="20%"><input type="text" name="dribbble" value="<?php echo $dribbble; ?>" style="width:100%;"/></td>
            <td width="30%"><input style="width:100%;" type="text" name="dribbblelink" value="<?php echo $dribbblelink; ?>" /></td>
        </tr>
        <tr>
            <td width="20%">Social Link 5</td>
            <td width="20%"><input type="text" name="google" value="<?php echo $pint; ?>" style="width:100%;"/></td>
            <td width="30%"><input style="width:100%;" type="text" name="googlelink" value="<?php echo $googlelink; ?>" /></td>
        </tr>
        <tr>
        	<td width="100%" colspan="3"><label style="font-size:12px;"><strong>Note:</strong> Icon name should be in lowercase without space. More social icons can be found at: http://fortawesome.github.io/Font-Awesome/icons/</label> </td>
        </tr>
	</table>    
<?php }

// save team meta box form data
add_action( 'save_post', 'add_agent_fields_function', 10, 2 );
function add_agent_fields_function( $team_id, $team ) {
    // Check post type for team
    if ( $team->post_type == 'team' ) {
        // Store data in post meta table if present in post data
		if ( isset($_POST['address']) ) {
            update_post_meta( $team_id, 'address', $_POST['address'] );
        }
		if ( isset($_POST['phone']) ) {
            update_post_meta( $team_id, 'phone', $_POST['phone'] );
        }
		if ( isset($_POST['mobile']) ) {
            update_post_meta( $team_id, 'mobile', $_POST['mobile'] );
        }
		if ( isset($_POST['email']) ) {
            update_post_meta( $team_id, 'email', $_POST['email'] );
        }
        if ( isset($_POST['designation']) ) {
            update_post_meta( $team_id, 'designation', $_POST['designation'] );
        }		
        if ( isset($_POST['facebook']) ) {
            update_post_meta( $team_id, 'facebook', $_POST['facebook'] );
        }
		if ( isset($_POST['facebooklink']) ) {
            update_post_meta( $team_id, 'facebooklink', $_POST['facebooklink'] );
        }
        if ( isset($_POST['twitter']) ) {
            update_post_meta( $team_id, 'twitter', $_POST['twitter'] );
        }
		if ( isset($_POST['twitterlink']) ) {
            update_post_meta( $team_id, 'twitterlink', $_POST['twitterlink'] );
        }
        if ( isset($_POST['linkedin']) ) {
            update_post_meta( $team_id, 'linkedin', $_POST['linkedin'] );
        }
		if ( isset($_POST['linkedinlink']) ) {
            update_post_meta( $team_id, 'linkedinlink', $_POST['linkedinlink'] );
        }
        if ( isset($_POST['dribbble']) ) {
            update_post_meta( $team_id, 'dribbble', $_POST['dribbble'] );
        }
		if ( isset($_POST['dribbblelink']) ) {
            update_post_meta( $team_id, 'dribbblelink', $_POST['dribbblelink'] );
        }
		if ( isset($_POST['google']) ) {
            update_post_meta( $team_id, 'google', $_POST['google'] );
        }
		if ( isset($_POST['googlelink']) ) {
            update_post_meta( $team_id, 'googlelink', $_POST['googlelink'] );
        }
    }
}

// Function to display team member
function Tattoo_our_team_func( $atts ) {
   extract( shortcode_atts( array(
		'show' => '',
		'type' => '',
		'column' => '',
	), $atts ) );
	
	$teampost = '';
	
	$team_query = new WP_Query(
		array(
			'post_type' => 'team',
			'posts_per_page' => $show,
			'post__not_in' => get_option('sticky_posts'),
			'orderby' => 'date',
			'order' => 'desc'
		)
	);
	
	if( $team_query->have_posts() ) : $counter = 0;
		$teampost .= '<div class="team-member-wrap">';
		if( $type == 'slider' ) : $teampost .= '<div class="team-rotator owl-carousel owl-theme">'; endif;
		while( $team_query->have_posts() ) : $team_query->the_post(); $counter ++;
		
			$mobile = get_post_meta( get_the_ID(), 'mobile', true );
			$email = get_post_meta( get_the_ID(), 'email', true );

			$designation = esc_html( get_post_meta( get_the_ID(), 'designation', true ) );
			$facebook = get_post_meta( get_the_ID(), 'facebook', true );
			$facebooklink = get_post_meta( get_the_ID(), 'facebooklink', true );
			$twitter = get_post_meta( get_the_ID(), 'twitter', true );
			$twitterlink = get_post_meta( get_the_ID(), 'twitterlink', true );
			$linkedin = get_post_meta( get_the_ID(), 'linkedin', true );
			$linkedinlink = get_post_meta( get_the_ID(), 'linkedinlink', true );
			$dribbble = get_post_meta( get_the_ID(), 'dribbble', true );
			$dribbblelink = get_post_meta( get_the_ID(), 'dribbblelink', true );
			$pint = get_post_meta( get_the_ID(), 'google', true );
			$googlelink = get_post_meta( get_the_ID(), 'googlelink', true );				
			
			if ( has_post_thumbnail()) {
				$large_imgSrc = wp_get_attachment_image_src( get_post_thumbnail_id(), 'team-post-thumb');
				$imgUrl = $large_imgSrc[0];
			}else{
				$imgUrl = get_template_directory_uri().'/images/img_404.png';
			}
			
			if( $counter%2 == 0 ) $nomargn2 = ' lastcols'; else $nomargn2 = '';
			if( $counter%3 == 0 ) $nomargn3 = ' lastcols'; else $nomargn3 = '';
			if( $counter%4 == 0 ) $nomargn4 = ' lastcols'; else $nomargn4 = '';
			
			if( $column == 2 ) 
				$shwgridcol = ' grid-col-two '.$nomargn2.'';
			elseif( $column == 3 )
				$shwgridcol = ' grid-col-three '.$nomargn3.'';
			elseif( $column == 4 )	
				$shwgridcol = ' grid-col-four '.$nomargn4.'';
				
			if( $type == 'grid' ) :
				
				$teampost .= '<div class="teammember-list'.$shwgridcol.'">';
					$teampost .= '<div class="team-inner">';
						$teampost .= '<div class="team-thumb">
										<img src="'.$imgUrl.'" alt="'.get_the_title().'"/>';										
						$teampost .= '</div><!-- team-thumb -->';
						$teampost .= '<div class="team-content">';
							$teampost .= '<ul class="member-social-icon">';
											if( $facebook != '' ){
												$teampost .= '<li><a href="'.$facebooklink.'" title="'.$facebook.'" target="_blank"><i class="fab fa-'.$facebook.'"></i></a></li>';
											}
											if( $twitter != '' ){
												$teampost .= '<li><a href="'.$twitterlink.'" title="'.$twitter.'" target="_blank"><i class="fab fa-'.$twitter.'"></i></a></li>';
											}
											if( $linkedin != '' ){
												$teampost .= '<li><a href="'.$linkedinlink.'" title="'.$linkedin.'" target="_blank"><i class="fab fa-'.$linkedin.'"></i></a></li>';
											}
											if( $dribbble != '' ){
												$teampost .= '<li><a href="'.$dribbblelink.'" title="'.$dribbble.'" target="_blank"><i class="fab fa-'.$dribbble.'"></i></a></li>';
											}
											if( $pint != '' ){
												$teampost .= '<li><a href="'.$googlelink.'" title="'.$pint.'" target="_blank"><i class="fab fa-'.$pint.'"></i></a></li>';
											}
							$teampost .= '</ul>';
							$teampost .= '<h4><a href="'.get_the_permalink().'">'.get_the_title().'</a></h4>
										  <span>'.$designation.'</span>';
						$teampost .= '</div><!-- team-content -->';
					$teampost .= '</div><!-- team-inner -->';
				$teampost .= '</div><!-- teammember-list -->';
							
			elseif( $type == 'slider' ) :
				$teampost .= '<div class="item">';
				$teampost .= '<div class="teammember-list">';
					$teampost .= '<div class="team-inner">';
						$teampost .= '<div class="team-thumb">
										<img src="'.$imgUrl.'" alt="'.get_the_title().'"/>';										
						$teampost .= '</div><!-- team-thumb -->';
						$teampost .= '<div class="team-content">';
							$teampost .= '<ul class="member-social-icon">';
											if( $facebook != '' ){
												$teampost .= '<li><a href="'.$facebooklink.'" title="'.$facebook.'" target="_blank"><i class="fab fa-'.$facebook.'"></i></a></li>';
											}
											if( $twitter != '' ){
												$teampost .= '<li><a href="'.$twitterlink.'" title="'.$twitter.'" target="_blank"><i class="fab fa-'.$twitter.'"></i></a></li>';
											}
											if( $linkedin != '' ){
												$teampost .= '<li><a href="'.$linkedinlink.'" title="'.$linkedin.'" target="_blank"><i class="fab fa-'.$linkedin.'"></i></a></li>';
											}
											if( $dribbble != '' ){
												$teampost .= '<li><a href="'.$dribbblelink.'" title="'.$dribbble.'" target="_blank"><i class="fab fa-'.$dribbble.'"></i></a></li>';
											}
											if( $pint != '' ){
												$teampost .= '<li><a href="'.$googlelink.'" title="'.$pint.'" target="_blank"><i class="fab fa-'.$pint.'"></i></a></li>';
											}
							$teampost .= '</ul>';
							$teampost .= '<h4><a href="'.get_the_permalink().'">'.get_the_title().'</a></h4>
										<span>'.$designation.'</span>';
						$teampost .= '</div><!-- team-content -->';
				$teampost .= '</div><!-- team-inner -->';
			$teampost .= '</div><!-- teammember-list -->';
			$teampost .= '</div><!-- item -->';
			endif;
				
		endwhile; wp_reset_postdata();
		if( $type == 'slider' ) : $teampost .= '</div>'; endif;
		$teampost .= '<div class="clear"></div></div>';
	else :
		$teampost .= '<div class="text-center error_msg" style="display:table; margin:0 auto;">'.__('There are not found our team members','Tattoo').'</div>';
	endif;
	
	return $teampost;
}
add_shortcode('our-team','Tattoo_our_team_func');