<?php
// custom post type for Testimonials
function my_custom_post_testimonials() {
	$labels = array(
		'name'               => __( 'Testimonial','Tattoo'),
		'singular_name'      => __( 'Testimonial','Tattoo'),
		'add_new'            => __( 'Add New','Tattoo'),
		'add_new_item'       => __( 'Add New Testimonial','Tattoo'),
		'edit_item'          => __( 'Edit Testimonial','Tattoo'),
		'new_item'           => __( 'New Testimonial','Tattoo'),
		'all_items'          => __( 'All Testimonials','Tattoo'),
		'view_item'          => __( 'View Testimonial','Tattoo'),
		'search_items'       => __( 'Search Testimonials','Tattoo'),
		'not_found'          => __( 'No testimonials found','Tattoo'),
		'not_found_in_trash' => __( 'No testimonials found in the Trash','Tattoo'), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Testimonials'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Manage Testimonials',
		'public'        => true,
		'menu_icon'		=> 'dashicons-format-quote',
		'menu_position' => null,
		'supports'      => array( 'title', 'editor', 'thumbnail'),
		'has_archive'   => false,
	);
	register_post_type( 'testimonials', $args );
}
add_action( 'init', 'my_custom_post_testimonials' );

function my_testi_admin_function() {
    add_meta_box( 'testi_meta_box',
        'Other Details',
        'display_testi_meta_box',
        'testimonials', 'normal', 'high'
    );
}
add_action( 'admin_init', 'my_testi_admin_function' );

function display_testi_meta_box( $testimonials ) { 
	$cdetails = esc_html( get_post_meta( $testimonials->ID, 'cdetails', true ));
?>
	<table width="100%">
    	<tr>
            <td width="20%">Company Details </td>
            <td width="20%"><input type="text" name="cdetails" value="<?php echo $cdetails; ?>" style="width:100%;" /></td>
        </tr>
    </table>
<?php }

function add_testi_fields_function( $testimonials_id, $testimonials ) {
	if ( $testimonials->post_type == 'testimonials' ) {
        // Store data in post meta table if present in post data
		if ( isset($_POST['cdetails']) ) {
            update_post_meta( $testimonials_id, 'cdetails', $_POST['cdetails'] );
        }
	}
}
add_action( 'save_post', 'add_testi_fields_function', 10, 2 );

// Function to display testimonials main
function Tattoo_testimonials_func($atts){
	extract( shortcode_atts( array(
		'show' => '-1',
	),$atts ));
	
	$testpost = '';
	
	$test_query = new WP_Query(
		array(
			'post_type' => 'testimonials',
			'posts_per_page' => $show
		)
	);
	
	if( $test_query->have_posts() ) :
		$testpost .= '<div id="clienttestiminials"><div class="owl-carousel clienttestiminials owl-theme">';
		while( $test_query->have_posts() ) : $test_query->the_post();
			$shwcdetails = esc_html( get_post_meta( get_the_ID(), 'cdetails', true ) );
		
			if ( has_post_thumbnail()) {
				$large_imgSrc = wp_get_attachment_image_src( get_post_thumbnail_id(), 'testi-thumb');
				$imgUrl = $large_imgSrc[0];
			}else{
				$imgUrl = get_template_directory_uri().'/images/img_404.png';
			}

			if( $shwcdetails != '' ){
				$shwcdet = '<span class="testi-position">'.$shwcdetails.'</span>';
			}			
			
			$testpost .= '<div class="item">
							<div class="testimonials-item">
								<div class="testi-thumb"><img src="'.$imgUrl.'" alt="'.get_the_title().'"/></div>
								<div class="testi-block">								
									<div class="testi-content">
										<p>'.content( of_get_option('testimonialsexcerptlength') ).'</p>
										<h4><a href="'.get_permalink().'">'.get_the_title().'</a></h4>
										'.$shwcdet.'
									</div>
								</div>
								<div class="quote-left"><i class="fas fa-quote-left"></i></div>												
							</div>					 		
				  		</div>';
		
		endwhile; wp_reset_postdata();
		$testpost .= '</div></div>';
	else :
		$testpost .= '<div class="text-center error_msg" style="display:table; margin:0 auto;">'.__('There are no testimonials available at this time','Tattoo').'</div>';
	endif;
	
	return $testpost;
}
add_shortcode( 'testimonials', 'Tattoo_testimonials_func' );


//Function to display Testimonials Listing
function Tattoo_testimonials_listing_func($atts){
	extract( shortcode_atts( array( 
		'show' => '',
	), $atts ) ); 
	
	$testi_post = '';
	
	$test_list_query = new WP_Query(
		array(
			'post_type' => 'testimonials',
			'posts_per_page' => $show
		)
	);
	
	if( $test_list_query->have_posts() ) :
		$testi_post .= '<div id="Tmnllist">';
			while ( $test_list_query->have_posts() ) : $test_list_query->the_post();

				$shwcdetails = esc_html( get_post_meta( get_the_ID(), 'cdetails', true ) );

				if ( has_post_thumbnail()) {
					$large_imgSrc = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full');
					$imgUrl = $large_imgSrc[0];
				}else{
					$imgUrl = get_template_directory_uri().'/images/img_404.png';
				}

				if( $shwcdetails != '' ){
					$shwcdet = '<span class="testi-position">'.$shwcdetails.'</span>';
				}
				
				$testi_post .= '<div class="tmnllisting">
									<div class="testi-block">							
										<div class="testi-content"><p>'.content( of_get_option('testimonialsexcerptlength') ).'</p></div>
									</div>
									<div class="testi-title">
										<h4><a href="'.get_permalink().'">'.get_the_title().'</a></h4>
										'.$shwcdet.'
									</div>
								</div>';
				
			endwhile;
		$testi_post .= '</div>';
	else : 
		$testi_post .= '<div class="text-center error_msg" style="display:table; margin:0 auto;">'.__('There are no testimonials available at this time','Tattoo').'</div>';
	endif;
	
	return $testi_post;
}
add_shortcode( 'testimonials-listing', 'Tattoo_testimonials_listing_func' );

//Testimonial sidebar Rotator
function testimonials_rotator_output_func( $atts ){
	extract( shortcode_atts( array( 
	'show' => '',
	),
	$atts ) ); 		
	wp_reset_query();
 	query_posts('post_type=testimonials&posts_per_page='.$show);
	if ( have_posts() ) :
	 $testimonialoutput = '<div id="testimonials"><div class="owl-carousel quotes owl-theme">';	
		while ( have_posts() ) : the_post();		   
			$testimonialoutput .= '
			  <div class="item"> '.content( '20' ).'
				  <h4><a href="'.get_permalink().'">'.get_the_title().'</a></h4>
			</div>
			';
		endwhile;
		 $testimonialoutput .= '</div></div>';
	else:
	  $testimonialoutput = '<div id="testimonials"><div class="owl-carousel quotes owl-theme">
           
               <div class="item">
                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam eget nibh sollicitudin, porttitor purus ut, tempus mauris. Sed eget nunc consequat ante convallis aliquet id iaculis neque. Quisque iaculis porttitor felis vel dictum. Nunc efficitur orci purus, eget elementum sem sodales ut. Curabitur vitae ipsum at ex interdum consectetur. Aliquam erat volutpat. Donec quam magna, accumsan sed dui sit amet, condimentum dapibus lorem. Aenean ac mi sed ante egestas ultricies dictum nec orci.</p>
				   <h4><a href="#">John Doe</a></h4>
				</div>
			  
                 <div class="item">
                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nullam eget nibh sollicitudin, porttitor purus ut, tempus mauris. Sed eget nunc consequat ante convallis aliquet id iaculis neque. Quisque iaculis porttitor felis vel dictum. Nunc efficitur orci purus, eget elementum sem sodales ut. Curabitur vitae ipsum at ex interdum consectetur. Aliquam erat volutpat. Donec quam magna, accumsan sed dui sit amet, condimentum dapibus lorem. Aenean ac mi sed ante egestas ultricies dictum nec orci.</p>
				   <h4><a href="#">Sarah Brown</a></h4>
				</div>
           
  </div></div>';			
	  endif;  
	wp_reset_query();	
	return $testimonialoutput;
}
add_shortcode( 'sidebar-testimonials', 'testimonials_rotator_output_func' );