<?php function Tattoo_social_sharing_buttons() {
	global $post;
	if(is_singular() || is_home()){

		$content ='';
	
		// Get current page URL 
		$crunchifyURL = urlencode(get_permalink());
 
		// Get current page title
		$crunchifyTitle = str_replace( ' ', '%20', get_the_title());
		
		// Get Post Thumbnail for pinterest
		$crunchifyThumbnail = wp_get_attachment_image_src( get_post_thumbnail_id( $post->ID ), 'full' );
 
		// Construct sharing URL without using any script
		$twitterURL = 'https://twitter.com/intent/tweet?text='.$crunchifyTitle.'&amp;url='.$crunchifyURL.'&amp;via=Crunchify';
		$facebookURL = 'https://www.facebook.com/sharer/sharer.php?u='.$crunchifyURL;
		$whatsappURL = 'whatsapp://send?text='.$crunchifyTitle . ' ' . $crunchifyURL;
		$linkedInURL = 'https://www.linkedin.com/shareArticle?mini=true&url='.$crunchifyURL.'&amp;title='.$crunchifyTitle;
		$emailURL = 'mailto:?subject=' . $crunchifyTitle . '&body=Check out this site: '. $crunchifyURL .'" title="Share by Email';
 
		// Based on popular demand added Pinterest too
		$pinterestURL = 'https://pinterest.com/pin/create/button/?url='.$crunchifyURL.'&amp;media='.$crunchifyThumbnail[0].'&amp;description='.$crunchifyTitle;
 
		// Add sharing button at the end of page/page content
		$content .= '<!-- Crunchify.com social sharing. Get your copy here: http://crunchify.me/1VIxAsz -->';
		$content .= '<ul class="social-share-post">';
			$content .= '<li class="social-share-facebook">
							<a class="social-share-link" href="'.$facebookURL.'" target="_blank" data-tooltip="Share On Facebook">
								<i class="fab fa-facebook-f"></i>
							</a>
						</li>';
			$content .= '<li class="social-share-twitter">
							<a class="social-share-link" href="'. $twitterURL .'" target="_blank" data-tooltip="Share On Twitter">
								<i class="fab fa-twitter"></i>
							</a>
						</li>';
			$content .= '<li class="social-share-whatsapp">
							<a class="social-share-link" href="'.$whatsappURL.'" target="_blank" data-tooltip="Share On Whatsapp">
								<i class="fab fa-whatsapp"></i>
							</a>
						</li>';
			$content .= '<li class="social-share-linkedin">
							<a class="social-share-link" href="'.$linkedInURL.'" target="_blank" data-tooltip="Share On Linkedin">
								<i class="fab fa-linkedin-in"></i>
							</a>
						</li>';
			$content .= '<li class="social-share-pinterest">
							<a class="social-share-link" href="'.$pinterestURL.'" data-pin-custom="true" target="_blank" data-tooltip="Pin It">
								<i class="fab fa-pinterest-p"></i>
							</a>
						</li>';
			$content .= '<li class="social-share-mail">
							<a class="social-share-link" href="'.$emailURL.'" target="_blank" data-tooltip="Share On Email">
								<i class="far fa-envelope"></i>
							</a>
						</li>';
		$content .= '</ul>';
		
		return $content;
	}else{
		// if not a post/page then don't include sharing button
		return $content;
	}
};

function Tattoo_contactmethods( $contactmethods ) {
// Add Google Plus
$contactmethods['google_plus'] = 'Google Plus';
// Add Twitter
$contactmethods['twitter'] = 'Twitter';
//add Facebook
$contactmethods['facebook'] = 'Facebook';
return $contactmethods;
}
add_filter('user_contactmethods','Tattoo_contactmethods',10,1);