<?php
/**
 * Displays About us Information
 *
 */
 
class Alexatheme_About_Us extends WP_Widget {
	
	public function __construct() {
        $widget_ops = array(
            'classname' => 'alexatheme-widget-aboutus',
            'description' => __( 'Displays About Us Information in Sidebar', 'Tattoo' ),
            'customize_selective_refresh' => true,
        );
        parent::__construct( 'alexatheme-widget-aboutus', __( 'Alexatheme : About Us', 'Tattoo' ), $widget_ops );
        $this->alt_option_name = 'alexatheme_widget_aboutus';
    }
	
	public function widget( $args, $instance )
    {
        if ( !isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }
		$image_uri = ( !empty($instance['image_uri']) ) ? $instance['image_uri'] : '';
        $title = ( !empty($instance['title']) ) ? $instance['title'] : '';
		$tagline = ( !empty($instance['tagline']) ) ? $instance['tagline'] : '';
        $paragraph = ( !empty($instance['paragraph']) ) ? $instance['paragraph'] : '';
		$iconone = ( !empty ($instance['iconone']) ) ? $instance['iconone'] : '';
		$icontwo = ( !empty ($instance['icontwo']) ) ? $instance['icontwo'] : '';
		$iconthree = ( !empty ($instance['iconthree']) ) ? $instance['iconthree'] : '';
		$iconfour = ( !empty ($instance['iconfour']) ) ? $instance['iconfour'] : '';
		$iconfive = ( !empty ($instance['iconfive']) ) ? $instance['iconfive'] : '';
		$urlone = ( !empty($instance['urlone']) ) ? $instance['urlone'] : '';
		$urltwo = ( !empty($instance['urltwo']) ) ? $instance['urltwo'] : '';
		$urlthree = ( !empty($instance['urlthree']) ) ? $instance['urlthree'] : '';
		$urlfour = ( !empty($instance['urlfour']) ) ? $instance['urlfour'] : '';
		$urlfive = ( !empty($instance['urlfive']) ) ? $instance['urlfive'] : '';

        echo $args['before_widget']; ?>
        	<div class="widget-aboutus">
                <?php if ( $image_uri ) { echo '<div class="widget-about-image" style="background-image:url('. $image_uri .')"></div>'; } ?>
                <div class="widget-about-conte text-center">
                	<?php 
						if ( $title ) { echo '<h2 class="wid-abt-hd">' . esc_html( $title ) . '</h2>'; }
						if ( $tagline ) { echo '<div class="sub-wid-abt-hd">' . esc_html( $tagline ) . '</div>'; }
						if( $paragraph ){ echo '<p>'; echo esc_html( $paragraph ); echo'</p>'; }
						if( $iconone || $icontwo || $iconthree || $iconfour || $iconfive ){
						echo'<ul class="widget-about-social">';
							if( $iconone ){
								echo '<li><a href="'.esc_url( $urlone ).'" target="_blank"><i class="fab fa-'.esc_html( $iconone ).'" aria-hidden="true"></i></a></li>';
							}
							if( $icontwo ){
								echo '<li><a href="'.esc_url( $urltwo ).'" target="_blank"><i class="fab fa-'.esc_html( $icontwo ).'" aria-hidden="true"></i></a></li>';
							}
							if( $iconthree ){
								echo '<li><a href="'.esc_url( $urlthree ).'" target="_blank"><i class="fab fa-'.esc_html( $iconthree ).'" aria-hidden="true"></i></a></li>';
							}
							if( $iconfour ){
								echo '<li><a href="'.esc_url( $urlfour ).'" target="_blank"><i class="fab fa-'.esc_html( $iconfour ).'" aria-hidden="true"></i></a></li>';
							}
							if( $iconfive ){
								echo '<li><a href="'.esc_url( $urlfive ).'" target="_blank"><i class="fab fa-'.esc_html( $iconfive ).'" aria-hidden="true"></i></a></li>';
							}
						echo'</ul>';
					}
					?>
                </div>
            </div>
        <?php echo $args['after_widget'];
    }
	
	public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
		$instance['image_uri'] = esc_url_raw( $new_instance['image_uri'] );
        $instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['tagline'] = sanitize_text_field( $new_instance['tagline'] );
		$instance['paragraph'] = sanitize_text_field( $new_instance['paragraph'] );
		$instance['iconone'] = sanitize_text_field( $new_instance['iconone'] );
		$instance['icontwo'] = sanitize_text_field( $new_instance['icontwo'] );
		$instance['iconthree'] = sanitize_text_field( $new_instance['iconthree'] );
		$instance['iconfour'] = sanitize_text_field( $new_instance['iconfour'] );
		$instance['iconfive'] = sanitize_text_field( $new_instance['iconfive'] );
		$instance['urlone'] = esc_url_raw( $new_instance['urlone'] );
		$instance['urltwo'] = esc_url_raw( $new_instance['urltwo'] );
		$instance['urlthree'] = esc_url_raw( $new_instance['urlthree'] );
		$instance['urlfour'] = esc_url_raw( $new_instance['urlfour'] );
		$instance['urlfive'] = esc_url_raw( $new_instance['urlfive'] );
        return $instance;
    }
	
    public function form( $instance ) {
		$image_uri	= isset( $instance['image_uri'] ) ? esc_url( $instance['image_uri'] ) : '';
        $title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$tagline	= isset( $instance['tagline'] ) ? esc_attr( $instance['tagline']) : '';
		$paragraph	= isset( $instance['paragraph'] ) ? esc_attr( $instance['paragraph']) : '';
		$iconone	= isset( $instance['iconone'] ) ? esc_attr( $instance['iconone']) : '';
		$icontwo	= isset( $instance['icontwo'] ) ? esc_attr( $instance['icontwo']) : '';
		$iconthree	= isset( $instance['iconthree'] ) ? esc_attr( $instance['iconthree']) : '';
		$iconfour	= isset( $instance['iconfour'] ) ? esc_attr( $instance['iconfour']) : '';
		$iconfive	= isset( $instance['iconfive'] ) ? esc_attr( $instance['iconfive']) : '';
		$urlone     = isset( $instance['urlone'] ) ? esc_attr( $instance['urlone'] ) : '';
		$urltwo     = isset( $instance['urltwo'] ) ? esc_attr( $instance['urltwo'] ) : '';
		$urlthree     = isset( $instance['urlthree'] ) ? esc_attr( $instance['urlthree'] ) : '';
		$urlfour     = isset( $instance['urlfour'] ) ? esc_attr( $instance['urlfour'] ) : '';
		$urlfive     = isset( $instance['urlfive'] ) ? esc_attr( $instance['urlfive'] ) : '';
        ?>
        <div class="flytheme-wrap">
            <div class="flytheme-aboutus-widget">
            	<div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id('image_uri'); ?>"><?php _e( 'Upload Image', 'Tattoo' ); ?></label>
                        <?php if ( $image_uri ) : ?>
                            <img class="custom_media_image_two flytheme-custom_media_image_two" src="<?php echo $image_uri; ?>" />
                        <?php endif; ?>
                        <input type="text" class="widefat custom_media_url" name="<?php echo $this->get_field_name('image_uri'); ?>" id="<?php echo $this->get_field_id('image_uri'); ?>" value="<?php echo $image_uri; ?>">
                        <input type="button" class="button button-primary custom_media_button flytheme_about_main_btn" id="custom_media_button" value="<?php _e( 'Upload Image', 'Tattoo' ) ?>" />
                    </h5>
                </div><!-- data row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'tagline' ); ?>"><?php _e( 'Tagline', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'tagline' ); ?>" name="<?php echo $this->get_field_name( 'tagline' ); ?>" type="text" value="<?php echo $tagline; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'paragraph' ); ?>"><?php _e( 'Content', 'Tattoo' ); ?></label>
                        <textarea class="widefat" id="<?php echo $this->get_field_id( 'paragraph' ); ?>" name="<?php echo $this->get_field_name( 'paragraph' ); ?>"><?php echo $paragraph; ?></textarea>
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'iconone' ); ?>"><?php _e( 'Social Media One Icon', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'iconone' ); ?>" name="<?php echo $this->get_field_name( 'iconone' ); ?>" type="text" value="<?php echo $iconone; ?>" /><br /><small><em><?php _e( 'Find Icon Here : https://fontawesome.com', 'Tattoo' ); ?></em></small>
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'urlone' ); ?>"><?php _e( 'Social Media One URL', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'urlone' ); ?>" name="<?php echo $this->get_field_name( 'urlone' ); ?>" type="text" value="<?php echo $urlone; ?>" />
                    </h5>
                </div><!-- data-row -->
                
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'icontwo' ); ?>"><?php _e( 'Social Media Two Icon', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'icontwo' ); ?>" name="<?php echo $this->get_field_name( 'icontwo' ); ?>" type="text" value="<?php echo $icontwo; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'urltwo' ); ?>"><?php _e( 'Social Media Two URL', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'urltwo' ); ?>" name="<?php echo $this->get_field_name( 'urltwo' ); ?>" type="text" value="<?php echo $urltwo; ?>" />
                    </h5>
                </div><!-- data-row -->
                
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'iconthree' ); ?>"><?php _e( 'Social Media Three Icon', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'iconthree' ); ?>" name="<?php echo $this->get_field_name( 'iconthree' ); ?>" type="text" value="<?php echo $iconthree; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'urlthree' ); ?>"><?php _e( 'Social Media Three URL', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'urlthree' ); ?>" name="<?php echo $this->get_field_name( 'urlthree' ); ?>" type="text" value="<?php echo $urlthree; ?>" />
                    </h5>
                </div><!-- data-row -->
                
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'iconfour' ); ?>"><?php _e( 'Social Media Four Icon', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'iconfour' ); ?>" name="<?php echo $this->get_field_name( 'iconfour' ); ?>" type="text" value="<?php echo $iconfour; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'urlfour' ); ?>"><?php _e( 'Social Media Four URL', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'urlfour' ); ?>" name="<?php echo $this->get_field_name( 'urlfour' ); ?>" type="text" value="<?php echo $urlfour; ?>" />
                    </h5>
                </div><!-- data-row -->
                
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'iconfive' ); ?>"><?php _e( 'Social Media Five Icon', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'iconfive' ); ?>" name="<?php echo $this->get_field_name( 'iconfive' ); ?>" type="text" value="<?php echo $iconfive; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'urlfive' ); ?>"><?php _e( 'Social Media Five URL', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'urlfive' ); ?>" name="<?php echo $this->get_field_name( 'urlfive' ); ?>" type="text" value="<?php echo $urlfive; ?>" />
                    </h5>
                </div><!-- data-row -->
            </div>
        </div>
        <?php
    }
}