<?php
/**
 * Brochure
 *
*/

class Alexatheme_Widget_Brochure extends WP_Widget {
	public function __construct() {
        $widget_ops = array(
            'classname' => 'alexatheme-widget-brochure',
            'description' => __( 'Display Brochure', 'Tattoo' ),
            'customize_selective_refresh' => true,
        );
        parent::__construct( 'alexatheme-widget-brochure', __( 'Alexatheme : Brochure', 'Tattoo' ), $widget_ops );
        $this->alt_option_name = 'widget-brochure';
    }
	
	public function widget( $args, $instance )
    {
		if ( !isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }
		$title = ( !empty($instance['title']) ) ? $instance['title'] : '';
		$linkpdf = ( !empty($instance['linkpdf']) ) ? $instance['linkpdf'] : '';
		
		echo $args['before_widget']; ?>
        <div class="widget-brochure">
        	<?php 
				if ( $linkpdf ) { echo '<div class="download-brochure"><a href="'.esc_html($linkpdf).'" download="'.esc_html( $title ).'">'.esc_html( $title ).'</a></div>'; }
			?>
        </div>
		
		<?php echo $args['after_widget'];
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['linkpdf'] = sanitize_text_field( $new_instance['linkpdf'] );
		
		return $instance;
	}
	
	public function form( $instance ) {
		$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$linkpdf = isset( $instance['linkpdf'] ) ? esc_attr( $instance['linkpdf'] ) : ''; ?>
        
        <div class="flytheme-wrap">
            <div class="data-row">
            	<h5>
                    <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'Tattoo' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
                </h5>
            </div><!-- data row -->
            <div class="data-row">
            	<h5>
                    <label for="<?php echo $this->get_field_id( 'linkpdf' ); ?>"><?php _e( 'File Path Here:', 'Tattoo' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'linkpdf' ); ?>" name="<?php echo $this->get_field_name( 'linkpdf' ); ?>" type="text" value="<?php echo $linkpdf; ?>" />
                </h5>
            </div><!-- data row -->
        </div><!-- flytheme wrap -->
	<?php }
}