<?php
/**
 * Displays Footer Info
 *
 */
 
class Alexatheme_Footer_Get_In_Touch extends WP_Widget {
	
	public function __construct() {
        $widget_ops = array(
            'classname' => 'alexatheme-widget-getintouch',
            'description' => __( 'Displays Contact Information', 'Tattoo' ),
            'customize_selective_refresh' => true,
        );
        parent::__construct( 'alexatheme-widget-getintouch', __( 'Alexatheme : Get in Touch', 'Tattoo' ), $widget_ops );
        $this->alt_option_name = 'alexatheme_widget_getintouch';
    }
	
	public function widget( $args, $instance )
    {
        if ( !isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }
        $title = ( !empty($instance['title']) ) ? $instance['title'] : '';
		$desc = ( !empty($instance['desc']) ) ? $instance['desc'] : '';
		$s_image_uri = ( !empty($instance['s_image_uri']) ) ? $instance['s_image_uri'] : '';
        $address = ( !empty($instance['address']) ) ? $instance['address'] : '';
		$phone = ( !empty($instance['phone']) ) ? $instance['phone'] : '';
        $fax = ( !empty($instance['fax']) ) ? $instance['fax'] : '';
		$email = ( !empty($instance['email']) ) ? $instance['email'] : '';
		$wrkhrs = ( !empty($instance['wrkhrs']) ) ? $instance['wrkhrs'] : '';
		$iconone = ( !empty ($instance['iconone']) ) ? $instance['iconone'] : '';
		$icontwo = ( !empty ($instance['icontwo']) ) ? $instance['icontwo'] : '';
		$iconthree = ( !empty ($instance['iconthree']) ) ? $instance['iconthree'] : '';
		$iconfour = ( !empty ($instance['iconfour']) ) ? $instance['iconfour'] : '';
		$iconfive = ( !empty ($instance['iconfive']) ) ? $instance['iconfive'] : '';
		$urlone = ( !empty($instance['urlone']) ) ? $instance['urlone'] : '';
		$urltwo = ( !empty($instance['urltwo']) ) ? $instance['urltwo'] : '';
		$urlthree = ( !empty($instance['urlthree']) ) ? $instance['urlthree'] : '';
		$urlfour = ( !empty($instance['urlfour']) ) ? $instance['urlfour'] : '';
		$urlfive = ( !empty($instance['urlfive']) ) ? $instance['urlfive'] : '';

        echo $args['before_widget']; ?>
        <div class="widget-getintouch">
			<?php
			if ( $title ) { 
				echo $args['before_title'] . esc_html( $title ) . $args['after_title'];
			}
			if( $s_image_uri ){
				echo'<div class="getintouch-logo"><img src="'.$s_image_uri.'"></div>';
			}
			if( $desc ){
				echo '<p>'.$desc.'</p>';
			}	
			
			if( $address || $phone || $email || $wrkhrs ){
				echo'<div class="foo-getintouch"><ul class="widget-getintouch-info">';
					if( $address ){
						echo '<li>'; echo esc_html( $address ); echo'</li>';
					} if( $phone ){
						echo '<li>'; echo esc_html( $phone ); echo'</li>';
					} if( $fax ){
                        echo '<li>'; echo esc_html( $fax ); echo'</li>';
                    } if( $email ){
                        echo '<li><a href="mailto:'.esc_html( $email ).'">'; echo esc_html( $email ); echo'</a></li>';
                    } if( $wrkhrs ){
						echo '<li>'; echo esc_html( $wrkhrs ); echo'</li>';
					}
					echo'</ul>';
				echo'</div>';
			} 
            if( $iconone || $icontwo || $iconthree || $iconfour || $iconfive ){
                echo '<ul class="widget-getintouch-social">';
                    if( $iconone ){
                        echo '<li><a href="'.esc_url( $urlone ).'" target="_blank"><i class="fab fa-'.esc_html( $iconone ).'" aria-hidden="true"></i></a></li>';
                    }
                    if( $icontwo ){
                        echo '<li><a href="'.esc_url( $urltwo ).'" target="_blank"><i class="fab fa-'.esc_html( $icontwo ).'" aria-hidden="true"></i></a></li>';
                    }
                    if( $iconthree ){
                        echo '<li><a href="'.esc_url( $urlthree ).'" target="_blank"><i class="fab fa-'.esc_html( $iconthree ).'" aria-hidden="true"></i></a></li>';
                    }
                    if( $iconfour ){
                        echo '<li><a href="'.esc_url( $urlfour ).'" target="_blank"><i class="fab fa-'.esc_html( $iconfour ).'" aria-hidden="true"></i></a></li>';
                    }
                    if( $iconfive ){
                        echo '<li><a href="'.esc_url( $urlfive ).'" target="_blank"><i class="fab fa-'.esc_html( $iconfive ).'" aria-hidden="true"></i></a></li>';
                    }
                echo'</ul>';
            } ?>
        </div>
        <?php echo $args['after_widget'];
    }
	
	public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;        
        $instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['desc'] = sanitize_text_field( $new_instance['desc'] );
		$instance['s_image_uri'] = esc_url_raw( $new_instance['s_image_uri'] );
		$instance['address'] = sanitize_text_field( $new_instance['address'] );
		$instance['phone'] = sanitize_text_field( $new_instance['phone'] );
        $instance['fax'] = sanitize_text_field( $new_instance['fax'] );
		$instance['email'] = sanitize_text_field( $new_instance['email'] );
		$instance['wrkhrs'] = sanitize_text_field( $new_instance['wrkhrs'] );
		$instance['iconone'] = sanitize_text_field( $new_instance['iconone'] );
		$instance['icontwo'] = sanitize_text_field( $new_instance['icontwo'] );
		$instance['iconthree'] = sanitize_text_field( $new_instance['iconthree'] );
		$instance['iconfour'] = sanitize_text_field( $new_instance['iconfour'] );
		$instance['iconfive'] = sanitize_text_field( $new_instance['iconfive'] );
		$instance['urlone'] = esc_url_raw( $new_instance['urlone'] );
		$instance['urltwo'] = esc_url_raw( $new_instance['urltwo'] );
		$instance['urlthree'] = esc_url_raw( $new_instance['urlthree'] );
		$instance['urlfour'] = esc_url_raw( $new_instance['urlfour'] );
		$instance['urlfive'] = esc_url_raw( $new_instance['urlfive'] );
        return $instance;
    }
	
    public function form( $instance ) {        
        $title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$desc	= isset( $instance['desc'] ) ? esc_attr( $instance['desc'] ) : '';
		$s_image_uri	= isset( $instance['s_image_uri'] ) ? esc_url( $instance['s_image_uri'] ) : '';
		$address	= isset( $instance['address'] ) ? esc_attr( $instance['address']) : ''; 
		$phone	= isset( $instance['phone'] ) ? esc_attr( $instance['phone']) : '';
        $fax  = isset( $instance['fax'] ) ? esc_attr( $instance['fax']) : ''; 
		$email	= isset( $instance['email'] ) ? esc_attr( $instance['email']) : '';
		$wrkhrs	= isset( $instance['wrkhrs'] ) ? esc_attr( $instance['wrkhrs']) : '';
		$iconone	= isset( $instance['iconone'] ) ? esc_attr( $instance['iconone']) : '';
		$icontwo	= isset( $instance['icontwo'] ) ? esc_attr( $instance['icontwo']) : '';
		$iconthree	= isset( $instance['iconthree'] ) ? esc_attr( $instance['iconthree']) : '';
		$iconfour	= isset( $instance['iconfour'] ) ? esc_attr( $instance['iconfour']) : '';
		$iconfive	= isset( $instance['iconfive'] ) ? esc_attr( $instance['iconfive']) : '';
		$urlone     = isset( $instance['urlone'] ) ? esc_attr( $instance['urlone'] ) : '';
		$urltwo     = isset( $instance['urltwo'] ) ? esc_attr( $instance['urltwo'] ) : '';
		$urlthree     = isset( $instance['urlthree'] ) ? esc_attr( $instance['urlthree'] ) : '';
		$urlfour     = isset( $instance['urlfour'] ) ? esc_attr( $instance['urlfour'] ) : '';
		$urlfive     = isset( $instance['urlfive'] ) ? esc_attr( $instance['urlfive'] ) : '';
        ?>
        <div class="flytheme-wrap">
            <div class="flytheme-footer-getintouch-widget">                
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'desc' ); ?>"><?php _e( 'Content', 'Tattoo' ); ?></label>
                        <textarea class="widefat" id="<?php echo $this->get_field_id( 'desc' ); ?>" name="<?php echo $this->get_field_name( 'desc' ); ?>"><?php echo $desc; ?></textarea>
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id('s_image_uri'); ?>"><?php _e( 'Upload Image', 'Tattoo' ); ?></label>
                        <?php if ( $s_image_uri ) : ?>
                            <img class="custom_media_image_three flytheme-custom_media_image_three" src="<?php echo $s_image_uri; ?>" />
                        <?php endif; ?>
                        <input type="text" class="widefat custom_media_url" name="<?php echo $this->get_field_name('s_image_uri'); ?>" id="<?php echo $this->get_field_id('s_image_uri'); ?>" value="<?php echo $s_image_uri; ?>">
                        <input type="button" class="button button-primary custom_media_button flytheme_about_main_btn" id="custom_media_button" value="<?php _e( 'Upload Logo', 'Tattoo' ) ?>" />
                    </h5>
                </div><!-- data row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'phone' ); ?>"><?php _e( 'Phone', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'phone' ); ?>" name="<?php echo $this->get_field_name( 'phone' ); ?>" type="text" value="<?php echo $phone; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'fax' ); ?>"><?php _e( 'Fax', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'fax' ); ?>" name="<?php echo $this->get_field_name( 'fax' ); ?>" type="text" value="<?php echo $fax; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'email' ); ?>"><?php _e( 'Email', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'email' ); ?>" name="<?php echo $this->get_field_name( 'email' ); ?>" type="text" value="<?php echo $email; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'address' ); ?>"><?php _e( 'Address', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'address' ); ?>" name="<?php echo $this->get_field_name( 'address' ); ?>" type="text" value="<?php echo $address; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'wrkhrs' ); ?>"><?php _e( 'Working Hours', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'wrkhrs' ); ?>" name="<?php echo $this->get_field_name( 'wrkhrs' ); ?>" type="text" value="<?php echo $wrkhrs; ?>" />
                    </h5>
                </div><!-- data-row -->    
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'iconone' ); ?>"><?php _e( 'Social Media One Icon', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'iconone' ); ?>" name="<?php echo $this->get_field_name( 'iconone' ); ?>" type="text" value="<?php echo $iconone; ?>" /><br /><small><em><?php _e( 'Find Icon Here : https://fontawesome.com', 'Tattoo' ); ?></em></small>
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'urlone' ); ?>"><?php _e( 'Social Media One URL', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'urlone' ); ?>" name="<?php echo $this->get_field_name( 'urlone' ); ?>" type="text" value="<?php echo $urlone; ?>" />
                    </h5>
                </div><!-- data-row -->
                
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'icontwo' ); ?>"><?php _e( 'Social Media Two Icon', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'icontwo' ); ?>" name="<?php echo $this->get_field_name( 'icontwo' ); ?>" type="text" value="<?php echo $icontwo; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'urltwo' ); ?>"><?php _e( 'Social Media Two URL', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'urltwo' ); ?>" name="<?php echo $this->get_field_name( 'urltwo' ); ?>" type="text" value="<?php echo $urltwo; ?>" />
                    </h5>
                </div><!-- data-row -->
                
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'iconthree' ); ?>"><?php _e( 'Social Media Three Icon', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'iconthree' ); ?>" name="<?php echo $this->get_field_name( 'iconthree' ); ?>" type="text" value="<?php echo $iconthree; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'urlthree' ); ?>"><?php _e( 'Social Media Three URL', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'urlthree' ); ?>" name="<?php echo $this->get_field_name( 'urlthree' ); ?>" type="text" value="<?php echo $urlthree; ?>" />
                    </h5>
                </div><!-- data-row -->
                
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'iconfour' ); ?>"><?php _e( 'Social Media Four Icon', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'iconfour' ); ?>" name="<?php echo $this->get_field_name( 'iconfour' ); ?>" type="text" value="<?php echo $iconfour; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'urlfour' ); ?>"><?php _e( 'Social Media Four URL', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'urlfour' ); ?>" name="<?php echo $this->get_field_name( 'urlfour' ); ?>" type="text" value="<?php echo $urlfour; ?>" />
                    </h5>
                </div><!-- data-row -->
                
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'iconfive' ); ?>"><?php _e( 'Social Media Five Icon', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'iconfive' ); ?>" name="<?php echo $this->get_field_name( 'iconfive' ); ?>" type="text" value="<?php echo $iconfive; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'urlfive' ); ?>"><?php _e( 'Social Media Five URL', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'urlfive' ); ?>" name="<?php echo $this->get_field_name( 'urlfive' ); ?>" type="text" value="<?php echo $urlfive; ?>" />
                    </h5>
                </div><!-- data-row -->
            </div>
        </div>
        <?php
    }
}