<?php
/**
 * Featured posts
 *
 */

class Alexatheme_Widget_latest_posts extends WP_Widget {

    public function __construct() {
        $widget_ops = array(
            'classname' => 'alexatheme-widget-latest-posts',
            'description' => __( 'Display latest posts', 'Tattoo' ),
            'customize_selective_refresh' => true,
        );
        parent::__construct( 'alexatheme-widget-latest-posts', __( 'Alexatheme : Latest Posts', 'Tattoo' ), $widget_ops );
        $this->alt_option_name = 'widget-latest-posts';
    }

    public function widget( $args, $instance ) {
        if ( ! isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }

        $enable_date = ! empty( $instance[ 'enable_date' ] ) ? 1 : 0;
		$enable_ttl = ! empty( $instance[ 'enable_ttl' ] ) ? 1 : 0;
        $number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 3;
		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';

        $query = new WP_Query( array(
            'posts_per_page'      => $number,
            'no_found_rows'       => true,
            'post_status'         => 'publish',
            'ignore_sticky_posts' => true,
        ) );

        if ( $query->have_posts() ) :  ?>
            <?php echo $args['before_widget']; 
            if ( $title ) { echo $args['before_title'] . esc_html( $title ) . $args['after_title']; } ?>
            <div class="latest-posts-widget">
                <?php
                    while ( $query->have_posts() ) : $query->the_post();
                    $imgSrc = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full');
                    if ( $imgSrc[0]!='' ) {
                        $imgUrl = $imgSrc[0];
                    }else{
                        $imgUrl = get_template_directory_uri().'/images/img_404.png';
                    }
                ?>
                	<div class="latest-posts-row">   
                    	<div class="latest-post-thumb" style="background-image: url(<?php echo $imgUrl; ?>);">
                        	<a href="<?php echo esc_url( get_the_permalink() ); ?>"></a>
                        </div><!-- latest post content  -->
                        <div class="latest-post-content">
                        	<?php if ( $enable_ttl != 1 ) : ?>
                        		<h5><a href="<?php echo esc_url( get_the_permalink() ); ?>"><?php echo esc_html( get_the_title() ); ?></a></h5>
                            <?php endif; ?>
                            <p><?php echo content(12); ?></p>
                        </div><!-- latest-post-content -->						  
                    </div><!-- latest-posts-row -->
                <?php endwhile; wp_reset_postdata(); ?>
            </div>
            <?php echo $args['after_widget'];
            wp_reset_postdata();
        endif;
    }

    public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );        
        $instance['number'] = (int) $new_instance['number'];
		$instance[ 'enable_ttl' ] = absint( $new_instance[ 'enable_ttl' ] );

        return $instance;
    }

    public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
        $number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 3;
		$enable_ttl = !empty( $instance['enable_ttl'] ) ? $instance['enable_ttl'] : '' ;
        ?>
        <div class="flytheme-wrap">
            <div class="">
            	<h5>
                    <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'Tattoo' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
                </h5>
            </div>
            <div class="accordion-fix panel">
                <h3 class="title panel-title"><?php _e( 'Options', 'Tattoo' ); ?></h3>
                <div class="accordion-contents content">
                    <div class="accordion-wrap">
                    	<div class="col-3">
                            <h5>
                                <label>
                                    <input type="checkbox" name="<?php echo $this->get_field_name( 'enable_ttl' ); ?>" id="<?php echo $this->get_field_id( 'enable_ttl' ); ?>" value="1" <?php checked( $enable_ttl, '1' ); ?>> <span><?php _e( 'Hide Title', 'Tattoo' ); ?></span>
                                </label>
                            </h5>
                        </div>
                        <div class="col-3">
                            <h5>
                                <label>
                                    <span><?php _e( 'Number of posts to show : ', 'Tattoo' ); ?></span>
                                    <input class="tiny-text" type="number" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" step="1" min="1" max="10" value="<?php echo $number; ?>" size="3">
                                </label>                               
                            </h5>
                        </div>                        
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}