<?php
/**
 * Newsletter
 *
*/

class Alexatheme_Widget_Newsletter extends WP_Widget {
	public function __construct() {
        $widget_ops = array(
            'classname' => 'alexatheme-widget-newsletter',
            'description' => __( 'Display Newsletter', 'Tattoo' ),
            'customize_selective_refresh' => true,
        );
        parent::__construct( 'alexatheme-widget-newsletter', __( 'Alexatheme : Newsletter', 'Tattoo' ), $widget_ops );
        $this->alt_option_name = 'widget-newsletter';
    }
	
	public function widget( $args, $instance )
    {
		if ( !isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }
		$title = ( !empty($instance['title']) ) ? $instance['title'] : '';
		$paragraph = ( !empty($instance['paragraph']) ) ? $instance['paragraph'] : '';
		$formname = ( !empty($instance['formname']) ) ? $instance['formname'] : '';
		$formid = ( !empty($instance['formid']) ) ? $instance['formid'] : '';
		
		echo $args['before_widget']; 
		if ( $title ) { 
			echo $args['before_title'] . esc_html( $title ) . $args['after_title']; 
		} ?>
        <div class="widget-newsletter">
        	<?php 
				if ( $paragraph ) { echo '<p>'.esc_html( $paragraph ).'</p>'; }
        		echo do_shortcode('[contact-form-7 id="'.esc_attr($formid).'" title="'.esc_attr($formname).'"]');
			?>
        </div>
		
		<?php echo $args['after_widget'];
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['paragraph'] = sanitize_text_field( $new_instance['paragraph'] );
		$instance['formname'] = sanitize_text_field( $new_instance['formname'] );
		$instance['formid'] = sanitize_text_field( $new_instance['formid'] );
		
		return $instance;
	}
	
	public function form( $instance ) {
		$title	= isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$paragraph	= isset( $instance['paragraph'] ) ? esc_attr( $instance['paragraph'] ) : '';
		$formname	= isset( $instance['formname'] ) ? esc_attr( $instance['formname'] ) : '';
		$formid	= isset( $instance['formid'] ) ? esc_attr( $instance['formid'] ) : ''; ?>
        
        <div class="flytheme-wrap">
            <div class="data-row">
            	<h5>
                    <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'Tattoo' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
                </h5>
            </div><!-- data row -->
            <div class="data-row">
            	<h5>
                    <label for="<?php echo $this->get_field_id( 'paragraph' ); ?>"><?php _e( 'Content:', 'Tattoo' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'paragraph' ); ?>" name="<?php echo $this->get_field_name( 'paragraph' ); ?>" type="text" value="<?php echo $paragraph; ?>" />
                </h5>
            </div><!-- data row -->
            <div class="data-row">
            	<h5>
                    <label for="<?php echo $this->get_field_id( 'formname' ); ?>"><?php _e( 'Contact Form Name:', 'Tattoo' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'formname' ); ?>" name="<?php echo $this->get_field_name( 'formname' ); ?>" type="text" value="<?php echo $formname; ?>" />
                </h5>
            </div><!-- data row -->
            <div class="data-row">
            	<h5>
                    <label for="<?php echo $this->get_field_id( 'formid' ); ?>"><?php _e( 'Contact Form ID:', 'Tattoo' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'formid' ); ?>" name="<?php echo $this->get_field_name( 'formid' ); ?>" type="text" value="<?php echo $formid; ?>" />
                </h5>
            </div><!-- data row -->
        </div><!-- flytheme wrap -->
	<?php }
}