<?php
/**
 * Sidebar banner
 *
*/

class Alexatheme_Widget_Sidebar_Banner extends WP_Widget {
	public function __construct() {
        $widget_ops = array(
            'classname' => 'alexatheme-widget-sidebar-banner',
            'description' => __( 'Display Banner on sidebar.', 'Tattoo' ),
            'customize_selective_refresh' => true,
        );
        parent::__construct( 'alexatheme-widget-sidebar-banner', __( 'Alexatheme : Sidebar Banner', 'Tattoo' ), $widget_ops );
        $this->alt_option_name = 'widget-sidebar-banner';
    }
	
	public function widget( $args, $instance )
    {
		if ( !isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }
		$title = ( !empty($instance['title']) ) ? $instance['title'] : '';
		$paragraph = ( !empty($instance['paragraph']) ) ? $instance['paragraph'] : '';
		$image_uri = ( !empty($instance['image_uri']) ) ? $instance['image_uri'] : '';
		$btntext = ( !empty($instance['btntext']) ) ? $instance['btntext'] : '';
		$btnlink = ( !empty($instance['btnlink']) ) ? $instance['btnlink'] : '';
		
		echo $args['before_widget'];?>
        
        <div class="widget-sidebar-banner sec-overlay text-center" style="background:url(<?php echo $image_uri; ?>) no-repeat scroll center center/cover;">
        	<div class="sidebar-banner">
				<?php if ( $title ) { echo'<h3>'; echo esc_html( $title ); echo'</h3>';
                } if ( $paragraph ) { 
                    echo '<p>'.esc_html( $paragraph ).'</p>'; 
                } if( $btntext ){
					echo '<a href="'.$btnlink.'" class="buttonstyle1"><span>'.$btntext.'</span></a>';
				}
                ?>
            </div><!-- sidebar banner -->
        </div><!-- widget-sidebar-banner -->
		
		<?php echo $args['after_widget'];
	}
	
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['paragraph'] = sanitize_text_field( $new_instance['paragraph'] );
		$instance['image_uri'] = esc_url_raw( $new_instance['image_uri'] );
		$instance['btntext'] = sanitize_text_field( $new_instance['btntext'] );
		$instance['btnlink'] = sanitize_text_field( $new_instance['btnlink'] );
		
		return $instance;
	}
	
	public function form( $instance ) {
		$title	= isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$paragraph	= isset( $instance['paragraph'] ) ? esc_attr( $instance['paragraph'] ) : '';
		$image_uri	= isset( $instance['image_uri'] ) ? esc_url( $instance['image_uri'] ) : '';
		$btntext	= isset( $instance['btntext'] ) ? esc_attr( $instance['btntext'] ) : '';
		$btnlink	= isset( $instance['btnlink'] ) ? esc_attr( $instance['btnlink'] ) : ''; ?>
        
        <div class="flytheme-wrap">
            <div class="data-row">
            	<h5>
                    <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:', 'Tattoo' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
                </h5>
            </div><!-- data row -->
            <div class="data-row">
            	<h5>
                    <label for="<?php echo $this->get_field_id( 'paragraph' ); ?>"><?php _e( 'Content:', 'Tattoo' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'paragraph' ); ?>" name="<?php echo $this->get_field_name( 'paragraph' ); ?>" type="text" value="<?php echo $paragraph; ?>" />
                </h5>
            </div><!-- data row -->
            <div class="data-row">
            	<h5>
                    <label for="<?php echo $this->get_field_id( 'btntext' ); ?>"><?php _e( 'Button Text:', 'Tattoo' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'btntext' ); ?>" name="<?php echo $this->get_field_name( 'btntext' ); ?>" type="text" value="<?php echo $btntext; ?>" />
                </h5>
            </div><!-- data row -->
            <div class="data-row">
            	<h5>
                    <label for="<?php echo $this->get_field_id( 'btnlink' ); ?>"><?php _e( 'Button Link:', 'Tattoo' ); ?></label>
                    <input class="widefat" id="<?php echo $this->get_field_id( 'btnlink' ); ?>" name="<?php echo $this->get_field_name( 'btnlink' ); ?>" type="text" value="<?php echo $btnlink; ?>" />
                </h5>
            </div><!-- data row -->
            <div class="data-row">
            	<h5>
                    <label for="<?php echo $this->get_field_id('image_uri'); ?>"><?php _e( 'Background Image', 'Tattoo' ); ?></label>
                    <?php if ( $image_uri ) : ?>
                        <img class="custom_media_image flytheme-custom_media_image" src="<?php echo $image_uri; ?>" /><br />
                    <?php endif; ?>
                    <input type="text" class="widefat custom_media_url" name="<?php echo $this->get_field_name('image_uri'); ?>" id="<?php echo $this->get_field_id('image_uri'); ?>" value="<?php echo $image_uri; ?>">
                    <input type="button" class="button button-primary custom_media_button flytheme_banner_background_btn" id="custom_media_button" value="<?php _e( 'Upload Image', 'Tattoo' ) ?>" />
                </h5>
            </div><!-- data row -->

        </div><!-- Tattoo wrap -->
	<?php }
}