<?php
/**
 * Working Hour Widgets
 *
 */
 
class Alexatheme_Working_Hours extends WP_Widget {
	
	public function __construct() {
        $widget_ops = array(
            'classname' => 'alexatheme-widget-opening-hrs',
            'description' => __( 'Displays Opening Hours Information', 'Tattoo' ),
            'customize_selective_refresh' => true,
        );
        parent::__construct( 'alexatheme-widget-opening-hrs', __( 'Alexatheme : Opening Hours', 'Tattoo' ), $widget_ops );
        $this->alt_option_name = 'alexatheme_widget_opening_hrs';
    }
	
	public function widget( $args, $instance )
    {
        if ( !isset( $args['widget_id'] ) ) {
            $args['widget_id'] = $this->id;
        }
		$title = ( !empty($instance['title']) ) ? $instance['title'] : '';
        $weektime = ( !empty($instance['weektime']) ) ? $instance['weektime'] : '';
		$sattime = ( !empty($instance['sattime']) ) ? $instance['sattime'] : '';
		$suntime = ( !empty($instance['suntime']) ) ? $instance['suntime'] : '';

        echo $args['before_widget']; ?>
        <div class="widget-opening-hrs">
			<?php 
				if ( $title ) { echo $args['before_title'] . esc_html( $title ) . $args['after_title']; }
				if( $weektime || $sattime || $suntime  ){
					echo'<div class="opening-hrs">';
						echo'<ul class="opening-hrs-list">';
							if( $weektime ){
								echo '<li><span>'.__('Monday - Friday','Tattoo').'</span>'; echo esc_html( $weektime ); echo'</li>';
							}if( $sattime ){
								echo '<li><span>'.__('Saturday','Tattoo').'</span>'; echo esc_html( $sattime ); echo'</li>';
							}if( $suntime ){
								echo '<li><span>'.__('Sunday','Tattoo').'</span>'; echo esc_html( $suntime ); echo'</li>';
							}
						echo'</ul>';
					echo'</div>';
				}
			?>            
        </div>
        <?php echo $args['after_widget'];
    }
	
	public function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['weektime'] = sanitize_text_field( $new_instance['weektime'] );
		$instance['sattime'] = sanitize_text_field( $new_instance['sattime'] );
		$instance['suntime'] = sanitize_text_field( $new_instance['suntime'] );
        return $instance;
    }
    public function form( $instance ) {
		$title = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$weektime = isset( $instance['weektime'] ) ? esc_attr( $instance['weektime'] ) : '';
		$sattime = isset( $instance['sattime'] ) ? esc_attr( $instance['sattime'] ) : '';
		$suntime = isset( $instance['suntime'] ) ? esc_attr( $instance['suntime'] ) : '';
    ?>
        <div class="flytheme-wrap">
            <div class="flytheme-opening-hrs-widget">
            	<div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'weektime' ); ?>"><?php _e( 'Monday - Friday', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'weektime' ); ?>" name="<?php echo $this->get_field_name( 'weektime' ); ?>" type="text" value="<?php echo $weektime; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'sattime' ); ?>"><?php _e( 'Saturday', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'sattime' ); ?>" name="<?php echo $this->get_field_name( 'sattime' ); ?>" type="text" value="<?php echo $sattime; ?>" />
                    </h5>
                </div><!-- data-row -->
                <div class="data-row">
                    <h5>
                        <label for="<?php echo $this->get_field_id( 'suntime' ); ?>"><?php _e( 'Sunday', 'Tattoo' ); ?></label>
                        <input class="widefat" id="<?php echo $this->get_field_id( 'suntime' ); ?>" name="<?php echo $this->get_field_name( 'suntime' ); ?>" type="text" value="<?php echo $suntime; ?>" />
                    </h5>
                </div><!-- data-row -->
            </div>
        </div>
        <?php
    }
}