<?php 
/**
 * A unique identifier is defined to store the options in the database and reference them from the theme.
 * By default it uses the theme name, in lowercase and without spaces, but this can be changed if needed.
 * If the identifier changes, it'll appear as if the options have been reset.
 */ 

function optionsframework_option_name() {
	// Change this to use your theme slug
	$themename = wp_get_theme();
	$themename = preg_replace("/\W/", "_", strtolower($themename) );
	return $themename;
}

/**
 * Defines an array of options that will be us ed to generate the settings page and be saved in the database.
 * When creating the 'id' fields, make sure to use all lowercase and no spaces.
 *
 * If you are making your theme translatable, you should replace 'Tattoo'
 * with the actual text domain for your theme.  Read more:
 * http://codex.wordpress.org/Function_Reference/load_theme_textdomain
*/

function optionsframework_options() {
	
	$options = array();
	$imagepath =  get_template_directory_uri() . '/images/';
	
	// Pull all the pages into an array
	 $options_pages = array();
	 $options_pages_obj = get_pages('sort_column=post_parent,menu_order');
	 $options_pages[''] = 'Select a page:';
	 foreach ($options_pages_obj as $page) {
	  $options_pages[$page->ID] = $page->post_title;
	 }

	// array of section content.
	$section_text = array(
		
		1=> Array(
			'section_class' => 'container',
			'section_sub_title' => 'Check Out Our',
			'section_title' => 'Amazing Artwork',
			'bgcolor' 		=> '',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[column_content type="one_fourth"][features image_path="'.$imagepath.'fea1.jpg" title="Simple Shapes" button_text="Read More" button_link="#"]Lorem ipsum dolor sit amet, consectetur adipiscing ullamcorper get euismod orci um sociis natoque.[/features][/column_content][column_content type="one_fourth"][features image_path="'.$imagepath.'fea2.jpg" title="Show Your Personality" button_text="Read More" button_link="#"]Lorem ipsum dolor sit amet, consectetur adipiscing ullamcorper get euismod orci um sociis natoque.[/features][/column_content][column_content type="one_fourth"][features image_path="'.$imagepath.'fea3.jpg" title="Full Sleeve Tattoos" button_text="Read More" button_link="#"]Lorem ipsum dolor sit amet, consectetur adipiscing ullamcorper get euismod orci um sociis natoque.[/features][/column_content][column_content type="one_fourth_last"][features image_path="'.$imagepath.'fea4.jpg" title="Powerful Solutions" button_text="Read More" button_link="#"]Lorem ipsum dolor sit amet, consectetur adipiscing ullamcorper get euismod orci um sociis natoque.[/features][/column_content][clear]',
		),
		2=> Array(
			'section_class' => 'container',
			'section_sub_title' => '',
			'section_title' => '',
			'bgcolor' 		=> '',
			'bgimage'		=> $imagepath.'count-bg.jpg',
			'class'			=> 'sec-overlay',
			'content'		=> '[counter_wrap][counter count="910" plus="yes" number_color="#ffffff" image_path="'.$imagepath.'count-thumb.png" title="Tattoos Design"  title_color="#ffffff"][counter count="509" plus="yes" number_color="#ffffff" image_path="'.$imagepath.'count-thumb.png" title="Piercing Done"  title_color="#ffffff"][counter count="352" plus="yes" number_color="#ffffff" image_path="'.$imagepath.'count-thumb.png" title="Corrective Makeup"  title_color="#ffffff"][counter count="204" plus="yes" number_color="#ffffff" image_path="'.$imagepath.'count-thumb.png" title="Number of Awards"  title_color="#ffffff"][counter count="2524" plus="yes" number_color="#ffffff" image_path="'.$imagepath.'count-thumb.png" title="Happy Clients"  title_color="#ffffff"][clear][/counter_wrap]',
		),
		3=> Array(
			'section_class' => 'container',
			'section_sub_title' => 'What We Offer for You',
			'section_title' => 'Our Professional Services',
			'bgcolor' 		=> '',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[column_content type="one_third"][services image_path="'.$imagepath.'ser-1.jpg" title="Piercing" price="$115" link="#"]Lorem ipsum dolor sit amet, consectetur adipisicing elit. Voluptatem, eum ullam accusantium eius repudiandae optio consequuntur debitis placeat itaque expedita nihil.[/services][/column_content][column_content type="one_third"][services image_path="'.$imagepath.'ser-2.jpg" title="Tattooing" price="$115" link="#"]Lorem ipsum dolor sit amet, consectetur adipisicing elit. Voluptatem, eum ullam accusantium eius repudiandae optio consequuntur debitis placeat itaque expedita nihil.[/services][/column_content][column_content type="one_third_last"][services image_path="'.$imagepath.'ser-3.jpg" title="Body Art" price="$115" link="#"]Lorem ipsum dolor sit amet, consectetur adipisicing elit. Voluptatem, eum ullam accusantium eius repudiandae optio consequuntur debitis placeat itaque expedita nihil.[/services][/column_content][clear][column_content type="one_third"][services image_path="'.$imagepath.'ser-4.jpg" title="Henna Art" price="$115" link="#"]Lorem ipsum dolor sit amet, consectetur adipisicing elit. Voluptatem, eum ullam accusantium eius repudiandae optio consequuntur debitis placeat itaque expedita nihil.[/services][/column_content][column_content type="one_third"][services image_path="'.$imagepath.'ser-5.jpg" title="Tribal Tattoo" price="$115" link="#"]Lorem ipsum dolor sit amet, consectetur adipisicing elit. Voluptatem, eum ullam accusantium eius repudiandae optio consequuntur debitis placeat itaque expedita nihil.[/services][/column_content][column_content type="one_third_last"][services image_path="'.$imagepath.'ser-6.jpg" title="Body Modification" price="$115" link="#"]Lorem ipsum dolor sit amet, consectetur adipisicing elit. Voluptatem, eum ullam accusantium eius repudiandae optio consequuntur debitis placeat itaque expedita nihil.[/services][/column_content][clear]',
		),
		4=> Array(
			'section_class' => 'container',
			'section_sub_title' => 'We put our people first',
			'section_title' => 'Our Amazing Artist',
			'bgcolor' 		=> '',
			'bgimage'		=> $imagepath.'team-bg.jpg',
			'class'			=> 'sec-overlay',
			'content'		=> '[our-team type="slider" show="-1"]',
		),
		5=> Array(
			'section_class' => 'container',
			'section_sub_title' => '',
			'section_title' => '',
			'bgcolor' 		=> '',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[video_wrap][video_left image_path="'.$imagepath.'video-img.jpg" title="20% Off" tagline="Your Next Tattoo"][popup_video video_link="https://www.youtube.com/embed/bTdOiLMS_hM"][/video_left][faq_right title="Frequently Ask Question?" sub_title="Caring For Your New Tattoo"][accordion][accordion_content title="Does It Hurt?"]Alienum phaedrum torquato eu, vis detraxit peric Mei an periculaeuripidis Alienum phaedrum torqu vis detraxit pe phaedrum torquat traxit peric Mriculis.[/accordion_content][accordion_content title="Is It Safe?"]Alienum phaedrum torquato eu, vis detraxit peric Mei an periculaeuripidis Alienum phaedrum torqu vis detraxit pe phaedrum torquat traxit peric Mriculis.[/accordion_content][accordion_content title="How Much Is It Going To Cost?"]Alienum phaedrum torquato eu, vis detraxit peric Mei an periculaeuripidis Alienum phaedrum torqu vis detraxit pe phaedrum torquat traxit peric Mriculis.[/accordion_content][accordion_content title="Can Tattoos Be Removed?"]Alienum phaedrum torquato eu, vis detraxit peric Mei an periculaeuripidis Alienum phaedrum torqu vis detraxit pe phaedrum torquat traxit peric Mriculis.[/accordion_content][accordion_content title="How Long Does It Take To Heal?"]Alienum phaedrum torquato eu, vis detraxit peric Mei an periculaeuripidis Alienum phaedrum torqu vis detraxit pe phaedrum torquat traxit peric Mriculis.[/accordion_content][/accordion][/faq_right][clear][/video_wrap]',
		),
		6=> Array(
			'section_class' => 'container',
			'section_sub_title' => 'They Said About Our Work',
			'section_title' => 'What Client Says?',
			'bgcolor' 		=> '',
			'bgimage'		=> $imagepath.'testimonials-bg.jpg',
			'class'			=> 'sec-overlay',
			'content'		=> '[testimonials show="4"]',
		),		
		7=> Array(
			'section_class' => 'container',
			'section_sub_title' => 'Discover The Latest',
			'section_title' => 'Pricing Plans',
			'bgcolor' 		=> '',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[column_content type="one_third"][pricing-plan image_path="'.$imagepath.'price-1.jpg" icon="pencil-paintbrush" icon_style="light" title="Silver Plan" price="100" price_sign="$" row1="Black & gray 20 / sq inch" row2="Colour tattoo 50/sq inch" row3="Portrait tattoo 10/sq inch" row4="Portrait tattoo 10/sq inch" row5="Tattoo From $ 10" btn_label="Submit Request" link="#"][/column_content][column_content type="one_third"][pricing-plan image_path="'.$imagepath.'price-2.jpg" icon="pencil-paintbrush" icon_style="light" title="Diamond Plan" price="150" price_sign="$" row1="Black & gray 20 / sq inch" row2="Colour tattoo 50/sq inch" row3="Portrait tattoo 10/sq inch" row4="Portrait tattoo 10/sq inch" row5="Tattoo From $ 10" btn_label="Submit Request" link="#"][/column_content][column_content type="one_third_last"][pricing-plan image_path="'.$imagepath.'price-3.jpg" icon="pencil-paintbrush" icon_style="light" title="Gold Plan" price="199" price_sign="$" row1="Black & gray 20 / sq inch" row2="Colour tattoo 50/sq inch" row3="Portrait tattoo 10/sq inch" row4="Portrait tattoo 10/sq inch" row5="Tattoo From $ 10" btn_label="Submit Request" link="#"][/column_content][clear]',
		),		
		8=> Array(
			'section_class' => 'container',
			'section_sub_title' => '',
			'section_title' => '',
			'bgcolor' 		=> '',
			'bgimage'		=> $imagepath.'process-bg.jpg',
			'class'			=> 'sec-overlay',
			'content'		=> '[column_content type="one_half"][process_wrap title="Process Work Design"]Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s[clear][process icon="lightbulb-on" icon_style="light" title="Your Idea"][process icon="pen" icon_style="light" title="Sketch"][process icon="dollar-sign" icon_style="light" title="Pricing"][process icon="axe-battle" icon_style="light" title="Tattooing"][clear][/process_wrap][/column_content][column_content type="one_half_last"][custom_order title="Order Custom Tattoo Stencil" small_content="Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s"][custom_order_form form_name="Custom Order" form_id="173"][/custom_order][/column_content][clear]',
		),
		9=> Array(
			'section_class' => 'container',
			'section_sub_title' => 'Articles Updated Daily In Tattoo World',
			'section_title' => 'Our Latest News & Blog',
			'bgcolor' 		=> '',
			'bgimage'		=> '',
			'class'			=> '',
			'content'		=> '[latest-news show="3" type="grid" column="3" date="show" comment="show" author="show" category="show"]',
		),		
	);

	$options = array();

	//Basic Settings
	$options[] = array(
		'name' => __('Basic Settings', 'Tattoo'),
		'type' => 'heading');
		
	$options[] = array(
		'name' => __('Main Logo', 'Tattoo'),
		'desc' => __('Upload your main logo here', 'Tattoo'),
		'id' => 'logo',
		'std'	=> $imagepath.'logo.png',
		'type' => 'upload');
		
	$options[] = array(
		'name' => __('Sticky Logo', 'Tattoo'),
		'desc' => __('Upload your sticky header logo here', 'Tattoo'),
		'id' => 'stckylogo',
		'std'	=> $imagepath.'logo.png',
		'type' => 'upload');
		
	$options[] = array(			
		'desc'	=> __('Check To View Box Layout ', 'Tattoo'),
		'id'	=> 'boxlayout',
		'type'	=> 'checkbox',
		'std'	=> '');			
		
	$options[] = array(
		'name' => __('Custom CSS', 'Tattoo'),
		'desc' => __('Some Custom Styling for your site. Place any css codes here instead of the style.css file.', 'Tattoo'),
		'id' => 'style2',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'name' => __('Enable / Disable Gutenberg editor', 'Tattoo'),
		'desc' => __('enable / disable gutenber editor for page and posts.', 'Tattoo'),
		'id' => 'gutenonoff',
		'type' => 'select',
		'std' => 'disable',
		'options' => array('enable'=>'Enable', 'disable'=>'Disable') );

	$options[] = array(
		'name' => __('Enable / Disable sticky header', 'Tattoo'),
		'desc' => __('enable / disable sticky header.', 'Tattoo'),
		'id' => 'stickhead',
		'type' => 'select',
		'std' => 'disable',
		'options' => array('enable'=>'Enable', 'disable'=>'Disable') );

	// Typography Body
	$typography_body = array(
		'size' => '15px',
		'face' => 'Playfair Display',
		'weight' => '400',
		'style' => 'normal',
		'color' => '#ffffff');	
	
	$typography_h1 = array(
		'size' => '42px',
		'face' => 'Rye',
		'weight' => '700',
		'style' => 'normal',
		'color' => '#ffffff');
		
	$typography_h2 = array(
		'size' => '38px',
		'face' => 'Rye',
		'weight' => '700',
		'style' => 'normal',
		'color' => '#ffffff');
		
	$typography_h3 = array(
		'size' => '22px',
		'face' => 'Rye',
		'weight' => '400',
		'style' => 'normal',
		'color' => '#ffffff');
		
	$typography_h4 = array(
		'size' => '20px',
		'face' => 'Rye',
		'weight' => '400',
		'style' => 'normal',
		'color' => '#ffffff');
		
	$typography_h5 = array(
		'size' => '18px',
		'face' => 'Rye',
		'weight' => '400',
		'style' => 'normal',
		'color' => '#ffffff');
		
	$typography_h6 = array(
		'size' => '16px',
		'face' => 'Rye',
		'weight' => '400',
		'style' => 'normal',
		'color' => '#ffffff');
	
	// Typography Logo
	$typography_logo = array(
		'size' => '45px',
		'face' => 'Rye',
		'weight' => '700',
		'style' => 'normal',
		'color' => '#ffffff');
	
	// Typography Tagline
	$typography_tag = array(
		'size' => '14px',
		'face' => 'Playfair Display',
		'weight' => '400',
		'style' => 'normal',
		'color' => '#ffffff');
		
	// Typography Nav
	$typography_nav = array(
		'size' => '14px',
		'face' => 'Rye',
		'weight' => '400',
		'style' => 'normal',
		'color' => '#ffffff');

	// Typography Slider Sub Title
	$typography_slidesubtitle = array(
		'size' => '30px',
		'face' => 'Birthstone',
		'weight' => '700',
		'style' => 'normal',
		'color' => '#beaa73');

	// Typography Slider Title
	$typography_slidetitle = array(
		'size' => '65px',
		'face' => 'Rye',
		'weight' => '700',
		'style' => 'normal',
		'color' => '#ffffff');

	// Typography Slider Description
	$typography_slidedesc = array(
		'size' => '15px',
		'face' => 'Playfair Display',
		'weight' => '400',
		'style' => 'normal',
		'color' => '#ffffff');
		
	// Typography Section Main Title
	$typography_sectitle = array(
		'size' => '40px',
		'face' => 'Rye',
		'weight' => '700',
		'style' => 'normal',
		'color' => '#ffffff');

	// Typography Section Sub Title
	$typography_secsubtitle = array(
		'size' => '30px',
		'face' => 'Birthstone',
		'weight' => '700',
		'style' => 'normal',
		'color' => '#beaa73');
	
	// Typography Testimonial Name
	$typography_testname = array(
		'size' => '22px',
		'face' => 'Rye',
		'weight' => '700',
		'style' => 'normal',
		'color' => '#ffffff');
		
	// Typography Testimonial company Name
	$typography_testcmp = array(
		'size' => '15px',
		'face' => 'Rye',
		'weight' => '400',
		'style' => 'normal',
		'color' => '#beaa73');
	
	// Typography Our Team Title
	$typography_teamtitle = array(
		'size' => '22px',
		'face' => 'Rye',
		'weight' => '500',
		'style' => 'normal',
		'color' => '#ffffff');
	
	// Typography Latest Posts Title
	$typography_lpttl = array(
		'size' => '18px',
		'face' => 'Rye',
		'weight' => '500',
		'style' => 'normal',
		'color' => '#ffffff');
	
	// Typography Footer Title
	$typography_foottitle = array(
		'size' => '20px',
		'face' => 'Rye',
		'weight' => '500',
		'style' => 'normal',
		'color' => '#ffffff');
	
	// Typography InnerPage Title 
	$typography_pagetitle = array(
		'size' => '35px',
		'face' => 'Rye',
		'weight' => '400',
		'style' => 'normal',
		'color' => '#ffffff');

	// Typography Blog Page Posts Title
	$typography_bpttl = array(
		'size' => '18px',
		'face' => 'Rye',
		'weight' => '500',
		'style' => 'normal',
		'color' => '#ffffff');
		
	// Typography Widget Title
	$typography_widgettitle = array(
		'size' => '18px',
		'face' => 'Rye',
		'weight' => '500',
		'style' => 'normal',
		'color' => '#ffffff');
	
	// Typography Product Title
	$typography_prodtitle = array(
		'size' => '18px',
		'face' => 'Rye',
		'weight' => '700',
		'style' => 'normal',
		'color' => '#ffffff');

	// Typography Single Product Title
	$typography_singleprodtitle = array(
		'size' => '26px',
		'face' => 'Rye',
		'weight' => '700',
		'style' => 'normal',
		'color' => '#ffffff');

	// font family Start 
	$options[] = array(
		'name' => __('Font Typogarphy', 'Tattoo'),
		'desc' => __('Select font family/size/color/weight/style for the body text.', 'Tattoo'),
		'id' => 'bodyfontface',
		'type' => 'typography',
		'std' => $typography_body );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for heading tag h1', 'Tattoo'),
		'id' => 'h1fontface',
		'type' => 'typography',
		'std' => $typography_h1 );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for heading tag h2', 'Tattoo'),
		'id' => 'h2fontface',
		'type' => 'typography',
		'std' => $typography_h2 );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for heading tag h3', 'Tattoo'),
		'id' => 'h3fontface',
		'type' => 'typography',
		'std' => $typography_h3 );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for heading tag h4', 'Tattoo'),
		'id' => 'h4fontface',
		'type' => 'typography',
		'std' => $typography_h4 );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for heading tag h5', 'Tattoo'),
		'id' => 'h5fontface',
		'type' => 'typography',
		'std' => $typography_h5 );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for heading tag h6', 'Tattoo'),
		'id' => 'h6fontface',
		'type' => 'typography',
		'std' => $typography_h6 );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the textual logo', 'Tattoo'),
		'id' => 'logofontface',
		'type' => 'typography',
		'std' => $typography_logo );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the logo tagline', 'Tattoo'),
		'id' => 'tagfontface',
		'type' => 'typography',
		'std' => $typography_tag );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for navigation menu', 'Tattoo'),
		'id' => 'navfontface',
		'type' => 'typography',
		'std' => $typography_nav );

	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for slider Sub title', 'Tattoo'),
		'id' => 'slidesubtitlefontface',
		'type' => 'typography',
		'std' => $typography_slidesubtitle );
	
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for slider Main title', 'Tattoo'),
		'id' => 'slidetitlefontface',
		'type' => 'typography',
		'std' => $typography_slidetitle );

	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for slider description', 'Tattoo'),
		'id' => 'slidedescfontface',
		'type' => 'typography',
		'std' => $typography_slidedesc );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the section title', 'Tattoo'),
		'id' => 'sectitlefontface',
		'type' => 'typography',
		'std' => $typography_sectitle );

	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the section sub title', 'Tattoo'),
		'id' => 'secsubtitlefontface',
		'type' => 'typography',
		'std' => $typography_secsubtitle );
	
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for testimonial name', 'Tattoo'),
		'id' => 'testnamefontface',
		'type' => 'typography',
		'std' => $typography_testname );

	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for testimonial company name', 'Tattoo'),
		'id' => 'testcmpfontface',
		'type' => 'typography',
		'std' => $typography_testcmp );
	
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the Our Team title', 'Tattoo'),
		'id' => 'teamtitlefontface',
		'type' => 'typography',
		'std' => $typography_teamtitle );
	
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the Latest Posts Title', 'Tattoo'),
		'id' => 'lpttlfontface',
		'type' => 'typography',
		'std' => $typography_lpttl );
	
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the footer Widget title', 'Tattoo'),
		'id' => 'foottitlefontface',
		'type' => 'typography',
		'std' => $typography_foottitle );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the InnerPage title', 'Tattoo'),
		'id' => 'pagetitlefontface',
		'type' => 'typography',
		'std' => $typography_pagetitle );

	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the Blog Page Posts Title', 'Tattoo'),
		'id' => 'bpttlfontface',
		'type' => 'typography',
		'std' => $typography_bpttl );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the widget title', 'Tattoo'),
		'id' => 'widgettitlefontface',
		'type' => 'typography',
		'std' => $typography_widgettitle );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the Product page title', 'Tattoo'),
		'id' => 'prodtitlefontface',
		'type' => 'typography',
		'std' => $typography_prodtitle );
		
	$options[] = array(
		'desc' => __('Select font family/size/color/weight/style for the Single Product page title', 'Tattoo'),
		'id' => 'singleprodtitlefontface',
		'type' => 'typography',
		'std' => $typography_singleprodtitle );

	// Header colors
	$options[] = array(
		'name' => __('Header font / background Colors', 'Tattoo'),	
		'desc' => __('Select main header background color for mobile', 'Tattoo'),
		'id' => 'mainheadbgclr',
		'std' => '#090909',
		'type' => 'color');
	
	$options[] = array(	
		'desc' => __('Select background color for header', 'Tattoo'),
		'id' => 'headbgcolor',
		'std' => '#090909',
		'type' => 'color');						
	
	$options[] = array(		
		'desc' => __('Select opacity for header overlay color', 'Tattoo'),
		'id' => 'headbgopac',
		'std' => '0.7',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,'0.1'=>0.1,'0'=>0,));

	// Navigation Menu colors
	$options[] = array(
		'name' => __('Navigation Menu font / background Colors', 'Tattoo'),	
		'desc' => __('Select font color for navigation hover', 'Tattoo'),
		'id' => 'navhovercolor',
		'std' => '#beaa73',
		'type' => 'color');

	// Fonts Colors
	$options[] = array(
		'name' => __('Font Colors', 'Tattoo'),
		'desc' => __('Select body color', 'Tattoo'),
		'id' => 'bodyclr',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select section title color with overlay', 'Tattoo'),
		'id' => 'ovrlaysecclr',
		'std' => '#ffffff',
		'type' => 'color');

	// Second Default Fonts & Background Colors
	$options[] = array(
		'name' => __('Second Default Fonts & Background Colors', 'Tattoo'),
		'desc' => __('Select second default fonts & background color', 'Tattoo'),
		'id' => 'defaultclr',
		'std' => '#090909',
		'type' => 'color');

	// Background Colors
	$options[] = array(
		'name' => __('Background Colors', 'Tattoo'),				
		'desc' => __('Select background color for body', 'Tattoo'),
		'id' => 'bodybgcolor',
		'std' => '#090909',
		'type' => 'color');	

	$options[] = array(
		'desc' => __('Select background color for our skill bar', 'Tattoo'),
		'id' => 'skillbarbgcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select background color for menu in mobile', 'Tattoo'),
		'id' => 'mobilemenubg',
		'std' => '#090909',
		'type' => 'color');

	// Links Colors
	$options[] = array(
		'name' => __('Link Colors ( Theme&#39;s Default Color )', 'Tattoo'),	
		'desc' => __('Select font hover color for links / anchor tags', 'Tattoo'),
		'id' => 'linkhovercolor',
		'std' => '#beaa73',
		'type' => 'color');		
	
	$options[] = array(
		'desc' => __('Select font color for links / anchor tags', 'Tattoo'),
		'id' => 'linkcolor',
		'std' => '#ffffff',
		'type' => 'color');	
	
	// Social Icons Colors
	$options[] = array(	
		'name' => __('Social icons colors', 'Tattoo'),			
		'desc' => __('Select font color for social icons', 'Tattoo'),
		'id' => 'socialfontcolor',
		'std' => '#ffffff',
		'type' => 'color');		
		
	$options[] = array(
		'desc' => __('Select font hover color for social icons', 'Tattoo'),
		'id' => 'socialfonthvcolor',
		'std' => '#beaa73',
		'type' => 'color');

	$options[] = array(	
		'name' => __('Team Member Social icons colors', 'Tattoo'),			
		'desc' => __('Select font color for team member social icons', 'Tattoo'),
		'id' => 'teamsocialfontcolor',
		'std' => '#090909',
		'type' => 'color');

	$options[] = array(	
		'desc' => __('Select font hover color for team member social icons', 'Tattoo'),
		'id' => 'teamsocialhvfontcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(	
		'desc' => __('Select background color for team member social icons', 'Tattoo'),
		'id' => 'teamsocialbgcolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(	
		'desc' => __('Select background hover color for team member social icons', 'Tattoo'),
		'id' => 'teamsocialhvbgcolor',
		'std' => '#beaa73',
		'type' => 'color');

	// Footer Colors
	$options[] = array(		
		'name' => __('Footer Background and Font Color', 'Tattoo'),
		'desc' => __('Select footer background color', 'Tattoo'),
		'id' => 'foobgclr',
		'std' => '#090909',
		'type' => 'color');
				
	$options[] = array(		
		'desc' => __('Select font color for footer description', 'Tattoo'),
		'id' => 'footdesccolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font color for footer copyright text', 'Tattoo'),
		'id' => 'copycolor',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font color for footer copyright links', 'Tattoo'),
		'id' => 'copylinks',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select font hover color for footer copyright links', 'Tattoo'),
		'id' => 'copylinkshov',
		'std' => '#beaa73',
		'type' => 'color');

	$options[] = array(	
		'name' =>__('Copyright Overlay Color and opacity', 'Tattoo'),					
		'desc' => __('Select copyright overlay color', 'Tattoo'),
		'id' => 'copyoverlaycolor',
		'std' => '#ffffff',
		'type' => 'color');						
	
	$options[] = array(		
		'desc' => __('Select copyright opacity for overlay color', 'Tattoo'),
		'id' => 'copyoverlaycoloropacity',
		'std' => '0.1',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,'0.1'=>0.1,'0'=>0,));
	
	// Overlay Color and Opacity
	$options[] = array(	
		'name' =>__('Overlay Color and opacity', 'Tattoo'),					
		'desc' => __('Select overlay color', 'Tattoo'),
		'id' => 'overlaycolor',
		'std' => '#090909',
		'type' => 'color');						
	
	$options[] = array(		
		'desc' => __('Select opacity for overlay color', 'Tattoo'),
		'id' => 'overlaycoloropacity',
		'std' => '0.5',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,'0.1'=>0.1,'0'=>0,));

	// Services Title Background Overlay Color and Opacity
	$options[] = array(	
		'name' =>__('Services Title Background Overlay Color and opacity', 'Tattoo'),
		'desc' => __('Select background overlay color for Services Title', 'Tattoo'),
		'id' => 'seroverlaycolor',
		'std' => '#beaa73',
		'type' => 'color');						
	
	$options[] = array(		
		'desc' => __('Select opacity for services title overlay color', 'Tattoo'),
		'id' => 'seroverlaycoloropacity',
		'std' => '0.9',
		'type' => 'select',
		'options'	=> array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,'0.1'=>0.1,'0'=>0,));
	
	// Main Button ( Default )
	$options[] = array(
		'name' => __('Main Button Color ( Your Theme&#39;s Default Button Color )', 'Tattoo'),
		'desc' => __('Select background color for default button', 'Tattoo'),
		'id' => 'btnbgcolor',
		'std' => '#beaa73',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background hover color for default button', 'Tattoo'),
		'id' => 'btnbghvcolor',
		'std' => '#ffffff',
		'type' => 'color');		
	
	$options[] = array(
		'desc' => __('Select font color default button', 'Tattoo'),
		'id' => 'btntxtcolor',
		'std' => '#ffffff',
		'type' => 'color');
	
	$options[] = array(
		'desc' => __('Select font hover color for default button', 'Tattoo'),
		'id' => 'btntxthvcolor',
		'std' => '#090909',
		'type' => 'color');	
		
	// First Butoon Color	
	$options[] = array(
		'name' => __('First Button Color', 'Tattoo'),
		'desc' => __('Select font color for button style one', 'Tattoo'),
		'id' => 'btnstyle1',
		'std' => '#ffffff',
		'type' => 'color');
	
	$options[] = array(
		'desc' => __('Select font hover color for button style one', 'Tattoo'),
		'id' => 'btnstyle1hv',
		'std' => '#beaa73',
		'type' => 'color');
		
	// Slider Button Color
	$options[] = array(
		'name' => __('Slider Button Color', 'Tattoo'),
		'desc' => __('Select text color for slider button', 'Tattoo'),
		'id' => 'sldrbtncolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select text color for slider button', 'Tattoo'),
		'id' => 'sldrbtnhvcolor',
		'std' => '#beaa73',
		'type' => 'color');

	// News & Blog Read More Button Color
	$options[] = array(
		'name' => __('News & Blog Read More Button Color', 'Tattoo'),
		'desc' => __('Select font color for news & blog read more button', 'Tattoo'),
		'id' => 'readmorebtncolor',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(
		'desc' => __('Select font hover color for news & blog read more button', 'Tattoo'),
		'id' => 'readmorebtnhvcolor',
		'std' => '#090909',
		'type' => 'color');

	// Slider controls colors		
	$options[] = array(
		'name' => __('Slider controls Colors', 'Tattoo'),
		'desc' => __('Select border color for slider pager', 'Tattoo'),
		'id' => 'sldpagebg',
		'std' => '#ffffff',
		'type' => 'color');
		
	$options[] = array(
		'desc' => __('Select background active color for slider pager', 'Tattoo'),
		'id' => 'sldpagehvbg',
		'std' => '#beaa73',
		'type' => 'color');
		
	// Sidebar Colors
	$options[] = array(
		'name' => __('Sidebar/Widget Colors', 'Tattoo'),
		'desc' => __('Select font color for sidebar li a', 'Tattoo'),
		'id' => 'sidebarfontcolor',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(
		'desc' => __('Select font hover color for sidebar li a', 'Tattoo'),
		'id' => 'sidebarfonthvcolor',
		'std' => '#beaa73',
		'type' => 'color');
	
	// Tab and Accordian colors
	$options[] = array(	
		'name' => __('Tab And Toggle Colors', 'Tattoo'),				
		'desc' => __('Select border color for tab active button', 'Tattoo'),
		'id' => 'tabactbdrclr',
		'std' => '#beaa73',
		'type' => 'color');
		
	$options[] = array(					
		'desc' => __('Select font hover/active color for tab button', 'Tattoo'),
		'id' => 'tabttlactvclr',
		'std' => '#ffffff',
		'type' => 'color');	
		
	$options[] = array(					
		'desc' => __('Select font color for tab description', 'Tattoo'),
		'id' => 'tabcontentfontcolor',
		'std' => '#ffffff',
		'type' => 'color');
			
	$options[] = array(	
		'name' => __('Accordion Colors', 'Tattoo'),				
		'desc' => __('Select font color for accordion title', 'Tattoo'),
		'id' => 'accttlclr',
		'std' => '#ffffff',
		'type' => 'color');
	
	$options[] = array(				
		'desc' => __('Select font color for active accordion title', 'Tattoo'),
		'id' => 'accttlactvclr',
		'std' => '#beaa73',
		'type' => 'color');
		
	$options[] = array(				
		'desc' => __('Select border color for active accordion title', 'Tattoo'),
		'id' => 'accbdractvclr',
		'std' => '#beaa73',
		'type' => 'color');
	
	$options[] = array(				
		'desc' => __('Select border color for accordion title', 'Tattoo'),
		'id' => 'acctitlebrdclr',
		'std' => '#ffffff',
		'type' => 'color');

	$options[] = array(				
		'desc' => __('Select font color for accordion title question icon', 'Tattoo'),
		'id' => 'acciconclr',
		'std' => '#090909',
		'type' => 'color');

	$options[] = array(				
		'desc' => __('Select font color for accordion description', 'Tattoo'),
		'id' => 'accdescclr',
		'std' => '#ffffff',
		'type' => 'color');
	
	//Back to top
	$options[] = array(
		'name' => __('Back To Top Icon and color', 'Tattoo'),
		'desc' => __('Add font-awesome icon name for back to top', 'Tattoo'),
		'id' => 'backtpicn',
		'std' => 'long-arrow-alt-up',
		'type' => 'text');
	
	$options[] = array(
		'desc' => __('Select color for back to top icon', 'Tattoo'),
		'id' => 'backtpicnclr',
		'std' => '#ffffff',
		'type' => 'color');
	
	$options[] = array(
		'desc' => __('Select hover color for back to top icon', 'Tattoo'),
		'id' => 'backtpicnhvclr',
		'std' => '#beaa73',
		'type' => 'color');	
	
	//excerpt length		
	$options[] = array(		
		'name' => __('Excerpt Lenth', 'Tattoo'),		
		'desc' => __('Select excerpt length for testimonials section', 'Tattoo'),
		'id' => 'testimonialsexcerptlength',
		'std' => '40',
		'type' => 'text');

	$options[] = array(				
		'desc' => __('Select excerpt length for latest news & blog posts', 'Tattoo'),
		'id' => 'newslength',
		'std' => '15',
		'type' => 'text');

	$options[] = array(									
		'desc' => __('Select excerpt length for blog page posts', 'Tattoo'),
		'id' => 'blogpagepostexcerptlength',
		'std' => '15',
		'type' => 'text');

	$options[] = array(	
		'name' => __('Read More Text', 'Tattoo'),		
		'desc' => __('Change read more button text for blog posts ', 'Tattoo'),
		'id' => 'blogpostreadmoretext',
		'std' => 'Read More',
		'type' => 'text');
			
	$options[] = array(
		'name' => __('Blog Single Layout', 'Tattoo'),
		'desc' => __('Select layout. eg:Boxed, Wide', 'Tattoo'),
		'id' => 'singlelayout',
		'type' => 'select',
		'std' => 'singleright',
		'options' => array('singleright'=>'Blog Single Right Sidebar', 'singleleft'=>'Blog Single Left Sidebar', 'sitefull'=>'Blog Single Full Width', 'nosidebar'=>'Blog Single No Sidebar') );	
		
	$options[] = array(
		'name' => __('Woocommerce Page Layout', 'Tattoo'),
		'desc' => __('Select layout. eg:right-sidebar, left-sidebar, full-width', 'Tattoo'),
		'id' => 'woocommercelayout',
		'type' => 'select',
		'std' => 'woocommercesitefull',
		'options' => array('woocommerceright'=>'Woocommerce Right Sidebar', 'woocommerceleft'=>'Woocommerce Left Sidebar', 'woocommercesitefull'=>'Woocommerce Full Width') );

	$options[] = array(
		'name' => __('Woocommerce Shop Page Image Hover Effect', 'Tattoo'),
		'desc' => __('Turn ON/OFF image hover effect on shop page', 'Tattoo'),
		'id' => 'imgeffect',
		'type' => 'select',
		'std' => 'off',
		'options' => array('on'=>'ON', 'off'=>'OFF') );
		
	//Layout Settings
	$options[] = array(
		'name' => __('Sections', 'Tattoo'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Number of Sections', 'Tattoo'),
		'desc' => __('Select number of sections', 'Tattoo'),
		'id' => 'numsection',
		'type' => 'select',
		'std' => '9',
		'options' => array_combine(range(1,30), range(1,30)) );

	$numsecs = of_get_option( 'numsection', 9 );

	for( $n=1; $n<=$numsecs; $n++){
		$options[] = array(
			'desc' => sprintf( __( '<h3>Section %s </h3>', 'Tattoo' ), ''.$n.''),
			'class' => 'toggle_title',
			'type' => 'info');	
			
		$options[] = array(
			'name' => __('Section Container Class', 'Tattoo'),
			'desc' => __('Add class "container" for normal width and "full-container" for full width', 'Tattoo'),
			'id' => 'secclass'.$n,
			'std' => ( ( isset($section_text[$n]['section_class']) ) ? $section_text[$n]['section_class'] : '' ),
			'type' => 'text');
				
		$options[] = array(
			'name' => __('Animation Type', 'Tattoo'),
			'id' => 'sectionanimate'.$n,			
			'type' => 'select',	
			'std' => 'fadeInUp',	
			'options'	=> array('none'=>'None','fadeInUp'=>'Fade In Up','bounce'=>'Bounce', 'bounceIn'=>'Bounce In','bounceInDown'=>'Bounce In Down','bounceInLeft'=>'Bounce In Left', 'bounceInRight'=>'Bounce In Right', 'bounceInUp'=>'Bounce In Up','fadeIn'=>'Fade In','fadeInDown'=>'Fade In Down','fadeInDownBig'=>'Fade In Down Big','fadeInLeft'=>'Fade In Left','fadeInLeftBig'=>'Fade In Left Big','fadeInRight'=>'Fade In Right','fadeInRightBig'=>'Fade In Right Big','fadeInUp'=>'Fade In Up','fadeInUpBig'=>'Fade In Up Big','flipInX'=>'Flip In X','flipInY'=>'Flip In Y','lightSpeedIn'=>'Light Speed In','slideInUp'=>'Slide In Up','slideInDown'=>'Slide In Down','slideInLeft'=>'Slide In Left','slideInRight'=>'Slide In Right','zoomIn'=>'Zoom In','zoomInDown'=>'Zoom In Down','zoomInLeft'=>'Zoom In Left','zoomInRight'=>'Zoom In Right','zoomInUp'=>'Zoom In Up'));

		$options[] = array(
			'name' => __('Section Sub Title', 'Tattoo'),
			'id' => 'sectionsubtitle'.$n,
			'std' => ( ( isset($section_text[$n]['section_sub_title']) ) ? $section_text[$n]['section_sub_title'] : '' ),
			'type' => 'text');

		$options[] = array(
			'name' => __('Section Title', 'Tattoo'),
			'id' => 'sectiontitle'.$n,
			'std' => ( ( isset($section_text[$n]['section_title']) ) ? $section_text[$n]['section_title'] : '' ),
			'type' => 'text');

		$options[] = array(
			'name' => __('Section Background Color', 'Tattoo'),
			'desc' => __('Select background color for section', 'Tattoo'),
			'id' => 'sectionbgcolor'.$n,
			'std' => ( ( isset($section_text[$n]['bgcolor']) ) ? $section_text[$n]['bgcolor'] : '' ),
			'type' => 'color');
			
		$options[] = array(
			'name' => __('Background Image', 'Tattoo'),
			'id' => 'sectionbgimage'.$n,
			'class' => '',
			'std' => ( ( isset($section_text[$n]['bgimage']) ) ? $section_text[$n]['bgimage'] : '' ),
			'type' => 'upload');

		$options[] = array(
			'name' => __('Section CSS Class', 'Tattoo'),
			'desc' => __('Set class for this section.', 'Tattoo'),
			'id' => 'sectionclass'.$n,
			'std' => ( ( isset($section_text[$n]['class']) ) ? $section_text[$n]['class'] : '' ),
			'type' => 'text');
			
		$options[] = array(
			'name'	=> __('Hide Section', 'Tattoo'),
			'desc'	=> __('Check to hide this section', 'Tattoo'),
			'id'	=> 'hidesec'.$n,
			'type'	=> 'checkbox',
			'std'	=> '');

		$options[] = array(
			'name' => __('Section Content', 'Tattoo'),
			'id' => 'sectioncontent'.$n,
			'std' => ( ( isset($section_text[$n]['content']) ) ? $section_text[$n]['content'] : '' ),
			'type' => 'editor');
	}

	//SLIDER SETTINGS
	$options[] = array(
		'name' => __('Homepage Slider', 'Tattoo'),
		'type' => 'heading');
		
	$options[] = array(
		'name' => __('Inner Page Banner', 'Tattoo'),
		'desc' => __('Upload inner page banner for site', 'Tattoo'),
		'id' => 'innerpagebanner',
		'std'	=> get_template_directory_uri()."/images/inner-banner.jpg",
		'type' => 'upload');

	$options[] = array(			
		'desc'	=> __('Check To hide inner page banner ( NOTE : Change innerpage title color after hiding innerpage banner.)', 'Tattoo'),
		'id'	=> 'hidepagebanner',
		'type'	=> 'checkbox',
		'std'	=> '');
	
	$options[] = array(
		'name' => __('Homepage Slider Show / Hide', 'Tattoo'),
		'desc' => __('Show / Hide slider on Homepage(Note: Add Header Image in Customizer if you want to hide slider on Home Page.)', 'Tattoo'),
		'id' => 'homepageslider',
		'type' => 'select',
		'std' => 'show',
		'options' => array('show'=>'Show', 'hide'=>'Hide') );
		
	$options[] = array(
		'name' => __('Inner Page Slider', 'Tattoo'),
		'desc' => __('Show / Hide inner page slider', 'Tattoo'),
		'id' => 'innerpageslider',
		'type' => 'select',
		'std' => 'hide',
		'options' => array('show'=>'Show', 'hide'=>'Hide') );
	
	$options[] = array(
		'name' => __('Slider Loader', 'Tattoo'),
		'desc' => __('Upload slider loader here 100x100 ( Only gif image )', 'Tattoo'),
		'id' => 'sliderloader',
		'std'	=> get_template_directory_uri()."/images/loading.gif",
		'type' => 'upload');
		
	$options[] = array(
		'name' => __('Slider Overlay Color', 'Tattoo'),
		'desc' => __('Select color for slider overlay', 'Tattoo'),
		'id' => 'sldbgcolor',
		'std' => '#090909',
		'type' => 'color');
	
	$options[] = array(
		'desc' => __('Select opacity for slider overlay','Tattoo'),
		'id' => 'sldbgopac',
		'std' => '0.7',
		'type' => 'select',
		'options' => array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,'0.1'=>0.1,'0'=>0,)
	);
	
	$options[] = array(
		'name' => __('Slider Overlay Text Position','Tattoo'),
		'desc' => __('Select text position of slider overlay text','Tattoo'),
		'id' => 'sldtxt',
		'std' => 'center',
		'type' => 'select',
		'options' => array('left'=>'Left', 'center'=>'Center','right'=>'Right')
	);
		
	$options[] = array(
		'name' => __('Custom Slider Shortcode Area For Home Page', 'Tattoo'),
		'desc' => __('Enter here your slider shortcode without php tag', 'Tattoo'),
		'id' => 'customslider',
		'std' => '',
		'type' => 'textarea');
		
	$options[] = array(
		'name' => __('Slider Effects and Timing', 'Tattoo'),
		'desc' => __('Select slider effect.','Tattoo'),
		'id' => 'slideefect',
		'std' => 'random',
		'type' => 'select',
		'options' => array('random'=>'Random', 'fade'=>'Fade', 'fold'=>'Fold', 'sliceDown'=>'Slide Down', 'sliceDownLeft'=>'Slide Down Left', 'sliceUp'=>'Slice Up', 'sliceUpLeft'=>'Slice Up Left', 'sliceUpDown'=>'Slice Up Down', 'sliceUpDownLeft'=>'Slice Up Down Left', 'slideInRight'=>'SlideIn Right', 'slideInLeft'=>'SlideIn Left', 'boxRandom'=>'Box Random', 'boxRain'=>'Box Rain', 'boxRainReverse'=>'Box Rain Reverse', 'boxRainGrow'=>'Box Rain Grow', 'boxRainGrowReverse'=>'Box Rain Grow Reverse' ));
	
	$options[] = array(
		'desc' => __('ON / OFF autoplay slider','Tattoo'),
		'id' => 'onoffauto',
		'std' => 'false',
		'type' => 'select',
		'options' => array('false'=>'ON', 'true'=>'Off'));
		
	$options[] = array(
		'desc' => __('Animation speed should be multiple of 100.', 'Tattoo'),
		'id' => 'slideanim',
		'std' => 500,
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add slide pause time.', 'Tattoo'),
		'id' => 'slidepause',
		'std' => 4000,
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slide Controllers', 'Tattoo'),
		'desc' => __('Hide/Show Direction Naviagtion of slider.','Tattoo'),
		'id' => 'slidenav',
		'std' => 'true',
		'type' => 'select',
		'options' => array('true'=>'Show', 'false'=>'Hide'));
		
	$options[] = array(
		'desc' => __('Hide/Show pager of slider.','Tattoo'),
		'id' => 'slidepage',
		'std' => 'true',
		'type' => 'select',
		'options' => array('true'=>'Show', 'false'=>'Hide'));
		
	$options[] = array(
		'desc' => __('Pause Slide on Hover.','Tattoo'),
		'id' => 'slidepausehover',
		'std' => 'false',
		'type' => 'select',
		'options' => array('true'=>'Yes', 'false'=>'No'));
		
	$options[] = array(
		'name' => __('Slider Image 1 (1600x900)', 'Tattoo'),
		'desc' => __('First Slide', 'Tattoo'),
		'id' => 'slide1',
		'std' => get_template_directory_uri()."/images/slides/slider1.jpg",
		'type' => 'upload');

	$options[] = array(
		'desc' => __('Slide Sub Title', 'Tattoo'),
		'id' => 'slidesubtitle1',
		'std' => 'We Are Here For You',
		'type' => 'text');
	
	$options[] = array(
		'desc' => __('Slide Main Title', 'Tattoo'),
		'id' => 'slidetitle1',
		'std' => 'Your Choice For Best Style',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Slide Description', 'Tattoo'),
		'id' => 'slidedesc1',
		'std' => 'Sed posuere commodo leo pharetra malesuada. Sed malesuada iaculis ultricies. Aliquam tincidunt erat mollis hendrerit porta. Vivamus molestie eget lacus vel mattis. Donec eget egestas ex. Nulla vulputate et sapien at sagittis.',
		'type' => 'textarea');
	
	$options[] = array(
		'desc' => __('Enter text for button one', 'Tattoo'),
		'id' => 'slidebutton1',
		'std' => 'Explore More',
		'type' => 'text');	

	$options[] = array(
		'desc' => __('Enter url for button one', 'Tattoo'),
		'id' => 'slideurl1',
		'std' => '#',
		'type' => 'text');												
	
	$options[] = array(
		'name' => __('Slider Image 2 (1600x900)', 'Tattoo'),
		'desc' => __('Second Slide', 'Tattoo'),
		'id' => 'slide2',
		'std' => get_template_directory_uri()."/images/slides/slider2.jpg",
		'type' => 'upload');

	$options[] = array(
		'desc' => __('Slide Sub Title', 'Tattoo'),
		'id' => 'slidesubtitle2',
		'std' => 'Adorn your Skin Today',
		'type' => 'text');
	
	$options[] = array(
		'desc' => __('Slide Main Title', 'Tattoo'),
		'id' => 'slidetitle2',
		'std' => 'Every Colour Makes People Happy',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Slide Description', 'Tattoo'),
		'id' => 'slidedesc2',
		'std' => 'Sed posuere commodo leo pharetra malesuada. Sed malesuada iaculis ultricies. Aliquam tincidunt erat mollis hendrerit porta. Vivamus molestie eget lacus vel mattis. Donec eget egestas ex. Nulla vulputate et sapien at sagittis.',
		'type' => 'textarea');
	
	$options[] = array(
		'desc' => __('Enter text for button one', 'Tattoo'),
		'id' => 'slidebutton2',
		'std' => 'Explore More',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Enter url for button one', 'Tattoo'),
		'id' => 'slideurl2',
		'std' => '#',
		'type' => 'text');	
	
	$options[] = array(
		'name' => __('Slider Image 3 (1600x900)', 'Tattoo'),
		'desc' => __('Third Slide', 'Tattoo'),
		'id' => 'slide3',
		'std' => get_template_directory_uri()."/images/slides/slider3.jpg",
		'type' => 'upload');

	$options[] = array(
		'desc' => __('Slide Sub Title', 'Tattoo'),
		'id' => 'slidesubtitle3',
		'std' => 'Fine Hands, Fine Art',
		'type' => 'text');
	
	$options[] = array(
		'desc' => __('Slide Main Title', 'Tattoo'),
		'id' => 'slidetitle3',
		'std' => 'Meet The New Style Perfection',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Slide Description', 'Tattoo'),
		'id' => 'slidedesc3',
		'std' => 'Sed posuere commodo leo pharetra malesuada. Sed malesuada iaculis ultricies. Aliquam tincidunt erat mollis hendrerit porta. Vivamus molestie eget lacus vel mattis. Donec eget egestas ex. Nulla vulputate et sapien at sagittis.',
		'type' => 'textarea');
	
	$options[] = array(
		'desc' => __('Enter text for button one', 'Tattoo'),
		'id' => 'slidebutton3',
		'std' => 'Explore More',
		'type' => 'text');	

	$options[] = array(
		'desc' => __('Enter url for button one', 'Tattoo'),
		'id' => 'slideurl3',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => __('Slider Image 4 (1600x900)', 'Tattoo'),
		'desc' => __('Third Slide', 'Tattoo'),
		'id' => 'slide4',
		'std' => get_template_directory_uri()."/images/slides/slider4.jpg",
		'type' => 'upload');

	$options[] = array(
		'desc' => __('Slide Sub Title', 'Tattoo'),
		'id' => 'slidesubtitle4',
		'std' => 'Get Inked, Get Well',
		'type' => 'text');
	
	$options[] = array(
		'desc' => __('Slide Main Title', 'Tattoo'),
		'id' => 'slidetitle4',
		'std' => 'Feel The Difference Of Talent',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Slide Description', 'Tattoo'),
		'id' => 'slidedesc4',
		'std' => 'Sed posuere commodo leo pharetra malesuada. Sed malesuada iaculis ultricies. Aliquam tincidunt erat mollis hendrerit porta. Vivamus molestie eget lacus vel mattis. Donec eget egestas ex. Nulla vulputate et sapien at sagittis.',
		'type' => 'textarea');
	
	$options[] = array(
		'desc' => __('Enter text for button one', 'Tattoo'),
		'id' => 'slidebutton4',
		'std' => 'Explore More',
		'type' => 'text');	

	$options[] = array(
		'desc' => __('Enter url for button one', 'Tattoo'),
		'id' => 'slideurl4',
		'std' => '#',
		'type' => 'text');
	
	$options[] = array(
		'name' => __('Slider Image 5 (1600x900)', 'Tattoo'),
		'desc' => __('Fifth Slide', 'Tattoo'),
		'id' => 'slide5',
		'std' => get_template_directory_uri()."/images/slides/slider5.jpg",
		'type' => 'upload');
	
	$options[] = array(
		'desc' => __('Slide Sub Title', 'Tattoo'),
		'id' => 'slidesubtitle5',
		'std' => 'Be Forever Stylish',
		'type' => 'text');
	
	$options[] = array(
		'desc' => __('Slide Main Title', 'Tattoo'),
		'id' => 'slidetitle5',
		'std' => 'We Ink Whatever You Think',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Slide Description', 'Tattoo'),
		'id' => 'slidedesc5',
		'std' => 'Sed posuere commodo leo pharetra malesuada. Sed malesuada iaculis ultricies. Aliquam tincidunt erat mollis hendrerit porta. Vivamus molestie eget lacus vel mattis. Donec eget egestas ex. Nulla vulputate et sapien at sagittis.',
		'type' => 'textarea');
	
	$options[] = array(
		'desc' => __('Enter text for button one', 'Tattoo'),
		'id' => 'slidebutton5',
		'std' => 'Explore More',
		'type' => 'text');	

	$options[] = array(
		'desc' => __('Enter url for button one', 'Tattoo'),
		'id' => 'slideurl5',
		'std' => '#',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 6 (1600x900)', 'Tattoo'),
		'desc' => __('Sixth Slide', 'Tattoo'),
		'id' => 'slide6',
		'std' => '',
		'type' => 'upload');

	$options[] = array(
		'desc' => __('Slide Sub Title', 'Tattoo'),
		'id' => 'slidesubtitle6',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'desc' => __('Slide Main Title', 'Tattoo'),
		'id' => 'slidetitle6',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Slide Description', 'Tattoo'),
		'id' => 'slidedesc6',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'desc' => __('Enter text for button one', 'Tattoo'),
		'id' => 'slidebutton6',
		'std' => '',
		'type' => 'text');	

	$options[] = array(
		'desc' => __('Enter url for button one', 'Tattoo'),
		'id' => 'slideurl6',
		'std' => '',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Slider Image 7 (1600x900)', 'Tattoo'),
		'desc' => __('Seventh Slide', 'Tattoo'),
		'id' => 'slide7',
		'std' => '',
		'type' => 'upload');

	$options[] = array(
		'desc' => __('Slide Sub Title', 'Tattoo'),
		'id' => 'slidesubtitle7',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'desc' => __('Slide Main Title', 'Tattoo'),
		'id' => 'slidetitle7',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Slide Description', 'Tattoo'),
		'id' => 'slidedesc7',
		'std' => '',
		'type' => 'textarea');

	$options[] = array(
		'desc' => __('Enter text for button one', 'Tattoo'),
		'id' => 'slidebutton7',
		'std' => '',
		'type' => 'text');	

	$options[] = array(
		'desc' => __('Enter url for button one', 'Tattoo'),
		'id' => 'slideurl7',
		'std' => '',
		'type' => 'text');	
		
	$options[] = array(
		'name' => __('Slider Image 8 (1600x900)', 'Tattoo'),
		'desc' => __('Eighth Slide', 'Tattoo'),
		'id' => 'slide8',
		'std' => '',
		'type' => 'upload');

	$options[] = array(
		'desc' => __('Slide Sub Title', 'Tattoo'),
		'id' => 'slidesubtitle8',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'desc' => __('Slide Main Title', 'Tattoo'),
		'id' => 'slidetitle8',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Slide Description', 'Tattoo'),
		'id' => 'slidedesc8',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'desc' => __('Enter text for button one', 'Tattoo'),
		'id' => 'slidebutton8',
		'std' => '',
		'type' => 'text');	

	$options[] = array(
		'desc' => __('Enter url for button one', 'Tattoo'),
		'id' => 'slideurl8',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'name' => __('Slider Image 9 (1600x900)', 'Tattoo'),
		'desc' => __('Ninth Slide', 'Tattoo'),
		'id' => 'slide9',
		'std' => '',
		'type' => 'upload');

	$options[] = array(
		'desc' => __('Slide Sub Title', 'Tattoo'),
		'id' => 'slidesubtitle9',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'desc' => __('Slide Main Title', 'Tattoo'),
		'id' => 'slidetitle9',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Slide Description', 'Tattoo'),
		'id' => 'slidedesc9',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'desc' => __('Enter text for button one', 'Tattoo'),
		'id' => 'slidebutton9',
		'std' => '',
		'type' => 'text');	

	$options[] = array(
		'desc' => __('Enter url for button one', 'Tattoo'),
		'id' => 'slideurl9',
		'std' => '',
		'type' => 'text');
			
	$options[] = array(
		'name' => __('Slider Image 10 (1600x900)', 'Tattoo'),
		'desc' => __('Tenth Slide', 'Tattoo'),
		'id' => 'slide10',
		'std' => '',
		'type' => 'upload');

	$options[] = array(
		'desc' => __('Slide Sub Title', 'Tattoo'),
		'id' => 'slidesubtitle10',
		'std' => '',
		'type' => 'text');
	
	$options[] = array(
		'desc' => __('Slide Main Title', 'Tattoo'),
		'id' => 'slidetitle10',
		'std' => '',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Slide Description', 'Tattoo'),
		'id' => 'slidedesc10',
		'std' => '',
		'type' => 'textarea');
	
	$options[] = array(
		'desc' => __('Enter text for button one', 'Tattoo'),
		'id' => 'slidebutton10',
		'std' => '',
		'type' => 'text');	

	$options[] = array(
		'desc' => __('Enter url for button one', 'Tattoo'),
		'id' => 'slideurl10',
		'std' => '',
		'type' => 'text');
	
	//FOOTER SETTINGS
	$options[] = array(
		'name' => __('Footer', 'Tattoo'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Footer Column', 'Tattoo'),
		'desc' => __('Select Footer Columns from here', 'Tattoo'),
		'id' => 'footcols',
		'type' => 'select',
		'std' => 'foocolsthree',
		'options' => array('foocolstwo'=>'Footer Two Columns', 'foocolsthree'=>'Footer Three Columns', 'foocolsfour'=>'Footer Four Columns') );

	$options[] = array(
		'name' => __('Footer Background Image', 'Tattoo'),
		'desc' => __('Upload footer main background image here', 'Tattoo'),
		'id' => 'footerbgimg',
		'class' => '',
		'std'	=> get_template_directory_uri().'/images/footer-bg.jpg',
		'type' => 'upload');

	$options[] = array(
		'name' => __('Footer Background Overlay Color', 'Tattoo'),
		'desc' => __('Select color for footer overlay', 'Tattoo'),
		'id' => 'footbgcolor',
		'std' => '#090909',
		'type' => 'color');
	
	$options[] = array(
		'desc' => __('Select opacity for footer background overlay','Tattoo'),
		'id' => 'footbgopac',
		'std' => '0.7',
		'type' => 'select',
		'options' => array('1'=>1, '0.9'=>0.9,'0.8'=>0.8,'0.7'=>0.7,'0.6'=>0.6,'0.5'=>0.5,'0.4'=>0.4,'0.3'=>0.3,'0.2'=>0.2,'0.1'=>0.1,'0'=>0,)
	);

	$options[] = array(
		'name' => __('Footer Top Logo', 'Tattoo'),
		'desc' => __('Upload footer top logo here', 'Tattoo'),
		'id' => 'footlogo',
		'class' => '',
		'std'	=> get_template_directory_uri().'/images/logo.png',
		'type' => 'upload');

	$options[] = array(
		'name' => __('Footer Copyright Text', 'Tattoo'),
		'desc' => __('Copyright Text for your site.', 'Tattoo'),
		'id' => 'copyrighttext',
		'std' => '&copy; Copyright 2021. All Rights Reserved.',
		'type' => 'textarea');

	$options[] = array(
		'name' => __('Footer Design by Text', 'Tattoo'),
		'desc' => __('Design by Text for your site.', 'Tattoo'),
		'id' => 'designbytext',
		'std' => 'Theme Designed by <a href="'.esc_url('http://www.alexathemes.net/').'" target="_blank">Alexa Themes.</a>',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Footer Back to Top Button', 'Tattoo'),
		'id' => 'backtotop',
		'std' => '[back-to-top]',
		'type' => 'textarea',);
		
	//CONTACT US
	$options[] = array(
		'name' => __('Contact Page', 'Tattoo'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Contact Infromation', 'Tattoo'),
		'desc' => __('Add heading here', 'Tattoo'),
		'id' => 'contheading',
		'std' => '[custom_heading sml_ttl="Reach Out To Us In The Nearest Office." sml_title_color="#beaa73" title="Contact Details" title_color="#ffffff" font_size="35px" font_family="Rye" align="center"]',
		'type' => 'textarea');

	$options[] = array(
		'desc' => __('Add Address here', 'Tattoo'),
		'id' => 'contadd',
		'std' => '128 York Street, Brooklyn, New York, United State.',
		'type' => 'textarea');
		
	$options[] = array(
		'desc' => __('Add Phone Number here', 'Tattoo'),
		'id' => 'contphone',
		'std' => ' +(+01)555-555-4444',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Add Fax Number here', 'Tattoo'),
		'id' => 'contfax',
		'std' => '+(+01) 500 000 0000',
		'type' => 'text');
		
	$options[] = array(
		'desc' => __('Add Email here', 'Tattoo'),
		'id' => 'contmail',
		'std' => '<a href="mailto:info@sitename.com">info@sitename.com</a>',
		'type' => 'textarea');

	$options[] = array(
		'desc' => __('Add Web url here', 'Tattoo'),
		'id' => 'weburl',
		'std' => '<a href="#">www.websiteurl.com</a>',
		'type' => 'textarea');

	$options[] = array(
		'name' => __('Contact Page Opening Hours Timing', 'Tattoo'),
		'desc' => __('Add Week Days timing here', 'Tattoo'),
		'id' => 'weekdaystm',
		'std' => '9.00 AM to 20.00 PM',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Add Saturday timing here', 'Tattoo'),
		'id' => 'saturdaystm',
		'std' => '9.00 AM to 20.00 PM',
		'type' => 'text');

	$options[] = array(
		'desc' => __('Add Sunday timing here', 'Tattoo'),
		'id' => 'sundaystm',
		'std' => 'Closed',
		'type' => 'text');
		
	$options[] = array(
		'name' => __('Google Map', 'Tattoo'),
		'desc' => __('Use iframe code url here. DO NOT APPLY IFRAME TAG', 'Tattoo'),
		'id' => 'googlemap',
		'std' => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3024.756708759334!2d-73.98826138515176!3d40.70135554620457!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89c25a33792730d3%3A0xe3fa10ae538dfcbf!2s128%20York%20St%2C%20Brooklyn%2C%20NY%2011201%2C%20USA!5e0!3m2!1sen!2sin!4v1635154316721!5m2!1sen!2sin',
		'type' => 'textarea');
		

	//Short codes						
	$options[] = array(
		'name' => __('Short Codes', 'Tattoo'),
		'type' => 'heading');

	$options[] = array(
		'name' => __('Features', 'Tattoo'),
		'desc' => __('[column_content type="one_fourth"][features image_path="Add image path here" title="Add title here" button_text="Add button text here" button_link="Add button link here"] Content goes here...[/features][/column_content][column_content type="one_fourth"][features image_path="Add image path here..." title="Add title here" button_text="Add button text here" button_link="Add button link here"] Content goes here... [/features][/column_content][column_content type="one_fourth"][features image_path="Add image path here" title="Add title here" button_text="Add button text here" button_link="Add button link here"] Content goes here... [/features][/column_content][column_content type="one_fourth_last"][features image_path="Add image path here" title="Add title here" button_text="Add button text here" button_link="Add button link here"] Content goes here... [/features][/column_content][clear]', 'Tattoo'),
		'type' => 'info' 
	);

	$options[] = array(
		'name' => __('Counter', 'Tattoo'),
		'desc' => __('[counter_wrap][counter count="Add counter number here" plus="yes" number_color="Add number color here" image_path="Add image path here" title="Add title here"  title_color="Add title color here"][counter count="Add counter number here" plus="yes" number_color="Add number color here" image_path="Add image path here" title="Add title here"  title_color="Add title color here"][counter count="Add counter number here" plus="yes" number_color="Add number color here" image_path="Add image path here" title="Add title here"  title_color="Add title color here"][counter count="Add counter number here" plus="yes" number_color="Add number color here" image_path="Add image path here" title="Add title here"  title_color="Add title color here"][counter count="Add counter number here" plus="yes" number_color="Add number color here" image_path="Add image path here" title="Add title here"  title_color="Add title color here"][clear][/counter_wrap]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Services', 'Tattoo'),
		'desc' => __('[column_content type="one_third"][services image_path="Add image path here" title="Add title here" price="Add price here" link="Add link here"] Content goes here... [/services][/column_content][column_content type="one_third"][services image_path="Add image path here" title="Add title here" price="Add price here" link="Add link here"] Content goes here... [/services][/column_content][column_content type="one_third_last"][services image_path="Add image path here" title="Add title here" price="Add price here" link="Add link here"] Content goes here... [/services][/column_content][clear][column_content type="one_third"][services image_path="Add image path here" title="Add title here" price="Add price here" link="Add link here"] Content goes here... [/services][/column_content][column_content type="one_third"][services image_path="Add image path here" title="Add title here" price="Add price here" link="Add link here"] Content goes here... [/services][/column_content][column_content type="one_third_last"][services image_path="Add image path here" title="Add title here" price="Add price here" link="Add link here"] Content goes here... [/services][/column_content][clear]', 'Tattoo'),
		'type' => 'info' 
	);

	$options[] = array(
		'name' => __('Team Members Grid Layout', 'Tattoo'),
		'desc' => __('[our-team type="grid" show="-1" column="2/3/4"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Team Members Slider Layout', 'Tattoo'),
		'desc' => __('[our-team type="slider" show="-1"]', 'Tattoo'),
		'type' => 'info'
	);

	$options[] = array(
		'name' => __('Video and Frequently Ask Question?', 'Tattoo'),
		'desc' => __('[video_wrap][video_left image_path="Add image path here" title="Add title here" tagline="Add tagline here"][popup_video video_link="https://www.youtube.com/embed/bTdOiLMS_hM"][/video_left][faq_right title="Add title here Ex. Frequently Ask Question?" sub_title="Add sub title here Ex. Caring For Your New Tattoo"][accordion][accordion_content title="Add title here"] Content goes here... [/accordion_content][accordion_content title="Add title here"] Content goes here... [/accordion_content][/accordion][/faq_right][clear][/video_wrap]', 'Tattoo'),
		'type' => 'info' 
	);

	$options[] = array(
		'name' => __('Testimonials Rotator', 'Tattoo'),
		'desc' => __('[testimonials show="4"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Testimonials Listing', 'Tattoo'),
		'desc' => __('[testimonials-listing show="3"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Testimonials Sidebar Rotator', 'Tattoo'),
		'desc' => __('[sidebar-testimonials show="2"]', 'Tattoo'),
		'type' => 'info'
	);

	$options[] = array(
		'name' => __('Pricing Plan', 'Tattoo'),
		'desc' => __('[column_content type="one_third"][pricing-plan image_path="Add image path here" icon="Add font awesome icon name here" icon_style="Add font awesome style here Ex. regular/light/solid/brand" title="Add title here" price="Add price here" price_sign="$" row1="Content goes here" row2="Content goes here" row3="Content goes here" row4="Content goes here" row5="Content goes here" btn_label="Add button text here" link="Add button link here"][/column_content][column_content type="one_third"][pricing-plan image_path="Add image path here" icon="Add font awesome icon name here" icon_style="Add font awesome style here Ex. regular/light/solid/brand" title="Add title here" price="Add price here" price_sign="$" row1="Content goes here" row2="Content goes here" row3="Content goes here" row4="Content goes here" row5="Content goes here" btn_label="Add button text here" link="Add button link here"][/column_content][column_content type="one_third_last"][pricing-plan image_path="Add image path here" icon="Add font awesome icon name here" icon_style="Add font awesome style here Ex. regular/light/solid/brand" title="Add title here" price="Add price here" price_sign="$" row1="Content goes here" row2="Content goes here" row3="Content goes here" row4="Content goes here" row5="Content goes here" btn_label="Add button text here" link="Add button link here"][/column_content][clear]', 'Tattoo'),
		'type' => 'info' 
	);

	$options[] = array(
		'name' => __('Process Work & Custom Order Form', 'Tattoo'),
		'desc' => __('[column_content type="one_half"][process_wrap title="Add title here"] Content goes here... [clear][process icon="Add font awesome icon name here" icon_style="Add font awesome style here Ex. regular/light/solid/brand" title="Add title here"][process icon="Add font awesome icon name here" icon_style="Add font awesome style here Ex. regular/light/solid/brand" title="Add title here"][process icon="Add font awesome icon name here" icon_style="Add font awesome style here Ex. regular/light/solid/brand" title="Add title here"][process icon="Add font awesome icon name here" icon_style="Add font awesome style here Ex. regular/light/solid/brand" title="Add title here"][clear][/process_wrap][/column_content][column_content type="one_half_last"][custom_order title="Add title here" small_content="Add small content goes here... "][custom_order_form form_name="Contact Us Form Name Here" form_id="Contact Us Form ID Here"][/custom_order][/column_content][clear]', 'Tattoo'),
		'type' => 'info' 
	);

	$options[] = array(
		'name' => __('News & Articles/Blog Grid Layout', 'Tattoo'),
		'desc' => __('[latest-news show="2" type="grid" column="2/3/4" from_category="Add category slug" date="show/hide" comment="show/hide" author="show/hide" category="show/hide"]', 'Tattoo'),
		'type' => 'info'
	);

	$options[] = array(
		'name' => __('News & Articles/Blog Slider Layout', 'Tattoo'),
		'desc' => __('[latest-news show="-1" type="slider" from_category="Add category slug" comment="show/hide" date="show/hide" author="show/hide" category="show/hide"]', 'Tattoo'),
		'type' => 'info'
	);	
	
	$options[] = array(
		'name' => __('Portfolio Grid Type', 'Tattoo'),
		'desc' => __('[portfolio show="no. of item to be shown( Note: -1 for displaying all items )" type="grid" filter="true/false" column="2/3/4"]', 'Tattoo'),
		'type' => 'info'
	);

	$options[] = array(
		'name' => __('Portfolio Filter Type', 'Tattoo'),
		'desc' => __('[portfolio show="no. of item to be shown( Note: -1 for displaying all items )" type="grid" filter="true/false" column="2/3/4"]', 'Tattoo'),
		'type' => 'info'
	);

	$options[] = array(
		'name' => __('Portfolio Slider Type', 'Tattoo'),
		'desc' => __('[portfolio show="no. of item to be shown( Note: -1 for displaying all items )" type="slider"]', 'Tattoo'),
		'type' => 'info'
	);	

	$options[] = array(
		'name' => __('Photo Gallery Grid Layout', 'Tattoo'),
		'desc' => __('[photo-gallery show="-1" type="grid" column="2/3/4"]<br><strong>You can also display a gallery of a particular category by adding (category="add category slug") option in shortcode.</strong>', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Photo Gallery Slider Layout', 'Tattoo'),
		'desc' => __('[photo-gallery show="-1" type="slider"]', 'Tattoo'),
		'type' => 'info'
	);

	$options[] = array(
		'name' => __('Photo Gallery Filter Layout', 'Tattoo'),
		'desc' => __('[photo-gallery show="-1" type="filter"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Client Logo Rotator', 'Tattoo'),
		'desc' => __('[client_lists][client image="Add image path here" link="#"][client image="Add image path here" link="#"][client image="Add image path here" link="#"][/client_lists]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Image Carousel/Portfolio Gallery', 'Tattoo'),
		'desc' => __('[image_carousel][image path="Add image path here"][image path="Add image path here"][/image_carousel]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Custom Heading', 'Tattoo'),
		'desc' => __('[custom_heading sml_ttl="Add small title here" sml_title_color="#ffffff" title="Custom Heading" title_color="#f6c409" font_size="36px" font_family="Roboto" align="left/center/right"]', 'Tattoo'),
		'type' => 'info'
	);	
	
	$options[] = array(
		'name' => __('Pop Up Video', 'Tattoo'),
		'desc' => __('[popup_video video_link="Add youtube/vimeo video url here"]', 'Tattoo'),
		'type' => 'info' 
	);
	
	$options[] = array(
		'name' => __('Social Icons', 'Tattoo'),
		'desc' => __('[social_area][social icon="facebook" link="#"][social icon="instagram" link="#"][social icon="twitter" link="#"][/social_area]', 'Tattoo'),
		'type' => 'info'
	);

	$options[] = array(
		'name' => __('Section Title', 'Tattoo'),
		'desc' => __('[section_title title="Add Section Title" section_text="Add Section text here"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Section ( NOTE : This shortcode will only work with "full-screen" page template )', 'Tattoo'),
		'desc' => __('[section container_class="container/full-container" animation_type="fadeIn" background_image="Add background image path" background_color="#ffffff" section_sub_title="Add section sub title" section_title="Add section title" section_text="Add sub text here" section_class="Add class to this section"] Add content / shortcode here [/section]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Two Columns', 'Tattoo'),
		'desc' => __('[column_content type="one_half" subcls="Add extra class"] Add Content here [/column_content][column_content type="one_half_last" subcls="Add extra class"] Add Content here [/column_content]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Three Columns', 'Tattoo'),
		'desc' => __('[column_content type="one_third" subcls="Add extra class"][/column_content][column_content type="one_third" subcls="Add extra class"][/column_content] [column_content type="one_third_last" subcls="Add extra class"][/column_content]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Four Columns', 'Tattoo'),
		'desc' => __('[column_content type="one_fourth" subcls="Add extra class"][/column_content][column_content type="one_fourth" subcls="Add extra class"][/column_content][column_content type="one_fourth" subcls="Add extra class"][/column_content][column_content type="one_fourth_last" subcls="Add extra class"][/column_content]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Five Columns', 'Tattoo'),
		'desc' => __('[column_content type="one_fifth" subcls="Add extra class"][/column_content][column_content type="one_fifth" subcls="Add extra class"][/column_content][column_content type="one_fifth" subcls="Add extra class"][/column_content][column_content type="one_fifth" subcls="Add extra class"][/column_content][column_content type="one_fifth_last" subcls="Add extra class"][/column_content]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Accordion', 'Tattoo'),
		'desc' => __('[accordion][accordion_content title="Add title here"] Short content here [/accordion_content][accordion_content title="Add title here"] Short content here [/accordion_content][/accordion]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Tabs', 'Tattoo'),
		'desc' => __('[tabs][tab title="Tab Title 1"] Content goes here [/tab][tab title="Tab Title 2"] Content goes here [/tab][/tabs]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Skill Bar', 'Tattoo'),
		'desc' => __('[skill title="Wordpress" percent="94" bgcolor_active="#beaa73"][skill title="SEO" percent="98" bgcolor_active="#beaa73"][skill title="HTML" percent="92" bgcolor_active="#beaa73"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Unorderd List', 'Tattoo'),
		'desc' => __('[unordered_list style="list-1/list-2/list-3/list-4/list-5/list-6/list-7/list-8/list-9/list-10"]&lt;li&gt;Add content&lt;/li&gt; &lt;li&gt;Add content&lt;/li&gt; &lt;li&gt;Add content&lt;/li&gt;[/unordered_list]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Blockquote', 'Tattoo'),
		'desc' => __('[blockquote align="left/right"] Phasellus suscipit porttitor fringilla. Vivamus eu placerat elit. Quisque sem. Integer vehicula tristique efficitur. Phasellus suscipit porttitor fringilla. Vivamus eu placerat elit. Quisque sem [/blockquote]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Youtube Video', 'Tattoo'),
		'desc' => __('[youtube vid_identifier="_mlf-lP9g6E"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Vimeo Video', 'Tattoo'),
		'desc' => __('[vimeo vid_identifier="144785540"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Dropcap', 'Tattoo'),
		'desc' => __('[dropcap]L[/dropcap]orem integer vehicula tristique efficitur. Phasellus suscipit porttitor fringilla. Vivamus eu placerat elit. Quisque sem. Integer vehicula tristique efficitur. Phasellus suscipit porttitor fringilla. Vivamus eu placerat elit. Quisque sem.', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Messages : Success Message', 'Tattoo'),
		'desc' => __('[message type="success"]This is a sample of the "success" style message box shortcode. To use this style use the following shortcode[/message]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Error Message', 'Tattoo'),
		'desc' => __('[message type="error"]This is a sample of the "error" style message box shortcode. To use this style use the following shortcode.[/message]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Warning Message', 'Tattoo'),
		'desc' => __('[message type="warning"]This is a sample of the "warning" style message box shortcode. To use this style use the following shortcode.[/message]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Information Message', 'Tattoo'),
		'desc' => __('[message type="info"]This is a sample of the "info" style message box shortcode. To use this style use the following shortcode.[/message]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('About Message', 'Tattoo'),
		'desc' => __('[message type="about"]This is a sample of the "about" style message box shortcode. To use this style use the following shortcode.[/message]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Button Style One', 'Tattoo'),
		'desc' => __('[button name="Button" align="left/center/right" link="#"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Gradient Button', 'Tattoo'),
		'desc' => __('[gradient_button size="small/medium/large/x-large" bg_color="#f6c409" color="#ffffff" text="Gradient Button" title="Gradient Button" url="Add link here" position="left/right"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Simple Button', 'Tattoo'),
		'desc' => __('[simple_button size="small/medium/large/x-large" bg_color="#f6c409" color="#ffffff" text="Simple Button" title="Simple Button" url="Add link here" position="left/right"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Round Button', 'Tattoo'),
		'desc' => __('[round_button style="light/dark" text="Round Button" title="Round Button" url="Add link here" position="left/right"]', 'Tattoo'),
		'type' => 'info'
	);
	
	$options[] = array(
		'name' => __('Miscellaneous', 'Tattoo'),
		'desc' => __('[clear]<br>[hr]<br>[back-to-top]<br>[searchform]<br>[spacer space="50"]', 'Tattoo'),
		'type' => 'info'
	);
	
	return $options;
}