<?php
/**
 * The Template for displaying all single posts.
 *
 * @package Tattoo Pro
 */
get_header(); ?>


<div class="container content-area">
    <div class="middle-align sidebar_content">
        <div class="sitefull" id="sitemain">
            <?php
                while ( have_posts() ) : the_post(); 
                $clientlbl = esc_html( get_post_meta( get_the_ID(), '_clientlbl', true ) );
                $client = esc_html( get_post_meta( get_the_ID(), '_client', true ) );
                $locatelbl = esc_html( get_post_meta( get_the_ID(), '_locatelbl', true ) );
                $location = esc_html( get_post_meta( get_the_ID(), '_location', true ) );
                $pdatelbl = esc_html( get_post_meta( get_the_ID(), '_pdatelbl', true ) );
                $pdate = esc_html( get_post_meta( get_the_ID(), '_pdate', true ) );
                $designlbl = esc_html( get_post_meta( get_the_ID(), '_designlbl', true ) );
                $designer = esc_html( get_post_meta( get_the_ID(), '_designer', true ) );
            ?>
               
                <article class="portfolio-single">
                    
                    <div class="portfolio-content">

                        <div class="portfolio-metadeta">
                            <div class="portfolio-share">
                                <?php echo Tattoo_social_sharing_buttons(); ?>
                            </div><!-- portfolio-share -->
                            <div class="portcategory">
                                <ul><li><span>Category : </span> <?php echo get_the_term_list(get_the_ID(), 'port_category', '', ''); ?></li></ul>
                            </div><!-- portcategory -->
                            <div class="clear"></div>
                        </div><!-- portfolio-metadeta-->
                        <div class="portfolio-metadata">
                            <div class="ptfmeta-left">
                                <ul>
                                    <?php if(!($clientlbl == null || $clientlbl == '')){ ?>    
                                        <li><span><?php echo $clientlbl; ?></span> <?php echo $client; ?></li>
                                    <?php } if(!($locatelbl == null || $locatelbl == '')){ ?>
                                        <li><span><?php echo $locatelbl; ?></span> <?php echo $location; ?></li>
                                    <?php } ?>
                                </ul>
                            </div><!-- ptfmeta-left -->
                            <div class="ptfmeta-right">
                                <ul>
                                    <?php if(!($pdatelbl == null || $pdatelbl == '')){ ?>    
                                        <li><span><?php echo $pdatelbl; ?></span> <?php echo $pdate; ?></li>
                                    <?php } if(!($designlbl == null || $designlbl == '')){ ?>
                                        <li><span><?php echo $designlbl; ?></span> <?php echo $designer; ?></li>
                                    <?php } ?>
                                </ul>
                            </div><!-- ptfmeta-right -->
                            <div class="clear"></div>
                        </div><!-- portfolio-metadata -->
                        <?php the_content(); ?>

                        <?php
                            // Posts pagination
                            Tattoo_content_nav( 'nav-below' );
                            
                            // If comments are open or we have at least one comment, load up the comment template
                            if ( comments_open() || '0' != get_comments_number() )
                                comments_template();
                        ?>

                        <?php
                				
                            //get the taxonomy terms of custom post type
            
                            $imgSrcFull = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full');
                            if ( $imgSrcFull[0]!='' ) {
                                $imgFUrl = $imgSrcFull[0];
                            }else{
                                $imgFUrl = get_template_directory_uri().'/images/img_404.png';
                            }
                            
                            $customTaxonomyTerms = wp_get_object_terms( $post->ID, 'port_category', array('fields' => 'ids') );//query arguments
                            $args = array(
                            'post_type' => 'portfolio',					
                            'post_status' => 'publish',					
                            'posts_per_page' => -1,					
                            'orderby' => 'rand',
                        'tax_query' => array(
                            array(
                            'taxonomy' => 'port_category',					
                            'field' => 'id',					
                            'terms' => $customTaxonomyTerms
                            )
                        ),
                        'post__not_in' => array ($post->ID),
            
                        );//the query
                        $relatedPosts = new WP_Query( $args );//loop through query
                        if($relatedPosts->have_posts()){
                            $nomar = 0;
                        
                            echo '<div class="related-port">
                                    <h3>Related Portfolio</h3>
                                    <div class="clear"></div>';
                                        
                                        while($relatedPosts->have_posts()){ $relatedPosts->the_post(); $nomar++;
                                            
                                        if( $nomar%3 == 0 ) $shwnomar = ' lastcols'; else $shwnomar = '';
                                        ?>
                                            <div class="relport-list<?php echo $shwnomar; ?>">
                                                <div class="portfolio-inner">
                                                    <div class="portfolio-image">
                                                        <?php the_post_thumbnail();?>
                                                        <div class="portfolio-overlay">
                                                            <h5><?php the_title(); ?></h5>
                                                            <span class="port-category"><?php echo get_the_term_list(get_the_ID(), 'port_category', '', '');?></span>
                                                        </div><!-- portfolio-content -->
                                                        <div class="overlay-two">
                                                            <div class="overlay-inner">
                                                                <div class="overlay-text">
                                                                    <ul>
                                                                        <li><a href="<?php the_permalink();?>"><i class="fas fa-link"></i></a></li>
                                                                        <li><a class="pop-gallery" data-fancybox="group'.$countcol.'" data-thumb="'.$imgThumbUrl.'" href="'.( ($videoUrl) ? $videoUrl : $imgSrc[0] ).'" data-caption="<?php the_title(); ?>"><i class="fas fa-search-plus"></i></a></li>
                                                                    </ul>
                                                                    <h4><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h4>
                                                                    <a class="ReadMore" href="<?php the_permalink();?>">Read More</a>
                                                                </div><!-- content-overlay -->
                                                            </div><!-- overlay-inner -->
                                                        </div><!-- overlay-two -->
                                                    </div><!-- portfolio-image -->
                                                </div><!-- portfolio-inner -->                      
                                            </div>
                                    
            
                        <?php } echo '<div class="clear"></div></div><!-- related-port -->';                                
            
                            } else { 
                                //no posts found
                        }
                        //restore original post data
                        wp_reset_postdata();?>

                    </div><!-- portfolio-content -->                                      
                </article><!-- portfolio-single -->                 

            <?php endwhile; // end of the loop. ?>
        </div>        
        <div class="clear"></div>        
    </div>
</div>
<?php get_footer(); ?>