<?php
/**
 * The Template for displaying Team single posts.
 *
 * @package Tattoo
 */
get_header(); 

if( of_get_option('singlelayout',true) != ''){
	$layout = of_get_option('singlelayout');
}
?>

<style>
<?php
if( of_get_option('singlelayout', true) == 'singleleft' ){
	echo '#sidebar { float:left !important; }'; 
}
?>
</style>	

<div class="container content-area">
    <div class="middle-align">
    	<div id="sidebar" class="team-sidebar">
        	<?php while ( have_posts() ) : the_post();
				$designation = esc_html( get_post_meta( get_the_ID(), 'designation', true ) );
				$address = esc_html( get_post_meta( get_the_ID(), 'address', true ) );
				$phone = esc_html( get_post_meta( get_the_ID(), 'phone', true ) );
				$mobile = esc_html( get_post_meta( get_the_ID(), 'mobile', true ) );
				$email = esc_html( get_post_meta( get_the_ID(), 'email', true ) );
				$facebook = get_post_meta( get_the_ID(), 'facebook', true );
				$facebooklink = get_post_meta( get_the_ID(), 'facebooklink', true );
				$twitter = get_post_meta( get_the_ID(), 'twitter', true );
				$twitterlink = get_post_meta( get_the_ID(), 'twitterlink', true );
				$linkedin = get_post_meta( get_the_ID(), 'linkedin', true );
				$linkedinlink = get_post_meta( get_the_ID(), 'linkedinlink', true );
				$dribbble = get_post_meta( get_the_ID(), 'dribbble', true );
				$dribbblelink = get_post_meta( get_the_ID(), 'dribbblelink', true );
				$pint = get_post_meta( get_the_ID(), 'google', true );
				$googlelink = get_post_meta( get_the_ID(), 'googlelink', true );				
			?>
            <div class="single-team-thumb">
            	<?php the_post_thumbnail('full' ); ?>
            </div><!-- single team thumb -->
            <div class="single-team-info">
            	<h3><?php the_title(); ?></h3>
                <span><?php echo $designation; ?></span>
            </div><!-- single team info -->
            <?php if( $address || $phone || $mobile || $email ){ ?>
            <div class="member-info">
               <ul>
                <?php
                    if( $address !='' ) { echo '<li><strong>'.__('Address','Tattoo').' : </strong>'.$address.'</li>'; }
                    if( $phone !='' ) { echo '<li><strong>'.__('Phone','Tattoo').' : </strong>'.$phone.'</li>'; }
                    if( $mobile !='' ) { echo '<li><strong>'.__('Mobile','Tattoo').' : </strong>'.$mobile.'</li>'; }
                    if( $email !='' ) { echo '<li><strong>'.__('Email','Tattoo').' : </strong><a href="mailto:'.$email.'">'.$email.'</a></li>'; }
                ?>
               </ul>
            </div><!-- member info -->
            <?php } ?>
            <div class="member-single-social">
				<?php if( $facebook != '' ){
                echo '<a href="'.$facebooklink.'" title="'.$facebook.'" target="_blank"><i class="fab fa-'.$facebook.'"></i></a>';
                }
                if( $twitter != '' ){
                echo '<a href="'.$twitterlink.'" title="'.$twitter.'" target="_blank"><i class="fab fa-'.$twitter.'"></i></a>';
                }
                if( $linkedin != '' ){
                echo '<a href="'.$linkedinlink.'" title="'.$linkedin.'" target="_blank"><i class="fab fa-'.$linkedin.'"></i></a>';
                }
                if( $dribbble != '' ){
                echo '<a href="'.$dribbblelink.'" title="'.$dribbble.'" target="_blank"><i class="fab fa-'.$dribbble.'"></i></a>';
                }
                if( $pint != '' ){
                echo '<a href="'.$googlelink.'" title="'.$pint.'" target="_blank"><i class="fab fa-'.$pint.'"></i></a><div class="clear"></div>';
                }?>
            </div>
        </div><!-- team sidebar -->
        <div class="site-main <?php echo $layout; ?>" id="sitemain">
        	<div class="single-team-content">
				<?php the_content();?>
            </div><!-- single team content -->
        </div><div class="clear"></div> 
            <?php endwhile; // end of the loop. ?>
    </div><!-- middle align -->
</div><!-- container content area -->
<?php get_footer(); ?>