<?php
/**
 * Theme storage manipulations
 *
 * @package WordPress
 * @subpackage NELSON
 * @since NELSON 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) {
	exit; }

// Get theme variable
if ( ! function_exists( 'nelson_storage_get' ) ) {
	function nelson_storage_get( $var_name, $default = '' ) {
		global $NELSON_STORAGE;
		return isset( $NELSON_STORAGE[ $var_name ] ) ? $NELSON_STORAGE[ $var_name ] : $default;
	}
}

// Set theme variable
if ( ! function_exists( 'nelson_storage_set' ) ) {
	function nelson_storage_set( $var_name, $value ) {
		global $NELSON_STORAGE;
		$NELSON_STORAGE[ $var_name ] = $value;
	}
}

// Check if theme variable is empty
if ( ! function_exists( 'nelson_storage_empty' ) ) {
	function nelson_storage_empty( $var_name, $key = '', $key2 = '' ) {
		global $NELSON_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return empty( $NELSON_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return empty( $NELSON_STORAGE[ $var_name ][ $key ] );
		} else {
			return empty( $NELSON_STORAGE[ $var_name ] );
		}
	}
}

// Check if theme variable is set
if ( ! function_exists( 'nelson_storage_isset' ) ) {
	function nelson_storage_isset( $var_name, $key = '', $key2 = '' ) {
		global $NELSON_STORAGE;
		if ( ! empty( $key ) && ! empty( $key2 ) ) {
			return isset( $NELSON_STORAGE[ $var_name ][ $key ][ $key2 ] );
		} elseif ( ! empty( $key ) ) {
			return isset( $NELSON_STORAGE[ $var_name ][ $key ] );
		} else {
			return isset( $NELSON_STORAGE[ $var_name ] );
		}
	}
}

// Inc/Dec theme variable with specified value
if ( ! function_exists( 'nelson_storage_inc' ) ) {
	function nelson_storage_inc( $var_name, $value = 1 ) {
		global $NELSON_STORAGE;
		if ( empty( $NELSON_STORAGE[ $var_name ] ) ) {
			$NELSON_STORAGE[ $var_name ] = 0;
		}
		$NELSON_STORAGE[ $var_name ] += $value;
	}
}

// Concatenate theme variable with specified value
if ( ! function_exists( 'nelson_storage_concat' ) ) {
	function nelson_storage_concat( $var_name, $value ) {
		global $NELSON_STORAGE;
		if ( empty( $NELSON_STORAGE[ $var_name ] ) ) {
			$NELSON_STORAGE[ $var_name ] = '';
		}
		$NELSON_STORAGE[ $var_name ] .= $value;
	}
}

// Get array (one or two dim) element
if ( ! function_exists( 'nelson_storage_get_array' ) ) {
	function nelson_storage_get_array( $var_name, $key, $key2 = '', $default = '' ) {
		global $NELSON_STORAGE;
		if ( '' === $key2 ) {
			return ! empty( $var_name ) && '' !== $key && isset( $NELSON_STORAGE[ $var_name ][ $key ] ) ? $NELSON_STORAGE[ $var_name ][ $key ] : $default;
		} else {
			return ! empty( $var_name ) && '' !== $key && isset( $NELSON_STORAGE[ $var_name ][ $key ][ $key2 ] ) ? $NELSON_STORAGE[ $var_name ][ $key ][ $key2 ] : $default;
		}
	}

}

// Set array element
if ( ! function_exists( 'nelson_storage_set_array' ) ) {
	function nelson_storage_set_array( $var_name, $key, $value ) {
		global $NELSON_STORAGE;
		if ( ! isset( $NELSON_STORAGE[ $var_name ] ) ) {
			$NELSON_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$NELSON_STORAGE[ $var_name ][] = $value;
		} else {
			$NELSON_STORAGE[ $var_name ][ $key ] = $value;
		}
	}
}

// Set two-dim array element
if ( ! function_exists( 'nelson_storage_set_array2' ) ) {
	function nelson_storage_set_array2( $var_name, $key, $key2, $value ) {
		global $NELSON_STORAGE;
		if ( ! isset( $NELSON_STORAGE[ $var_name ] ) ) {
			$NELSON_STORAGE[ $var_name ] = array();
		}
		if ( ! isset( $NELSON_STORAGE[ $var_name ][ $key ] ) ) {
			$NELSON_STORAGE[ $var_name ][ $key ] = array();
		}
		if ( '' === $key2 ) {
			$NELSON_STORAGE[ $var_name ][ $key ][] = $value;
		} else {
			$NELSON_STORAGE[ $var_name ][ $key ][ $key2 ] = $value;
		}
	}
}

// Merge array elements
if ( ! function_exists( 'nelson_storage_merge_array' ) ) {
	function nelson_storage_merge_array( $var_name, $key, $value ) {
		global $NELSON_STORAGE;
		if ( ! isset( $NELSON_STORAGE[ $var_name ] ) ) {
			$NELSON_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			$NELSON_STORAGE[ $var_name ] = array_merge( $NELSON_STORAGE[ $var_name ], $value );
		} else {
			$NELSON_STORAGE[ $var_name ][ $key ] = array_merge( $NELSON_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Add array element after the key
if ( ! function_exists( 'nelson_storage_set_array_after' ) ) {
	function nelson_storage_set_array_after( $var_name, $after, $key, $value = '' ) {
		global $NELSON_STORAGE;
		if ( ! isset( $NELSON_STORAGE[ $var_name ] ) ) {
			$NELSON_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			nelson_array_insert_after( $NELSON_STORAGE[ $var_name ], $after, $key );
		} else {
			nelson_array_insert_after( $NELSON_STORAGE[ $var_name ], $after, array( $key => $value ) );
		}
	}
}

// Add array element before the key
if ( ! function_exists( 'nelson_storage_set_array_before' ) ) {
	function nelson_storage_set_array_before( $var_name, $before, $key, $value = '' ) {
		global $NELSON_STORAGE;
		if ( ! isset( $NELSON_STORAGE[ $var_name ] ) ) {
			$NELSON_STORAGE[ $var_name ] = array();
		}
		if ( is_array( $key ) ) {
			nelson_array_insert_before( $NELSON_STORAGE[ $var_name ], $before, $key );
		} else {
			nelson_array_insert_before( $NELSON_STORAGE[ $var_name ], $before, array( $key => $value ) );
		}
	}
}

// Push element into array
if ( ! function_exists( 'nelson_storage_push_array' ) ) {
	function nelson_storage_push_array( $var_name, $key, $value ) {
		global $NELSON_STORAGE;
		if ( ! isset( $NELSON_STORAGE[ $var_name ] ) ) {
			$NELSON_STORAGE[ $var_name ] = array();
		}
		if ( '' === $key ) {
			array_push( $NELSON_STORAGE[ $var_name ], $value );
		} else {
			if ( ! isset( $NELSON_STORAGE[ $var_name ][ $key ] ) ) {
				$NELSON_STORAGE[ $var_name ][ $key ] = array();
			}
			array_push( $NELSON_STORAGE[ $var_name ][ $key ], $value );
		}
	}
}

// Pop element from array
if ( ! function_exists( 'nelson_storage_pop_array' ) ) {
	function nelson_storage_pop_array( $var_name, $key = '', $defa = '' ) {
		global $NELSON_STORAGE;
		$rez = $defa;
		if ( '' === $key ) {
			if ( isset( $NELSON_STORAGE[ $var_name ] ) && is_array( $NELSON_STORAGE[ $var_name ] ) && count( $NELSON_STORAGE[ $var_name ] ) > 0 ) {
				$rez = array_pop( $NELSON_STORAGE[ $var_name ] );
			}
		} else {
			if ( isset( $NELSON_STORAGE[ $var_name ][ $key ] ) && is_array( $NELSON_STORAGE[ $var_name ][ $key ] ) && count( $NELSON_STORAGE[ $var_name ][ $key ] ) > 0 ) {
				$rez = array_pop( $NELSON_STORAGE[ $var_name ][ $key ] );
			}
		}
		return $rez;
	}
}

// Inc/Dec array element with specified value
if ( ! function_exists( 'nelson_storage_inc_array' ) ) {
	function nelson_storage_inc_array( $var_name, $key, $value = 1 ) {
		global $NELSON_STORAGE;
		if ( ! isset( $NELSON_STORAGE[ $var_name ] ) ) {
			$NELSON_STORAGE[ $var_name ] = array();
		}
		if ( empty( $NELSON_STORAGE[ $var_name ][ $key ] ) ) {
			$NELSON_STORAGE[ $var_name ][ $key ] = 0;
		}
		$NELSON_STORAGE[ $var_name ][ $key ] += $value;
	}
}

// Concatenate array element with specified value
if ( ! function_exists( 'nelson_storage_concat_array' ) ) {
	function nelson_storage_concat_array( $var_name, $key, $value ) {
		global $NELSON_STORAGE;
		if ( ! isset( $NELSON_STORAGE[ $var_name ] ) ) {
			$NELSON_STORAGE[ $var_name ] = array();
		}
		if ( empty( $NELSON_STORAGE[ $var_name ][ $key ] ) ) {
			$NELSON_STORAGE[ $var_name ][ $key ] = '';
		}
		$NELSON_STORAGE[ $var_name ][ $key ] .= $value;
	}
}

// Call object's method
if ( ! function_exists( 'nelson_storage_call_obj_method' ) ) {
	function nelson_storage_call_obj_method( $var_name, $method, $param = null ) {
		global $NELSON_STORAGE;
		if ( null === $param ) {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $NELSON_STORAGE[ $var_name ] ) ? $NELSON_STORAGE[ $var_name ]->$method() : '';
		} else {
			return ! empty( $var_name ) && ! empty( $method ) && isset( $NELSON_STORAGE[ $var_name ] ) ? $NELSON_STORAGE[ $var_name ]->$method( $param ) : '';
		}
	}
}

// Get object's property
if ( ! function_exists( 'nelson_storage_get_obj_property' ) ) {
	function nelson_storage_get_obj_property( $var_name, $prop, $default = '' ) {
		global $NELSON_STORAGE;
		return ! empty( $var_name ) && ! empty( $prop ) && isset( $NELSON_STORAGE[ $var_name ]->$prop ) ? $NELSON_STORAGE[ $var_name ]->$prop : $default;
	}
}
