<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'nelson_cf7_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'nelson_cf7_theme_setup9', 9 );
	function nelson_cf7_theme_setup9() {
		if ( nelson_exists_cf7() ) {
			add_filter('wpcf7_autop_or_not', '__return_false');
			add_action( 'wp_enqueue_scripts', 'nelson_cf7_frontend_scripts', 1100 );
			add_action( 'wp_enqueue_scripts', 'nelson_cf7_responsive_styles', 2000 );
			add_filter( 'nelson_filter_merge_styles', 'nelson_cf7_merge_styles' );
			add_filter( 'nelson_filter_merge_styles_responsive', 'nelson_cf7_merge_styles_responsive' );
			add_filter( 'nelson_filter_merge_scripts', 'nelson_cf7_merge_scripts' );
		}
		if ( is_admin() ) {
			add_filter( 'nelson_filter_tgmpa_required_plugins', 'nelson_cf7_tgmpa_required_plugins' );
			add_filter( 'nelson_filter_theme_plugins', 'nelson_cf7_theme_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'nelson_cf7_tgmpa_required_plugins' ) ) {
		function nelson_cf7_tgmpa_required_plugins( $list = array() ) {
		if ( nelson_storage_isset( 'required_plugins', 'contact-form-7' ) && nelson_storage_get_array( 'required_plugins', 'contact-form-7', 'install' ) !== false ) {
			// CF7 plugin
			$list[] = array(
				'name'     => nelson_storage_get_array( 'required_plugins', 'contact-form-7', 'title' ),
				'slug'     => 'contact-form-7',
				'required' => false,
			);
		}
		return $list;
	}
}

// Filter theme-supported plugins list
if ( ! function_exists( 'nelson_cf7_theme_plugins' ) ) {
		function nelson_cf7_theme_plugins( $list = array() ) {
		if ( ! empty( $list['contact-form-7']['group'] ) ) {
			foreach ( $list as $k => $v ) {
				if ( substr( $k, 0, 15 ) == 'contact-form-7-' ) {
					if ( empty( $v['group'] ) ) {
						$list[ $k ]['group'] = $list['contact-form-7']['group'];
					}
					if ( ! empty( $list['contact-form-7']['logo'] ) ) {
						$list[ $k ]['logo'] = strpos( $list['contact-form-7']['logo'], '//' ) !== false
												? $list['contact-form-7']['logo']
												: nelson_get_file_url( "plugins/contact-form-7/{$list['contact-form-7']['logo']}" );
					}
				}
			}
		}
		return $list;
	}
}

// Check if cf7 installed and activated
if ( ! function_exists( 'nelson_exists_cf7' ) ) {
	function nelson_exists_cf7() {
		return class_exists( 'WPCF7' );
	}
}

// Enqueue WooCommerce custom styles
if ( ! function_exists( 'nelson_cf7_frontend_scripts' ) ) {
		function nelson_cf7_frontend_scripts() {
		if ( nelson_is_on( nelson_get_theme_option( 'debug_mode' ) ) ) {
			$nelson_url = nelson_get_file_url( 'plugins/contact-form-7/contact-form-7.css' );
			if ( '' != $nelson_url ) {
				wp_enqueue_style( 'nelson-contact-form-7', $nelson_url, array(), null );
			}
			$nelson_url = nelson_get_file_url( 'plugins/contact-form-7/contact-form-7.js' );
			if ( '' != $nelson_url ) {
				wp_enqueue_script( 'nelson-contact-form-7', $nelson_url, array( 'jquery' ), null, true );
			}
		}
	}
}

// Enqueue WooCommerce responsive styles
if ( ! function_exists( 'nelson_cf7_responsive_styles' ) ) {
		function nelson_cf7_responsive_styles() {
		if ( nelson_is_on( nelson_get_theme_option( 'debug_mode' ) ) ) {
			$nelson_url = nelson_get_file_url( 'plugins/contact-form-7/contact-form-7-responsive.css' );
			if ( '' != $nelson_url ) {
				wp_enqueue_style( 'nelson-contact-form-7-responsive', $nelson_url, array(), null );
			}
		}
	}
}

// Merge custom styles
if ( ! function_exists( 'nelson_cf7_merge_styles' ) ) {
		function nelson_cf7_merge_styles( $list ) {
		$list[] = 'plugins/contact-form-7/contact-form-7.css';
		return $list;
	}
}


// Merge responsive styles
if ( ! function_exists( 'nelson_cf7_merge_styles_responsive' ) ) {
		function nelson_cf7_merge_styles_responsive( $list ) {
		$list[] = 'plugins/contact-form-7/contact-form-7-responsive.css';
		return $list;
	}
}

// Merge custom scripts
if ( ! function_exists( 'nelson_cf7_merge_scripts' ) ) {
		function nelson_cf7_merge_scripts( $list ) {
		$list[] = 'plugins/contact-form-7/contact-form-7.js';
		return $list;
	}
}