<?php
/* Custom Feeds for Instagram support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('nelson_instagram_feed_theme_setup9')) {
	add_action( 'after_setup_theme', 'nelson_instagram_feed_theme_setup9', 9 );
	function nelson_instagram_feed_theme_setup9() {
		if (is_admin()) {
			add_filter( 'nelson_filter_tgmpa_required_plugins', 'nelson_instagram_feed_tgmpa_required_plugins' );
		}
	}
}

// Check if Custom Feeds for Instagram installed and activated
if ( !function_exists( 'nelson_exists_instagram_feed' ) ) {
	function nelson_exists_instagram_feed() {
		return defined('SBIVER');
	}
}

if ( ! function_exists( 'nelson_instagram_feed_tgmpa_required_plugins' ) ) {
    
    function nelson_instagram_feed_tgmpa_required_plugins( $list = array() ) {
        if ( nelson_storage_isset( 'required_plugins', 'instagram-feed' ) && nelson_storage_get_array( 'required_plugins', 'instagram-feed', 'install' ) !== false ) {
			$list[] = array(
				'name'     => nelson_storage_get_array( 'required_plugins', 'instagram-feed', 'title' ),
				'slug'     => 'instagram-feed',
				'required' => false,
			);
		}
        return $list;
    }
}
?>