<?php
/* Quickcal Appointments support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'nelson_quickcal_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'nelson_quickcal_theme_setup9', 9 );
	function nelson_quickcal_theme_setup9() {
		if ( nelson_exists_quickcal() ) {
			add_action( 'wp_enqueue_scripts', 'nelson_quickcal_frontend_scripts', 1100 );
			add_action( 'wp_enqueue_scripts', 'nelson_quickcal_responsive_styles', 2000 );
			add_filter( 'nelson_filter_merge_styles', 'nelson_quickcal_merge_styles' );
			add_filter( 'nelson_filter_merge_styles_responsive', 'nelson_quickcal_merge_styles_responsive' );
		}
		if ( is_admin() ) {
			add_filter( 'nelson_filter_tgmpa_required_plugins', 'nelson_quickcal_tgmpa_required_plugins' );
			add_filter( 'nelson_filter_theme_plugins', 'nelson_quickcal_theme_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'nelson_quickcal_tgmpa_required_plugins' ) ) {
		function nelson_quickcal_tgmpa_required_plugins( $list = array() ) {
		if ( nelson_storage_isset( 'required_plugins', 'quickcal' ) && nelson_storage_get_array( 'required_plugins', 'quickcal', 'install' ) !== false && nelson_is_theme_activated() ) {
			$path = nelson_get_plugin_source_path( 'plugins/quickcal/quickcal.zip' );
			if ( ! empty( $path ) || nelson_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => nelson_storage_get_array( 'required_plugins', 'quickcal', 'title' ),
					'slug'     => 'quickcal',
					'source'   => ! empty( $path ) ? $path : 'upload://quickcal.zip',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Filter theme-supported plugins list
if ( ! function_exists( 'nelson_quickcal_theme_plugins' ) ) {
		function nelson_quickcal_theme_plugins( $list = array() ) {
		if ( ! empty( $list['quickcal']['group'] ) ) {
			foreach ( $list as $k => $v ) {
				if ( substr( $k, 0, 6 ) == 'quickcal' ) {
					if ( empty( $v['group'] ) ) {
						$list[ $k ]['group'] = $list['quickcal']['group'];
					}
					if ( ! empty( $list['quickcal']['logo'] ) ) {
						$list[ $k ]['logo'] = strpos( $list['quickcal']['logo'], '//' ) !== false
												? $list['quickcal']['logo']
												: nelson_get_file_url( "plugins/quickcal/{$list['quickcal']['logo']}" );
					}
				}
			}
		}
		return $list;
	}
}



// Check if plugin installed and activated
if ( ! function_exists( 'nelson_exists_quickcal' ) ) {
	function nelson_exists_quickcal() {
		return class_exists( 'quickcal_plugin' );
	}
}

// Enqueue WooCommerce responsive styles
if ( ! function_exists( 'nelson_quickcal_responsive_styles' ) ) {
		function nelson_quickcal_responsive_styles() {
		if ( nelson_is_on( nelson_get_theme_option( 'debug_mode' ) ) ) {
			$nelson_url = nelson_get_file_url( 'plugins/quickcal/quickcal-responsive.css' );
			if ( '' != $nelson_url ) {
				wp_enqueue_style( 'nelson-quickcal-responsive', $nelson_url, array(), null );
			}
		}
	}
}

// Enqueue styles for frontend
if ( ! function_exists( 'nelson_quickcal_frontend_scripts' ) ) {
		function nelson_quickcal_frontend_scripts() {
		if ( nelson_is_on( nelson_get_theme_option( 'debug_mode' ) ) ) {
			$nelson_url = nelson_get_file_url( 'plugins/quickcal/quickcal.css' );
			if ( '' != $nelson_url ) {
				wp_enqueue_style( 'nelson-quickcal', $nelson_url, array(), null );
			}
		}
	}
}


// Merge custom styles
if ( ! function_exists( 'nelson_quickcal_merge_styles' ) ) {
		function nelson_quickcal_merge_styles( $list ) {
		$list[] = 'plugins/quickcal/quickcal.css';
		return $list;
	}
}

// Merge responsive styles
if ( ! function_exists( 'nelson_quickcal_merge_styles_responsive' ) ) {
		function nelson_quickcal_merge_styles_responsive( $list ) {
		$list[] = 'plugins/quickcal/quickcal-responsive.css';
		return $list;
	}
}


// Add plugin-specific colors and fonts to the custom CSS
if ( nelson_exists_quickcal() ) {
	require_once NELSON_THEME_DIR . 'plugins/quickcal/quickcal-styles.php';
}
