<?php
/**
 * WooCommerce Cost of Goods
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@skyverge.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade WooCommerce Cost of Goods to newer
 * versions in the future. If you wish to customize WooCommerce Cost of Goods for your
 * needs please refer to http://docs.woocommerce.com/document/cost-of-goods/ for more information.
 *
 * @author      SkyVerge
 * @copyright   Copyright (c) 2013-2025, SkyVerge, Inc. (info@skyverge.com)
 * @license     http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License v3.0
 */

namespace SkyVerge\WooCommerce\COG\Helpers;

use Automattic\WooCommerce\Internal\CostOfGoodsSold\CostOfGoodsSoldController;

defined( 'ABSPATH' ) or exit;

/**
 * Helper class for integrating with the core WooCommerce CoGs feature.
 * 
 * @since 2.15.0
 */
class CoreIntegrationHelper {
    /**
     * Determines if the core CoGs feature is enabled.
     * 
     * @since 2.15.0
     */
    public static function isCoreIntegrationEnabled() : bool {
        if (class_exists(CostOfGoodsSoldController::class)) {
            return wc_get_container()->get( CostOfGoodsSoldController::class )->feature_is_enabled();
        }

        return false;
    }

    /**
     * Determines if we should sync the plugin's CoGs data with the core WooCommerce field.
     * 
     * @since 2.15.0
     */
    public static function shouldSyncDataWithCore() : bool {
        $shouldSync = static::isCoreIntegrationEnabled();

        /**
         * Filters whether we should sync the plugin's CoGs data with the core WooCommerce field.
         * 
         * @param bool $shouldSync
         * @since 2.15.0
         */
        return (bool) apply_filters( 'wc_cog_should_sync_data_with_core', $shouldSync );
    }
}
