-- Version: 2.0.55
return {
	["allow_decimal"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this textfield (when in numeric mode) allows decimal numbers.]==] },
	["allow_negative"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this textfield (when in numeric mode) allows negative numbers.]==] },
	["allow_none_state"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether the `"none"` state is allowed for this switch.  This can't be set to false if the current switch_state is 'none'.]==] },
	["anchor"] = { type="attribute", read="GuiAnchor", write="GuiAnchor", exec=nil, description=[==[The anchor for this relative widget, if any. Setting `nil` clears the anchor.]==] },
	["auto_center"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this frame auto-centers on window resize when stored in [LuaGui::screen](runtime:LuaGui::screen).]==] },
	["auto_toggle"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this button will automatically toggle when clicked.]==] },
	["badge_text"] = { type="attribute", read="LocalisedString", write="LocalisedString", exec=nil, description=[==[The text to display after the normal tab text (designed to work with numbers)]==] },
	["caption"] = { type="attribute", read="LocalisedString", write="LocalisedString", exec=nil, description=[==[The text displayed on this element. For frames, this is the "heading". For other elements, like buttons or labels, this is the content.  Whilst this attribute may be used on all elements without producing an error, it doesn't make sense for tables and flows as they won't display it.]==] },
	["children"] = { type="attribute", read="LuaGuiElement[]", write=nil, exec=nil, description=[==[The child-elements of this GUI element.]==] },
	["children_names"] = { type="attribute", read="string[]", write=nil, exec=nil, description=[==[Names of all the children of this element. These are the identifiers that can be used to access the child as an attribute of this element.]==] },
	["clicked_sprite"] = { type="attribute", read="SpritePath", write="SpritePath", exec=nil, description=[==[The sprite to display on this sprite-button when it is clicked.]==] },
	["column_count"] = { type="attribute", read="uint", write=nil, exec=nil, description=[==[The number of columns in this table.]==] },
	["direction"] = { type="attribute", read="GuiDirection", write=nil, exec=nil, description=[==[Direction of this element's layout.]==] },
	["drag_target"] = { type="attribute", read="LuaGuiElement", write="LuaGuiElement", exec=nil, description=[==[The `frame` that is being moved when dragging this GUI element, if any. This element needs to be a child of the `drag_target` at some level.  Only top-level elements in [LuaGui::screen](runtime:LuaGui::screen) can be `drag_target`s.]==] },
	["draw_horizontal_line_after_headers"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this table should draw a horizontal grid line below the first table row.]==] },
	["draw_horizontal_lines"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this table should draw horizontal grid lines.]==] },
	["draw_vertical_lines"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this table should draw vertical grid lines.]==] },
	["elem_filters"] = { type="attribute", read="PrototypeFilter", write="PrototypeFilter", exec=nil, description=[==[The elem filters of this choose-elem-button, if any. The compatible type of filter is determined by `elem_type`.  Writing to this field does not change or clear the currently selected element.]==] },
	["elem_tooltip"] = { type="attribute", read="ElemID", write="ElemID", exec=nil, description=[==[The element tooltip to display when hovering over this element, or `nil`.]==] },
	["elem_type"] = { type="attribute", read="ElemType", write=nil, exec=nil, description=[==[The elem type of this choose-elem-button.]==] },
	["elem_value"] = { type="attribute", read="string|SignalID|PrototypeWithQuality", write="string|SignalID|PrototypeWithQuality", exec=nil, description=[==[The elem value of this choose-elem-button, if any.  The `"signal"` type operates with [SignalID](runtime:SignalID).  The `"with-quality"` types operate with [PrototypeWithQuality](runtime:PrototypeWithQuality).  The remaining types use strings.]==] },
	["enabled"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this GUI element is enabled. Disabled GUI elements don't trigger events when clicked.]==] },
	["entity"] = { type="attribute", read="LuaEntity", write="LuaEntity", exec=nil, description=[==[The entity associated with this entity-preview, camera, minimap, if any.]==] },
	["force"] = { type="attribute", read="string", write="string", exec=nil, description=[==[The force this minimap is using, if any.]==] },
	["game_controller_interaction"] = { type="attribute", read="defines.game_controller_interaction", write="defines.game_controller_interaction", exec=nil, description=[==[How this element should interact with game controllers.]==] },
	["gui"] = { type="attribute", read="LuaGui", write=nil, exec=nil, description=[==[The GUI this element is a child of.]==] },
	["horizontal_scroll_policy"] = { type="attribute", read="ScrollPolicy", write="ScrollPolicy", exec=nil, description=[==[Policy of the horizontal scroll bar.]==] },
	["hovered_sprite"] = { type="attribute", read="SpritePath", write="SpritePath", exec=nil, description=[==[The sprite to display on this sprite-button when it is hovered.]==] },
	["ignored_by_interaction"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this GUI element is ignored by interaction. This makes clicks on this element 'go through' to the GUI element or even the game surface below it.]==] },
	["index"] = { type="attribute", read="uint", write=nil, exec=nil, description=[==[The index of this GUI element (unique amongst the GUI elements of a LuaPlayer).]==] },
	["is_password"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this textfield displays as a password field, which renders all characters as `*`.]==] },
	["items"] = { type="attribute", read="LocalisedString[]", write="LocalisedString[]", exec=nil, description=[==[The items in this dropdown or listbox.]==] },
	["left_label_caption"] = { type="attribute", read="LocalisedString", write="LocalisedString", exec=nil, description=[==[The text shown for the left switch label.]==] },
	["left_label_tooltip"] = { type="attribute", read="LocalisedString", write="LocalisedString", exec=nil, description=[==[The tooltip shown on the left switch label.]==] },
	["location"] = { type="attribute", read="GuiLocation", write="GuiLocation", exec=nil, description=[==[The location of this widget when stored in [LuaGui::screen](runtime:LuaGui::screen). `nil` if not set or not in [LuaGui::screen](runtime:LuaGui::screen).]==] },
	["locked"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this choose-elem-button can be changed by the player.]==] },
	["lose_focus_on_confirm"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this textfield loses focus after [defines.events.on_gui_confirmed](runtime:defines.events.on_gui_confirmed) is fired.]==] },
	["minimap_player_index"] = { type="attribute", read="uint", write="uint", exec=nil, description=[==[The player index this minimap is using.]==] },
	["mouse_button_filter"] = { type="attribute", read="MouseButtonFlags", write="MouseButtonFlags", exec=nil, description=[==[The mouse button filters for this button or sprite-button.]==] },
	["name"] = { type="attribute", read="string", write="string", exec=nil, description=[==[The name of this element. `""` if no name was set.]==] },
	["number"] = { type="attribute", read="double", write="double", exec=nil, description=[==[The number to be shown in the bottom right corner of this sprite-button, or `nil` to show nothing.]==] },
	["numeric"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this textfield is limited to only numeric characters.]==] },
	["object_name"] = { type="attribute", read="string", write=nil, exec=nil, description=[==[The class name of this object. Available even when `valid` is false. For LuaStruct objects it may also be suffixed with a dotted path to a member of the struct.]==] },
	["parent"] = { type="attribute", read="LuaGuiElement", write=nil, exec=nil, description=[==[The direct parent of this element. `nil` if this is a top-level element.]==] },
	["player_index"] = { type="attribute", read="uint", write=nil, exec=nil, description=[==[Index into [LuaGameScript::players](runtime:LuaGameScript::players) specifying the player who owns this element.]==] },
	["position"] = { type="attribute", read="MapPosition", write="MapPosition", exec=nil, description=[==[The position this camera or minimap is focused on, if any.]==] },
	["quality"] = { type="attribute", read="LuaQualityPrototype", write="QualityID", exec=nil, description=[==[The quality to be shown in the bottom left corner of this sprite-button, or `nil` to show nothing.]==] },
	["raise_hover_events"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this element will raise [on_gui_hover](runtime:on_gui_hover) and [on_gui_leave](runtime:on_gui_leave).]==] },
	["read_only"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this text-box is read-only. Defaults to `false`.]==] },
	["resize_to_sprite"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether the sprite widget should resize according to the sprite in it. Defaults to `true`.]==] },
	["right_label_caption"] = { type="attribute", read="LocalisedString", write="LocalisedString", exec=nil, description=[==[The text shown for the right switch label.]==] },
	["right_label_tooltip"] = { type="attribute", read="LocalisedString", write="LocalisedString", exec=nil, description=[==[The tooltip shown on the right switch label.]==] },
	["selectable"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether the contents of this text-box are selectable. Defaults to `true`.]==] },
	["selected_index"] = { type="attribute", read="uint", write="uint", exec=nil, description=[==[The selected index for this dropdown or listbox. Returns `0` if none is selected.]==] },
	["selected_tab_index"] = { type="attribute", read="uint", write="uint", exec=nil, description=[==[The selected tab index for this tabbed pane, if any.]==] },
	["show_percent_for_small_numbers"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Related to the number to be shown in the bottom right corner of this sprite-button. When set to `true`, numbers that are non-zero and smaller than one are shown as a percentage rather than the value. For example, `0.5` will be shown as `50%` instead.]==] },
	["slider_value"] = { type="attribute", read="double", write="double", exec=nil, description=[==[The value of this slider element.]==] },
	["sprite"] = { type="attribute", read="SpritePath", write="SpritePath", exec=nil, description=[==[The sprite to display on this sprite-button or sprite in the default state.]==] },
	["state"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Is this checkbox or radiobutton checked?]==] },
	["style"] = { type="attribute", read="LuaStyle|string", write="LuaStyle|string", exec=nil, description=[==[The style of this element. When read, this evaluates to a [LuaStyle](runtime:LuaStyle). For writing, it only accepts a string that specifies the textual identifier (prototype name) of the desired style.]==] },
	["surface_index"] = { type="attribute", read="uint", write="uint", exec=nil, description=[==[The surface index this camera or minimap is using.]==] },
	["switch_state"] = { type="attribute", read="SwitchState", write="SwitchState", exec=nil, description=[==[The switch state for this switch.  If [LuaGuiElement::allow_none_state](runtime:LuaGuiElement::allow_none_state) is false this can't be set to `"none"`.]==] },
	["tabs"] = { type="attribute", read="TabAndContent[]", write=nil, exec=nil, description=[==[The tabs and contents being shown in this tabbed-pane.]==] },
	["tags"] = { type="attribute", read="Tags", write="Tags", exec=nil, description=[==[The tags associated with this LuaGuiElement.]==] },
	["text"] = { type="attribute", read="string", write="string", exec=nil, description=[==[The text contained in this textfield or text-box.]==] },
	["toggled"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this button is currently toggled. When a button is toggled, it will use the `selected_graphical_set` and `selected_font_color` defined in its style.]==] },
	["tooltip"] = { type="attribute", read="LocalisedString", write="LocalisedString", exec=nil, description=[==[The text to display when hovering over this element. Writing `""` or `nil` will disable the tooltip.]==] },
	["type"] = { type="attribute", read="GuiElementType", write=nil, exec=nil, description=[==[The type of this GUI element.]==] },
	["valid"] = { type="attribute", read="boolean", write=nil, exec=nil, description=[==[Is this object valid? This Lua object holds a reference to an object within the game engine. It is possible that the game-engine object is removed whilst a mod still holds the corresponding Lua object. If that happens, the object becomes invalid, i.e. this attribute will be `false`. Mods are advised to check for object validity if any change to the game state might have occurred between the creation of the Lua object and its access.]==] },
	["value"] = { type="attribute", read="double", write="double", exec=nil, description=[==[How much this progress bar is filled. It is a value in the range `[0, 1]`.]==] },
	["vertical_centering"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether the content of this table should be vertically centered. Overrides [LuaStyle::column_alignments](runtime:LuaStyle::column_alignments). Defaults to `true`.]==] },
	["vertical_scroll_policy"] = { type="attribute", read="ScrollPolicy", write="ScrollPolicy", exec=nil, description=[==[Policy of the vertical scroll bar.]==] },
	["visible"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Sets whether this GUI element is visible or completely hidden, taking no space in the layout.]==] },
	["word_wrap"] = { type="attribute", read="boolean", write="boolean", exec=nil, description=[==[Whether this text-box will word-wrap automatically. Defaults to `false`.]==] },
	["zoom"] = { type="attribute", read="double", write="double", exec=nil, description=[==[The zoom this camera or minimap is using. This value must be positive.]==] },
	["add"] = { type="method", read=nil, write=nil, exec={"GuiAnchor", "LocalisedString", "ElemID", "boolean", "defines.game_controller_interaction", "boolean", "uint", "string", "boolean", "string", "Tags", "LocalisedString", "GuiElementType", "boolean"}, description=[==[Add a new child element to this GuiElement.]==] },
	["add_item"] = { type="method", read=nil, write=nil, exec={"uint", "LocalisedString"}, description=[==[Inserts a string at the end or at the given index of this dropdown or listbox.]==] },
	["add_tab"] = { type="method", read=nil, write=nil, exec={"LuaGuiElement", "LuaGuiElement"}, description=[==[Adds the given tab and content widgets to this tabbed pane as a new tab.]==] },
	["get_item"] = { type="method", read=nil, write=nil, exec={"uint"}, description=[==[Gets the item at the given index from this dropdown or listbox.]==] },
	["remove_item"] = { type="method", read=nil, write=nil, exec={"uint"}, description=[==[Removes the item at the given index from this dropdown or listbox.]==] },
	["remove_tab"] = { type="method", read=nil, write=nil, exec={"LuaGuiElement"}, description=[==[Removes the given tab and its associated content from this tabbed pane.  Removing a tab does not destroy the tab or the tab contents. It just removes them from the view.]==] },
	["scroll_to_element"] = { type="method", read=nil, write=nil, exec={"LuaGuiElement", "in-view|top-third"}, description=[==[Scrolls this scroll bar such that the specified GUI element is visible to the player.]==] },
	["scroll_to_item"] = { type="method", read=nil, write=nil, exec={"int", "in-view|top-third"}, description=[==[Scrolls the scroll bar such that the specified listbox item is visible to the player.]==] },
	["select"] = { type="method", read=nil, write=nil, exec={"int", "int"}, description=[==[Selects a range of text in this textbox.]==] },
	["set_item"] = { type="method", read=nil, write=nil, exec={"uint", "LocalisedString"}, description=[==[Sets the given string at the given index in this dropdown or listbox.]==] },
	["set_slider_discrete_values"] = { type="method", read=nil, write=nil, exec={"boolean"}, description=[==[Sets whether this slider only allows discrete values.]==] },
	["set_slider_minimum_maximum"] = { type="method", read=nil, write=nil, exec={"double", "double"}, description=[==[Sets this sliders minimum and maximum values. The minimum can't be >= the maximum.]==] },
	["set_slider_value_step"] = { type="method", read=nil, write=nil, exec={"double"}, description=[==[Sets the minimum distance this slider can move. The minimum distance can't be > (max - min).]==] },
	["swap_children"] = { type="method", read=nil, write=nil, exec={"uint", "uint"}, description=[==[Swaps the children at the given indices in this element.]==] },
}