require((KuxCoreLibPath or "__Kux-CoreLib__/") .. "init")

local function isEnabled()
	-- return game.get_player(1).mod_settings["Kux-CoreLib_Debug"].value
	return false --TODO
end

---@class KuxCoreLib.Debug
---@field asGlobal fun():KuxCoreLib.Debug Provides Debug in the global namespace
local Debug = {
	__class  = "Debug",
	__guid   = "{62243C3D-5389-42F7-B7C2-D87967E2D9AF}",
	__origin = "Kux-CoreLib/lib/Debug.lua"
}
if not KuxCoreLib.__classUtils.ctor(Debug) then return self end

---------------------------------------------------------------------------------------------------
Debug.util = require((KuxCoreLibPath or "__Kux-CoreLib__/").."modules/debug_util") --[[@as KuxCoreLib.debug_util]]
local Path = KuxCoreLib.require.Path

function Debug.onSettingsChanged()
	--
end

function Debug.trace(...)
	if not isEnabled() then return end

	local msg = ""
	local args = { ... }
	for i, v in ipairs(args) do
		if v == nil then v = "{nil}" end
		msg = msg .. v
	end
	game.get_player(1).print(msg, { r = 0.7, g = 0.7, b = 0.7, a = 1 })
end

function Debug.warning(...)
	if not isEnabled() then return end

	local msg = ""
	local args = { ... }
	for _, v in ipairs(args) do
		if v == nil then v = "{nil}" end
		msg = msg .. v
	end
	game.get_player(1).print(msg, { r = 1, g = 1, b = 0, a = 1 })
end

function Debug.error(...)
	if not isEnabled() then return end

	local msg = ""
	local args = { ... }
	for i, v in ipairs(args) do
		if v == nil then v = "{nil}" end
		msg = msg .. v
	end
	game.get_player(1).print(msg, { r = 1, g = 0, b = 0, a = 1 })
end

--TODO: remove Path dependency
---@diagnostic disable-next-line: inject-field
function Debug.util.extractLineInfo(inputString)
	local fileName, lineNumber = inputString:match("%s*(.-):(%d+)")
	if (string.match(fileName, "^%.%.%.")) then
		fileName = Path.guessFullName(fileName)
	end

	return fileName, tonumber(lineNumber)
end

---Gets the mod that contains the code that is currently executing.
---@return string?
Debug.getExecutingMod = Debug.util.getExecutingMod

---Returns the mod of the method that invoked the currently executing method.
---@param excludeSelf boolean?
---@return string?
Debug.getCallingMod = Debug.util.getExecutingMod


---Formats a stacktrace generated by traceback
---@param stacktrace string
---@param fname string name of current func to find there caller
---@return string
function Debug.formatStackTrace(stacktrace, fname)
	local out = {}
	local foundCreatePart = false
	local markedCaller = false
	for line in stacktrace:gmatch("[^\n]+") do
		line = line:gsub("\t", "    ") -- Tabs zu 4 Spaces

		local indent = "    "
		if line:find("in function '"..fname.."'") then
			foundCreatePart = true
			table.insert(out, indent .. line)
		elseif foundCreatePart and not markedCaller and line:match("in function") then
			table.insert(out, indent .. "> " .. line:sub(3))
			markedCaller = true
		elseif line:find("__debugadapter__") or line:find("rawxpcall") or line:find("xpcall") then
			table.insert(out, indent .. "⇡×" .. line:sub(3))
		else
			table.insert(out, indent .. line)
		end
	end
	return table.concat(out, "\n")
end

---Formats a stacktrace generated by traceback
---@param stacktrace string
---@param fname string name of current func to find there caller
---@return string?
function Debug.extractCallerFromTrace(stacktrace, fname)
	for line in stacktrace:gmatch("[^\n]+") do
		if line:find("in function '"..fname.."'") then
			foundCreatePart = true
		elseif foundCreatePart then
			if line:match("in function") then
				return line:gsub("\t","")
			end
		end
	end
end

local function trim_from_entry(trace, func_name)
	for pos, line in trace:gmatch("()([^\n]+)") do
		if line:find("in function '"..func_name.."'") then
			return trace:sub(1, pos - 1)
		end
	end
	return trace
end

local function enhance_exception(ex)
	local func_name = debug.traceback(nil, 3):match("in function '([^']*)'")
	ex.stack_trace = trim_from_entry(ex.stack_trace, "try")
	ex.caller = debug.traceback(nil, 3):match("^[^\n]*\n\t([^\n]*)") or "<unknown>"
	ex.current_stack = debug.traceback("", 3)
	ex.stack_trace = Debug.formatStackTrace(ex.stack_trace, func_name)
	return ex
end

---Calls the function and provides an exception object and terminates with an extended error.
---@param f function
---@param on_error (fun(KuxCoreLib.Exception):string)?
---@param skipLevel integer? (defaults to 0)
---@return any
---<p>Usage: <code>result = call(f, format_exception)</code></p>
function _G.call(f,on_error, skipLevel)
	local ok, result = xpcall(f, Debug.catchException)
	if not ok then
		local ex = enhance_exception(result)
		local msg = on_error and on_error(ex) or ex.message.."\n"..ex.stack_trace
		error(msg, 2 + (skipLevel or 0))
	end
	return result
end

---Calls the function and provides an exception object and terminates with an extended error.
---@param f function
---@param catch fun(KuxCoreLib.Exception)
---@return boolean
---@return any #result of f or an error object
function _G.trycall(f,catch)
	local ok, result = xpcall(f, Debug.catchException)
	if not ok then
		local ex = enhance_exception(result)
		if catch then catch(ex) end
		return false, ex
	end
	return true, result
end

---
---@param err any
---@return KuxCoreLib.Exception
---<p>Usage: <br>
---<code>local ok, result = xpcall(try, Debug.catchException)<br>
--- if not ok then error(error_handler(result)) end</code>
function Debug.catchException(err)
	local ex = {
		message=err,
		stack_trace = debug.traceback("", 2)
	}
	return ex
end

---------------------------------------------------------------------------------------------------
return Debug

---@class KuxCoreLib.Exception
---@field message string
---@field stack_trace string
--@field caller string