local table = require('__Kux-CoreLib__/stdlib/utils/table') --[[@as StdLib.Utils.Table]]
local groups = {}

groups.category = {
    'ammo-category',
    'equipment-category',
    'fuel-category',
    'item-group',
    'item-subgroup',
    'module-category',
    'rail-category',
    'recipe-category',
    'resource-category',
}
groups.equipment = {
    'active-defense-equipment',
    'battery-equipment',
    'belt-immunity-equipment',
    'energy-shield-equipment',
    'generator-equipment',
    'movement-bonus-equipment',
    'night-vision-equipment',
    'roboport-equipment',
    'solar-panel-equipment',
}
groups.other = {
    'ambient-sound',
    'autoplace-control',
    'combat-robot-count',
    'damage-type',
    'equipment-grid',
    'font',
    'gui-style',
    'map-gen-presets',
    'map-settings',
    'market',
    'noise-expression',
    'noise-layer',
    'optimized-decorative',
    'recipe',
    'technology',
    'tile',
    'train-path-achievement',
    'trivial-smoke',
    'tutorial',
}
groups.utility = {
    'utility-constants',
    'utility-sounds',
    'utility-sprites'
}

groups.signal = {
    'virtual-signal'
}

groups.achievement = {
    'achievement',
    'build-entity-achievement',
    'construct-with-robots-achievement',
    'deconstruct-with-robots-achievement',
    'deliver-by-robots-achievement',
    'dont-build-entity-achievement',
    'dont-craft-manually-achievement',
    'dont-use-entity-in-energy-production-achievement',
    'finish-the-game-achievement',
    'group-attack-achievement',
    'kill-achievement',
    'player-damaged-achievement',
    'produce-achievement',
    'produce-per-hour-achievement',
    'research-achievement',
}

groups.item = {
    'item',
    'ammo',
    'armor',
    'blueprint-book',
    'blueprint',
    'capsule',
    'deconstruction-item',
    'gun',
    'item-with-entity-data',
    'item-with-inventory',
    'item-with-label',
    'item-with-tags',
    'module',
    'rail-planner',
    'repair-tool',
    'selection-tool',
    'tool',
}

groups.entity = {
    'accumulator',
    'ammo-turret',
    'arithmetic-combinator',
    'arrow',
    'artillery-flare',
    'artillery-projectile',
    'artillery-turret',
    'artillery-wagon',
    'assembling-machine',
    'beacon',
    'beam',
    'boiler',
    'car',
    'cargo-wagon',
    'character-corpse',
    'cliff',
    'combat-robot',
    'constant-combinator',
    'construction-robot',
    'container',
    'corpse',
    'curved-rail',
    'decider-combinator',
    'deconstructible-tile-proxy',
    'decorative',
    'electric-energy-interface',
    'electric-pole',
    'electric-turret',
    'entity-ghost',
    'explosion',
    'fire',
    'fish',
    'flame-thrower-explosion',
    'fluid-turret',
    'fluid-wagon',
    'flying-text',
    'furnace',
    'gate',
    'generator',
    'god-controller',
    'heat-pipe',
    'infinity-container',
    'inserter',
    'item-entity',
    'item-request-proxy',
    'lab',
    'lamp',
    'land-mine',
    'leaf-particle',
    'loader',
    'locomotive',
    'logistic-container',
    'logistic-robot',
    'mining-drill',
    'offshore-pump',
    'particle',
    'particle-source',
    'pipe',
    'pipe-to-ground',
    'player',
    'player-port',
    'power-switch',
    'programmable-speaker',
    'projectile',
    'pump',
    'radar',
    'rail-chain-signal',
    'rail-remnants',
    'rail-signal',
    'reactor',
    'resource',
    'roboport',
    'rocket-silo',
    'rocket-silo-rocket',
    'rocket-silo-rocket-shadow',
    'simple-entity',
    'simple-entity-with-force',
    'simple-entity-with-owner',
    'smoke',
    'smoke-with-trigger',
    'solar-panel',
    'splitter',
    'sticker',
    'storage-tank',
    'straight-rail',
    'stream',
    'tile-ghost',
    'train-stop',
    'transport-belt',
    'tree',
    'turret',
    'underground-belt',
    'unit',
    'unit-spawner',
    'wall'
}

groups.fluid = {
    'fluid'
}

groups.item_and_fluid = table.array_combine(groups.item, groups.fluid)

return groups
