-- Maps an ore to its coresponding mod setting
local resource_setting_map = {
    ["coal"]          = "refill-coal"    ,
    ["iron-ore"]      = "refill-iron"    ,
    ["copper-ore"]    = "refill-copper"  ,
    ["stone"]         = "refill-stone"   ,
    ["uranium-ore"]   = "refill-uranium" ,
    ["calcite"]       = "refill-calcite" ,
    ["tungsten-ore"]  = "refill-tungsten",
    ["scrap"]         = "refill-scrap"   ,
    ["lithium-brine"] = "refill-lithium"
}

local function is_setting_enabled(setting_name)
    local mod_setting = settings.global[setting_name]
    return mod_setting and mod_setting.value
end

-- Called each time an ore patch runs out
local function refill_ore(event)
    -- Checks which ore ran out and if the corresponding setting is enabled
    local setting = resource_setting_map[event.entity.name]
    if (
        (setting ~= nil and not is_setting_enabled(setting)) or 
        (setting == nil and not is_setting_enabled("refill-modded-ores"))
    ) then
        return
    end

    -- Increases the amount that ores are refilled to to prevent tiny ore patches from firing too many events
    storage.refill_amount = storage.refill_amount and storage.refill_amount + 1 or 1

    -- Refills the ore
    event.entity.amount = storage.refill_amount
end

script.on_event(defines.events.on_resource_depleted, refill_ore);
