--[[ Copyright (c) 2017 Optera
 * Part of Storage Tank mk2
 *
 * See LICENSE.md in the project directory for license information.
--]]

local base_tank = data.raw["storage-tank"]["storage-tank"]
base_tank.fast_replaceable_group = base_tank.fast_replaceable_group or "storage-tank"
base_tank.next_upgrade = "storage-tank2"

local tank2 = table.deepcopy(data.raw["storage-tank"]["storage-tank"])
tank2.name = "storage-tank2"
tank2.icon = "__StorageTank2_2_0__/graphics/icon/storage-tank2.png"
tank2.minable.result = "storage-tank2"
tank2.icon_size = 64
tank2.next_upgrade = nil
tank2.max_health = 1000
tank2.fluid_box =
  {
	volume = settings.startup["stm2-tank-capacity"].value,
    pipe_covers = pipecoverspictures(),
	hide_connection_info = true,
    pipe_connections =
    {
      {direction = defines.direction.north, position = {-1, -1} },
      {direction = defines.direction.east, position = {1, 1} },
      {direction = defines.direction.south, position = {1, 1} },
      {direction = defines.direction.west, position = {-1, -1} },
      {direction = defines.direction.north, position = {1, -1} },
      {direction = defines.direction.east, position = {1, -1} },
      {direction = defines.direction.west, position = {-1, 1} },
      {direction = defines.direction.south, position = {-1, 1} },
    }
  }
tank2.rotatable = false
tank2.two_direction_only = true
tank2.pictures.picture =
  {
    layers =
    {
      {
        filename = "__StorageTank2_2_0__/graphics/entity/storage-tank2.png",
        priority = "extra-high",
		width = 219,
		height = 215,
		shift = util.by_pixel(-0.25, 3.75),
		scale = 0.5,
      },
    }
  }


data:extend({
  tank2
})