# Warehousing

Mod for Factorio. *Store **all** the things!* (We heard you like boxes, you packrat you!)

[![GitHub release][badge-latest-release]][github-latest-release]
[![Factorio version target][badge-factorio-version]][mod-portal-entry]
![GitHub Release Date][badge-release-date]
[![Crowdin][badge-crowdin]][crowdin-project]

Go [grab it now][mod-portal-entry], or get it in-game by searching for `Warehousing`.


## Description

Adds 6x6 warehouses that allow you to store a lot of items, and smaller (cheaper) 3x3 storehouses with less capacity.

Warehouses and storehouses also have logistic versions (passive provider, active provider, storage, requester, and buffer), just like chests.

You can also attach red and green wires to the warehouses, and they'll attach to the correct points on the corner of the logistics warehouses.

![Warehouses in a Factorio map][hero-image]

---
No.|Warehouse|Storehouse
-|-|-
1.|Basic warehouse: 1800 slots|Storehouse: 450 slots
&nbsp;|![Basic Warehouse][warehouse-basic]|![Basic Storehouse][storehouse-basic]
2.|Storage warehouse: 2000 slots|Storehouse: 500 slots
&nbsp;|![Storage Warehouse][warehouse-storage]|![Storage Storehouse][storehouse-storage]
3.|Passive provider warehouse: 1800 slots|Storehouse: 450 slots
&nbsp;|![Passive provider warehouse][warehouse-passive-provider]|![Passive provider storehouse][storehouse-passive-provider]
4.|Active provider warehouse: 1800 slots|Storehouse: 450 slots
&nbsp;|![Active provider warehouse][warehouse-active-provider]|![Active provider storehouse][storehouse-active-provider]
5.|Requester warehouse: 1800 slots|Storehouse: 450 slots
&nbsp;|![Requester warehouse][warehouse-requester]|![Requester warehouse][storehouse-requester]
6.|Buffer warehouse: 1800 slots|Storehouse: 450 slots
&nbsp;|![Buffer warehouse][warehouse-buffer]|![Buffer warehouse][storehouse-buffer]

### Recipes

#### Basic warehouse / storehouse

Item|Qty
---|---:
Steel plate | 200
Iron stick | 85
Stone brick | 40
![Basic Warehouse][warehouse-basic]

Item|Qty
---|---:
Steel plate | 50
Iron stick | 16
Stone brick | 10
![Basic Storehouse][storehouse-basic]

#### Storage warehouse / storehouse

Item|Qty
---|---:
Basic warehouse|1
Storage logistic chest|1
Steel plate|10
Iron stick|15
![Storage Warehouse][warehouse-storage]

Item|Qty
---|---:
Basic storehouse|1
Storage logistic chest|1
Iron stick|4
![Storage Storehouse][storehouse-storage]

#### Passive provider warehouse / storehouse

Item|Qty
---|---:
Basic warehouse|1
Passive provider logistic chest|1
Steel plate|10
Iron stick|15
![Passive provider warehouse][warehouse-passive-provider]

Item|Qty
---|---:
Basic storehouse|1
Passive provider logistic chest|1
Iron stick|4
![Passive provider storehouse][storehouse-passive-provider]

#### Active provider warehouse / storehouse

Item|Qty
---|---:
Basic warehouse|1
Active provider logistic chest|1
Steel plate|10
Iron stick|15
![Active provider warehouse][warehouse-active-provider]

Item|Qty
---|---:
Basic storehouse|1
Active provider logistic chest|1
Iron stick|4
![Active provider storehouse][storehouse-active-provider]

#### Requester warehouse / storehouse

Item|Qty
---|---:
Basic warehouse|1
Requester logistic chest|1
Steel plate|10
Iron stick|15
![Requester warehouse][warehouse-requester]

Item|Qty
---|---:
Basic storehouse|1
Requester logistic chest|1
Iron stick|4
![Requester storehouse][storehouse-requester]

#### Buffer warehouse / storehouse

Item|Qty
---|---:
Basic warehouse|1
Buffer logistic chest|1
Steel plate|10
Iron stick|15
![Buffer warehouse][warehouse-buffer]

Item|Qty
---|---:
Basic storehouse|1
Buffer logistic chest|1
Iron stick|4
![Buffer storehouse][storehouse-buffer]


## Contributors

Graphics by Nova_Kast, with visual updates for Factorio 1.0 by snouz. **Please do not use without permission!** PM Anoyomouse on the Factorio forums for permission/requests.

Storehouses contributed by Hanniballo. Updates for Factorio 0.15 contributed by kingarthur, with integration help from dgw (joined as co-maintainer as of 0.0.13).

## Migration removal

As part of the effort to clean up the repo for 2.0 and SpaceAge, the migrations have been removed, as we don't forsee anyone needing them to transition from 1.1 to 2.0

The migrations are many years old and have not been required for the longest time.

Should migrations be needed (your game is that old), then we suggest opening your game in 1.1, running the migrations, and then moving to 2.0

### Translations

Want to see Warehousing available in your language? Please help us [translate the mod][crowdin-project] on Crowdin! Create a free account (or log in with Google, Twitter, Facebook, GitHub, or GitLab) and help make this mod (even more) awesome!

Existing translations kindly provided by the following people:

| <!-- flag -->    |        Language        |                                    Translator(s)                                           |
|------------------|------------------------|--------------------------------------------------------------------------------------------|
| :south_africa:   | Afrikaans              | Anoyomouse<br>@Yuuki2012                                                                   |
|                  | Arabic                 | yahyaqradi10                                                                               |
| :bulgaria:       | Bulgarian              | peter-mw                                                                                   |
| :cn:             | Chinese (Simplified)   | 621awdrgyjil<br>PlexPt<br>plumxing                                                         |
| :cn:             | Chinese (Traditional)  | artemkiselevvloger<br>k98a<br>pickuse2013<br>willy04wu69                                   |
| :czech_republic: | Czech                  | kukuc473<br>Raus                                                                           |
| :netherlands:    | Dutch                  | Beverneus<br>eregni<br>TheRealHenkFisher<br>Yuuki-chan2012                                 |
| :finland:        | Finnish                | mikkoku81                                                                                  |
| :fr:             | French                 | alainmonk<br>daikyraraga<br>Hasturcraft<br>rom5921                                         |
| :de:             | German                 | apcnc<br>honkinator22<br>Opterai<br>silentpiranha                                          |
| :hungary:        | Hungarian              | artemkiselevvloger                                                                         |
| :it:             | Italian                | aironenerowork<br>cocchisgambelluri45                                                      |
| :jp:             | Japanese               | Quifon                                                                                     |
| :kr:             | Korean                 | angpoo<br>@GimoXagros<br>StaGVii                                                           |
| :poland:         | Polish                 | diilmac<br>Nalapl3<br>sayonara4747<br>tengongcreative                                      |
| :brazil:         | Portuguese (Brazilian) | @RaphaelNeumann<br>@scarsick<br>vini84200<br>artemkiselevvloger<br>Clelton<br>PrinceAstero |
| :ru:             | Russian                | applevine1<br>apriori<br>axell2580<br>bjiomspeed<br>Oceanel                                |
| :slovakia:       | Slovak                 | 350zipoo                                                                                   |
| :es:             | Spanish                | AgnotSeeker<br>black.dreicous<br>frenchiveruti<br>ithan.lara.f<br>leortegacaudillo         |
| :tr:             | Turkish                | orya                                                                                       |
| :ukraine:        | Ukrainian              | antonus777<br>ddayver<br>Met_en_Bouldry<br>padwiyangel<br>sasha.garmash96                  |


  [warehouse-basic]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/warehouse/warehouse-basic.png
  [warehouse-storage]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/warehouse/warehouse-storage.png
  [warehouse-passive-provider]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/warehouse/warehouse-passive-provider.png
  [warehouse-active-provider]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/warehouse/warehouse-active-provider.png
  [warehouse-requester]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/warehouse/warehouse-requester.png
  [warehouse-buffer]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/warehouse/warehouse-buffer.png

  [storehouse-basic]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/storehouse/storehouse-basic.png
  [storehouse-storage]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/storehouse/storehouse-storage.png
  [storehouse-passive-provider]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/storehouse/storehouse-passive-provider.png
  [storehouse-active-provider]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/storehouse/storehouse-active-provider.png
  [storehouse-requester]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/storehouse/storehouse-requester.png
  [storehouse-buffer]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/graphics/entity/storehouse/storehouse-buffer.png

  [hero-image]: https://raw.githubusercontent.com/Warehousing/Warehousing/master/hero-image.jpg

  [badge-crowdin]: https://d322cqt584bo4o.cloudfront.net/factorio-warehousing/localized.svg
  [badge-latest-release]: https://img.shields.io/github/release/Warehousing/Warehousing.svg?label=current+version
  [badge-release-date]: https://img.shields.io/github/release-date/Warehousing/Warehousing.svg?label=released
  [badge-factorio-version]: https://img.shields.io/badge/dynamic/json.svg?label=supports%20factorio%20version&url=https%3A%2F%2Fmods.factorio.com%2Fapi%2Fmods%2FWarehousing&query=%24.releases%5B-1%3A%5D.info_json.factorio_version&colorB=%23a87723

  [crowdin-project]: https://crowdin.com/project/factorio-warehousing
  [forum-thread]: https://forums.factorio.com/17295
  [github-latest-release]: https://github.com/Warehousing/Warehousing/releases/latest
  [issue-tracker]: https://github.com/Warehousing/Warehousing/issues
  [mod-portal-entry]: https://mods.factorio.com/mod/Warehousing
