--[[ Copyright (c) 2017 David-John Miller AKA Anoyomouse
 * Part of the Warehousing mod
 * extended by dgw 2021
 * ported to 2.0 by anoyomouse 2024
 *
 * See License.txt in the project directory for license information.
--]]

ICONPATH = "__Warehousing__/graphics/icons/"
local item_sounds = require("__base__.prototypes.item_sounds")

data:extend({
	{
		type = "item",
		name = "warehouse-basic",
		icon = ICONPATH.."warehouse-basic.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "storage",
		order = "a[items]-c[warehouse]",
		place_result = "warehouse-basic",
		stack_size = 15,
	},
	{
		type = "item",
		name = "warehouse-passive-provider",
		icon = ICONPATH.."warehouse-passive-provider.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "logistic-network",
		order = "b[storage]-c[passive-provider-chest]-b[warehouse]",
		place_result = "warehouse-passive-provider",
		stack_size = 15,
	},
	{
		type = "item",
		name = "warehouse-storage",
		icon = ICONPATH.."warehouse-storage.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "logistic-network",
		order = "b[storage]-c[storage-chest]-b[warehouse]",
		place_result = "warehouse-storage",
		stack_size = 15,
	},
	{
		type = "item",
		name = "warehouse-active-provider",
		icon = ICONPATH.."warehouse-active-provider.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "logistic-network",
		order = "b[storage]-c[active-provider-chest]-b[warehouse]",
		place_result = "warehouse-active-provider",
		stack_size = 15,
	},
	{
		type = "item",
		name = "warehouse-requester",
		icon = ICONPATH.."warehouse-requester.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "logistic-network",
		order = "b[storage]-e[requester-chest]-b[warehouse]",
		place_result = "warehouse-requester",
		stack_size = 15,
	},
	{
		type = "item",
		name = "warehouse-buffer",
		icon = ICONPATH.."warehouse-buffer.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "logistic-network",
		order = "b[storage]-d[buffer-chest]-b[warehouse]",
		place_result = "warehouse-buffer",
		stack_size = 15,
	},
	{
		type = "item",
		name = "storehouse-basic",
		icon = ICONPATH.."storehouse-basic.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "storage",
		order = "a[items]-c[storehouse]",
		place_result = "storehouse-basic",
		stack_size = 15,
	},
	{
		type = "item",
		name = "storehouse-passive-provider",
		icon = ICONPATH.."storehouse-passive-provider.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "logistic-network",
		order = "b[storage]-c[passive-provider-chest]-a[storehouse]",
		place_result = "storehouse-passive-provider",
		stack_size = 15,
	},
	{
		type = "item",
		name = "storehouse-storage",
		icon = ICONPATH.."storehouse-storage.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "logistic-network",
		order = "b[storage]-c[storage-chest]-a[storehouse]",
		place_result = "storehouse-storage",
		stack_size = 15,
	},
	{
		type = "item",
		name = "storehouse-active-provider",
		icon = ICONPATH.."storehouse-active-provider.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "logistic-network",
		order = "b[storage]-c[active-provider-chest]-a[storehouse]",
		place_result = "storehouse-active-provider",
		stack_size = 15,
	},
	{
		type = "item",
		name = "storehouse-requester",
		icon = ICONPATH.."storehouse-requester.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "logistic-network",
		order = "b[storage]-e[requester-chest]-a[storehouse]",
		place_result = "storehouse-requester",
		stack_size = 15,
	},
	{
		type = "item",
		name = "storehouse-buffer",
		icon = ICONPATH.."storehouse-buffer.png",
		icon_size = 64,
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		subgroup = "logistic-network",
		order = "b[storage]-d[buffer-chest]-a[storehouse]",
		place_result = "storehouse-buffer",
		stack_size = 15,
	},

	-- no recipes; only for editor
	{
		type = "item",
		name = "linked-storehouse",
		icon = ICONPATH.."storehouse-linked.png",
		icon_size = 64,
		hidden = true,
		subgroup = "other",
		order = "a[items]-a[linked-chest]-a[linked-storehouse]",
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		place_result = "linked-storehouse",
		stack_size = 15,
	},
	{
		type = "item",
		name = "linked-warehouse",
		icon = ICONPATH.."warehouse-linked.png",
		icon_size = 64,
		hidden = true,
		subgroup = "other",
		order = "a[items]-a[linked-chest]-b[linked-warehouse]",
		inventory_move_sound = item_sounds.metal_chest_inventory_move,
		pick_sound = item_sounds.metal_chest_inventory_pickup,
		drop_sound = item_sounds.metal_chest_inventory_move,
		place_result = "linked-warehouse",
		stack_size = 15,
	},
})
