local locomotive = util.table.deepcopy(data.raw.locomotive["locomotive"])
locomotive.name = "deg-electric-locomotive"
locomotive.minable.result = "deg-electric-locomotive"
locomotive.weight = 1200
-- locomotive.max_speed = 1.5
locomotive.max_power = "1MW"
locomotive.reversing_power_modifier = 1.0
locomotive.energy_source.fuel_categories = {"electrical"}
locomotive.energy_source.fuel_inventory_size = 1
locomotive.energy_source.burnt_inventory_size = 1
locomotive.energy_source.smoke = nil
locomotive.color = {r = 0, g = 0.33, b = 0.92, a = 0.5}
locomotive.stop_trigger = {
  {
    type = "play-sound",
    sound =
    {
      {
        filename = "__base__/sound/train-breaks.ogg",
        volume = 0.3
      }
    }
  }
}

-- importing the accumulator entity prototype to save having to include all the extra functions for graphics
local battery_charging_station = util.table.deepcopy(data.raw["accumulator"]["accumulator"])
-- general changes
battery_charging_station.type = "furnace"
battery_charging_station.name = "deg-battery-charging-station"
battery_charging_station.minable.result = "deg-battery-charging-station"
-- battery_charging_station.fixed_quality = "normal" -- not sure if this is the right use of this
-- graphics
battery_charging_station.graphics_set = {
    animation = battery_charging_station.chargable_graphics.picture,
    working_visualisations = {{
        constant_speed = true,
        animation = {
            filename = "__base__/graphics/entity/accumulator/accumulator-charge.png",
            priority = "high",
            width = 178,
            height = 210,
            line_length = 6,
            frame_count = 24,
            draw_as_glow = true,
            shift = util.by_pixel(0, -22),
            scale = 0.5
        }
    }}
}

-- crafting
battery_charging_station.fixed_recipe = "deg-battery-pack-recharge"
battery_charging_station.energy_usage = "10MW"
battery_charging_station.crafting_speed = 1
battery_charging_station.crafting_categories = {"deg-et-electrical"}
battery_charging_station.energy_source = {
  type = "electric",
  buffer_capacity = "20MJ",
  usage_priority = "secondary-input",
  input_flow_limit = "10MW",
  output_flow_limit = "0kW",
  drain = "500W"
}
battery_charging_station.source_inventory_size = 1
battery_charging_station.result_inventory_size = 1
battery_charging_station.cant_insert_at_source_message_key = "deg_inventory_restriction.cant_be_smelted"
battery_charging_station.circuit_connector = {
    circuit_connector_definitions["accumulator"],
    circuit_connector_definitions["accumulator"],
    circuit_connector_definitions["accumulator"],
    circuit_connector_definitions["accumulator"]
}
--[[battery_charging_station.circuit_connector = circuit_connector_definitions.create_vector(
  universal_connector_template,
  { variation = 26, main_offset = util.by_pixel(18.5, 19), shadow_offset = util.by_pixel(20.5, 25.5), show_shadow = true },
  { variation = 26, main_offset = util.by_pixel(18.5, 19), shadow_offset = util.by_pixel(20.5, 25.5), show_shadow = true },
  { variation = 26, main_offset = util.by_pixel(18.5, 19), shadow_offset = util.by_pixel(20.5, 25.5), show_shadow = true },
  { variation = 26, main_offset = util.by_pixel(18.5, 19), shadow_offset = util.by_pixel(20.5, 25.5), show_shadow = true }
)--]]

-- fix for Space Exploration to allow charging stations to be built in space
battery_charging_station.se_allow_in_space = true

data:extend(
{
  locomotive,
  
  {
    type = "electric-energy-interface",
    name = "deg-locomotive-charging-dummy",
    icon = "__ElectricTrains__/graphics/icons/electric-locomotive.png",
    icon_size = 32, --icon_mipmaps = 4,
    flags = {"placeable-neutral", "not-blueprintable", "not-on-map", "not-deconstructable"},
    corpse = "small-remnants",
    selection_box = {{-0.25, -0.25}, {0.25, 0.25}},
    energy_source =
    {
      type = "electric",
      buffer_capacity = "250MJ",
      usage_priority = "primary-input",
      input_flow_limit = "25MW",
      output_flow_limit = "0kW"
    },
    charge_cooldown = 45,
    discharge_cooldown = 30,
  },
  
  battery_charging_station
})
