local mul = settings.startup["advanced-electric-multiplier-advanced-accumulator"].value
local tier = settings.startup["advanced-electric-enabled-tiers"].value

function advanced_accumulator_picture(tint, repeat_count)
  return
  {
    layers =
    {
      {
        filename = "__Advanced-Electric-Revamped-v16__/graphics/entity/advanced-accumulator/hr-accumulator.png",
        priority = "high",
        width = 130,
        height = 189,
        repeat_count = repeat_count,
        shift = util.by_pixel(0, -11),
        tint = tint,
        scale = 0.5
      },
      {
        filename = "__base__/graphics/entity/accumulator/accumulator-shadow.png",
        priority = "high",
        width = 234,
        height = 106,
        repeat_count = repeat_count,
        shift = util.by_pixel(29, 6),
        draw_as_shadow = true,
        scale = 0.5
      }
    }
  }
end

local orig_accu = data.raw["accumulator"]["accumulator"]

local advanced_accumulator = util.table.deepcopy(orig_accu)
advanced_accumulator.name = "advanced-accumulator"
advanced_accumulator.icon = "__Advanced-Electric-Revamped-v16__/graphics/icons/advanced-accumulator.png"
advanced_accumulator.icon_size = 64;
advanced_accumulator.icon_mipmaps = 4
advanced_accumulator.minable.result =  "advanced-accumulator"
advanced_accumulator.max_health = 250
advanced_accumulator.energy_source = {
  type = "electric",
  buffer_capacity =  numberstringmultiplicator(orig_accu["energy_source"]["buffer_capacity"], mul),
  usage_priority = "tertiary",
  input_flow_limit = numberstringmultiplicator(orig_accu["energy_source"]["input_flow_limit"], mul),
  output_flow_limit = numberstringmultiplicator(orig_accu["energy_source"]["output_flow_limit"], mul)
}
advanced_accumulator.chargable_graphics = {
	picture = advanced_accumulator_picture(),
	charge_animation = advanced_electric_accumulator_charge(advanced_accumulator_picture),
	charge_cooldown = 30,
	charge_light = {intensity = 0.7, size = 7, color = {r = 0.15, g = 0.27, b = 0.12}},
	discharge_animation = advanced_electric_accumulator_discharge(advanced_accumulator_picture),
	discharge_cooldown = 60,
	discharge_light = {intensity = 0.7, size = 7, color = {r = 0.15, g = 0.27, b = 0.12}},
}
advanced_accumulator.fast_replaceable_group = "accumulator"
if tier == "elite" or tier == "ultimate" then
	advanced_accumulator.next_upgrade = "elite-accumulator"
end
data:extend({advanced_accumulator})
