$(document).ready(function(){
    var prevSlide = 0;
    var gamePadClick = false;
    var idleTimeout;
    var inTransition = false;
    var transitionTimeout;

    var hoverSound = new Audio('sounds/LauncherHover.ogg');
    hoverSound.volume = 0.2;
    var openSound = new Audio('sounds/LauncherSingleOpen.ogg');
    var doubleOpenSound = new Audio('sounds/LauncherDoubleFoldOpen.ogg');
    var downloadEndSound = new Audio('sounds/LauncherUpdateSuccess.ogg');
    downloadEndSound.volume = 0.25;

    function playHoverSound(){ hoverSound.currentTime = 0; hoverSound.play(); }

    function setVolumes(){      
        openSound.volume = 0.75;
        doubleOpenSound.volume = 0.75;
    }

    function muteVolumes(){
        openSound.volume = 0;
        doubleOpenSound.volume = 0;
    }

    var startTime = Date.now();
    var elapsedTime = 0;
    var interval = setInterval(function() {
        elapsedTime = Date.now() - startTime;
    }, 100);
    var lang = 'en';
    var urlLang = getParameterByName('language');
    if (urlLang != '' && urlLang != lang) {
        lang = urlLang;
    }

    $('.navButtons li').hover(
        function(){
            $(this).find('svg').attr('class','hover');
            $(this).find('p').addClass('orange');
            playHoverSound();
        }, function(){
            if(!$(this).find('.tabImg').hasClass('active')){
                $(this).find('svg').attr('class','');
                $(this).find('p').removeClass('orange');
            }
        }
        );

    $('.navButtons .buildnotes,.navButtons .primeaccess,.navButtons .whatsnew').click(function(e){
        if(!inTransition){
            inTransition = true;
            clearTimeout(transitionTimeout);
            transitionTimeout = setTimeout(function(){
                inTransition = false;
            },605);
            $('.navButtons li').removeClass('active');
            $(this).addClass('active');
            var targetDiv = $('#'+$(this).attr('data-linkto'));
            if(!targetDiv.hasClass('active')){
                $('.navButtons .buildnotes,.navButtons .primeaccess,.navButtons .whatsnew').find('.tabImg').removeClass('active');
                $(this).find('.tabImg').addClass('active');
                $('.navButtons .buildnotes,.navButtons .primeaccess,.navButtons .whatsnew').not(this).each(function(){
                    $(this).find('svg').attr('class','');
                    $(this).find('p').removeClass('orange');
                });

                $('section#primeaccess, section#whatsnew, section#buildnotes').each(function(){
                    var that = $(this);
                    if(that.hasClass('active')){
                        that.css('z-index',3);
                        setTimeout(function(){
                            that.removeClass('active');
                            that.hide();
                            if(that.find('video').length){
                                that.find('video')[0].pause();
                            }
                            gamePadClick = false;
                        },605);
                        return false;
                    }
                });
                
                targetDiv.show();
                targetDiv.css('z-index',4);
                targetDiv.addClass('active').removeClass('inactive');
                if(targetDiv.find('video')[0]){
                    targetDiv.find('video')[0].play();
                }

                if(!$('#firstLoadHotspot').is(':visible')){
                    setTimeout(function(){
                        $('#firstLoad').find('video')[0].pause();
                        $('#firstLoadHotspot').fadeIn();
                        gamePadClick = false;
                    },300);
                }

                if($(this).hasClass('whatsnew')){                
                    prevSlide = 0;
                    if($('#whatsnewSlides').hasClass('totalSlides4')){
                        $('#firstLoadHotspot').addClass('fourSlides');
                    }
                } else {
                    setTimeout(function(){
                        $('#whatsnewSlides .whatsnewslide .slideImage').removeClass('anim').show();
                        $('#whatsnewSlides .whatsnewslide,.slideTitle').addClass('init').removeClass('open active0 active1 active2 active3 active4 from0 from1 from2 from3 from4 closed');
                    },605);
                }
                $('#whatsnewSlides .whatsnewslide .behindOverlay').hide();
                doubleOpenSound.currentTime = 0;
                doubleOpenSound.play();
                
            }
        }
    });

    $('#firstLoadHotspot').click(function(e){
        if($(this).is(':visible')){
            openSound.currentTime = 0;
            openSound.play();
            // setTimeout(function(){
            //     startIdle();
            // },500);
            $('#firstLoad').removeClass('left').addClass('right');
            $('.navButtons .primeaccess,.navButtons .whatsnew,.navButtons .buildnotes').find('.tabImg').removeClass('active');
            
            $('#firstLoad').find('video')[0].play();
            setTimeout(function(){
                $('#whatsnewSlides .whatsnewslide,#whatsnewSlides .slideTitle').addClass('init').removeClass('open active0 active1 active2 active3 from0 from1 from2 from3 closed');
                $('#whatsnewSlides .whatsnewslide .behindOverlay').hide();
                $('#whatsnewSlides .whatsnewslide .slideImage').removeClass('anim').removeAttr('style');
            },1000);

            $('.navButtons svg').attr('class','');
            $('.navButtons li p').removeClass('orange');

            $('section#primeaccess.active, section#whatsnew.active, section#buildnotes.active').removeClass('active').addClass('inactive').removeAttr('style');
            setTimeout(function(){
                $('section#primeaccess, section#whatsnew, section#buildnotes').removeClass('inactive');
            },1000);
            $(this).fadeOut(100);
            $('.navButtons li').removeClass('active');
        }
    }).hover(
    function(){
        playHoverSound();
    }, function(){
        
    }
    );
    
    $('#whatsnewSlides .whatsnewslide').click(function(e){
        var textFadeSpeed = 800;
        if(!$(this).hasClass('open')){
            openSound.currentTime = 0;
            openSound.play();
            if($(this).hasClass('init')){
                $('#whatsnewSlides .whatsnewslide,.slideTitle').removeClass('init');
            }
            var num = $(this).attr('data-slideNum');
            $('#whatsnewSlides .whatsnewslide,.slideTitle').removeClass('open active0 active1 active2 active3 active4 from0 from1 from2 from3 from4 closed');
            $(this).addClass('open');
            $('#whatsnewSlides .whatsnewslide .slideImage').removeClass('anim').hide();
            $(this).find('.behindOverlay').fadeIn(500);
            $('#whatsnewSlides .whatsnewslide,.slideTitle').addClass('active'+num+' from'+prevSlide);
            $('#whatsnewSlides .whatsnewslide').not(this).addClass('closed');
            $('#whatsnewSlides .whatsnewslide').not(this).find('.behindOverlay').fadeOut(500);
            prevSlide = num;
            setTimeout(function(){
                gamePadClick = false;
                $('#whatsnewSlides .whatsnewslide.open .slideImage').show();
                // $('#whatsnewSlides .whatsnewslide.open .slideImage').addClass('anim');
            },600);

            setTimeout(function(){
                $('#whatsnewSlides .whatsnewslide.open .slideImage').addClass('anim');
            },650);
            // $('#whatsnewSlides .whatsnewslide.open .slideImage').show().addClass('anim');

        }
    }).hover(
    function(){
        playHoverSound();
    }, function(){
        
    }
    );

    //if(getParameterByName('steam')){
    //    $('#twitchLink').remove();
    //}

    $('#primeaccess #paLink').click(function (e) {
        var langLink = getSiteLanguageLink($('body').attr('data-lang'));
        let params = new URLSearchParams('utm_medium=launcher&utm_source=prime_access&utm_campaign=caliban_prime');
        if(getParameterByName('steam')){
            params.append('steam',1);
        }
        var location = 'https://www.warframe.com' + langLink + '/prime-access?'+params.toString();
        window.open(location, "_blank");
    });

    $('#whatsnewSlides #RhinoHeirloom').click(function (e) {
        var langLink = getSiteLanguageLink($('body').attr('data-lang'));
        let params = new URLSearchParams('utm_medium=launcher&utm_source=whats_new');
        if(getParameterByName('steam')){
            params.append('steam',1);
        }
        var location = 'https://www.warframe.com' + langLink + '/heirloom/rhino?'+params.toString();
        window.open(location, "_blank");
    });
    $('#whatsnewSlides #JadeChorus').click(function (e) {
        var langLink = getSiteLanguageLink($('body').attr('data-lang'));
        let params = new URLSearchParams('utm_medium=launcher&utm_source=whats_new');
        if(getParameterByName('steam')){
            params.append('steam',1);
        }
        var location = 'https://www.warframe.com' + langLink + '/supporter-packs/jade-shadows?'+params.toString();
        window.open(location, "_blank");
    });
    // $('#whatsnewSlides #Tennocon2024').click(function (e) {
    //     var langLink = getSiteLanguageLink($('body').attr('data-lang'));
    //     let params = new URLSearchParams('utm_medium=launcher&utm_source=whats_new&utm_campaign=tennocon2024');
    //     if(getParameterByName('steam')){
    //         params.append('steam',1);
    //     }
    //     var location = 'https://www.warframe.com' + langLink + '/tennocon?'+params.toString();
    //     window.open(location, "_blank");
    // });
    // $('#whatsnewSlides #tcDigitalPack').click(function (e) {
    //     var langLink = getSiteLanguageLink($('body').attr('data-lang'));
    //     let params = new URLSearchParams('utm_medium=launcher&utm_source=whats_new&utm_campaign=tennocon_2023');
    //     if(getParameterByName('steam')){
    //         params.append('steam',1);
    //     }
    //     var location = 'https://www.warframe.com' + langLink + '/tennocon?'+params.toString()+'#ticketsorpacks';
    //     window.open(location, "_blank");
    // });
    //
    /*
    $('#whatsnewSlides #tcMerchPack').click(function (e) {
        let params = new URLSearchParams('utm_medium=launcher&utm_source=whats_new&utm_campaign=2023-07-Merch-Tennocon-MerchPack');
        if(getParameterByName('steam')){
            params.append('steam',1);
        }
        var location = 'https://store.warframe.com/products/tennocon-2023-merch-pack?'+params.toString();
        window.open(location, "_blank");
    });
    */

    $('#whatsnewSlides #starterPack').click(function (e) {
        var langLink = getSiteLanguageLink($('body').attr('data-lang'));
        let params = new URLSearchParams('utm_medium=launcher&utm_source=starter_weapon_pack');
        if(getParameterByName('steam')){
            params.append('steam',1);
        }
        var location = 'https://www.warframe.com' + langLink + '/starter-weapon-pack?'+params.toString();
        window.open(location, "_blank");
    });

    // hide timed button until the right time
    // Thursday, June 9, 2022 6:00:00 PM GMT
    // Thursday, June 9, 2022 2:00:00 PM EDT
    /*
    if (Date.now() < 1654797600000) {
        $('.timedbutton').addClass('is-disabled');
        $('.timedbutton .whatsnewbutton').attr('href', null);
    }
    */

    function getParameterByName(name) {
        name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
                results = regex.exec(location.search);
        return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
    }

    function getSiteLanguageLink(lang) {
        var langSiteLinks = [];
        langSiteLinks['en'] = '';
        langSiteLinks['de'] = '/de';
        langSiteLinks['ru'] = '/ru';
        langSiteLinks['fr'] = '/fr';
        langSiteLinks['es'] = '/es';
        langSiteLinks['ja'] = '/ja';
        langSiteLinks['pt'] = '/pt-br';
        langSiteLinks['tr'] = '/tr';
        langSiteLinks['pl'] = '/pl';
        langSiteLinks['zh'] = '/zh-hans';
        langSiteLinks['tc'] = '/zh-hant';
        langSiteLinks['ko'] = '/ko';
        langSiteLinks['it'] = '/it';
        langSiteLinks['th'] = '/th';

        if(langSiteLinks.hasOwnProperty(lang)) {
            return langSiteLinks[lang];
        }
        return langSiteLinks['en']
    }

    // called from C++
    var mainButtonEnabled = false;
    setMainButtonState = function (enable) {
        let buttTarget = $('body.mainIndex #playNow, body.mainIndex #mainbutton, body.intro #playNow, body.agreeBody #mainbutton');
        if (enable == 'true') {
            mainButtonEnabled = true;
            buttTarget.css('opacity', '1');
        }
        else if (enable == 'false') {
            mainButtonEnabled = false;
            buttTarget.css('opacity', '0.4');
        }
    };

    // call out to C++
    $('body.mainIndex #playNow, body.agreeBody #mainbutton, body.intro #playNow').click(function (e) {
        if (mainButtonEnabled === true) {
            sendMessage('PlayNow');
        }
    }).hover(
    function () {
        if (mainButtonEnabled === true) {
            playHoverSound();
        }
    }, function () {}
    );
    
    // called from C++
    var altButtonEnabled = false;
    setAltButtonState = function (enable) {
        if (enable == 'true') {
            altButtonEnabled = true;
            $('#altbutton').css('display', 'inline');
        }
        else if (enable == 'false') {
            altButtonEnabled = false;
            $('#altbutton').css('display', 'none');
        }
    };

    // call out to C++
    $('#altbutton').click(function (e) {
        if (altButtonEnabled === true) {
            sendMessage('Cancel');
        }
    }).hover(
    function () {
        if (altButtonEnabled === true) {
            playHoverSound();
        }
    }, function () {
    }
    );



    var indicatorVal;
    var indicatorStartPos = 24;
    var barWidth = 400;
    var progressWatcher = setInterval(function(){
        if($('progress').attr('value') > 0 && $('progress').attr('value') <= 100 && $('progress').attr('value') != indicatorVal)
        {
            indicatorVal = $('progress').attr('value');
            $('.launcherSprites-progressIndicator').show().html(Math.round(indicatorVal) + '%');

            var pos = parseInt(indicatorStartPos) + Math.round(barWidth * ((indicatorVal) / 100));

            $('.launcherSprites-progressIndicator').css({left:pos+'px'});
            
        }
        else if($('progress').css('visibility') == 'hidden') {
            $('.launcherSprites-progressIndicator').hide();
            // this may come up again ... ? clearInterval(progressWatcher)
        }
    },16);

    playDownloadEndSound = function () {
        downloadEndSound.play();
    }

    function tabLeft(){
        if($('.navButtons li.active').length === 0 || $('.navButtons li').first().hasClass('active')){
            //on home screen/last tab, default to last tab
            $('.navButtons li').last().click();
        } else {
            $('.navButtons li.active').prev().click();
        }
    }

    function firstTab(){
        $('.navButtons li').first().click().find('svg').attr('class','hover');
    }

    function tabRight(){
        if($('.navButtons li.active').length === 0 || $('.navButtons li').last().hasClass('active')){
            //on home screen/last tab, default to first tab
            $('.navButtons li').first().click().find('svg').attr('class','hover');
        } else {
            $('.navButtons li.active').next().click().find('svg').attr('class','hover');
        }
    }

    function whatsNewLeft(){
        if($('#whatsnewSlides .whatsnewslide.open').length === 0 || $('#whatsnewSlides .whatsnewslide').first().hasClass('open')){
            $('#whatsnewSlides .whatsnewslide').last().click();
        } else {
            $('#whatsnewSlides .whatsnewslide.open').prev().click();
        }
    }

    function whatsNewRight(){
        if($('#whatsnewSlides .whatsnewslide.open').length === 0 || $('#whatsnewSlides .whatsnewslide').last().hasClass('open')){
            $('#whatsnewSlides .whatsnewslide').first().click();
        } else {
            $('#whatsnewSlides .whatsnewslide.open').next().click();
        }
    }

    var autoplaying = true;
    function startIdle(){
        //only gets called on init load and going back to home screen
        muteVolumes()
        idleTimeout = setInterval(function(){
            autoPlay();
        },10000);
    }

    function autoPlay(){
        if($('#primeaccess').hasClass('active') || !$('#whatsnew').hasClass('active') || ($('#whatsnew').hasClass('active') && $('#whatsnew .slide'+$('.whatsnewslide').length).hasClass('open'))){
            if($('#primeaccess').hasClass('active')){
                firstTab();
            } else {
                tabRight();
            }
            
            setTimeout(function(){
                if($('#whatsnew').hasClass('active')){
                    whatsNewRight();
                }
            },2000);
        } else if($('#whatsnew').hasClass('active')){
            whatsNewRight();
        }
    }

    $('body').mousedown(function(){
        if(autoplaying){
            //clicking anywhere will stop the idle phase
            clearInterval(idleTimeout);
            setVolumes();
            autoplaying = false;
        }
    });

    startIdle();
    
    var gamepadCheck = setInterval(function(){
        if(typeof navigator.getGamepads()[0] !== 'undefined' && navigator.getGamepads()[0] !== null){
            var bumperL = navigator.getGamepads()[0].buttons[4];
            var bumperR = navigator.getGamepads()[0].buttons[5];
            var triggerL = navigator.getGamepads()[0].buttons[6];
            var triggerR = navigator.getGamepads()[0].buttons[7];
            var backBtn = navigator.getGamepads()[0].buttons[8];
            var startBtn = navigator.getGamepads()[0].buttons[9];

            if(!gamePadClick){
                if(bumperL.pressed){
                    gamePadClick = true;
                    tabLeft();
                }

                if(bumperR.pressed){
                    gamePadClick = true;
                    tabRight();
                }

                if($('#whatsnew').hasClass('active')){
                    if(triggerL.pressed){
                        gamePadClick = true;
                        whatsNewLeft();
                    }
                    if(triggerR.pressed){
                        gamePadClick = true;
                        whatsNewRight();
                    }
                }

                if(backBtn.pressed){
                    if($('#whatsnew').hasClass('active') || $('#buildnotes').hasClass('active') || $('#primeaccess').hasClass('active')){
                        $('#firstLoadHotspot').click();
                    }
                    //also throw in exit launcher event here?
                }

                if(startBtn.pressed){
                    $('#playNow,#mainbutton').click();
                }
            }
        }
    },16);

    // Send a query to the browser process.
    function sendMessage(msg) {
        // Results in a call to the OnQuery method in binding_test.cpp
        window.cefQuery({
            request: 'Binding:' + msg,
            onSuccess: function (response) {
                //document.getElementById('result').value = 'Response: ' + response;
            },
            onFailure: function (error_code, error_message) { }
        });
    }

    function getParameterByName(name) {
        name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
        results = regex.exec(location.search);
        return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
    }
    
    //Simulate Progress moving
    // setInterval(function(){
    //     if($('progress').attr('value') == 100){
    //         $('progress').attr('value',0);
    //     }
    //     $('progress').attr('value',parseInt($('progress').attr('value'))+10);
    // },400);
});
