$(document).ready(function () {

    var lang = 'en';
    var urlLang = getParameterByName('language');
    if (urlLang != '' && urlLang != lang) {
        lang = urlLang;
    }

    $('body').addClass('lang-' + lang);
    $('body').attr('data-lang', lang);

    var langArray = {
        '#firstLoad #logoText': {
            "de": "Koumei & die Fünf Schicksale",
            "ru": "Комея и Пять Судеб",
            "fr": "Koumei & les Cinq Augures",
            "es": "Koumei & los Cinco Destinos",
            "ja": "Koumeiと五つの定め",
            "pt": "Os Cinco Destinos de Koumei",
            "tr": "Koumei & the Five Fates",
            "pl": "Koumei i Pięć Losów",
            "ko": "코우메이와 다섯 개의 운명",
            "it": "Koumei & i Cinque Destini",
            "zh": "《Koumei 与五运》",
            "tc": "《Koumei & The Five Fate》",
            "uk": "Кумей та П’ять Доль",
            "th": "Koumei & the Five Fates"
        },
        '#buyPA span': {
            'de': "Jetzt kaufen",
            'ru': "Купить сейчас",
            'fr': "Achetez Maintenant",
            'es': "Comprar ahora",
            'ja': "今すぐ購入",
            'pt': "Compre agora",
            'tr': "Hemen Satın Al",
            'pl': "Kup Teraz",
            'zh': "立即购买",
            'tc': "立即購買",
            'ko': "지금 구매하세요",
            'it': "Acquista Ora",
            'th': "ซื้อเลย",
            'uk': "Придбати зараз"
        },
        '.storyOneCopy h1': {
            'de': "Die Tenno",
            'ru': "Тэнно",
            'fr': "Les Tennos",
            'es': "Los Tenno",
            'ja': "テンノ",
            'pt': "Os Tennos",
            'tr': "Tenno",
            'pl': "Tenno",
            'zh': "Tenno",
            'tc': "Tenno",
            'ko': "텐노",
            'it': "I Tenno",
            'th': "Tenno",
            'uk': "Тенно",
        },
        '.storyOneCopy p': {
            'de': "Sie wurden Tenno genannt. Krieger von Klinge und Gewehr: Meister der Warframe Rüstung. Jene, die den Alten Krieg überlebt haben, wurden treibend in den Ruinen zurückgelassen. Nun werden sie erneut gebraucht.",
            'ru': "Когда-то их называли Тэнно. Те из них, кто пережил Старую Войну, остались скитаться среди руин. Воины клинка и пистолета, мастера Варфреймов. Теперь они снова нужны Системе.",
            'fr': "Ils s'appelaient Tennos. Guerriers maniant armes et lames, maîtres de l'armure Warframe. Ceux qui ont survécu à l'Ancienne Guerre ont été abandonnés parmi les ruines. Maintenant, le Système a une fois de plus besoin d'eux.",
            'es': "Fueron llamados tenno. Guerreros de espada y arma de fuego: maestros de la armadura warframe. Sobrevivientes de la Antigua Guerra que quedaron a la deriva entre las ruinas. Ahora se les necesita una vez más.",
            'ja': "彼らはかつてテンノと呼ばれていた。外骨格装甲「WARFRAME」を駆る伝説の戦士たち...　古の大戦を生き残った者たちは深き眠りにつき、荒廃した世界をさまよっていました。そして今、再び彼らの力が必要とされているのです。",
            'pt': "Eram chamados de Tennos, guerreiros da lâmina e da arma: os mestres da armadura Warframe. Os que sobreviveram à Guerra Ancestral e foram deixados à deriva entre as ruínas. Agora, são requisitados mais uma vez.",
            'tr': "Onlara Tenno denir. Bıçak ve silahın savaşçıları: Warframe zırhının ustaları. Eski Savaştan sağ kurtulanlar harabeler arasında başı boş bırakıldı. Şimdi ise onlara bir kez daha ihtiyaç var.",
            'pl': "Nazywali ich Tenno. Wojownicy miecza i broni palnej - mistrzowie Warframe'ów. Ci, którzy przetrwali Starą Wojnę, dryfowali wśród ruin. Teraz znów są potrzebni.",
            'zh': "他们被称为 Tenno ，驾驭名为战甲的超级装甲，身负枪与剑的战士。这些从远古之战中生还的战士正在废墟中漂流。现在他们再次被召唤。",
            'tc': "他們被稱為 Tenno。槍劍戰士：Warframe 盔甲的大師。那些從遠古戰爭中倖存下來的戰士被遺下在廢墟中漂流。 現在他們再次被傳召。",
            'ko': "검과 총의 전사들이자, 워프레임 갑옷을 통달한 그들을 텐노라 일컬었으니. 고대의 전쟁에서 살아남은 텐노들은 폐허와 함께 버려져 우주를 떠돌고 있었다. 이제 세상은 그들을 다시 필요로 한다.",
            'it': "Furono chiamati Tenno. Guerrieri di lama e fucile: maestri dell'armatura Warframe. Coloro che sopravvissero alla Vecchia Guerra furono abbandonati tra le rovine. Ora, sono nuovamente necessari.",
            'th': "พวกเขาถูกเรียกว่า Tenno นักรบแห่งดาบและปืน: ผู้เชี่ยวชาญในเกราะ Warframe ผู้รอดชีวิตจากสงครามครั้งเก่าที่ถูกทิ้งให้ล่องลอยอยู่ท่ามกลางซากปรักหักพัง ตอนนี้พวกเขาเป็นที่ต้องการอีกครั้ง",
            'uk': "І було їм імʼя тенно. Незрівнянні майстри стрілецької й холодної зброї, повелителі автономних обладунків — ворфреймів. Ті з них, хто вцілів під час Давньої війни, загубилися серед руїн. Та вони знову потрібні."
        },
        '.storyTwoCopy h1': {
            'de': "Kennt eure Feinde",
            'ru': "Знайте своих врагов",
            'fr': "Connaissez vos ennemis",
            'es': "Conoce a tus enemigos",
            'ja': "敵を知る",
            'pt': "Conheça seus Inimigos",
            'tr': "Düşmanlarını Tanı",
            'pl': "Poznaj swoich wrogów",
            'zh': "了解你的敌人",
            'tc': "瞭解你的敵人",
            'ko': "그대의 적을 인지하라",
            'it': "Conosci i Tuoi Nemici",
            'th': "รู้จักศัตรูของท่าน",
            'uk': "Знайте своїх ворогів"
        },
        '.storyTwoCopy p': {
            'de': "Die Grineer, mit ihren riesigen Armeen, breiten sich im Ursprungssystem aus. Ein Ruf hallt zwischen den Sternen und ruft die Tenno zu einem uralten Ort. Sie rufen euch.",
            'ru': "Империя Гринир благодаря своей бесчисленной армии распространяет своё влияние в Изначальной Системе. Древний зов эхом раздается среди звёзд, призывая всех Тэнно в древнее место. Им нужна ваша помощь.",
            'fr': "Les Grineers, avec leurs vastes armées, se répandent dans tout le Système Origine. Un appel résonne à travers les étoiles, invoquant les Tennos dans un lieu ancien. Ils vous convoquent.",
            'es': "Los grineer, con sus vastos ejércitos, se están extendiendo por todo el Sistema Origen. Una llamada resuena a través de las estrellas convocando a los tenno a un lugar antiguo. Convocándote a ti.",
            'ja': "強大な軍事力を有する「グリニア」帝国がOrigin太陽系全体をもその手中に収めようとしています。救いを求めるようにテンノの帰還を願う声が太陽系に響き渡っています。あなたを必要としているのです。",
            'pt': "Os Grineers, com seus vastos exércitos, se espalham por todo o Sistema de Origem. Um chamado ecoa através das estrelas, convocando os Tennos para um lugar ancestral. Eles convocam você.",
            'tr': "Grineer, devasa ordusunun gücüyle Origin Sistemine yayılıyor. Yıldızlar arasında yankılanan bir çağrı Tenno'yu eski bir yere çağırıyor. Seni çağırıyorlar.",
            'pl': "Grineer rozprzestrzeniają się w całym Systemie Origin wraz ze swoją ogromną armią. Pośród gwiazd rozbrzmiewa zew przyzywający Tenno. Przyzywający Ciebie.",
            'zh': "Grineer，与他们庞大的军队正在蔓延到整个始源星系。一个跨越星际的召唤正呼叫着 Tenno 前往一处古老之地。他们正在召唤你。",
            'tc': "Grineer ，與他們龐大的軍隊，正蔓延整個始源星系。 一個跨越星際的召喚呼叫著 Tenno 到一處古老之地。他們召喚你。",
            'ko': "그리니어 제국이 그들의 대군을 말미암아 그 세력을 근원계 전역으로 확장하고 있다. 그리고, 하나의 목소리가 별들의 바다 너머 고대의 유적에 잠든 한 텐노를 향해 메아리친다. 바로 당신을 부르는 소리다.",
            'it': "I Grineer, con i loro vasti eserciti, si stanno espandendo in tutto il Sistema Origin. Una chiamata riecheggia tra le stelle invocando i Tenno in un luogo antico. Invocano te.",
            'th': "พวก Grineer มีกองทัพแผ่ไพศาลกระจายไปทั่วระบบออริจิน มีเสียงเรียกดังก้องไปทั่วดวงดาวที่เรียก Tenno ไปยังสถานที่โบราณ พวกเขาเรียกท่าน",
            'uk': "Незліченні орди ґрінерів підминають під себе Материнську систему. Серед зірок лунає заклик до тенно, що веде їх до стародавнього місця. Цей заклик для вас."
        },
        '.storyThreeCopy h1': {
            'de': "Folgt der Lotus",
            'ru': "Следуйте за Лотос",
            'fr': "Suivez Le Lotus",
            'es': "Sigue a Lotus",
            'ja': "Lotusの導き",
            'pt': "Siga a Lótus",
            'tr': "Lotus'un İzinden Git",
            'pl': "Podążaj za Lotus",
            'zh': "追随 Lotus",
            'tc': "追隨 Lotus",
            'ko': "로터스를 따르라",
            'it': "Segui Lotus",
            'th': "ตามรอย Lotus",
            'uk': "Слідуйте за Лотос"
        },
        '.storyThreeCopy p': {
            'de': "Erlaubt der Lotus, euch zu führen. Sie hat euch aus der Kryostasis-Kammer gerettet und euch eine Chance zum Überleben gegeben. Die Grineer werden euch finden. Ihr müsst vorbereitet sein. Die Lotus wird euch den Weg der Warframes lehren und das Geheimnis, ihre Kräfte zu entfalten.",
            'ru': "Позвольте Лотос указывать путь. Она спасла вас от криосна и дала шанс на выживание. Рано или поздно, Гринир вас найдут, и вы должны быть к этому готовы. Лотос научит вас, как пользоваться варфреймами, чтобы открыть секреты их силы и уникальные способности.",
            'fr': "Laissez le Lotus vous guider. Elle vous a sauvé de votre cryostase et vous a donné une chance de survivre. Les Grineers vous trouveront ; vous devez être préparé. Le Lotus vous apprendra comment utiliser les Warframes et les secrets pour débloquer leurs pouvoirs.",
            'es': "Deja que Lotus te guíe. Ella te rescató de tu cámara de criostasis y te dio la oportunidad de sobrevivir. Los grineer te encontrarán; debes estar preparado. Lotus te enseñará cómo usar los warframes y los secretos para desbloquear sus poderes.",
            'ja': "Lotusが導くままに。彼女はあなたを冷凍ポッドから救出し生きるチャンスを与えてくれました。グリニアはあなたを諦めません、迫る戦いに備えるのです。LotusはWARFRAMEの使い方と彼らが持つ潜在能力を引き出すための知識を伝授します。",
            'pt': "Permita que a Lótus seja a sua guia. Ela o resgatou de sua câmara de sono criogênico, e permitiu que você sobrevivesse. Os Grineers o encontrarão, você precisa estar preparado. A Lótus lhe ensinará a arte dos Warframes e os segredos para desbloquear seus poderes.",
            'tr': "Lotus'un sana rehberlik etmesine izin ver. O, seni soğuk uykundan uyandırdı ve sana hayatta kalman için bir şans verdi. Ancak Grineer seni bulacak; hazırlıklı olmalısın. Lotus sana Warframe'leri ve onların güçlerini nasıl açığa çıkaracağının sırlarını öğretecek.",
            'pl': "Pozwól Lotus poprowadzić Cię. Uratowała Cię z Twojej komory kriostazy i dała szansę na przetrwanie. Grineer Cię znajdą, trzeba się przygotować. Lotus nauczy Cię tajemnic Warframe'ów i sposobów, do odblokowania ich pełnego potencjału.",
            'zh': "让 Lotus 引导你。她已把你从冷冻舱里救出来，并给了你一个活下去的机会。Grineer 会找到你；你必须做好准备。Lotus 会教你战甲的使用方法，以及解锁他们力量的秘诀。",
            'tc': "讓 Lotus 引領你。她已將你從低溫催眠室中拯救出來並給予了你一次生存的機會。 Grineer 會找到你；你必須做好準備。Lotus 會教你運用 Warframe 的各種方法以及解鎖他們力量的秘訣。",
            'ko': "로터스의 안내에 부응하라. 그녀는 당신을 동면 장치에서 구하고, 살아남을 기회를 주었다. 그리니어는 당신을 찾을 것이며, 이에 당신은 대비해야 한다. 로터스는 당신에게 워프레임의 방식과 그 힘을 개방할 수 있는 비밀을 알려줄 것이다.",
            'it': "Lascia che Lotus ti guidi. Ti ha salvato dalla criostasi e ti ha dato la possibilità di sopravvivere. I Grineer ti troveranno; devi essere pronto. Lotus ti insegnerà come utilizzare i Warframe e i segreti per sbloccare le loro abilità.",
            'th': "ให้ Lotus นำทางท่าน นางได้ช่วยชีวิตท่านจากห้องแช่แข็งและให้โอกาสท่านมีชีวิตรอด Grineer จะตามหาท่าน; ท่านต้องเตรียมพร้อม Lotus จะสอนถึงวิถีของ Warframe และเคล็ดลับในการปลดล็อกพลังของพวกมัน",
            'uk': "Дозвольте Лотос вести вас. Вона витягла вас із кріокапсули й дала можливість вижити. Ґрінери вас знайшли, тож приготуйтеся. Лотос навчить шляху тенно й розкриє таємниці ваших здібностей."
        },
        '#primeaccess .pa1': {
            'de': "Wenn ihr die besten und mächtigsten Bewaffnungen benötigt, dann müssen es Primes sein. Jeder Prime Warframe, jede Prime Waffe und andere Gegenstände sind in ihrer reinen Form und exquisit vergoldet - wie die Orokin es vorgesehen hatten.",
            'ru': "Когда вам требуется самое лучшее и мощное снаряжение, праймы — то, что вам нужно. Изысканно позолоченный, каждый прайм-варфрейм, оружие и любой другой прайм-предмет существуют в своей чистейшей форме — как и задумали Орокин.",
            'fr': "Si vous avez besoin des armements les plus performants et les plus raffinés, seuls l'équipement Prime peut vous satisfaire. Sublimement dorés, chaque Warframe, arme et objet Prime existe dans sa forme la plus pure, telle que les Orokins l'ont pensée.",
            'es': "Cuando necesitas los mejores y más poderosos armamentos, los Primes son la solución. Exquisitamente dorados, cada warframe, arma y componente Prime en su forma más pura, tal como los Orokin los concibieron.",
            'ja': "至高と究極を求める戦士のために揃えられた装備、それこそがプライム。精巧に黄金が輝き、すべてのプライムWARFRAMEや武器は、オロキンが望んだ純粋を体現する。",
            'pt': "Quando você precisa dos melhores e mais poderosos armamentos, os itens Prime são a solução. Em sua sublime forma áurea, cada Warframe, Arma e Componente Prime está em sua versão mais pura — exatamente como pretendiam os Orokin.",
            'tr': "En iyi ve en güçlü silahlara ihtiyaç duyduğunuzda, yalnızca Prime'lar işinize yarar. Zarifçe yaldızlanmış her Prime Warframe, Silah ve eşya en saf haliyle mevcuttur — tıpkı Orokin'in amaçladığı gibi.",
            'pl': "Gdy potrzebujesz najlepszej i najpotężniejszej broni, tylko przedmioty Prime będą odpowiednie. Każdy Warframe, broń i przedmiot Prime są kunsztownie pozłacane i w najczystszej postaci, tak jak stworzyli je Orokin.",
            'zh': "当你需要最精良且强大的武器时，只有 Prime 版本物品才能满足你的需求。每个 Prime 战甲、武器和物品都经过精美镀金，以最纯粹的形式存在，正如 Orokin 所希望的那样。",
            'tc': "當你需要最精良最強大的武器時，只有 Prime 級物品才可以滿足你的要求。每個 Prime Warframe，武器和物品都經過精美鍍金，以最純粹的形式存在 — 正如 Orokin 所期望的那樣。",
            'ko': "가장 훌륭하고 강력한 무기가 필요하다면, 프라임이 정답입니다. 황금색으로 도금된 모든 프라임 워프레임, 무기 및 아이템들은 오로킨이 의도한 대로 가장 순수한 형태로 존재합니다.",
            'it': "Quando hai bisogno degli armamenti più raffinati e potenti, i Prime sono la soluzione. Finemente dorati, ogni Warframe, Arma e oggetto Prime esiste nella sua forma più pura - proprio come volevano gli Orokin.",
            'th': "เมื่อคุณต้องการอาวุธที่ดีที่สุดและทรงพลังที่สุด มีเพียง Prime เท่านั้นที่จะให้คุณได้ เพราะ Warframe อาวุธ และไอเทมระดับ Prime ทุกชิ้นจะได้รับการตกแต่งปิดทองอย่างประณีตงดงาม และอยู่ในรูปแบบที่บริสุทธิ์ที่สุด เหมือนกับที่ Orokin ตั้งใจไว้",
            'uk': "Якщо вам потрібне найліпше та найпотужніше озброєння, то лише прайми згодяться. Вишукані, позолочені ворфрейми-прайм, їхня зброя та предмети — усе існує у найчистішій формі, як і задумали орокіни."
        },
        '#primeaccess .pa2': {
            'de': "Prime Access ist der direkteste Weg zu erstaunlicher Technologie. Besucht den in-Game Markt für das neueste Paket im Angebot, inklusive exklusiver Gegenstände und heruntergesetztem Platinum!",
            'ru': "Доступ Прайм — ваш самый прямой путь к этой поразительной технологии. Посетите внутриигровой магазин, чтобы получить последние наборы, включая эксклюзивные предметы и платину со скидкой!",
            'fr': "Le Prime Access est votre accès direct à cette technologie exceptionnelle. Visitez le Marché en jeu pour découvrir les dernières offres groupées, notamment des objets exclusifs et du Platinum à prix réduit!",
            'es': "Prime Access es tu ruta más directa a esta asombrosa tecnología. ¡Visita el mercado del juego para descubrir los últimos paquetes, incluyendo componentes exclusivos y Platinum con descuento!",
            'ja': "Prime Accessはそんな起源の力を直接入手するために用意されたプログラムです。最新のバンドルからアイテムを得られ、限定外装品や割引プラチナも手に入れられます。",
            'pt': "O Prime Access é o seu acesso direto a essa tecnologia excepcional. Visite o Mercado do jogo para conferir os pacotes mais recentes, incluindo itens exclusivos e Platinas com desconto!",
            'tr': "Prime Access, bu şaşırtıcı teknolojiye giden en doğrudan yoldur. Özel eşyalar ve indirimli Platinum da dahil olmak üzere en son paket teklifleri için oyun içi Market'i ziyaret edin!",
            'pl': "Prime Access to najkrótsza droga do tej zdumiewającej technologii. Odwiedź Rynek w grze, aby zapoznać się z najnowszymi ofertami pakietów, ekskluzywnych przedmiotów i przecenionej Platyny!",
            'zh': "Prime Access 是你获得这项惊人技术的最直接途径。访问游戏内商店，获取最新的组合包产品，包括专属物品和超值折扣白金！",
            'tc': "Prime Access 是你獲得這項驚人技術的最直接途徑。造訪遊戲內商店，獲取最新的組合包產品，包括獨家物品以及優惠白金！",
            'ko': "프라임 액세스는 이 놀라운 기술을 경험할 수 있는 가장 빠른 경로입니다. 게임 내 상점에서 한정 아이템들과 할인된 플래티넘이 포함된 최신 번들 상품을 확인해 보세요!",
            'it': "L'Accesso Prime è la via più diretta per accedere a questa straordinaria tecnologia. Visita il Mercato in gioco per le nuove offerte bundle, inclusi oggetti esclusivi e Platinum scontato!",
            'th': "Prime Access คือเส้นทางตรงที่สุดที่จะนำคุณไปสู่เทคโนโลยีที่น่าทึ่งนี้ เข้าไปเยี่ยมชมตลาดในเกมเพื่อรับข้อเสนอใหม่ ๆ ล่าสุด รวมถึงไอเทมพิเศษและแพลทินัมลดราคา",
            'uk': "Прайм-доступ — це найкоротший шлях до отримання видатних технологій. Відвідайте ігрову крамницю й перегляньте найновіші пропозиції, включно з винятковими речами та платиною за вигідною ціною."
        },
        '.buildnotestitle': {
            'de': "Build Notizen",
            'ru': "Новости обновлений",
            'fr': "Notes de la version",
            'es': "Notas de actualización",
            'ja': "パッチノート",
            'pt': "Notas de Atualização",
            'tr': "Güncelleme Notları",
            'pl': "Notki Aktualizacji",
            'zh': "版本说明",
            'tc': "版本說明",
            'ko': "빌드 노트",
            'it': "Note di Rilascio",
            'th': "บันทึกประจำรุ่น",
            'uk': "Примітки до випуску"
        },
        '.patitle': {
            'de': "",
            'ru': "Калибан Прайм",
            'fr': "",
            'es': "",
            'ja': "",
            'pt': "",
            'tr': "",
            'pl': "",
            'zh': "",
            'tc': "",
            'ko': "칼리반 프라임",
            'it': "",
            'th': "",
            'uk': "Калібан-прайм"
        },
        '.whatsnewbutton span.moreInfo': {
            'de': "Mehr Info",
            'ru': "Подробнее",
            'fr': "Plus d'infos",
            'es': "Más información",
            'ja': "詳細",
            'pt': "Mais Informações",
            'tr': "Detaylı Bilgi",
            'pl': "Więcej informacji",
            'zh': "更多信息",
            'tc': "更多資訊",
            'ko': "자세한 정보",
            'it': "Ulteriori Informazioni",
            'uk': "Більше інформації",
            'th': "ข้อมูลเพิ่มเติม"
        },
        '.whatsnewbutton span.watchNow': {
            'de': "Jetzt ansehen",
            'ru': "Смотрите сейчас",
            'fr': "Visionner Maintenant",
            'es': "Ver ahora",
            'ja': "今すぐ視聴",
            'pt': "Assista Agora",
            'tr': "Hemen İzle",
            'pl': "Oglądaj",
            'zh': "立即观看",
            'tc': "立即觀看",
            'ko': "지금 시청하기",
            'it': "Guarda Ora",
            'th': "",
            'uk': ""
        },
        '.whatsnewbutton span.buyNow': {
            'de': "Jetzt kaufen",
            'ru': "Купить сейчас",
            'fr': "Achetez Maintenant",
            'es': "Comprar ahora",
            'ja': "今すぐ購入",
            'pt': "Compre Agora",
            'tr': "Hemen Satın Al",
            'pl': "Kup teraz",
            'ko': "지금 구매하세요",
            'it': "Acquista Ora",
            'zh': "立即购买",
            'tc': "立即購買",
            'uk': "Придбати зараз",
            'th': "ซื้อเลย"
        },
        '.whatsnewtitle': {
            'de': "Was gibt's Neues",
            'ru': "Что нового",
            'fr': "Quoi de neuf",
            'es': "Novedades",
            'ja': "最新情報",
            'pt': "Novidades",
            'tr': "Yeni İçerikler",
            'pl': "Nowości",
            'zh': "最新动态",
            'tc': "最新動向",
            'ko': "새로워진 점",
            'it': "Novità",
            'th': "มีอะไรใหม่บ้าง",
            'uk': "Що нового"
        },
        '.whatsnewslide .slideDesc a.whatsnew-info': {
            'de': "Mehr Info",
            'ru': "Подробнее",
            'fr': "Plus d'infos",
            'es': "Más información",
            'ja': "詳細",
            'pt': "Mais Informações",
            'tr': "Detaylı Bilgi",
            'pl': "Więcej informacji",
            'zh': "更多信息",
            'tc': "更多資訊",
            'ko': "자세한 정보",
            'it': "Ulteriori Informazioni",
            'th': "ข้อมูลเพิ่มเติม",
            'uk': "Більше інформації"
        },
        '.whatsnewslide .slideDesc .disclaimer': {
            'de': "PRIME RÜCKKEHR LÄUFT BIS ZUM 25. JANUAR 2022",
            'ru': "ВОЗРОЖДЕНИЕ ПРАЙМ БУДЕТ ПРОХОДИТЬ ДО 25 ЯНВАРЯ 2022 ГОДА",
            'fr': "RÉSURGENCE PRIME EST DISPONIBLE JUSQU'AU 25 JANVIER 2022 ",
            'es': "RESURGIMIENTO PRIME ESTARÁ DISPONIBLE HASTA EL 25 DE ENERO DE 2022",
            'ja': "PRIME RESURGENCEは2022年1月26日まで開催されます",
            'pt': "A RESSURGÊNCIA PRIME ESTARÁ DISPONÍVEL ATÉ O DIA 25 DE JANEIRO DE 2022",
            'tr': "PRIME DİRİLİŞ 25 OCAK 2022'YE KADAR SİZLERLE",
            'pl': "ODRODZENIE PRIME TRWA DO 25. STYCZNIA 2022",
            'ko': "프라임 리서전스는 북미 시간 기준으로 2022년 1월 25일까지 진행됩니다",
            'it': "RISORGENZA PRIME SARÀ DISPONIBILE FINO AL 25 GENNAIO 2022",
            'zh': "《PRIME 重生》将持续到美东冬令时间 2022 年 1 月 25 日！",
            'tc': "PRIME RESURGENCE 活動進行到美東冬令時間 2022 年 1 月 25 日",
            'th': "",
            'uk': "",
        },
        /*Slide 1*/ //TIP: CTRL-W twice to select all in quotes
        '.whatsnewslide.slide1 h4':
            {
                "de": "Inselweber",
                "ru": "Плетельщица островов",
                "fr": "La Toile Insulaire",
                "es": "Tejedora de islas",
                "ja": "島々を織りしもの",
                "pt": "Tecelã Insular",
                "tr": "Isleweaver",
                "pl": "Tkaczka Światów",
                "ko": "섬을 엮는 자",
                "it": "Tessitrice di Isole",
                "zh": "《织屿人》",
                "tc": "織島者",
                "uk": "Ткаля островів",
                "th": "Isleweaver"
            },
        '.whatsnewslide.slide1 .slideDesc p:nth-of-type(1)':
            {
                "de": "Kehrt zum schwebenden Königreich von Duviri zurück, dem Land voller Fabeln und Erzählungen und drängt den neuesten Einfall der Gleichgültigkeit zurück! Major Neci Rusalka ist zwischen den schwebenden Inseln wieder aufgetaucht - und sie hat das Raunen mitgebracht.",
                "ru": "Снова ступите в парящее Королевство Дувири, мир сказаний и легенд, чтобы отразить новую волну Безразличия! Майор Нэси Русалка всплыла среди островов — и принеся с собой Шёпот.",
                "fr": "Retournez au Royaume flottant de Duviri, terre de fables et d'histoires, pour repousser la dernière incursion de l'Indifférence! Le major Neci Rusalka a refait surface parmi les îles flottantes et elle a amené le Murmure avec elle.",
                "es": "¡Regresa al reino flotante de Duviri, tierra de fábulas e historias, para repeler la última incursión de la Indiferencia! La mayor Neci Rusalka ha resurgido entre las islas flotantes y ha traído consigo al Murmullo.",
                "ja": "Major Neci Rusalkaがササヤキを引き連れて再び姿を現したようだ。伝説の浮島デュヴィリ王国へ帰還し、「無関心のモノ」の侵攻を撃退せよ。",
                "pt": "Retorne ao reino flutuante de Duviri, uma terra de fábulas e histórias, para deter a mais recente incursão da Indiferença! A Major Neci Rusalka ressurgiu entre as ilhas flutuantes e trouxe o Murmúrio com ela.",
                "tr": "Kayıtsızlığın son saldırısını geri püskürtmek için masallar ve hikâyeler diyarı Duviri'nin yüzen Krallığına geri dönün! Binbaşı Neci Rusalka yüzen adalar arasında yeniden ortaya çıktı — ve yanında Murmur'u da getirdi.",
                "pl": "Wróć do unoszącego się Królestwa Duviri, krainy baśni i opowieści, aby odeprzeć najnowszą inwazję Obojętności! Major Neci Rusalka ponownie pojawiła się wśród unoszących się wysp i sprowadziła ze sobą Szept.",
                "ko": "동화와 이야기의 땅, 공중을 부유하는 두비리 왕국으로 돌아가 최근 시작된 무심의 침입을 저지하세요! 네시 루살카 소령이 이 부유섬들 사이에 다시 나타났습니다 — 그리고 그녀의 곁엔 속삭임들이 있지요.",
                "it": "Torna nel Regno galleggiante di Duviri, terra di favole e storie, per respingere la nuova incursione dell'Indifferenza! Neci Rusalka è ricomparsa tra le isole galleggianti - portando con sé i Murmur.",
                "zh": "回到充满寓言和故事的浮岛王国双衍王境，击退虚空无情之物的最新入侵！内奇·鲁莎卡少校再次出现在浮岛上，她带着低语者一同现身。",
                "tc": "回到漂浮的渡域王國，一個充滿寓言和故事的土地，擊退漠然的最新入侵！妮熙・露莎卡少校在浮島之間重新浮出水面 — 而她帶來了喃喃者。",
                "uk": "Поверніться до летючого королівства Дувірі — країни казок та історій. Відбийте чергове вторгнення Байдужості! Майорка Несі Русалка виринула серед островів і принесла із собою Шепіт.",
                "th": "กลับสู่อาณาจักรลอยฟ้าของ Duviri ดินแดนแห่งนิทานและเรื่องเล่าเพื่อต่อต้านความเฉยเมยที่บุกรุกเข้ามา! Major Neci Rusalka ปรากฏตัวอีกครั้งที่หมู่เกาะลอยฟ้าพร้อมกับนำ Murmur มาด้วย"
            },

        /*Slide 2*/
        '.whatsnewslide.slide2 h4':
            {
                "de": "TennoGen: Fraktionen",
                "ru": "ТэнноГен «Фракции»",
                "fr": "",
                "es": "Facciones TennoGen",
                "ja": "TennoGen 勢力バンドル",
                "pt": "Facções do TennoGen",
                "tr": "TennoGen Fraksiyonları",
                "pl": "Frakcje TennoGen",
                "zh": "TennoGen 派系",
                "tc": "TennoGen 派系",
                "ko": "텐노젠 진영 번들",
                "it": "",
                "th": "",
                "uk": "ТенноҐен «Угруповання»",
            },
        '.whatsnewslide.slide2 .slideDesc p:nth-of-type(1)':
            {
                "de": "Verschönert euer Arsenal mit diesen neuen, von der Community erstellten, Anpassungen! Dazu gehören der Gauss-Skin & -Helm: Profitas erstellt von malaya, Jadie und Noxxr, das schnittige Syandana Xikonos erstellt von led2012 und Daemonstar, der brutale Peitschen-Skin: Jotunheim erstellt von Mz-3 und die modulare Rüstung: Xairaks erstellt von lex182 und cedd00.",
                "ru": "Улучшите свой арсенал с помощью новых кастомизаций, созданных сообществом! В их числе скин и шлем Гаусса «Профитас» от malaya, Jadie и Noxxr, изящная сандана «Ксиконос» от led2012 и daemonstar, брутальный скин плети «Йотунхейм» от Mz-3 и модульная броня «Ксиракс» от lex182 и cedd00.",
                "fr": "Améliorez votre Arsenal avec de nouvelles personnalisations conçues par la communauté ! Découvrez l'Aspect et le Casque Gauss Profitas de malaya, Jadie et Noxxr, l'élégante Syandana Xikonos de led2012 et daemonstar, l'Aspect de Fouet Jotunheim brutal de Mz-3 ainsi que l'Armure modulaire Xairaks de lex182 et cedd00.",
                "es": "¡Mejora tu arsenal con nuevas personalizaciones diseñadas por la comunidad! Descubre el diseño y casco Profitas de Gauss de malaya, Jadie y Noxxr, la elegante syandana Xikonos de led2012 y daemonstar, el brutal diseño Jotunheim de látigo de Mz-3 y la armadura modular Xairaks de lex182 y cedd00.",
                "ja": "コミュニティがデザインした新カスタマイズオプションが登場。malaya、Jadie、NoxxrによるGauss Profitas スキンとヘルメット、led2012、daemonstarによるスタイリッシュなXikonos シャンダナ、Mz-3による強烈なJotunheim ウィップスキン、そしてlex182、cedd00によるXairaks アーマーが含まれます。",
                "pt": "Eleve seu Arsenal com novas Personalizações criadas pela comunidade! Apresentando a Skin e o Capacete Profitas para o Gauss, desenvolvidos por malaya, Jadie e Noxxr, a elegante Syandana Xikonos, desenvolvida por led2012 e daemonstar, a brutal Skin Jotunheim para Chicotes, desenvolvida por Mz-3 e a Armadura modular Xairaks, desenvolvida por lex182 e cedd00.",
                "tr": "Topluluk tarafından tasarlanan yeni Özelleştirmelerle Arsenal'inizi bir üst seviyeye taşıyın! Bu özelleştirmeler, malaya, Jadie ve Noxxr'un Gauss Profitas Skin'i ve Miğferini, led2012 ve daemonstar'ın şık Xikonos Syandana'sını, Mz-3'ün acımasız Kırbaç Jotunheim Skin'ini ve lex182 ile cedd00'ın modüler Xairaks Zırhı'nı içeriyor.",
                "pl": "Rozwiń swój Arsenał dzięki nowym personalizacjom, stworzonym przez społeczność! Przedstawiamy skórkę i hełm Gauss Profitas aurostwa malaya, Jadie i Noxxr; stylową Syandanę Xikonos autorstwa led2012 i daemonstar; brutalną skórkę bicza Jotunheim autorstwa Mz-3 oraz modułowy pancerz Xairaks autorstwa lex182 i cedd00.",
                "zh": "通过玩家社区设计的全新自定义装饰为你的军械库注入新活力！包括由 malaya、Jadie 和 Noxxr 设计的 Gauss 速盈外观和头盔、由 led2012 和 daemonstar 设计的时尚希科诺斯披饰，由 Mz-3 创作的残暴鞭类武器约顿海姆外观，以及由 lex182 和 cedd00 设计的模块化赛拉克斯护甲。",
                "tc": "用全新的社群設計外觀來豐富你的軍械庫吧！當中包含由 malaya、Jadie，及 Noxxr 設計的 Gauss 速利外觀和頭盔、由 led2012 及 daemonstar 設計的流線齋科諾披飾、由 Mz-3 設計的粗獷鞭 約頓海姆外觀，以及由 lex182 及 cedd00 設計的組合式齋拉克護甲。",
                "ko": "커뮤니티에서 새롭게 제작한 외형 아이템으로 무기고를 더욱 강력하게 꾸며보세요! malaya, Jadie, Noxxr가 제작한 가우스 프로피타스 스킨과 헬멧, led2012와 daemonstar가 제작한 세련된 시코노스 샨다나, Mz-3가 제작한 잔혹한 요툰헤임 휩 스킨, 그리고 lex182와 cedd00이 제작한 모듈형 자이락스 아머가 포함되어 있습니다.",
                "it": "Migliora il tuo Arsenale con nuove Personalizzazioni create dalla comunità! La Skin ed Elmo Gauss Profitas di malaya, Jadie & Noxxr, l'elegante Syandana Xikonos di led2012 & daemonstar, la brutale Skin Frusta Jotunheim di Mz-3 e l'Armatura Xairaks modulare di lex182 & cedd00.",
                "th": "ยกระดับคลังของคุณด้วยชุดปรับแต่งใหม่ล่าสุดที่ออกแบบโดยชุมชน ประกอบด้วย สกินและหมวกเหล็ก Gauss Profitas จาก malaya, Jadie และ Noxxr, ไซอันดานา Xikonos ที่สวยงามจาก led2012 และ daemonstar, สกินแส้ Jotunheim สุดโหดจาก Mz-3 และชุดเกราะ Xairaks แบบแยกชิ้นส่วนจาก lex182 และ cedd00",
                "uk": "Поліпшуйте свою зброярню за допомогою нових оздоблень від спільноти! Серед них вигляд та шолом «Прибутковість» для Ґаусса від malaya, Jadie та Noxxr, витончена сяндана «Зайкон» від led2012 та daemonstar, брутальний вигляд «Йотунгейм» для Вісп від Mz-3 та модульний обладунок «Зайракс» від lex182 та cedd00."
            },

        /*Slide 3*/
        '.whatsnewslide.slide3 h4':
            {
                "de": "Heirloom-Kollektion: Valkyr",
                "ru": "Коллекция Валькирии «Наследие»",
                "fr": "Collection Valkyr Héritage",
                "es": "Colección Legado de Valkyr",
                "ja": "Valkyr Heirloom コレクション",
                "pt": "Coleção do Legado da Valkyr",
                "tr": "Valkyr Heirloom Koleksiyonu",
                "pl": "Kolekcja: Pamiątkowa Valkyr",
                "zh": "Valkyr 传家宝组合包",
                "tc": "Valkyr 祖傳組合包",
                "ko": "발키르 에어룸 컬렉션",
                "it": "Collezione Valkyr Heirloom",
                "th": "คอลเลกชัน Valkyr Heirloom",
                "uk": "Колекція «Спадок» для Валькірії"
            },
        '.whatsnewslide.slide3 .slideDesc p:nth-of-type(1)':
            {
                "de": "Erhebt euch in Würde und zerschmettert die Fesseln der Qual mit dem neuen Look für Valkyr. Beinhaltet Anpassungen, die den Fluss der Zeit und die Hingabe der Tenno symbolisieren.",
                "ru": "Восстаньте во всём величии и разорвите узы мучений с новым великолепным обликом для Валькирии. Кастомизации из коллекции «Наследие» символизируют течение времени и преданность Тэнно.",
                "fr": "Élevez-vous en majesté et brisez les chaînes du tourment avec un nouveau look glorieux pour Valkyr. Des personnalisations qui symbolisent le passage du temps et le dévouement du Tenno.",
                "es": "Asciende majestuosamente y rompe las cadenas del tormento con una nueva y gloriosa apariencia para Valkyr. Incluye personalizaciones que simbolizan el paso del tiempo y la dedicación de los tenno.",
                "ja": "Valkyrの威厳を輝かしい新装でみなぎらせ、苦悩の鎖を打ち砕け。時の流れとテンノの献身を象徴するカスタマイズを可能にする。",
                "pt": "Ascenda majestosamente e rompa as amarras da agonia com um novo visual glorioso para a Valkyr. Inclui Personalizações que simbolizam a passagem do tempo e a dedicação dos Tennos.",
                "tr": "Valkyr için görkemli yeni bir görünümle ihtişamla yükselin ve işkencenin bağlarını parçalayın. Zamanın geçişini ve Tenno'nun adanmışlığını simgeleyen Özelleştirmeler içerir.",
                "pl": "Wznieś się w majestacie i skrusz więzy udręki dzięki wspaniałemu nowemu wyglądowi Valkyr. Zawiera personalizacje symbolizujące upływ czasu i oddanie Tenno.",
                "zh": "以威严之姿崛起，Valkyr 用焕然一新的光辉面貌粉碎苦难的枷锁。拥有象征着时间流逝和 Tenno 付出的自定义外'tc'观。",
                "tc": "透過 Valkyr 的全新輝煌面貌重現威風，打破折磨的束縛。具有標誌著時間流逝和 Tenno 奉獻精神的自訂功'uk'能。",
                "ko": "발키르를 위한 영광스러운 새로운 모습으로 장험함 속에서 일어나 고통의 유산을 벗어던지세요! 지금껏 지나온 흐름과 텐노들의 헌신을 상징합니다.",
                "it": "Ascendi maestoso e spezza le catene del tormento con un nuovo, glorioso look per Valkyr. Con Personalizzazioni che simboleggiano il passare del tempo e la dedizione dei Tenno.",
                "th": "ปรากฎตัวอย่างสง่างามและทลายพันธนาการแห่งความทุกข์ทรมานด้วยรูปลักษณ์ใหม่ที่สวยงามของ Valkyr พร้อมชุดการปรับแต่งที่แสดงถึงกาลเวลาที่ผันผ่านและความทุ่มเทของ Tenno",
                "uk": "З цим славетним виглядом для Валькірії ви велично підійметеся й скинете окови тортур. Оздоблення символізують плин часу та відданість тенно."
            },

        /*Slide 4*/
        '.whatsnewslide.slide4 h4': {
            "de": "Paket: Oraxia",
            "ru": "Набор «Ораксия»",
            "fr": "Bundle Oraxia",
            "es": "Conjunto de Oraxia",
            "ja": "Oraxia バンドル",
            "pt": "Conjunto da Oraxia",
            "tr": "Oraxia Paketi",
            "pl": "Zestaw Oraxii",
            "ko": "오락시아 번들",
            "it": "Pacchetto Oraxia",
            "zh": "Oraxia 组合包",
            "tc": "Oraxia 組合包",
            "uk": "Комплект «Ораксія»",
            "th": "ชุดรวม Oraxia"
        },
        '.whatsnewslide.slide4 .slideDesc p:nth-of-type(1)': {
            "de": "Die geduldige Jägerin Oraxia lauert in Duviri! Nutzt die agile Beweglichkeit des Netz-werfenden Spinnen-Warframes, um eure Gegner auszumanövrieren und ihre Schwächen auszunutzen. Fügt Oraxia sofort eurem Arsenal hinzu, zusammen mit ihrem unverkennbaren Ephemera, ihrer Rüstung, ihren Waffen und mehr.",
            "ru": "Терпеливая охотница Ораксия поджидает в Дувири! Используйте паутинную подвижность этого варфрейма, чтобы передвигаться по стенам, обходить врагов и бить точно в их слабые места. Добавьте Ораксию в ваш арсенал мгновенно вместе с её особой эфемерой, бронёй, оружием и не только.",
            "fr": "La patiente chasseresse Oraxia rôde à Duviri ! Utilisez la mobilité de cette Warframe arachnide pour vous jouer de tous vos adversaires et exploiter leurs faiblesses. Ajoutez Oraxia à votre Arsenal instantanément, ainsi que son Ephemera, son Armure, ses armes emblématiques et bien plus encore.",
            "es": "¡Oraxia, la paciente cazadora, acecha en Duviri! Usa la movilidad de teleraña sigilosa de este warframe arácnido para burlar a todos tus oponentes y explotar sus debilidades. Agrega a Oraxia a tu arsenal al instante, junto con su efímero, armadura, armas distintivas y más.",
            "ja": "忍耐強い狩人Oraxiaはデュヴィリに潜む。ウェブスリングを活かす機動力を誇るクモ型WARFRAMEは、どんな獲物も出し抜いて弱点を突くだろう。彼女特有のエフェメラ、アーマー、武器などと共に、今すぐOraxiaをアーセナルに追加しよう。",
            "pt": "A paciente caçadora Oraxia espreita em Duviri! Use a mobilidade do Warframe araneídeo para superar quaisquer oponentes e explorar suas fraquezas. Adicione instantaneamente a Oraxia ao seu Arsenal com sua efêmera, armadura, armas e muito mais.",
            "tr": "Sabırlı avcı Oraxia Duviri'de pusuda bekliyor! Örümcek Warframe'in ağ fırlatma kabiliyetini kullanarak rakiplerine üstünlük sağla ve zayıflıklarından yararlan. Oraxia'yı kendine özgü Ephemera, Zırh, Silahlar ve daha fazlasıyla birlikte anında Arsenalinine ekle.",
            "pl": "Cierpliwa łowczyni Oraxia czai się w Duviri! Wykorzystaj pajęczą zwinność tej Warframe do sprawnego manewrowania, by przechytrzyć przeciwników i wykorzystać ich słabości. Dodaj Oraxię do swojego Arsenału natychmiast wraz z jej charakterystyczną Efemerą, pancerzem, bronią i nie tylko.",
            "ko": "인내하는 사냥꾼 오락시아가 두비리에 숨어들었습니다! 거미 워프레임의 거미줄을 이용하는 기동력을 활용해 모든 적들을 따돌리고 약점을 공략하세요. 오락시아를 그녀의 대표 이페메라, 아머, 무기 등과 함께 여러분의 무기고에 지금 바로 추가해 보세요.",
            "it": "La paziente cacciatrice Oraxia si nasconde a Duviri! Utilizza la mobilità aracnide di questo Warframe per superare in astuzia qualsiasi avversario e sfruttarne i punti deboli. Aggiungi Oraxia al tuo Arsenale immediatamente, insieme alla sua Ephemera, Armatura, Armi distintive e molto altro ancora.",
            "zh": "耐心的猎人 Oraxia 就潜伏在双衍王境中！利用蛛形战甲的蛛网特性，智胜任何对手并利用他们的弱点。立即将 Oraxia 和她标志性的幻纹、护甲、武器等物品一起添加到你的军械库。",
            "tc": "耐心的獵人──Oraxia 潛伏在渡域！利用游絲蜘蛛 Warframe 的機動性來戰勝任何對手並利用他們的弱點。立即將 Oraxia 與她的標誌性幻紋，護甲，武器及更多精彩內容新增到你的軍械庫。",
            "uk": "Терпелива мисливиця Ораксія ховається в Дувірі! Використовуйте рухливість павукоподібного ворфрейма, що пускає павутину, щоби перехитрити будь-якого ворога та використати його слабкі сторони. Миттєво додайте Ораксію до своєї зброярні разом з її визначними ефемерою, обладунками, зброєю й не тільки.",
            "th": "นักล่าที่รอคอยเก่งอย่าง Oraxia กำลังดักซุ่มอยู่ใน Duviri! ใช้ความสามารถในการเหวี่ยงใยของ Warframe แมงมุมเพื่อเอาชนะศัตรูและใช้ประโยชน์จากจุดอ่อนของพวกมัน เพิ่ม Oraxia ลงในคลังอาวุธของคุณได้ทันทีควบคู่ไปกับอิเฟมเมอรา ชุดเกราะ อาวุธ และอื่น ๆ อีกมากมาย"


        },

    };

    if(lang !== 'en'){
        for (var select in langArray) {
            if ($(select).length !== 0) {
                for (var sLang in langArray[select]) {
                    if (sLang == lang && langArray[select][sLang] != "") {
                        $(select).html(langArray[select][sLang]);
                    }
                }
            }
        }
    }

    function getParameterByName(name) {
        name = name.replace(/[\[]/, "\\[").replace(/[\]]/, "\\]");
        var regex = new RegExp("[\\?&]" + name + "=([^&#]*)"),
                results = regex.exec(location.search);
        return results === null ? "" : decodeURIComponent(results[1].replace(/\+/g, " "));
    }
});